/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.constraint;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.NullObjectPattern;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class StrMinMax
extends CellProcessorAdaptor {
    protected long min;
    protected long max;

    public StrMinMax(long l, long l2) {
        super(NullObjectPattern.INSTANCE);
        if (l2 < l) {
            throw new SuperCSVException("max < min in the arguments " + l + " " + l2);
        }
        if (l < 0L) {
            throw new SuperCSVException("min length must be >= 0, is " + l);
        }
        this.min = l;
        this.max = l2;
    }

    public StrMinMax(long l, long l2, CellProcessor cellProcessor) {
        super(cellProcessor);
        if (l2 < l) {
            throw new SuperCSVException("max < min in the arguments " + l + " " + l2);
        }
        this.min = l;
        this.max = l2;
    }

    public Object execute(Object object, CSVContext cSVContext) throws NumberFormatException {
        String string = object.toString();
        if ((long)string.length() < this.min || (long)string.length() > this.max) {
            throw new SuperCSVException("Entry \"" + object + "\" on line " + cSVContext.lineNumber + " column " + cSVContext.columnNumber + " is not within the string sizes " + this.min + " - " + this.max);
        }
        return this.next.execute(string, cSVContext);
    }
}

