/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.io;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.io.AbstractCsvReader;
import org.supercsv.io.ICsvBeanReader;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.MethodCache;
import org.supercsv.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvBeanReader
extends AbstractCsvReader
implements ICsvBeanReader {
    protected List<? super Object> lineResult = new ArrayList<Object>();
    protected MethodCache cache = new MethodCache();

    public CsvBeanReader(Reader reader, CsvPreference csvPreference) {
        this.setPreferences(csvPreference);
        this.setInput(reader);
    }

    <T> T fillObject(Class<T> clazz, String[] stringArray) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        T t = clazz.newInstance();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            try {
                this.cache.getSetMethod(t, stringArray[i]).invoke(t, this.lineResult.get(i));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SuperCSVException("Method set" + stringArray[i].substring(0, 1).toUpperCase() + stringArray[i].substring(1) + "() does not accept input \"" + this.lineResult.get(i) + "\" of type " + this.lineResult.get(i).getClass().getName(), illegalArgumentException);
            }
        }
        return t;
    }

    @Override
    public <T> T read(Class<T> clazz, String[] stringArray) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (this.tokenizer.readStringList(this.line)) {
            this.lineResult.clear();
            this.lineResult.addAll(this.line);
            return this.fillObject(clazz, stringArray);
        }
        return null;
    }

    @Override
    public <T> T read(Class<T> clazz, String[] stringArray, CellProcessor[] cellProcessorArray) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, SuperCSVException {
        if (this.tokenizer.readStringList(this.line) && Util.processStringList(this.lineResult, this.line, cellProcessorArray, this.tokenizer.getLineNumber(), null)) {
            return this.fillObject(clazz, stringArray);
        }
        return null;
    }
}

