/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.io;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.io.ICsvReader;
import org.supercsv.io.ITokenizer;
import org.supercsv.io.Tokenizer;
import org.supercsv.prefs.CsvPreference;

public abstract class AbstractCsvReader
implements ICsvReader {
    protected List<String> line = new ArrayList<String>();
    protected ITokenizer tokenizer;
    protected CsvPreference preferences;

    public void close() throws IOException {
        this.tokenizer.close();
    }

    public String get(int n) throws IOException, IndexOutOfBoundsException {
        return this.line.get(n);
    }

    public String[] getCSVHeader(boolean bl) throws IOException {
        if (bl && this.tokenizer.getLineNumber() != 0) {
            throw new SuperCSVException("CSV header can only be fetched as the first read operation on a source!");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        if (this.tokenizer.readStringList(arrayList)) {
            stringArray = arrayList.toArray(new String[0]);
        }
        return stringArray;
    }

    public int getLineNumber() {
        return this.tokenizer.getLineNumber();
    }

    public int length() throws IOException {
        return this.line.size();
    }

    public ICsvReader setInput(Reader reader) {
        this.tokenizer = new Tokenizer(reader, this.preferences);
        return this;
    }

    public ICsvReader setPreferences(CsvPreference csvPreference) {
        this.preferences = csvPreference;
        return this;
    }

    public ICsvReader setTokenizer(ITokenizer iTokenizer) {
        this.tokenizer = iTokenizer;
        return this;
    }
}

