/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.constraint;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class DMinMax
extends CellProcessorAdaptor {
    public static final double MAXD = Double.MAX_VALUE;
    public static final double MIND = Double.MIN_VALUE;
    public static final double MAXS = 32767.0;
    public static final double MINS = -32768.0;
    public static final double MAXC = 65535.0;
    public static final double MINC = 0.0;
    public static final double MAX8bit = 255.0;
    public static final double MIN8bit = -128.0;
    protected double min;
    protected double max;

    public DMinMax(double d, double d2) {
        this.init(d, d2);
    }

    public DMinMax(double d, double d2, DoubleCellProcessor doubleCellProcessor) {
        super(doubleCellProcessor);
        this.init(d, d2);
    }

    public Object execute(Object object, CSVContext cSVContext) throws NumberFormatException {
        Double d = object instanceof Double ? (Double)object : Double.valueOf(Double.parseDouble(object.toString()));
        if (!(d >= this.min) || !(d <= this.max)) {
            throw new SuperCSVException("Entry \"" + object + "\" on line " + cSVContext.lineNumber + " column " + cSVContext.columnNumber + " is not within the numerical range " + this.min + "-" + this.max);
        }
        return this.next.execute(d, cSVContext);
    }

    private void init(double d, double d2) {
        if (d2 < d) {
            throw new SuperCSVException("max < min in the arguments " + d + " " + d2);
        }
        this.min = d;
        this.max = d2;
    }
}

