/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Alias;
import net.argius.stew.Connector;
import net.argius.stew.ConnectorConfiguration;
import net.argius.stew.ConnectorMap;
import net.argius.stew.LocalSystem;
import net.argius.stew.Resource;
import net.argius.stew.ui.OutputProcessor;

public final class Environment {
    static final String CONNECTOR_PROPERTIES_NAME = "connector.properties";
    static final String ALIAS_PROPERTIES_NAME = "alias.properties";
    private static final Logger log = LoggerFactory.getLogger(Environment.class);
    private OutputProcessor outputProcessor;
    private ConnectorMap connectorMap;
    private Connector connector;
    private Connection conn;
    private int timeoutSeconds;
    private File systemDirectory;
    private File currentDirectory;
    private long connectorTimestamp;
    private Alias alias;

    public Environment() {
        this.initializeQueryTimeout();
        this.connectorMap = new ConnectorMap();
        this.loadConnectorMap();
        this.systemDirectory = LocalSystem.getDirectory();
        this.currentDirectory = this.getInitialCurrentDirectory();
        File file = new File(this.systemDirectory, ALIAS_PROPERTIES_NAME);
        this.alias = new Alias(file);
        if (file.exists()) {
            try {
                this.alias.load();
            }
            catch (IOException iOException) {
                log.warn("", iOException);
            }
        }
    }

    public Environment(Environment environment) {
        this.connectorMap = new ConnectorMap(environment.connectorMap);
        this.timeoutSeconds = environment.timeoutSeconds;
        this.systemDirectory = environment.systemDirectory;
        this.currentDirectory = environment.currentDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        try {
            this.releaseConnection();
            if (log.isDebugEnabled()) {
                log.debug("released connection");
            }
        }
        catch (SQLException sQLException) {
            log.error("release error", sQLException);
        }
        finally {
            this.outputProcessor = null;
            this.connectorMap = null;
            this.connector = null;
            this.conn = null;
            this.systemDirectory = null;
            this.currentDirectory = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("released Environment");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseConnection() throws SQLException {
        block13: {
            try {
                if (this.conn != null) {
                    if (this.connector != null && this.connector.usesAutoRollback()) {
                        try {
                            this.conn.rollback();
                            OutputProcessor outputProcessor = this.getOutputProcessor();
                            if (outputProcessor != null) {
                                outputProcessor.output(Resource.getString("i.rollbacked", new Object[0]));
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("rollbacked");
                            }
                        }
                        catch (SQLException sQLException) {
                            log.warn("", sQLException);
                        }
                    }
                    try {
                        this.conn.close();
                        if (log.isDebugEnabled()) {
                            log.debug("disconnected");
                        }
                        break block13;
                    }
                    catch (SQLException sQLException) {
                        log.warn("", sQLException);
                        throw sQLException;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("not connected");
                }
            }
            finally {
                this.conn = null;
                this.connector = null;
            }
        }
    }

    private File getInitialCurrentDirectory() {
        File file;
        if (LocalSystem.containsKey("net.argius.stew.directory") && (file = new File(LocalSystem.getProperty("net.argius.stew.directory"))).isDirectory()) {
            return file;
        }
        return new File(".");
    }

    private void initializeQueryTimeout() {
        this.timeoutSeconds = LocalSystem.getPropertyAsInt("net.argius.stew.query.timeout", -1);
        if (log.isDebugEnabled()) {
            log.debug("timeout: " + this.timeoutSeconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConnectorMap() {
        ConnectorMap connectorMap;
        Object object;
        File file = new File(LocalSystem.getDirectory(), CONNECTOR_PROPERTIES_NAME);
        try {
            object = new FileInputStream(file);
            try {
                connectorMap = ConnectorConfiguration.load((InputStream)object);
            }
            finally {
                ((InputStream)object).close();
            }
        }
        catch (IOException iOException) {
            connectorMap = new ConnectorMap();
        }
        object = this.connectorMap;
        synchronized (object) {
            if (this.connectorMap.size() > 0) {
                this.connectorMap.clear();
            }
            this.connectorMap.putAll(connectorMap);
            this.connectorTimestamp = file.lastModified();
        }
    }

    public boolean updateConnectorMap() {
        File file = new File(LocalSystem.getDirectory(), CONNECTOR_PROPERTIES_NAME);
        if (file.lastModified() > this.connectorTimestamp) {
            this.loadConnectorMap();
            return true;
        }
        return false;
    }

    public OutputProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    public void setOutputProcessor(OutputProcessor outputProcessor) {
        this.outputProcessor = outputProcessor;
    }

    public ConnectorMap getConnectorMap() {
        return this.connectorMap;
    }

    public Connector getCurrentConnector() {
        return this.connector;
    }

    void setCurrentConnector(Connector connector) {
        this.connector = connector;
    }

    public Connection getCurrentConnection() {
        return this.conn;
    }

    void setCurrentConnection(Connection connection) {
        this.conn = connection;
    }

    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File file) {
        this.currentDirectory = file;
    }

    public File getSystemDirectory() {
        return this.systemDirectory;
    }

    public Alias getAlias() {
        return this.alias;
    }
}

