using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Text;
using System.Threading;
using Sdl;
using StarEngine.Core;

namespace StarEngine.Sdl
{
    /// <summary>
    /// IGameEnvironment  SDL ɂłB
    /// </summary>
    public sealed class GameEnvironment : IGameEnvironment, IDisposable
    {
        /// <summary>
        /// GameEnvironment IuWFNg𐶐܂B
        /// ɓ͏o܂B
        /// </summary>
        /// <param name="windowType">EBhE^CvB</param>
        /// <returns>GameEnvironment IuWFNgB</returns>
        public static GameEnvironment Create(WindowType windowType)
        {
            if (Instance != null && !Instance.IsDisposed)
                throw new InvalidOperationException("GameEnvionment IuWFNg͓ɓł܂B");
            return Instance = new GameEnvironment(windowType);
        }
        private static GameEnvironment Instance;

        private GameEnvironment(WindowType windowType)
        {
            this.WindowType = windowType;

            uint flags =
                SDL.SDL_INIT_VIDEO |
                SDL.SDL_INIT_JOYSTICK |
                SDL.SDL_INIT_AUDIO |
                SDL.SDL_INIT_TIMER;

            if (SDL.SDL_Init(flags) < 0)
                throw new StarEngineException(SDL.SDL_GetError());

            this.SdlScreen = Sdl.Screen.Create(new Size(320, 240), this.WindowType);
            
            this.SdlInput = Sdl.Input.Create();

            this.SdlAudio = Sdl.Audio.Create();

            this.SdlEvent = new SDL.SDL_Event();

            SDL.SDL_ShowCursor((int)SDL.SDL_DISABLE);
        }

        /// <summary>
        ///  GameEnvironment ɂĎgpĂ郊\[XSĉ܂B
        /// </summary>
        public void Dispose()
        {
            this.Dispose(true);
            GC.SuppressFinalize(this);
        }

        /// <summary>
        /// GameEnvironment ̃fXgN^łB
        /// </summary>
        ~GameEnvironment()
        {
            this.Dispose(false);
        }

        private void Dispose(bool disposing)
        {
            if (!this.IsDisposed)
            {
                this.IsDisposed = true;
                if (disposing)
                {
                    this.SdlAudio.Dispose();
                    this.SdlInput.Dispose();
                    this.SdlScreen.Dispose();
                }
                SDL.SDL_Quit();
            }
        }

        /// <summary>
        ///  GameEnvironment ꂽǂl擾܂B
        /// </summary>
        public bool IsDisposed
        {
            get { return this.isDisposed; }
            private set { this.isDisposed = value; }
        }
        private bool isDisposed = false;

        /// <summary>
        /// EBhE^Cv擾܂B
        /// </summary>
        public WindowType WindowType
        {
            get { return this.windowType; }
            private set { this.windowType = value; }
        }
        private WindowType windowType;

        /// <summary>
        /// ͋@擾܂B
        /// </summary>
        public IInput Input
        {
            get { return this.SdlInput; }
        }

        private Input SdlInput;

        /// <summary>
        /// `ΏۂƂȂʂ擾܂B
        /// </summary>
        public IScreen Screen
        {
            get { return this.SdlScreen; }
        }
        
        private Screen SdlScreen;

        private SDL.SDL_Event SdlEvent;

        /// <summary>
        /// I[fBI擾܂B
        /// </summary>
        public IAudio Audio
        {
            get { return this.SdlAudio; }
        }

        private Audio SdlAudio;
        
        /// <summary>
        /// gpeNX`t@Ng擾܂B
        /// </summary>
        public ITextureFactory TextureFactory
        {
            get { return StarEngine.Sdl.TextureFactory.Instance; }
        }

        /// <summary>
        /// Q[s܂B
        /// </summary>
        /// <param name="game">sQ[B</param>
        public void Run(IGame game)
        {
            this.Title = game.Title;

            if (this.IsRunning) return;
            this.IsRunning = true;
            this.IsTerminated = false;

            int now, nowX;
            int before = Environment.TickCount;
            int before2 = before;
            int errorX = 0;
            int fps = game.Fps;
            

            int tempCounter = 0;
            double frameTime = 1000.0 / game.Fps;

            while (true)
            {
                tempCounter++;

                this.SdlInput.Update(this.SdlScreen);
                if (SDL.SDL_PollEvent(ref this.SdlEvent) != 0 && this.SdlEvent.type == SDL.SDL_QUIT)
                    this.Terminate();
                
                while (100 > (nowX = ((now = Environment.TickCount) - before) * (fps / 10) + errorX))
                    Thread.Sleep(1);
                
                before = now;
                errorX = nowX % 100;

                // per 1 second
                if ((now - before2) >= 1000)
                {
                    this.RealFps = (double)tempCounter / (now - before2) * 1000;
                    Debug.WriteLine(string.Format("FPS: {0:#.00}", this.RealFps));
                    tempCounter = 0;
                    before2 = now;
                }

                game.Update(this);

                this.SdlScreen.Update(game);

                if (this.IsTerminated)
                    break;
            }

            this.IsRunning = false;
        }

        /// <summary>
        /// Q[sǂl擾܂B
        /// </summary>
        public bool IsRunning
        {
            get { return this.isRunning; }
            private set { this.isRunning = value; }
        }
        private bool isRunning = false;

        /// <summary>
        /// Q[I܂B
        /// </summary>
        public void Terminate()
        {
            if (this.IsRunning)
                this.IsTerminated = true;
        }

        private bool IsTerminated = false;

        /// <summary>
        /// ۂ FPS 擾܂B
        /// </summary>
        public double RealFps
        {
            get { return this.realFps; }
            private set { this.realFps = value; }
        }
        private double realFps;

        /// <summary>
        /// ^Cgݒ肵܂B
        /// </summary>
        public string Title
        {
            set
            {
                SDL.SDL_WM_SetCaption(Encoding.UTF8.GetBytes(value), null);
            }
        }
    }
}
