using System;
using System.Collections.Generic;
using System.Text;

namespace StarEngine.Core
{
    /// <summary>
    /// サウンド関係のためのメソッドを提供します。
    /// </summary>
    public interface IAudio
    {
        /// <summary>
        /// BGM を再生します。
        /// すでに BGM が再生している場合は、 BGM を停止します。
        /// </summary>
        /// <param name="path">ファイルのパス。</param>
        /// <param name="fadeInTime">フェードインの時間 (ミリ秒)。</param>
        /// <param name="volume">音量 (0〜255)。</param>
        /// <param name="isLoop">ループするかどうかを示す値。</param>
        void PlayBgm(string path, int fadeInTime, byte volume, bool isLoop);

        /// <summary>
        /// BGM を停止します。
        /// </summary>
        /// <param name="fadeOutTime">フェードアウトの時間 (ミリ秒)。</param>
        void StopBgm(int fadeOutTime);

        /// <summary>
        /// BGM が再生中かどうかを示す値を取得します。
        /// </summary>
        bool IsPlayingBgm { get; }

        /// <summary>
        /// BGM の音量を取得または設定します。
        /// </summary>
        byte BgmVolume { get; set; }

        /// <summary>
        /// SE を再生します。
        /// </summary>
        /// <param name="path">ファイルのパス。</param>
        /// <param name="fadeInTime">フェードアウトの時間 (ミリ秒)。</param>
        /// <param name="volume">音量 (0〜255)。</param>
        /// <param name="panning">定位 (0〜255)。</param>
        /// <remarks>
        /// 一定数以上の SE を再生しようとした場合は、無視されます。
        ///
        /// 定位は、 0 が左端、127 または 128 が中央、 255 が右端です。
        /// </remarks>
        void PlaySE(string path, int fadeInTime, byte volume, byte panning);

        /// <summary>
        /// 再生中の全ての効果音を停止します。
        /// </summary>
        /// <param name="fadeOutTime">フェードアウトの時間 (ミリ秒)。</param>
        void StopAllSEs(int fadeOutTime);
    }
}
