include StarEngine

font = Font.new("MS UI Gothic", 12)
color = Color.new(255, 255, 255)

class Sprite
  
  TEXTURE = Texture.load "Images/Sprite.png"
  MAX_X = Screen.width - TEXTURE.width
  MAX_Y = Screen.height - TEXTURE.height
  
  attr_reader :x
  attr_reader :y
  
  def initialize
    @x = rand(MAX_X)
    @y = rand(MAX_Y)
    @vx = rand(2) * 2 - 1
    @vy = rand(2) * 2 - 1
  end
  
  def update
    @x += @vx
    @y += @vy
    if @x < 0
      @x = -@x
      @vx = 1
    end
    if @y < 0
      @y = -@y
      @vy = 1
    end
    if MAX_X <= @x
      @x = -(@x - MAX_X) + MAX_X
      @vx = -1
    end
    if MAX_Y <= @y
      @y = -(@y - MAX_Y) + MAX_Y
      @vy = -1
    end
  end
  
end

sprites = Array.new(300) { Sprite.new }

Game.run do
  
  screen = Screen.offscreen
  
  screen.clear
  
  sprites.each do |s|
    s.update
    screen.render_texture Sprite::TEXTURE, s.x, s.y
  end
  
  screen.render_text("Keyboard:", 8, 8, font, color)
  screen.render_text(Input.pressed_keys(:keyboard).inspect, 8 + 16, 8 + 16, font, color)
  
  screen.render_text("Game Pad:", 8, 8 + 32, font, color)
  screen.render_text(Input.pressed_keys(:game_pad).inspect, 8 + 16, 8 + 48, font, color)
  
  screen.render_text("Mouse:", 8, 8 + 64, font, color)
  screen.render_text(Input.pressed_keys(:mouse).inspect, 8 + 16, 8 + 80, font, color)
  x, y = Input.mouse_location
  screen.render_text("(#{x}, #{y})", x, y, font, color)
  
  screen.render_text("FPS:", 8, 8 + 96, font, color)
  screen.render_text("%0.2f" % Game.real_fps, 8 + 16, 8 + 112, font, color)

end

