import gunmetry.ExtractMarkerPlugin;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.SpinnerNumberModel;
import sos.panel.JGenericPanel;

/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (Created on 2005/03/02)
 */
public class OnePerRegion implements ExtractMarkerPlugin{
	private JGenericPanel optionPanel = new JGenericPanel();
	
	/** Creates a new instance of OnePerRegion */
	public OnePerRegion() {
		optionPanel.addNumericSpinner("min distance = ", new SpinnerNumberModel(2,1,Integer.MAX_VALUE,1));
	}

	public javax.swing.JPanel getOptionPanel() {
		return optionPanel;
	}

	public ArrayList<Point> extractMarker(sos.process.Morphology mo, boolean[] binaryMap) {
		// get value from optionPanel		
		int minDistance = (Integer)optionPanel.getSpinnerNumber(0);
		
		int[] distanceMap = mo.geodesicDistance8(binaryMap);
		
		ArrayList<Point> result = new ArrayList<Point>();
		int[] regionMap = new int[binaryMap.length];
		int nRegion = mo.extractRegion4(binaryMap,regionMap);
		Point[] markers = new Point[nRegion];
		int[] maxDistance = new int[nRegion]; 
		int offset;
		for (int y=0; y<mo.getHeight(); y++){
			for (int x=0; x<mo.getWidth(); x++){
				offset = x+y*mo.getWidth();
				if (minDistance<=distanceMap[offset]){
					int region = regionMap[offset];
					if (maxDistance[region]<distanceMap[offset]){
						maxDistance[region] = distanceMap[offset];
						if (markers[region]!=null){
							markers[region].setLocation(x,y);
						}else{
							markers[region] = new Point(x,y);
						}
					}
				}
			}
		}
		
		for (int i=0; i<markers.length; i++){
			if (markers[i]!=null){
				result.add(markers[i]);
			}
		}
		
		return result;
	}
	
}
