/*
 * RegionShapePanel.java
 *
 * Created on 2005/06/06, 1:32
 */

package gunmetry.region;
import gunmetry.GunmetryViewer;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.Icon;

/**
 *
 * @author  Gaku Tanaka
 */
public abstract class RegionGraphics extends javax.swing.JPanel {
	static protected GunmetryViewer gunmetryViewer;
	protected RegionSet regionSet;
	
	/** Creates new form RegionShapePanel */
	public RegionGraphics() {
		initComponents();
	}
	
	static public void setGunmetryViewer(GunmetryViewer viewer){
		gunmetryViewer = viewer;
	}
	
	public void init(RegionSet regionSet, Icon icon, Color color){
		this.regionSet = regionSet;
		jToggleButton.setIcon(icon);
		jCanvasColor.setColor(color);
	}
	
	protected boolean needToDraw(){
		return jToggleButton.isSelected();
	}
	
	protected Color getColor(){
		return jCanvasColor.getColor();
	}
	
	public abstract void draw(Graphics g);
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jToggleButton = new javax.swing.JToggleButton();
        jCanvasColor = new sos.canvas.JCanvasColor();

        setLayout(new java.awt.GridBagLayout());

        jToggleButton.setSelected(true);
        jToggleButton.setMargin(new java.awt.Insets(1, 1, 1, 1));
        jToggleButton.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jToggleButtonItemStateChanged(evt);
            }
        });

        add(jToggleButton, new java.awt.GridBagConstraints());

        jCanvasColor.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jCanvasColorMousePressed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        add(jCanvasColor, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents
	
	private void jCanvasColorMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jCanvasColorMousePressed
		gunmetryViewer.overlapImage();
	}//GEN-LAST:event_jCanvasColorMousePressed
	
	private void jToggleButtonItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonItemStateChanged
		gunmetryViewer.overlapImage();
	}//GEN-LAST:event_jToggleButtonItemStateChanged
	
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private sos.canvas.JCanvasColor jCanvasColor;
    private javax.swing.JToggleButton jToggleButton;
    // End of variables declaration//GEN-END:variables
	
}
