package gunmetry;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import sos.graphics.SOSGraphics;
import sos.graphics.PointRect;
/*
 * Markers.java
 *
 * Created on 2005/05/21, 15:05
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

/**
 *
 * @author Gaku Tanaka
 */
public class Markers extends ArrayList<Point> implements SOSGraphics{
	private PointRect pointRect;
	private HashSet<Point> selectedMarker = new HashSet<Point>();
	private boolean visible = true;
	private Color color;
	
	/** Creates a new instance of Markers */
	public Markers() {
	}
	
	public void draw(java.awt.Graphics g) {
		if (visible){
			if (0<selectedMarker.size()){
				g.setColor(Color.white);
				for (Point p: selectedMarker){
					pointRect.setLocation(p.x, p.y);
					pointRect.fillRect(g);
				}
			}
			
			if (0<size()){
				g.setColor(color);
				for (int i=0; i<size(); i++){
					Point p = get(i);
					pointRect.setLocation(p.x,p.y);
					pointRect.drawRect(g);
				}
			}
		}
	}
	
	public void setAll(ArrayList<Point> points){
		clear();
		addAll(points);
	}
	
	public void setVisible(boolean visible) {
		this.visible = visible;
	}
	
	public void setColor(Color color) {
		this.color = color;
	}
	
	public void setPointRect(PointRect pointRect){
		this.pointRect = pointRect;
	}
	
	public Point get(Point2D point){
		for (int i=0; i<size(); i++){
			Point p = get(i);
			pointRect.setLocation(p.x,p.y);
			if (pointRect.contains(point)){
				return p;
			}
		}
		return null;
	}
	
	public void add(String strPoint, double ratioX, double ratioY){
		String[] location = strPoint.split(",");
		int x = (int)(Integer.valueOf(location[0])*ratioX);
		int y = (int)(Integer.valueOf(location[1])*ratioY);
		Point p = new Point(x,y);
		add(p);
	}
	
	public void select(Shape shape){
		Rectangle rect = shape.getBounds();
		for (int i=0; i<size(); i++){
			Point p = get(i);
			if (rect.contains(p)){
				selectedMarker.add(p);
			}
		}
	}
	
	public void select(Point p){
		int index = indexOf(p);
		if (-1<index){
			selectedMarker.add(get(index));
		}
	}
	
	public void clearSelection(){
		selectedMarker.clear();
	}
	
	public void removeSelected(){
		removeAll(selectedMarker);
		clearSelection();
	}
	
	public void translateSelected(int dx, int dy){
		for (Point p: selectedMarker){
			p.translate(dx,dy);
		}
	}

}
