/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

import sos.util.FirstInFirstOut;

public abstract class Sort {
    protected int[] ascendingOrder = null;
    protected int minIndex = -1;
    protected int maxIndex = -1;
    protected int inputLength;
    protected int range;
    protected int offset;
    protected int[] heap;

    public final int[] getOrder() {
        return this.ascendingOrder;
    }

    public final void setOrder(int[] order) {
        this.ascendingOrder = order;
    }

    public final int getOrder(int index) {
        return this.ascendingOrder[index];
    }

    public final int[] getRank() {
        int[] ranking = new int[this.ascendingOrder.length];
        for (int i = 0; i < this.ascendingOrder.length; ++i) {
            ranking[this.ascendingOrder[i]] = i;
        }
        return ranking;
    }

    public int[] getTieRank() {
        int[] tieRank = new int[this.ascendingOrder.length];
        tieRank[0] = 0;
        for (int i = 1; i < tieRank.length; ++i) {
            int ranking = this.equals(this.ascendingOrder[i], this.ascendingOrder[i - 1]) ? tieRank[this.ascendingOrder[i - 1]] : i;
            tieRank[this.ascendingOrder[i]] = ranking;
        }
        return tieRank;
    }

    protected void swap(int i, int j) {
        int value = this.heap[i];
        this.heap[i] = this.heap[j];
        this.heap[j] = value;
    }

    public int[] getDistributive() {
        FirstInFirstOut fifo = new FirstInFirstOut(this.ascendingOrder.length + 1);
        fifo.add(0);
        for (int i = 1; i < this.ascendingOrder.length; ++i) {
            if (this.equals(this.ascendingOrder[i], this.ascendingOrder[i - 1])) continue;
            fifo.add(i);
        }
        fifo.add(this.ascendingOrder.length);
        return fifo.toArray();
    }

    public abstract void sortAdditional(int var1, int var2);

    protected void sort() {
        int k;
        int j;
        int i;
        this.heap = new int[this.range];
        int num = 0;
        for (i = 0; i < this.range; ++i) {
            this.heap[num++] = i + this.offset;
            j = num;
            k = j / 2;
            while (1 < j && this.compare(this.heap[j - 1], this.heap[k - 1])) {
                this.swap(j - 1, k - 1);
                j = k;
                k = j / 2;
            }
        }
        i = 0;
        while (0 < num) {
            this.ascendingOrder[i + this.offset] = this.heap[0];
            this.heap[0] = this.heap[--num];
            j = 1;
            k = j * 2;
            while (k <= num) {
                if (k + 1 <= num && this.compare(this.heap[k], this.heap[k - 1])) {
                    ++k;
                }
                if (this.compare(this.heap[k - 1], this.heap[j - 1])) {
                    this.swap(j - 1, k - 1);
                }
                j = k;
                k = j * 2;
            }
            ++i;
        }
        this.heap = null;
    }

    protected abstract boolean compare(int var1, int var2);

    protected abstract boolean equals(int var1, int var2);

    public final Object[] sort(Object[] data) {
        Object[] result = (Object[])data.clone();
        for (int i = 0; i < data.length; ++i) {
            int index = this.ascendingOrder[i];
            result[i] = data[this.ascendingOrder[i]];
        }
        return result;
    }

    public final double[] sort(double[] data) {
        double[] result = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = data[this.ascendingOrder[i]];
        }
        return result;
    }

    public final int[] sort(int[] data) {
        int[] result = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = data[this.ascendingOrder[i]];
        }
        return result;
    }

    protected void setRange(int start, int end) {
        this.offset = start;
        this.range = end - start;
    }

    protected void initAscendingOrder(int l) {
        this.ascendingOrder = new int[l];
        for (int i = 0; i < l; ++i) {
            this.ascendingOrder[i] = i;
        }
    }
}

