/*
 * Decompiled with CFR 0.152.
 */
package sos.threedim;

import java.awt.Color;
import java.io.Serializable;
import sos.math.MathVector;

public class Vertex
implements Serializable {
    private double[] coordinate;
    private Color color = Color.black;

    public Vertex() {
        this.coordinate = new double[3];
    }

    public Vertex(double[] coordinate) {
        this.setLocation(coordinate);
    }

    public Vertex(double x, double y, double z) {
        this.coordinate = new double[3];
        this.setLocation(x, y, z);
    }

    public void setLocation(double[] coordinate) {
        this.coordinate = coordinate;
    }

    public void setLocation(double x, double y, double z) {
        this.coordinate[0] = x;
        this.coordinate[1] = y;
        this.coordinate[2] = z;
    }

    public void translate(double[] d) {
        this.coordinate[0] = this.coordinate[0] + d[0];
        this.coordinate[1] = this.coordinate[1] + d[1];
        this.coordinate[2] = this.coordinate[2] + d[2];
    }

    public void translate(double dx, double dy, double dz) {
        this.coordinate[0] = this.coordinate[0] + dx;
        this.coordinate[1] = this.coordinate[1] + dy;
        this.coordinate[2] = this.coordinate[2] + dz;
    }

    public double distanceSq(Vertex v) {
        return MathVector.norm(this.coordinate, v.getLocation());
    }

    public double distanceSq(double[] co) {
        return MathVector.norm(this.coordinate, co);
    }

    public void reset() {
        this.setLocation(0.0, 0.0, 0.0);
    }

    public double getX() {
        return this.coordinate[0];
    }

    public double getY() {
        return this.coordinate[1];
    }

    public double getZ() {
        return this.coordinate[2];
    }

    public double[] getLocation() {
        return this.coordinate;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

