/*
 * Decompiled with CFR 0.152.
 */
package sos.math;

import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevertPolish {
    private static char character;
    private static String strIn;
    private static StringBuffer strOut;
    private static int nextStrIn;

    private static void setCharacter() throws RuntimeException {
        if (nextStrIn == strIn.length()) {
            throw new RuntimeException("'" + character + "' \u4ee5\u964d\u7d9a\u304d\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        while ((character = strIn.charAt(nextStrIn++)) == ' ' || character == '\t') {
        }
        if (Character.isLowerCase(character)) {
            character = Character.toUpperCase(character);
        }
    }

    private static boolean isEqual(String func) {
        int len = func.length();
        if (nextStrIn + len - 1 > strIn.length()) {
            return false;
        }
        String subs = strIn.substring(nextStrIn - 1, nextStrIn + len - 1);
        if (func.equalsIgnoreCase(subs)) {
            nextStrIn += len - 1;
            RevertPolish.setCharacter();
            return true;
        }
        return false;
    }

    private static void expression() throws RuntimeException {
        RevertPolish.term();
        while (character == '+' || character == '-') {
            char old_ch = character;
            RevertPolish.setCharacter();
            RevertPolish.term();
            strOut.append(old_ch + ",");
        }
    }

    private static void term() throws RuntimeException {
        RevertPolish.sign();
        while (character == '*' || character == '/') {
            char old_ch = character;
            RevertPolish.setCharacter();
            RevertPolish.sign();
            strOut.append(old_ch + ",");
        }
    }

    private static void sign() throws RuntimeException {
        if (character == '-') {
            RevertPolish.setCharacter();
            RevertPolish.sign();
            strOut.append("-1,*,");
        } else if (character == '+') {
            RevertPolish.setCharacter();
            RevertPolish.sign();
        } else {
            RevertPolish.pow();
        }
    }

    private static void pow() throws RuntimeException {
        RevertPolish.function();
        while (character == '^') {
            char old_ch = character;
            RevertPolish.setCharacter();
            RevertPolish.sign();
            strOut.append(old_ch + ",");
        }
    }

    private static void signPreFunction() throws RuntimeException {
        if (character == '-') {
            RevertPolish.setCharacter();
            RevertPolish.signPreFunction();
            strOut.append("-1,*,");
        } else if (character == '+') {
            RevertPolish.setCharacter();
            RevertPolish.signPreFunction();
        } else {
            RevertPolish.function();
        }
    }

    private static void function() throws RuntimeException {
        if (RevertPolish.isEqual("SIN")) {
            RevertPolish.signPreFunction();
            strOut.append("SIN,");
        } else if (RevertPolish.isEqual("COS")) {
            RevertPolish.signPreFunction();
            strOut.append("COS,");
        } else if (RevertPolish.isEqual("TAN")) {
            RevertPolish.signPreFunction();
            strOut.append("TAN,");
        } else if (RevertPolish.isEqual("ARCSIN")) {
            RevertPolish.signPreFunction();
            strOut.append("ARCSIN,");
        } else if (RevertPolish.isEqual("ARCCOS")) {
            RevertPolish.signPreFunction();
            strOut.append("ARCCOS,");
        } else if (RevertPolish.isEqual("ARCTAN")) {
            RevertPolish.signPreFunction();
            strOut.append("ARCTAN,");
        } else if (RevertPolish.isEqual("SQR")) {
            RevertPolish.signPreFunction();
            strOut.append("SQR,");
        } else if (RevertPolish.isEqual("LN")) {
            RevertPolish.signPreFunction();
            strOut.append("LN,");
        } else if (RevertPolish.isEqual("EXP")) {
            RevertPolish.signPreFunction();
            strOut.append("EXP,");
        } else if (RevertPolish.isEqual("ABS")) {
            RevertPolish.signPreFunction();
            strOut.append("ABS,");
        } else if (RevertPolish.isEqual("INT")) {
            RevertPolish.signPreFunction();
            strOut.append("INT,");
        } else if (RevertPolish.isEqual("RND")) {
            RevertPolish.signPreFunction();
            strOut.append("RND,");
        } else {
            RevertPolish.factor();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void factor() throws RuntimeException {
        if (character == '(') {
            RevertPolish.setCharacter();
            RevertPolish.expression();
            if (character != ')') throw new RuntimeException("\u5bfe\u5fdc\u3059\u308b')'\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
            RevertPolish.setCharacter();
            return;
        } else if (Character.isDigit(character) || character == '.') {
            RevertPolish.number();
            strOut.append(',');
            return;
        } else if (Character.isUpperCase(character)) {
            RevertPolish.variable();
            strOut.append(',');
            return;
        } else {
            if (character != '\n') throw new RuntimeException("'" + character + "' \u4e0d\u660e\u306a\u6587\u5b57\u3067\u3059\u3002");
            throw new RuntimeException("\u5f0f\u304c\u9014\u4e2d\u3067\u7d42\u308f\u3063\u3066\u3044\u307e\u3059\u3002");
        }
    }

    private static void variable() {
        while (Character.isUpperCase(character) || Character.isDigit(character) || character == '_') {
            strOut.append(character);
            RevertPolish.setCharacter();
        }
    }

    private static void number() throws RuntimeException {
        while (Character.isDigit(character)) {
            strOut.append(character);
            RevertPolish.setCharacter();
        }
        if (character == '.') {
            strOut.append(character);
            RevertPolish.setCharacter();
            RevertPolish.number_();
        }
        if (character == 'E') {
            strOut.append(character);
            RevertPolish.setCharacter();
            if (character == '-' || character == '+') {
                strOut.append(character);
                RevertPolish.setCharacter();
                RevertPolish.number_();
            } else {
                RevertPolish.number_();
            }
        }
    }

    private static void number_() throws RuntimeException {
        if (Character.isDigit(character)) {
            do {
                strOut.append(character);
                RevertPolish.setCharacter();
            } while (Character.isDigit(character));
        } else {
            throw new RuntimeException("\u5c0f\u6570\u70b9\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc\u3002");
        }
    }

    public static String convert(String equation) throws RuntimeException {
        strIn = equation + '\n';
        strOut = new StringBuffer();
        nextStrIn = 0;
        RevertPolish.setCharacter();
        RevertPolish.expression();
        if (character != '\n') {
            throw new RuntimeException("'" + character + "' \u4f59\u5206\u306a\u6587\u5b57\u3067\u3059\u3002");
        }
        String postfix = new String(strOut);
        strIn = null;
        strOut = null;
        return postfix;
    }

    public static double calc(String expression, double[] variables) {
        String[] elements = expression.split(",");
        LinkedList<Double> stack = new LinkedList<Double>();
        for (int i = 0; i < elements.length; ++i) {
            try {
                if (elements[i].startsWith("V")) {
                    int index = Integer.parseInt(elements[i].substring(1));
                    stack.add(variables[index - 1]);
                    continue;
                }
                stack.add(new Double(elements[i]));
                continue;
            }
            catch (NumberFormatException e) {
                RevertPolish.operation(stack, elements[i]);
            }
        }
        double answer = (Double)stack.removeLast();
        return answer;
    }

    public static double calc(String expression, int[] variables) {
        String[] elements = expression.split(",");
        LinkedList<Double> stack = new LinkedList<Double>();
        for (int i = 0; i < elements.length; ++i) {
            try {
                if (elements[i].startsWith("V")) {
                    int index = Integer.parseInt(elements[i].substring(1));
                    stack.add(1.0 * (double)variables[index - 1]);
                    continue;
                }
                stack.add(new Double(elements[i]));
                continue;
            }
            catch (NumberFormatException e) {
                RevertPolish.operation(stack, elements[i]);
            }
        }
        double answer = (Double)stack.removeLast();
        return answer;
    }

    public static double calc(String expression) {
        String[] elements = expression.split(",");
        LinkedList<Double> stack = new LinkedList<Double>();
        for (int i = 0; i < elements.length; ++i) {
            try {
                stack.add(new Double(elements[i]));
                continue;
            }
            catch (NumberFormatException e) {
                RevertPolish.operation(stack, elements[i]);
            }
        }
        double answer = (Double)stack.removeLast();
        return answer;
    }

    private static void operation(LinkedList<Double> stack, String operator) throws RuntimeException {
        if (operator.equals("+")) {
            double d1 = stack.removeLast();
            double d2 = stack.removeLast();
            stack.add(new Double(d2 + d1));
        } else if (operator.equals("-")) {
            double d1 = stack.removeLast();
            double d2 = stack.removeLast();
            stack.add(new Double(d2 - d1));
        } else if (operator.equals("*")) {
            double d1 = stack.removeLast();
            double d2 = stack.removeLast();
            stack.add(new Double(d2 * d1));
        } else if (operator.equals("/")) {
            double d1 = stack.removeLast();
            double d2 = stack.removeLast();
            stack.add(new Double(d2 / d1));
        } else if (operator.equals("^")) {
            double d1 = stack.removeLast();
            double d2 = stack.removeLast();
            stack.add(new Double(Math.pow(d2, d1)));
        } else if (operator.equals("PI")) {
            stack.add(new Double(Math.PI));
        } else if (operator.equals("E")) {
            stack.add(new Double(Math.E));
        } else if (operator.equals("SIN")) {
            double d = stack.removeLast();
            stack.add(new Double(Math.sin(d)));
        } else if (operator.equals("COS")) {
            double d = stack.removeLast();
            stack.add(new Double(Math.cos(d)));
        } else if (operator.equals("TAN")) {
            double d = stack.removeLast();
            stack.add(new Double(Math.tan(d)));
        } else if (operator.equals("ARCSIN")) {
            double d = stack.removeLast();
            stack.add(new Double(Math.asin(d)));
        } else if (operator.equals("ARCCOS")) {
            double d = stack.removeLast();
            stack.add(new Double(Math.acos(d)));
        } else if (operator.equals("ARCTAN")) {
            double d = stack.removeLast();
            stack.add(new Double(Math.atan(d)));
        } else if (operator.equals("SQR")) {
            double d = stack.removeLast();
            stack.add(new Double(Math.sqrt(d)));
        } else if (operator.equals("LN")) {
            double d = stack.removeLast();
            stack.add(new Double(Math.log(d)));
        } else if (operator.equals("EXP")) {
            double d = stack.removeLast();
            stack.add(new Double(Math.exp(d)));
        } else if (operator.equals("ABS")) {
            double d = stack.removeLast();
            stack.add(new Double(Math.abs(d)));
        } else if (operator.equals("INT")) {
            double d = stack.removeLast();
            stack.add(new Double(Math.floor(d)));
        } else if (operator.equals("RND")) {
            double d = stack.removeLast();
            if (d >= 1.0) {
                double rnd = Math.floor(Math.random() * Math.floor(d)) + 1.0;
                stack.add(new Double(rnd));
            } else {
                stack.add(new Double(Math.random()));
            }
        } else {
            if (operator.length() == 1) {
                throw new RuntimeException("'" + operator + "' \u672a\u5b9a\u7fa9\u3067\u3059\u3002");
            }
            throw new RuntimeException("\"" + operator + "\" \u672a\u5b9a\u7fa9\u3067\u3059\u3002");
        }
    }
}

