/*
 * Decompiled with CFR 0.152.
 */
package sos.image;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import sos.image.ImagePixelMediator;
import sos.process.NeighborFrame;
import sos.util.ColorVector;
import sos.util.MinMaxInteger;

public class ImageInfo {
    private String fileName;
    private NeighborFrame neighborFrame = new NeighborFrame(1, 1);
    private int[] pixels;
    private int[] pixelsColorsTable = null;
    private int[] pixelsLabel = new int[1];
    private int[] intRGB;
    private int[] colorsHistogram;
    private double[][] colorVectors;
    private int[][] colorsPixelsTable = null;
    private int colorSpaceType;

    public ImageInfo() {
        this.pixelsColorsTable = new int[1];
    }

    public ImageInfo(BufferedImage img) {
        this();
        this.setImage(img);
    }

    public void setImage(Image img) {
        this.setSize(img.getWidth(null), img.getHeight(null));
        this.extractPixels(img);
    }

    private void extractPixels(Image img) {
        this.pixels = ImagePixelMediator.convertToPixels(img);
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public final void setSize(int w, int h) {
        if (w != this.neighborFrame.width || h != this.neighborFrame.height) {
            this.neighborFrame = new NeighborFrame(w, h);
        }
        if (this.pixelsLabel.length != this.neighborFrame.size) {
            this.pixelsColorsTable = new int[this.neighborFrame.size];
            this.pixelsLabel = new int[this.neighborFrame.size];
        }
    }

    public final int getWidth() {
        return this.neighborFrame.width;
    }

    public final int getHeight() {
        return this.neighborFrame.height;
    }

    public final int getImageSize() {
        return this.neighborFrame.size;
    }

    public final void setName(String name) {
        this.fileName = name;
    }

    public final String getName() {
        return this.fileName;
    }

    public final int getUsedColorNumber() {
        return this.intRGB.length;
    }

    public final int[] getIntRGB() {
        return this.intRGB;
    }

    public final int getIntRGB(int index) {
        return this.intRGB[index];
    }

    public final int[] getPixelColorTable() {
        return this.pixelsColorsTable;
    }

    public final int getPixelColorTable(int index) {
        return this.pixelsColorsTable[index];
    }

    public final void setColor(int[] pixels) {
        this.intRGB = ColorVector.extractUsedColor(pixels);
        this.colorsHistogram = ColorVector.makeHistogram(pixels, this.intRGB, this.pixelsColorsTable);
    }

    public final void setIntRGB(int[] rgb) {
        this.intRGB = rgb;
    }

    public final void setColorHistogram(int[] h) {
        this.colorsHistogram = h;
    }

    public final double[][] getRGB() {
        this.colorSpaceType = 0;
        double[][] input = new double[this.intRGB.length][3];
        ColorVector.getRGB(this.intRGB, input);
        return input;
    }

    public final double[][] getLAB() {
        this.colorSpaceType = 1;
        double[][] input = new double[this.intRGB.length][3];
        ColorVector.getLAB(this.intRGB, input);
        return input;
    }

    public final int[] getHistogram() {
        return this.colorsHistogram;
    }

    public final NeighborFrame getNeighborFrame() {
        return this.neighborFrame;
    }

    public final void setPixelsLabel(int[] colorLabel) {
        for (int pn = 0; pn < this.neighborFrame.size; ++pn) {
            this.pixelsLabel[pn] = colorLabel[this.pixelsColorsTable[pn]];
        }
    }

    public final void setPixelsLabel(int index, int value) {
        this.pixelsLabel[index] = value;
    }

    public final int[] getPixelsLabel() {
        return this.pixelsLabel;
    }

    public final int getPixelsLabel(int index) {
        return this.pixelsLabel[index];
    }

    public final void clearLabel() {
        for (int i = 0; i < this.pixelsLabel.length; ++i) {
            this.pixelsLabel[i] = -1;
        }
    }

    public final int[][] getColorPixelTable() {
        if (this.colorsPixelsTable != null) {
            return this.colorsPixelsTable;
        }
        this.colorsPixelsTable = new int[this.intRGB.length][];
        for (int in = 0; in < this.intRGB.length; ++in) {
            this.colorsPixelsTable[in] = new int[this.colorsHistogram[in]];
            Arrays.fill(this.colorsPixelsTable[in], -1);
        }
        block1: for (int pn = 0; pn < this.neighborFrame.size; ++pn) {
            int index = this.pixelsColorsTable[pn];
            for (int i = 0; i < this.colorsPixelsTable[index].length; ++i) {
                if (this.colorsPixelsTable[index][i] != -1) continue;
                this.colorsPixelsTable[index][i] = pn;
                continue block1;
            }
        }
        return this.colorsPixelsTable;
    }

    public int getColorSpaceType() {
        return this.colorSpaceType;
    }

    public int[] createClusterFromLabel(int nUnit) {
        int[] result = new int[this.intRGB.length];
        this.setClusterFromLabel(nUnit, result);
        return result;
    }

    public void setClusterFromLabel(int nUnit, int[] cluster) {
        int[][] nLabel = new int[this.intRGB.length][nUnit];
        for (int pn = 0; pn < this.neighborFrame.size; ++pn) {
            int[] nArray = nLabel[this.pixelsColorsTable[pn]];
            int n = this.getPixelsLabel(pn);
            nArray[n] = nArray[n] + 1;
        }
        MinMaxInteger mmi = new MinMaxInteger();
        for (int in = 0; in < this.intRGB.length; ++in) {
            mmi.compareMax(nLabel[in]);
            cluster[in] = mmi.getIndex();
        }
    }
}

