package org.dyndns.nuda.mapper.helper.xml;

import java.util.Stack;

import org.dyndns.nuda.tools.xml.Context;
import org.dyndns.nuda.tools.xml.ScopeHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * SQLインタフェースコンテナコマンドXMLを解析するためのスコープオブジェクトです
 * 
 * @author nkoseki
 * 
 */
public enum SQLXMLInterfaceCommandScope implements
		ScopeHandler<SQLInterfaceCommandResultBean> {
	
	/**
	 * ノード：SQLInterfaceCommand を表します
	 */
	SQLInterfaceCommand {
		@Override
		public void startElement(
				final Context<SQLInterfaceCommandResultBean> ctx,
				final String uri, final String localName, final String qName,
				final Attributes attributes) throws SAXException {
		}
		
		@Override
		public void endElement(
				final Context<SQLInterfaceCommandResultBean> ctx,
				final String uri, final String localName, final String qName)
				throws SAXException {
		}
		
		@Override
		public void characters(
				final Context<SQLInterfaceCommandResultBean> ctx,
				final char[] ch, final int start, final int length)
				throws SAXException {
		}
	},
	
	/**
	 * ノード：command を表します
	 */
	command {
		@Override
		public void startElement(
				final Context<SQLInterfaceCommandResultBean> ctx,
				final String uri, final String localName, final String qName,
				final Attributes attributes) throws SAXException {
			SQLInterfaceCommandXMLBean bean = new SQLInterfaceCommandXMLBean();
			bean.type = attributes.getValue("type");
			bean.implementation = attributes.getValue("implementation");
			
			ctx.getValue().beans.add(bean);
		}
		
		@Override
		public void endElement(
				final Context<SQLInterfaceCommandResultBean> ctx,
				final String uri, final String localName, final String qName)
				throws SAXException {
		}
		
		@Override
		public void characters(
				final Context<SQLInterfaceCommandResultBean> ctx,
				final char[] ch, final int start, final int length)
				throws SAXException {
			// TODO 自動生成されたメソッド・スタブ
			
		}
	},
	
	/**
	 * ノード：invalid を表します
	 */
	invalid {
		
		@Override
		public void startElement(
				final Context<SQLInterfaceCommandResultBean> ctx,
				final String uri, final String localName, final String qName,
				final Attributes attributes) throws SAXException {
		}
		
		@Override
		public void endElement(
				final Context<SQLInterfaceCommandResultBean> ctx,
				final String uri, final String localName, final String qName)
				throws SAXException {
			// TODO 自動生成されたメソッド・スタブ
			
		}
		
		@Override
		public void characters(
				final Context<SQLInterfaceCommandResultBean> ctx,
				final char[] ch, final int start, final int length)
				throws SAXException {
		}
	};
	
	@Override
	public ScopeHandler<SQLInterfaceCommandResultBean> changeScope(
			final Stack<ScopeHandler<SQLInterfaceCommandResultBean>> scopeStack,
			final String qName) {
		try {
			return SQLXMLInterfaceCommandScope.valueOf(qName);
		} catch (Exception e) {
			e.printStackTrace();
			return invalid;
		}
		
	}
	
	@Override
	public ScopeHandler<SQLInterfaceCommandResultBean> defaultScope() {
		return invalid;
	}
	
}
