package org.dyndns.nuda.mapper.helper.command;

import org.dyndns.nuda.mapper.JDBCXMLInvocationHandler;
import org.dyndns.nuda.mapper.connection.SQLInterfaceConnection;

/**
 * SQLインタフェースコンテナ制御コマンド：ユーザベーストラン制御機能制御コマンド
 * 
 * @author nkoseki
 * 
 */
public class UseManualTransactionCommandImpl implements
		UseManualTransactionCommand {
	private JDBCXMLInvocationHandler	container;
	
	@Override
	public void setContainer(final JDBCXMLInvocationHandler container) {
		this.container = container;
	}
	
	@Override
	public JDBCXMLInvocationHandler getContainer() {
		return this.container;
	}
	
	@Override
	public void useManualTransaction(final boolean useManualTransaction) {
		if (this.container != null) {
			this.container.setManualTransaction(useManualTransaction);
			if (this.container.getConnection() instanceof SQLInterfaceConnection) {
				SQLInterfaceConnection con =
					(SQLInterfaceConnection) this.container.getConnection();
				con.setUseManualTransaction(useManualTransaction);
			}
		}
	}
	
	@Override
	public boolean isUseManualTransaction() {
		if (this.container != null) {
			return this.container.isManualTransaction();
		} else {
			//			System.out
			//				.println("UseManualTransactionCommandImpl#isUseManualTransaction [コンテナが存在しないためコマンドの起動に失敗しました]");
			return false;
		}
	}
	
}
