package org.dyndns.nuda.mapper.helper.command;

import java.sql.SQLException;

import org.dyndns.nuda.mapper.JDBCXMLInvocationHandler;
import org.dyndns.nuda.mapper.connection.SQLInterfaceConnection;

/**
 * SQLインタフェースコンテナ制御コマンド：自動コミットモード制御コマンド
 * 
 * @author nkoseki
 * 
 */
public class UseAutoCommitCommandImpl implements UseAutoCommitCommand {
	private JDBCXMLInvocationHandler	container;
	
	@Override
	public void setContainer(final JDBCXMLInvocationHandler container) {
		this.container = container;
	}
	
	@Override
	public JDBCXMLInvocationHandler getContainer() {
		return this.container;
	}
	
	@Override
	public void useAutoCommit(final boolean useAutoCommit) {
		if (this.container != null) {
			if (this.container.getConnection() instanceof SQLInterfaceConnection) {
				SQLInterfaceConnection con =
					(SQLInterfaceConnection) this.container.getConnection();
				try {
					con.setAutoCommit(useAutoCommit);
					this.container.setUseAutoCommit(useAutoCommit);
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
		}
	}
	
	@Override
	public boolean isUseAutoCommit() {
		if (this.container != null) {
			return this.container.isUseAutoCommit();
		} else {
			return false;
		}
	}
	
}
