package org.dyndns.nuda.mapper.helper.command;

import org.dyndns.nuda.mapper.helper.SQLInterfaceControllerCommand;

/**
 * 自動コミットモードを制御するためのSQLインタフェースコンテナ制御コマンドです
 * 
 * @author nkoseki
 * 
 */
public interface UseAutoCommitCommand extends SQLInterfaceControllerCommand {
	
	/**
	 * 自動コミットモードを設定します
	 * 
	 * @param useAutoCommit
	 *            自動コミットモードON:true / 自動コミットモードOFF:false
	 */
	public void useAutoCommit(boolean useAutoCommit);
	
	/**
	 * 現在設定されている自動コミットモードを取得します
	 * 
	 * @return useAutoCommit
	 *         自動コミットモードON:true / 自動コミットモードOFF:false
	 */
	public boolean isUseAutoCommit();
}
