package org.dyndns.nuda.mapper;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;

/**
 * SQLXMLで用いる検索条件を表すオブジェクトです
 * 
 * @author nkoseki
 * 
 */
public class QueryCondition {
	private Map<String, String>	conditions	=
												new LinkedHashMap<String, String>();
	
	public void addCondition(final String target, final String aCondition) {
		if (target != null
			&& !target.isEmpty()
			&& aCondition != null
			&& !aCondition.isEmpty()
			&& this.checkCondition(target, aCondition)) {
			this.conditions.put(target, aCondition);
		}
	}
	
	public boolean checkCondition(final String target, final String aCondition) {
		return true;
	}
	
	public String renderCondition() {
		StringBuilder b = new StringBuilder();
		b.append("\n");
		for (Entry<String, String> entry : this.conditions.entrySet()) {
			b.append("AND");
			b.append("\t");
			
			b.append(entry.getKey());
			b.append("\t");
			b.append(entry.getValue());
			b.append("\n");
		}
		return b.toString();
	}
}
