package org.dyndns.nuda.mapper;

/**
 * JavaBeans'S'からJavaBeans'D'への変換を表すインタフェースです
 * 
 * @author nkoseki
 * 
 * @param <S>
 *            変換元JavaBeans
 * @param <D>
 *            変換先JavaBeans
 */
public interface BeanTransfer<S, D> {
	
	/**
	 * 引数に指定されたJavaBeansを型DがあらわすJavaBeansへと変換します
	 * 
	 * @param source
	 *            変換元JavaBeansオブジェクト
	 * @return 変換先JavaBeansオブジェクト
	 */
	public D transfer(S source);
}
