/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.mapper.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dyndns.nuda.mapper.event.SQLInterfaceEvent;
import org.dyndns.nuda.mapper.event.SQLInterfaceEventListener;

public class SQLInterfaceEventProcessor {
    private static Map<Class<?>, List<SQLInterfaceEventListener<?>>> listenerMap = new HashMap();

    private SQLInterfaceEventProcessor() {
    }

    public static SQLInterfaceEventProcessor newInstance() {
        return new SQLInterfaceEventProcessor();
    }

    public <T extends SQLInterfaceEvent> SQLInterfaceEventProcessor addEventListener(SQLInterfaceEventListener<T> listener) {
        if (listener == null) {
            return this;
        }
        Class<?> eventListenerObject = listener.getClass();
        Class<?> paramType = SQLInterfaceEventProcessor.getGenClass(eventListenerObject);
        if (listenerMap.containsKey(paramType)) {
            List<SQLInterfaceEventListener<?>> listenerList = listenerMap.get(paramType);
            listenerList.add(listener);
        } else {
            ArrayList<SQLInterfaceEventListener<T>> listenerList = new ArrayList<SQLInterfaceEventListener<T>>();
            listenerList.add(listener);
            listenerMap.put(paramType, listenerList);
        }
        return this;
    }

    public void broadcast(SQLInterfaceEvent event) {
        if (event == null) {
            return;
        }
        Class<?> eventClass = event.getClass();
        if (listenerMap.containsKey(eventClass)) {
            List<SQLInterfaceEventListener<?>> listenerList = listenerMap.get(eventClass);
            for (SQLInterfaceEventListener<?> listener : listenerList) {
                Class<?> listenerClass = listener.getClass();
                try {
                    Method m = listenerClass.getDeclaredMethod("handle", event.getClass());
                    if (m.getModifiers() != 1) continue;
                    if (!m.isAccessible()) {
                        m.setAccessible(true);
                    }
                    m.invoke(listener, event);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static Class<?> getGenClass(Class<?> param) {
        ParameterizedType parameterizedType;
        Type[] actTypes;
        Class result = null;
        Type[] intfTypes = param.getGenericInterfaces();
        if (intfTypes.length == 0) {
            return null;
        }
        Type type0 = intfTypes[0];
        if (type0 instanceof ParameterizedType && (actTypes = (parameterizedType = (ParameterizedType)type0).getActualTypeArguments()).length != 0 && actTypes[0] instanceof Class) {
            Class genType;
            result = genType = (Class)actTypes[0];
        }
        return result;
    }
}

