﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Controls;
using System.Windows;
using form = System.Windows.Forms;
using System.Diagnostics;
using System.Threading;
using System.IO;
using System.Windows.Threading;
using Ionic.Zip;
using Ionic.Zlib;
namespace Serius
{
    class Node_page : Canvas
    {
        public static Info info;
        Button button_mongo = new Button() { Content = "start mongodb" };
        Button button_node_inspector = new Button() { Content = "start node-inspector" };
        Button button_node_debug = new Button() { Content = "debug node app" };
        Button button_clear_text = new Button() { Content = "clear text" };
        TextBox console = new TextBox() { IsReadOnly = true};
        static Node_page()
        {
            info = Info.read();
        }
        public Node_page()
        {
            GlobalEvent.add(new Simple_event(node_check));
            ScrollViewer scroll = new ScrollViewer() { Width = 600, Height = 450, HorizontalScrollBarVisibility = ScrollBarVisibility.Auto};
            scroll.Content = console;
            this.Children.Add(button_mongo);
            button_mongo.Click += button_mongo_Click;
            Canvas.SetLeft(button_mongo, 0);
            this.Children.Add(button_node_inspector);
            button_node_inspector.Click += button_node_inspector_Click;
            Canvas.SetLeft(button_node_inspector, 100);
            this.Children.Add(button_node_debug);
            button_node_debug.Click += button_node_debug_Click;
            GlobalEvent.add(new Simple_event(init_mongo));
            Canvas.SetLeft(button_node_debug, 250);
            button_clear_text.Click += button_clear_text_Click;
            Canvas.SetLeft(button_clear_text, 350);
            this.Children.Add(button_clear_text);
            this.Children.Add(scroll);
            Canvas.SetLeft(scroll, 0); Canvas.SetTop(scroll, 30);

        }

        void button_clear_text_Click(object sender, RoutedEventArgs e)
        {
            console.Text = "";
        }
        
        public void node_check()
        {
            if (info.node_version == null)
            {
                GlobalEvent.add(new Simple_event(node_version));
            }
            else node_inspector_check();
        }
        public void node_version()
        {
            Process p = e(System.Environment.GetEnvironmentVariable("ComSpec"), "/c node -v", null, get_data, null);
        }
        String ver;
        public void get_data(object sender, DataReceivedEventArgs e)
        {
            if (e.Data != null && e.Data.StartsWith("v"))
            {
                info.node_version = e.Data;
            }
            else if (e.Data == null && info.node_version == null)
            {
                if (MessageBox.Show("node.jsをインストールしますか", "node.js installer", MessageBoxButton.YesNo) == MessageBoxResult.Yes)
                {
                    if (IntPtr.Size == 4) execute(AppDomain.CurrentDomain.BaseDirectory + "/node-v0.8.12-x86.msi", "", 1);
                    else if (IntPtr.Size == 8) execute(AppDomain.CurrentDomain.BaseDirectory + "/node-v0.8.12-x64.msi", "", 1);
                }
            }
            GlobalEvent.add(new Simple_event(node_inspector_check));
        }
        public void node_inspector_check()
        {
            if (info.node_inspector_exist == null)
            {
                e(System.Environment.GetEnvironmentVariable("ComSpec"), "/c node-inspector", null, node_inspector_get, null);
                GlobalEvent.add(new Simple_event(mongodb_check));
            }
            else mongodb_check();
        }
        public void node_inspector_get(object sender, DataReceivedEventArgs e)
        {
            if (e.Data != null && e.Data.StartsWith("info"))
            {
                info.node_inspector_exist = "true";
            }
            else if (e.Data == null) {
                if (info.node_inspector_exist == null)
                {
                    if (MessageBox.Show("node-inspectorをインストールしますか。", "node-inspector install") == MessageBoxResult.OK)
                    {
                        node_inspector_install();
                    }
                }
            }
        }
        public void node_inspector_install()
        {
            execute(System.Environment.GetEnvironmentVariable("ComSpec"), "/c npm install -g node-inspector", 1000);
        }
        public void chrome_check() {
            if (info.chrome_address == null)
            {
                FileInfo fi = new FileInfo(@"C:\Program Files (x86)\Google\Chrome\Application\chrome.exe");
                if (fi.Exists)
                {
                    info.chrome_address = fi.FullName;
                    return;
                }
                fi = new FileInfo(Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData) + @"\Google\Chrome\Application\chrome.exe");
                if (fi.Exists) {
                    info.chrome_address = fi.FullName;
                    return;
                }
                if (MessageBox.Show("Chromeをインストールしますか？", "Chrome install?", MessageBoxButton.YesNo) == MessageBoxResult.Yes) {
                    execute(AppDomain.CurrentDomain.BaseDirectory + "ChromeSetup.exe", "", 1000);
                }
            }
        }
        public void mongodb_check()
        {
            if (info.mongo_address == null)
            {
                DirectoryInfo di = new DirectoryInfo("c:/data");
                if (di.Exists == false) di.Create();
                di = new DirectoryInfo("c:/data/db");
                if (di.Exists == false) di.Create();
                switch(MessageBox.Show("mognodbをインストールしますか、引用しますか", "mongodb installer", MessageBoxButton.YesNoCancel)) {
                    case MessageBoxResult.Yes:
                        String option = "";
                        if (IntPtr.Size == 4) option = "i386-2.2.0";
                        else if (IntPtr.Size == 8) option = "x86_64-2.2.0";
                        String address = AppDomain.CurrentDomain.BaseDirectory + "mongodb-win32-" + option;
                        ZipFile zip = new ZipFile(address + ".zip");
                        zip.ExtractAll(AppDomain.CurrentDomain.BaseDirectory);
                        zip.Dispose();
                        info.mongo_address = address + "/bin";
                        break;
                    case MessageBoxResult.No:
                        form.OpenFileDialog dialog = new form.OpenFileDialog();
                        dialog.Filter = "mongod.exe|mongod.exe";
                        if (dialog.ShowDialog() == form.DialogResult.OK) {
                            info.mongo_address = dialog.FileName.Substring(0, dialog.FileName.LastIndexOf('\\'));
                        }
                        break;
                }
            }
            chrome_check();
        }
        void button_node_debug_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            Process[] ps = Process.GetProcessesByName("node");
            if (ps.Length != 0)
            {
                foreach(Process p in ps) p.Kill();
            }
            GlobalEvent.add(new Simple_event(start_node_inspector));
            GlobalEvent.add(new Simple_event(start_node_debug));
        }
        public void void_function() { }

        void button_node_inspector_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            start_node_inspector();
        }
        int n = 0;
        Process p_inspector;
        public void start_node_inspector()
        {
            p_inspector = execute(System.Environment.GetEnvironmentVariable("ComSpec"), @"/c node-inspector", 10);
        }
        public Process execute(String file_name, String arguments, int loop_count)
        {
            return e(file_name, arguments, new Simple_event(get_info) { status = Simple_event_staus.Loop, loop_count = loop_count }, p_OutputDataReceived, p_OutputDataReceived);
        }
        public Process e(String file_name, String arguments, Simple_event checker, DataReceivedEventHandler output, DataReceivedEventHandler error)
        {
            ProcessStartInfo psi = new ProcessStartInfo();
            Process p = new Process();
            psi.FileName = file_name;
            psi.RedirectStandardInput = true;
            if (output != null)
            {
                psi.RedirectStandardOutput = true;
                p.OutputDataReceived += output;
            }
            else psi.RedirectStandardOutput = false;
            if (error != null)
            {
                psi.RedirectStandardError = true;
                p.ErrorDataReceived += error;
            }
            psi.UseShellExecute = false;
            psi.CreateNoWindow = true;
            psi.Arguments = arguments;
            p.StartInfo = psi;
            p.Start();
            if (output != null) p.BeginOutputReadLine();
            if (error != null) p.BeginErrorReadLine();
            GlobalEvent.add(checker);
            return p;
        }
        void p_OutputDataReceived(object sender, DataReceivedEventArgs e)
        {
            str += e.Data + "\n";
        }
        Process p_node;
        public void start_node_debug()
        {
            p_node = execute(System.Environment.GetEnvironmentVariable("ComSpec"), @"/c cd " + Project.project.address + " & node --debug server.js", -1);//, new Simple_event(get_info_node) { status = Simple_event_staus.Loop, loop_count = -1 }, null, p_OutputDataReceived);
            addresses.Add("http://localhost:8080/debug?port=5858");
            GlobalEvent.add(new Simple_event(open_browse));
            addresses.Add("http://localhost:5963");
            GlobalEvent.add(new Simple_event(open_browse));
        }
        public List<String> addresses = new List<string>();
        public void open_browse()
        {
            execute(info.chrome_address, addresses[0], 1);
            addresses.RemoveAt(0);
        }
        void button_mongo_Click(object sender, System.Windows.RoutedEventArgs e)
        {
            if (info.mongo_address == null)
            {
                mongodb_check();
                return;
            }
            stop_mongo(true);
            if ((String)button_mongo.Content == "start mongodb")
            {
                GlobalEvent.add(new Simple_event(start_mongo));
                button_mongo.Content = "stop mongodb";
            }
            else
            {
                button_mongo.Content = "start mongodb";
            }
        }
        Process p_mongo;
        public void init_mongo()
        {
            Process[] ps = Process.GetProcessesByName("mongod");
            if (ps.Length == 0)
            {
                if (info.mongo_address == null) return;
                GlobalEvent.add(new Simple_event(start_mongo));
                button_mongo.Content = "stop mongodb";
            }
        }
        public void stop_mongo(bool wait)
        {
            
            Process[] ps = Process.GetProcessesByName("mongod");
            if (ps.Length != 0)
            {
                p_mongo = execute(AppDomain.CurrentDomain.BaseDirectory + "stop_mongo.exe", info.mongo_address, 10);
                if (wait) p_mongo.WaitForExit();
            }
        }
        public void stop_mongo_input1()
        {
            p_mongo.StandardInput.WriteLine("use admin");
        }
        public void stop_mongo_input2()
        {
            p_mongo.StandardInput.WriteLine("db.shutdownServer()");
        }
        public void stop_mongo_finish()
        {
            p_mongo.Kill();
        }
        public void start_mongo()
        {
            p_mongo = execute(info.mongo_address + "/mongod.exe", "", -1);// new Simple_event(get_info_of_mongod) { status = Simple_event_staus.Loop, loop_count = -1 }, null, p_OutputDataReceived);
            //psi.Arguments = "--repair";
        }
        public void get_info_node()
        {
            String line;
            while ((line = p_node.StandardOutput.ReadLine()) != null)
            {
                console.Text += line + "\n";
            }
            console.Text += str;
            str = "";
        }
        public void get_info_of_mongod()
        {
            String line;
            while ((line = p_mongo.StandardOutput.ReadLine()) != null)
            {
                console.Text += line + "\n";
            }
            console.Text += str;
            str = "";
        }
        public void get_info()
        {
            console.Text += str;
            str = "";
        }
        String str = "";
        public void read()
        {
        }
    }
    enum Simple_event_staus
    {
        Disposable, Loop, Thread
    }
    class Simple_event
    {
        public Simple_event_staus status = Simple_event_staus.Disposable;
        public sev run;
        public int loop_count = 1;
        public Simple_event(sev run)
        {
            this.run = run;
        }
    }
    delegate void sev();
    class GlobalEvent
    {
        public static DispatcherTimer timer = new DispatcherTimer() { Interval = new TimeSpan(0, 0, 0, 0, 100)};
        public static List<Simple_event> simple_events = new List<Simple_event>();
        static GlobalEvent()
        {
            timer.Tick += timer_Tick;
        }
        static Object o = new Object();
        static void timer_Tick(object sender, EventArgs e)
        {
            if (simple_events.Count == 0) return;
            Simple_event eve = simple_events[0];
            simple_events.RemoveAt(0);
            switch (eve.status)
            {
                case Simple_event_staus.Disposable:
                    eve.run();
                    break;
                case Simple_event_staus.Loop:
                    eve.run();
                    eve.loop_count--;
                    if (eve.loop_count != 0) simple_events.Add(eve);
                    break;
                case Simple_event_staus.Thread:
                    new Thread(new ThreadStart(eve.run)).Start();
                    break;
            }
            if (simple_events.Count == 0) timer.Stop();
        }
        public static void add(Simple_event eve)
        {
            if (eve == null || eve.run == null) return;
            simple_events.Add(eve);
            if (timer.IsEnabled == false)
            {
                timer.Tick += timer_Tick;
                timer.Start();
            }

        }
    }
}
