﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using System.IO;
using System.Runtime.Serialization.Json;

namespace Serius
{
    [DataContract]
    class Info
    {
        public static String address = AppDomain.CurrentDomain.BaseDirectory + "/info.inf";
        [DataMember]
        int l_project;
        public int latest_project
        {
            get {return l_project;}
            set
            {
                 l_project = value;
                 changed = true;
            }
        }
        [DataMember]
        public String m_address;
        public String mongo_address
        {
            get { return m_address; }
            set
            {
                m_address = value;
                changed = true;
            }
        }
        [DataMember]
        public String n_version;
        public String node_version
        {
            get { return n_version; }
            set
            {
                n_version = value;
                changed = true;
            }
        }
        [DataMember]
        public String n_dev_version;
        public String node_dev_version
        {
            get { return n_dev_version; }
            set
            {
                n_dev_version = value;
                changed = true;
            }
        }
        [DataMember]
        public String n_inspector_exist;
        public String node_inspector_exist
        {
            get { return n_inspector_exist; }
            set
            {
                n_inspector_exist = value;
                changed = true;
            }
        }
        [DataMember]
        public List<String> projects = new List<String>();
        public void remove(String address)
        {
            int n;
            if ((n = projects.IndexOf(address)) == -1)
            {
                projects.Add(address);
                changed = true;
            }
        }
        public void add(String address) {
            projects.Remove(address);
            changed = true;
        }
        public bool changed = false;
        public static Info read()
        {
            Info info = null;
            FileInfo fi = new FileInfo(address);
            if (fi.Exists == false) return new Info() { changed = true };
            using (FileStream fs = new FileStream(address, FileMode.Open))
            {
                var serializer = new DataContractJsonSerializer(typeof(Info));
                info = (Info)serializer.ReadObject(fs);
            }
            return info;
        }
        public void write()
        {
            if (changed == false) return;
            using (FileStream fs = new FileStream(address, FileMode.Create))
            {
                var serializer = new DataContractJsonSerializer(typeof(Info));
                serializer.WriteObject(fs, this);
            }
        }
    }
}
