﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.IO;
using form = System.Windows.Forms;
namespace Serius
{
    /// <summary>
    /// MainWindow.xaml の相互作用ロジック
    /// </summary>
    public partial class MainWindow : Window
    {
        public static String main_directory = Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments) + "/Serius-x";
        public String project_directory;
        Project project;
        public MainWindow()
        {
            InitializeComponent();
            DirectoryInfo di = new DirectoryInfo(main_directory);
            if (di.Exists == false) di.Create();
        }
        protected override void OnInitialized(EventArgs e)
        {
            base.OnInitialized(e);
        }

        private void new_file_click(object sender, RoutedEventArgs e)
        {
            new_file new_file_dialog = new new_file();
            if (new_file_dialog.ShowDialog() == true)
            {
                Filea file = new Filea(new_file_dialog.file_name);
                project.files.Add(file);
                tab.Items.Add(file.item);
            }
        }

        private void new_project_click(object sender, RoutedEventArgs e)
        {
            new_project new_project_dialog = new new_project();
            if (new_project_dialog.ShowDialog() == true)
            {
                project_directory = main_directory + "/" + new_project_dialog.name;
                DirectoryInfo di = new DirectoryInfo(project_directory);
                if (di.Exists == false)
                {
                    di.Create();
                    project = new Project(new_project_dialog.name);
                    this.Title = project.name;
                }
                else MessageBox.Show("既に同名のフォルダが存在しています。");
            }
        }

        private void open_project_click(object sender, RoutedEventArgs e)
        {
            form.OpenFileDialog dialog = new form.OpenFileDialog();
            dialog.Filter = "プロジェクトファイル|*.prj";
            if (dialog.ShowDialog() == form.DialogResult.OK)
            {
                project = Project.open(dialog.FileName);
                this.Title = project.name;
                foreach (Filea file in project.files)
                {
                    tab.Items.Add(file.item);
                }
            }
        }

        private void save_project_click(object sender, RoutedEventArgs e)
        {
            project.save();
        }
    }
    class Project
    {
        public String name;
        public List<Filea> files = new List<Filea>();
        public Project() {}
        public Project(String name)
        {
            this.name = name;
        }
        public String path
        {
            get
            {
                return MainWindow.main_directory + "/" + name + "/";
            }
        }
        public void create()
        {
        }
        public void save()
        {
            StreamWriter sw = new StreamWriter(path +"_" + name + ".prj");
            sw.WriteLine(name);
            sw.Close();
            foreach (Filea file in files)
            {
                sw = new StreamWriter(path + file.name + "." + file.extention);
                sw.Write(file.text_canvas.text.text);
                sw.Close();
            }
        }
        public static Project open(String path)
        {
            DirectoryInfo di = new DirectoryInfo(path.Substring(0, path.LastIndexOf('\\')));
            Project ret = new Project(di.Name);
            foreach (FileInfo fi in di.GetFiles())
            {
                switch (fi.Extension.Substring(1))
                {
                    case "htm": case"html":
                        StreamReader sr = new StreamReader(fi.OpenRead());
                        ret.files.Add(new Filea(fi.Name, sr.ReadToEnd()));
                        sr.Close();
                        break;
                    case "js":
                        sr = new StreamReader(fi.OpenRead());
                        ret.files.Add(new Filea(fi.Name, sr.ReadToEnd()));
                        sr.Close();
                        break;
                    case "prj":
                        sr = new StreamReader(fi.OpenRead());
                        sr.Close();
                        break;
                }
            }
            return ret;
        }
    }
    class Filea
    {
        public String name;
        public String extention;
        public Text_canvas text_canvas;
        public TabItem item = new TabItem();
        public Filea(String file_name)
        {
            int n = file_name.LastIndexOf('.');
            this.name = file_name.Substring(0, n);
            n++;
            this.extention = file_name.Substring(n, file_name.Length - n);
            item.Header = new TextBlock() { Text = name };
            text_canvas = new Text_canvas();
            item.Content = text_canvas;
        }
        public Filea(String file_name, String text) : this(file_name)
        {
            text_canvas.text.text = text;
        }
    }
}
class Map<type_key, type_value> : Dictionary<type_key, type_value>
{
}