﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Controls;
using System.Windows.Media;
using System.Windows;

namespace Serius
{
    enum Kind_select
    {
        Class, Function, Field,
        Tag,
        Tag_attribute,
        Tag_value
    }
    class Compiler
    {
        public static Color Tag = Colors.Blue;
        public List<Text> texts = new List<Text>();
        public List<Tag> tags = new List<Tag>();
        public Tag tag { get { return tags[tags.Count - 1]; } }
        public Compiler(Word now)
        {
            this.now = now;
        }
        public void html_compile()
        {
            tags.Add(new Tag() {name="window"});
            for (; ; )
            {
                if (now.kind == Kind_word.Compare_Left)
                {
                    if (now.next.kind == Kind_word.Slash)//</
                    {
                        nex();
                        neo();
                        if (now.kind == Kind_word.Letter)
                        {
                            now.type = Type_value.Tag_close_name;
                            now.item = tags.Last();
                            neo();
                            if (now.kind == Kind_word.Compare_Right)
                            {
                                tags.Remove(tags.Last());
                            }
                            else throw new Exception();
                        }
                        else throw new Exception();
                    }
                    else
                    {
                        neo();
                        tag_compile();
                    }
                }
                else
                {
                    nex();
                }
            }
        }
        public void tag_compile()
        {
            Tag here = null;
            Tag_attribute tag_attribute = null;
            for (; ; )
            {
                if (now.kind == Kind_word.Letter)
                {
                    if (here == null)
                    {
                        here = new Tag() { name = now.str };
                        now.type = Type_value.Tag_name;
                        now.item = tags.Last();
                    }
                    else
                    {
                        tag_attribute = new Tag_attribute() { name = now.str };
                        now.type = Type_value.Tag_attribute;
                        now.item = here;
                    }
                    neo();
                    if (now.kind == Kind_word.Equal)
                    {
                        neo();
                        if (now.kind == Kind_word.Double_quote || now.kind == Kind_word.Single_quote)
                        {
                            string_compile(now.kind, Type_value.Tag_attribute_value, tag_attribute);
                            neo();
                        }
                    }
                }
                else if (now.kind == Kind_word.Slash)
                {
                    nex();
                    if (now.kind == Kind_word.Compare_Right)
                    {
                        //now programing
                        return;
                    }
                    else throw new Exception();
                }
                else if (now.kind == Kind_word.Compare_Right)
                {
                    tags.Add(here);
                    if (here.tag == "style")
                    {
                        neo();
                        css_comile();
                    }
                    else if (here.tag == "script")
                    {
                        neo();
                        js_compile();
                    }
                    return;
                }
                else throw new Exception_error();
            }
        }
        public void string_compile(Kind_word start, Type_value type, Item item)
        {
            for (; ; )
            {
                nex();
                if (now.kind == start)
                {
                    return;
                }
                else if (now.kind == Kind_word.End || now.kind == Kind_word.Break)
                {
                    return;
                }
                else if (now.kind == Kind_word.Yen)
                {
                    now.type = type;
                    now.item = item;
                    nex();
                }
                now.type = type;
                now.item = item;
            }
        }
        public void css_comile()
        {
            neo();
            for (; ; )
            {
                Type_value type = Type_value.Style_attribute_tag;
                if (now.kind == Kind_word.Dot)
                {
                    nex();
                }
                else if (now.kind == Kind_word.Sharp)
                {
                    nex();
                }
                if (now.kind == Kind_word.Letter)
                {
                }
                else throw new Exception();
                if (now.kind == Kind_word.Brace_left)
                {
                    neo();
                    for (; ; )
                    {
                        if (now.kind == Kind_word.Minus)
                        {
                            nex();
                        }
                        else if (now.kind == Kind_word.Letter)
                        {
                            nex();
                        }
                        else
                        {
                            if (now.kind == Kind_word.Space) neo();
                            break;
                        }
                    }
                    if (now.kind == Kind_word.Colon)
                    {
                        neo();
                    }
                    else throw new Exception();
                    if (now.kind == Kind_word.Semicolon || now.kind == Kind_word.Brace_right) throw new Exception();
                    css_value_compile(Kind_word.Semicolon, Kind_word.Brace_right);
                }
            }
        }
        public Kind_word css_value_compile(Kind_word end, Kind_word sub)
        {
        head:
            if (now.kind == Kind_word.Letter || now.kind == Kind_word.Minus)
            {
                for (; ; )
                {
                    if (now.kind == Kind_word.Minus)
                    {
                        nex();
                    }
                    else if (now.kind == Kind_word.Letter)
                    {
                        nex();
                    }
                    else
                    {
                        if (now.kind == Kind_word.Space) neo();
                        break;
                    }
                }
                if (now.kind == Kind_word.Dot)
                {
                    nex();
                }
                else if (now.kind == Kind_word.Paren_left)
                {
                    neo();
                    css_value_compile(Kind_word.Paren_right, Kind_word.Comma);
                }
                goto head;
            }
            else if (now.kind == Kind_word.Number)
            {
                nex();
                if (now.kind == Kind_word.Letter)
                {
                    if (now.str == "em" || now.str == "px" || now.str == "%" || now.str == "pt")
                    {
                    }
                    else throw new Exception();
                }
                goto head;
            }
            else if (now.kind == Kind_word.Sharp)
            {
                if (now.kind == Kind_word.Letter || now.kind == Kind_word.Number)
                {
                    string_compile(now.kind, Type_value.Style_attribute_value, null);//now programing
                }
                else throw new Exception();
                goto head;
            }
            else if (now.kind == Kind_word.Single_quote || now.kind == Kind_word.Double_quote)
            {
                goto head;
            }
            else if (now.kind == end) return end;
            else if (now.kind == sub) return sub;
            else throw new Exception();
        }
        public void js_compile()
        {
            for (; ; )
            {
                js_line_compile(Kind_word.Semicolon, Kind_word.None);
            }
        }
        public void js_line_compile(Kind_word end, Kind_word finish)
        {
            if (now.kind == Kind_word.Letter)
            {
                if (now.str == "var")
                {
                }
                else if (now.str == "function")
                {
                }
                else if (now.str == "for")
                {
                }
                else if (now.str == "switch" || now.str == "while")
                {
                }
                else if (now.str == "if")
                {
                }
                else if (now.str == "do")
                {
                }
            }
            else
            {
                for (; ; )
                {
                    if (now.kind == finish || now.kind == Kind_word.End)
                    {
                        return;
                    }
                    if (now.kind == Kind_word.Plus || now.kind == Kind_word.Minus)
                    {
                        if (now.next.kind == now.kind)
                        {
                            nex(); neo();
                        }
                        else throw new Exception();
                    }
                    else if (now.kind == Kind_word.Not)
                    {
                    }
                    if (now.kind == Kind_word.Letter)
                    {
                        neo();
                        for (; ; )
                        {
                            if (now.kind == Kind_word.Paren_left)
                            {
                            }
                            else if (now.kind == Kind_word.Bracket_left)
                            {
                            }
                            else if (now.kind == Kind_word.Dot)
                            {
                            }
                            else break;
                        }
                    }
                    else if (now.kind == Kind_word.Paren_left)
                    {
                    }
                    else if (now.kind == Kind_word.Bracket_left)
                    {
                    }
                    else if (now.kind == Kind_word.Brace_left)
                    {
                    }
                operate_head:
                    if (now.kind == Kind_word.Equal) { }
                    else if (now.kind == Kind_word.Plus || now.kind == Kind_word.Minus)
                    {
                        if (now.next.kind == now.kind) goto operate_head;
                    }
                    else if (now.kind == Kind_word.Slash || now.kind == Kind_word.Astarisk)
                    {
                    }
                    else if (now.kind == Kind_word.Compare_Left || now.kind == Kind_word.Compare_Right) { }
                    else if (now.kind == end || now.kind == Kind_word.Comma || now.kind == Kind_word.Break) { break; }
                }
            }
        }
        public void js_var_compile() { }
        public void js_function_compile() { }
        public void js_for_compile() { }
        public void js_if_compile() { }
        public void js_do_compile() { }
        public void js_switch_compile() { }
        public void js_while_compile() { }
        Word now;
        void neo()
        {
            now = now.next_over_space;
            if (now.kind == Kind_word.End) throw new Exception_end();
        }
        void nex()
        {
            now = now.next;
            if (now.kind == Kind_word.End) throw new Exception_end();
        }
    }
    class Exception_end : Exception { }
    class Exception_error : Exception { }
    class VBlob
    {
    }
    class VFolder : VBlob
    {
    }
    class VFile : VBlob
    {
    }
    class Blob
    {
    }
    class Folder : Blob
    {
    }
    class File : Blob
    {
        public String name;
    }
    class Item
    {
        public String name;
        public virtual String output() { return null; }
    }
    class Selection : Item
    {
        public String explain;
        public Kind_select select;
    }
    partial class Tag
    {
        public static Map<String, Tag> Base_tags = new Map<String,Tag>();
        public static Map<String, Tag_attribute> Base_tag_attributes = new Map<String, Tag_attribute>();
        static Tag()
        {
            Tag tag;
            foreach (String name in new String[] {"window", "html", "head", "title", "meta", "link", "object", "script", "style", "body", "div", "span", "table", "tr", "tbody", "thead", "td", "h1", "h2", "h3", "h4", "h5", "h6", "h7", "font", "img", "audio", "video", "ul", "li", "p", "hr", "br", "form", "input", "textarea", "select"})
            {
                tag = new Tag() { name = name, select = Kind_select.Tag };
                Base_tags.Add(tag.name, tag);
            }
            Tag_attribute att;
            foreach (String name in new String[] { "lang", "dir", "name", "http-equiv", "content", "rel", "href", "hreflang", "type", "media", "style", "class", "id", "title", "tabindex",
                "src", "charset", "defer", "language", "data", "width", "height", "usemap",
                "onclick", "ondblclick", "onmousedown", "onmouseup", "onmouseover", "onmouseout", "onkeypress", "onkeydown", "onkeyup"})
            {
                att = new Tag_attribute() { name = name, select = Kind_select.Tag_attribute };
                Base_tag_attributes.Add(att.name, att);
            }
            tag = Base_tags["window"]; tag.explain = "";
            tag.set_children("html");
            tag = Base_tags["html"]; tag.explain = "ホームページ開始タグです。";
            tag.set_children("head", "body", "script"); tag.set_attributes("lang", "dir");
            //head
            tag = Base_tags["head"]; tag.explain = "中にヘッダ情報を記述するタグです。";
            tag.set_children("title", "meta", "link", "script", "style", "object"); tag.set_attributes("lang", "dir");
            tag = Base_tags["title"]; tag.explain = "ページのタイトルを記述します。\n検索キーワードに大きな影響を与えます。";
            tag = Base_tags["meta"]; tag.explain = "付加情報を付与します。\nname属性とhttp-equiv属性は、どちらかを必ず指定する必要があります。contentは必須です。";
            tag.set_attributes("name", "http-equiv", "content");
            tag = Base_tags["link"]; tag.explain = "外部文書との連携に使います。前や次の文書を指定したり、外部スタイルシートを引用したりできます。";
            tag.set_attributes("rel", "href", "hreflang", "type", "media", "style", "class", "id", "title", "lang", "dir", "onclick", "ondblclick", "onmousedown", "onmouseup", "onmouseover", "onmouseout", "onkeypress", "onkeydown", "onkeyup");
            tag = Base_tags["object"]; tag.explain = "動画、サウンド、画像、HTML文書、Javaアプレット等を埋め込むことができます。";
            tag.set_attributes("data", "type", "width", "height", "usemap", "name", "style", "class", "id", "title", "lang", "dir", "tabindex", "onclick", "ondblclick", "onmousedown", "onmouseup", "onmouseover", "onmouseout", "onkeypress", "onkeydown", "onkeyup");
            //style,script
            tag = Base_tags["style"]; tag.explain = "中にスタイルシートを記述します。\ntypeは必須です。";
            tag.set_attributes("type", "media", "title", "lang", "dir");
            tag = Base_tags["script"]; tag.explain = "中にjavascriptコードを記述します。\ntypeは必須です。";
            tag.set_attributes("type", "src", "charset", "defer", "language");
            tag = Base_tags["body"]; tag.explain = "中身を記述します。";

            att = Base_tag_attributes["lang"]; att.explain = "要素の言語を指定します。";
            att.set_values("ja", "en-US", "zh", "de", "it", "pt", "pl", "ru", "hi", "la", "en", "en-GB", "ko", "fr", "nl", "es", "el", "he", "ar", "sw");
            att = Base_tag_attributes["dir"]; att.explain = "要素の所持方向を指定することができます。";
            att.set_values("ltr", "rtl");
            att = Base_tag_attributes["name"]; att.explain = "meta名を指定します。大文字と小文字は区別されます";
            att.set_values("Content-Type", "keywords", "author", "description", "ROBOTS");
            att = Base_tag_attributes["http-equiv"]; att.explain = "HTTPヘッダ名を指定します。";
            att.set_values("Content-Type", "Content-Style-Type", "Content-Script-Type");
            att = Base_tag_attributes["content"]; att.explain = "metaの内容を記述します。大文字と小文字は区別されます。";

        }
        public void set_children(params String[] names)
        {
            foreach (String name in names) tags.Add(Base_tags[name]);
        }
        public void set_attributes(params String[] names)
        {
            foreach (String name in names) attributes.Add(Base_tag_attributes[name]);
        }
    }
    partial class Tag : Selection
    {
        public List<Tag> tags = new List<Tag>();
        public List<Tag_attribute> attributes = new List<Tag_attribute>();
        public String id;
        public String explain;
        public String cls;
        public String tag;
        public bool single;
        public override String output()
        {
            String output = "";
            output = "<" + tag;
            if (id != null) output += " id='" + id + "'";
            if (name != null) output += " name='" + name + "'";
            if (cls != null) output += " cls='" + cls + "'";
            if (single) { output += "/>"; return output; }
            else output += ">";
            for (int i = 0; i < tags.Count; i++) output += tags[i].ToString();
            output += "</" + name + ">";
            return output;
        }
    }
    class Tag_attribute : Selection
    {
        public List<Tag_value> values = new List<Tag_value>();
        public void set_values(params String[] names)
        {
            foreach (String name in names) values.Add(new Tag_value() { name = name });
        }
    }
    class Tag_value : Selection
    {
    }
    class Text_content : Tag
    {
        public String value;
        public override string output()
        {
            return value;
        }
    }
    class Tag_js : Tag
    {
        public override string output()
        {
            return "<script type='text/javascript'>" + "</script>";
        }
    }
    class Tag_cache : Tag
    {
        public List<String> files = new List<string>();
    }
    class Tag_wordl : Tag
    {
        public override string output()
        {
            return "<script type='text/javascript'>" + "</script>";
        }
    }
    class Tag_style : Tag
    {
    }
    class JS : Tag
    {
    }
    class Attribute
    {
    }
    class Block : Variable
    {
        public Block parent;
        protected Map<String, Variable> values = new Map<String, Variable>();
        public bool add(String key, Variable value)
        {
            if (values.ContainsKey(key)) return false;
            else
            {
                if (value is Block) (value as Block).parent = this;
                values.Add(key, value);
                return true;
            }
        }
        public Variable get(String key)
        {
            if (values.ContainsKey(key)) return values[key];
            else if (parent == null) return null;
            else return parent.get(key);
        }
    }
    class Style
    {
    }
    class Variable : Selection
    {
    }
    class Class : Block
    {
    }
    class Function : Block
    {
        List<Variable> draws = new List<Variable>();
    }
    class For : Block
    {
        List<Variable> draws = new List<Variable>();
    }
}
