<?php

require_once('simg-functions.php');

/**
 * パラメータクラス
 * @author System Concept
 *
 */
abstract class SimgParameter {

	/**
	 * 一時保存情報
	 */
	private $temporary;
	/**
	 * 構築
	 */
	public function __construct() {
		$this->initialize();
	}
	/**
	 * 初期化処理
	 */
	private function initialize() {
		$this->clearTemporary();
	}
	/**
	 * 一時保存情報クリア
	 */
	public function clearTemporary() {
		$this->temporary = array();
	}
	/**
	 * 一時保存情報取得
	 * @param $key キー
	 * @return 一時保存情報
	 */
	public function getTemporary($key) {
		return simg_get_array_value($this->temporary, $key, null);
	}
	/**
	 * 一時保存情報設定
	 * @param $key キー
	 * @param $v 値
	 */
	public function putTemporary($key, $v) {
		$this->temporary[$key] = $v;
	}
	/**
	 * リクエスト情報取得
	 * @param $key キー
	 * @return リクエスト情報
	 */
	public function getRequest($key) {
		return simg_get_array_value($_REQUEST, $key, null);
	}
	/**
	 * GET/POST情報取得
	 * @param $key キー
	 * @return GET/POST情報
	 */
	public function getGetAndPost($key) {
		return simg_get_array_value($_GET, $key, simg_get_array_value($_POST, $key, null));
	}
	/**
	 * クッキー情報取得
	 * @param $key キー
	 * @return クッキー情報
	 */
	public function getCookie($key) {
		return simg_get_array_value($_COOKIE, $key, null);
	}
	/**
	 * セッション情報取得
	 * @param $key キー
	 * @return セッション情報
	 */
	public function getSession($key) {
		if(!$this->isSessionStarted())
			return null;
		return simg_get_array_value($_SESSION, $key, null);
	}
	/**
	 * セッション有無判定
	 * @param $key キー
	 * @return true/false=有り/無し
	 */
	public function isExistSession($key) {
		if(!$this->isSessionStarted())
			return false;
		return isset($_SESSION[$key]);
	}
	/**
	 * セッションが開始されているかを調べる
	 * @return true=開始されている
	 */
	public function isSessionStarted() {
		return isset($_SESSION);
	}
	/**
	 * セッション情報設定
	 * @param $key キー
	 * @param $v 値
	 */
	public function putSession($key, $v) {
		$_SESSION[$key] = $v;
	}
	/**
	 * 情報取得
	 * @param $key キー
	 * @return 情報
	 */
	public function get($key) {
		$v = $this->getTemporary($key);
		if(is_null($v)) {
			$v = $this->getGetAndPost($key);
			if(is_null($v)) {
				$v = $this->getCookie($key);
				if(is_null($v)) {
					$v = $this->getSession($key);
				}
			}
		}
		return $v;
	}
}

?>
