<?php

require_once('Smarty.class.php');
require_once('simg-functions.php');
require_once('SimgLog.php');

/**
 * ---------------------------------------------------
 * 関数命名規約
 * -----------------------+---------------------------
 * function_[plugin-name] | テンプレート関数プラグイン
 * block_[plugin-name]    | ブロック関数プラグイン
 * compiler_[plugin-name] | コンパイラ関数プラグイン
 * modifier_[plugin-name] | 修飾子プラグイン
 * -----------------------+---------------------------
 */

/**
 * Tyoe: function
 * Name: ss_url
 * Purpose: URL作成
 */
function function_url($params, &$smarty) {
	$queries = array();
	$wq = simg_get_array_value($params, SS_PARAM_QUERY, null);
	if($wq != null && strlen($wq) > 0) {
		parse_str($wq, $queries);
	}
	//SimgLog::getInstance()->put(PEAR_LOG_DEBUG, "__make_url queries: [%s]", print_r($queries, true));
	$dir = simg_get_array_value($params, SS_PARAM_DIRECTORY, '');
	return simg_make_url($dir, $queries);
}

/**
 * Tyoe: function
 * Name: ss_json_decode
 * Purpose: JSON文字列デコード
 */
function function_json_decode($params, &$smarty) {
	$v = simg_get_array_value($params, SS_PARAM_VALUE, '');
	$a = simg_get_array_value($params, SS_PARAM_ASSOC, false);
	return json_decode($v, $a);
}

/**
 * Tyoe: function
 * Name: ss_json_encode
 * Purpose: JSON文字列エンコード
 */
function function_json_encode($params, &$smarty) {
	$v = simg_get_array_value($params, SS_PARAM_VALUE, '');
	return json_encode($v);
}

/**
 * Tyoe: function
 * Name: ss_url_encode
 * Purpose:URLエンコード
 */
function function_url_encode($params, &$smarty) {
	$v = simg_get_array_value($params, SS_PARAM_VALUE, '');
	return rawurlencode($v);
}

?>
