<?php

/**
 * Simf例外
 *
 */
class SimgException extends Exception {

	/**
	 * 構築
	 * @param string $message エラーメッセージ
	 * @param system $filename エラー発生ファイル名
	 * @param system $lineno エラー発生行番号
	 * @param Exception $previous 原因例外
	 * @param number $code コード
	 */
	public function __construct($message = "", $filename = null, $lineno = null, Exception $previous = null, $code = 0) {
		if(!is_null($filename) && !is_null($lineno))
			parent::__construct(sprintf("Simg: %s (%s at %d)", $message, basename($filename), $lineno), $code, $previous);
		else
			parent::__construct($message, $code, $previous);
	}
}

?>
