/*SIE-SVG without Plugin under LGPL2.1 & GPL2.0 & Mozilla Public Lisence
 *公式ページは http://sie.sourceforge.jp/
 *利用方法は <script defer="defer" type="text/javascript" src="sie-mini.js"></script>
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Mozilla SVG Cairo Renderer project.
 *
 * The Initial Developer of the Original Code is IBM Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Parts of this file contain code derived from the following files(s)
 * of the Mozilla SVG project (these parts are Copyright (C) by their
 * respective copyright-holders):
 *    layout/svg/renderer/src/libart/nsSVGLibartBPathBuilder.cpp
 *
 * Contributor(s):DHRNAME revulo bellbind
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
function DOMException(b){Error.apply(this,arguments);this.code=b;var a=["","Index Size Error","DOMString Size Error","Hierarchy Request Error","Wrong　Document　Error","Invalid　Character　Error","No Data Allowed　Error","No Modification Allowed Error","Not Found Error","Not Supported　Error","Inuse　Attribute　Error","Invalid State　Error","Syntax Error","Invalid Modification　Error","Namespace Error","Invalid Access Error"];this.message=a[b];return this}DOMException.INDEX_SIZE_ERR=1;DOMException.DOMSTRING_SIZE_ERR=2;DOMException.HIERARCHY_REQUEST_ERR=3;DOMException.WRONG_DOCUMENT_ERR=4;DOMException.INVALID_CHARACTER_ERR=5;DOMException.NO_DATA_ALLOWED_ERR=6;DOMException.NO_MODIFICATION_ALLOWED_ERR=7;DOMException.NOT_FOUND_ERR=8;DOMException.NOT_SUPPORTED_ERR=9;DOMException.INUSE_ATTRIBUTE_ERR=10;DOMException.INVALID_STATE_ERR=11;DOMException.SYNTAX_ERR=12;DOMException.INVALID_MODIFICATION_ERR=13;DOMException.NAMESPACE_ERR=14;DOMException.INVALID_ACCESS_ERR=15;DOMException.prototype=new Error();DOMImplementation={hasFeature:function(b,a){switch(b){case"CORE":case"XML":case"Events":case"StyleSheets":case"org.w3c.svg.static":case"org.w3c.dom.svg.static":return true;default:if(a==="2.0"){return true}else{return false}}},createDocumentType:function(c,e,a){var b=new Node();b.publicId=e;b.systemId=a;return b},createDocument:function(c,g,a){try{var b;if(c){b=new (DOMImplementation[c].Document)}else{b=new Document()}b.implementation=this;b.doctype=a;b.documentElement=b.createElementNS(c,g);return b}catch(f){alert(f.message)}},"http://www.w3.org/2000/xmlns":{}};function Node(){this.childNodes=[];this._capter=[];return this}Node.ELEMENT_NODE=1;Node.ATTRIBUTE_NODE=2;Node.TEXT_NODE=3;Node.CDATA_SECTION_NODE=4;Node.ENTITY_REFERENCE_NODE=5;Node.ENTITY_NODE=6;Node.PROCESSING_INSTRUCTION_NODE=7;Node.COMMENT_NODE=8;Node.DOCUMENT_NODE=9;Node.DOCUMENT_TYPE_NODE=10;Node.DOCUMENT_FRAGMENT_NODE=11;Node.NOTATION_NODE=12;Node.prototype={tar:null,firstChild:null,previousSibling:null,nextSibling:null,attributes:null,namespaceURI:null,localName:null,lastChild:null,prefix:null,ownerDocument:null,parentNode:null,replaceChild:function(a,c){this.insertBefore(a,c);var b=this.removeChild(c);return b},appendChild:function(a){this.insertBefore(a,null);return a},hasChildNodes:function(){if(this.childNodes.length>0){return true}else{return false}},cloneNode:function(a){if("ownerDocument" in this){var b=this.ownerDocument.importNode(this,a)}else{b=new Node()}return b},normalize:function(){var g=this.childNodes;try{for(var b=g.length-1;b<0;--b){var f=g[b],a=f.nextSibling;if(a){if(f.nodeType===Node.TEXT_NODE&&a.nodeType===Node.TEXT_NODE){f.appendData(a.data);f.legnth=f.data.length;this.removeChild(a)}else{f.normalize()}}else{f.normalize()}}}catch(c){}},isSupported:function(b,a){return(this.ownerDocument.implementation.hasFeature(b+"",a+""))},hasAttributes:function(){if(this.attributes.length>0){return true}else{return false}}};Array.prototype.item=function(a){return(this[a])};function NamedNodeMap(){return this}Array.prototype._copyNode=function __nnmp_c(e,b){for(var c=0,a=e.length;c<a;c++){this[c]=e[c].cloneNode(b)}};NamedNodeMap.prototype={length:0,getNamedItem:function(a){},setNamedItem:function(a){},removeNamedItem:function(a){},item:function(a){return this[a]},getNamedItemNS:function(e,c){for(var f=0,a=this.length;f<a;f++){var b=this[f];if(b.namespaceURI===e&&b.localName===c){this._num=f;return b}}return null},setNamedItemNS:function(a){var b=this.getNamedItemNS(a.namespaceURI,a.localName);if(b){var c=this[this._num];this[this._num]=a;return c}else{if(a.ownerElement!==void 0){throw (new DOMException(DOMException.INUSE_ATTRIBUTE_ERR))}this[this.length]=a;this.length+=1;return null}},removeNamedItemNS:function(b,a){var c=this.getNamedItemNS(b,a);if(!tgns){throw (new DOMException(DOMException.NOT_FOUND_ERR))}else{var e=this[this._num];delete (this[this._num]);this.length-=1;return e}},_copyNode:Array.prototype._copyNode};function CharacterData(){Node.apply(this);return this}CharacterData.prototype=new Node();CharacterData.constructor=Node;CharacterData.prototype.length=0;CharacterData.prototype.substringData=function(c,b){if(c<0||b<0||c>this.length){throw (new DOMException(INDEX_SIZE_ERR))}if(c+b>this.length){b=this.length-c}var a=this.data.substr(c,b);return a};CharacterData.prototype.replaceData=function(c,b,a){if(c<0||b<0||c>this.length){throw (new DOMException(INDEX_SIZE_ERR))}this.deleteData(c,b);this.insertData(c,a)};function Attr(){Node.apply(this);delete this._capter;return this}Attr.prototype=new Node();Attr.constructor=Node;Attr.prototype.nodeType=Node.ATTRIBUTE_NODE;function Element(){Node.apply(this);this.attributes=new NamedNodeMap();return this}Element.prototype=new Node();Element.constructor=Node;Element.prototype.nodeType=Node.ELEMENT_NODE;Element.prototype.nodeValue=null;Element.prototype.getAttribute=function(a){return(this.getAttributeNS("http://www.w3.org/2000/svg",a))};Element.prototype.setAttribute=function(a,b){this.setAttributeNS(null,a,b)};Element.prototype.removeAttribute=function(a){this.removeAttributeNS(null,a)};Element.prototype.getAttributeNode=function(a){};Element.prototype.setAttributeNode=function(a){};Element.prototype.removeAttributeNode=function(a){var b=this.attributes.removeNamedItemNS(a.namespaceURI,a.localName);return b};Element.prototype.getElementsByTagName=function(a){};Element.prototype.getAttributeNS=function(b,a){var c=this.getAttributeNodeNS(b,a);if(!c){return null}else{return(c.nodeValue)}};Element.prototype.setAttributeNS=function(a,e,b){var c=this.ownerDocument.createAttributeNS(a,e);c.nodeValue=b+"";c.value=b+"";this.setAttributeNodeNS(c)};Element.prototype.removeAttributeNS=function(b,a){};Element.prototype.getAttributeNodeNS=function(b,a){var c=this.attributes.getNamedItemNS(b,a);return c};Element.prototype.getElementsByTagNameNS=function(c,f){var t=[],e=0;var a=this.childNodes;for(var h=0,b=a.length;h<b;h++){var k=a[h];if(k.nodeType===Node.ELEMENT_NODE){var r=(c==="*")?k.namespaceURI:c;var q=(f==="*")?k.localName:f;if((k.namespaceURI===r)&&(k.localName===q)){t[e]=k;e++}var o=k.getElementsByTagNameNS(c,f);if(o){for(var g=0,l=o.length;g<l;++g){t[t.length]=o[g]}e+=o.length}r=q=o=null}}a=h=g=b=l=null;if(e===0){return null}return t};Element.prototype.hasAttribute=function(a){return(this.hasAttributeNS("http://www.w3.org/2000/svg",a))};Element.prototype.hasAttributeNS=function(b,a){if(this.getAttributeNodeNS(b,a)){return true}else{return false}};function Text(){return this}Text.prototype=new CharacterData();Text.constructor=CharacterData;Text.prototype.nodeType=Node.TEXT_NODE;Text.prototype.nodeName="#text";Text.prototype.splitText=function(e){var c=this.substringData(0,e-1);this.replaceData(0,this.length-1,c);var a="";if(this.length!==e){a=this.substringData(e,this.length-1)}var b=this.ownerDocument.createTextNode(a);if(this.parentNode){this.parentNode.insertBefore(b,this.nextSibling)}return b};function Comment(){return this}Comment.prototype=new CharacterData();Comment.constructor=CharacterData;Comment.prototype.nodeType=Node.COMMENT_NODE;Comment.prototype.nodeName="#comment";function CDATASection(){this.nodeType=Node.CDATA_SECTION_NODE;this.nodeName="#cdata-section";return this}CDATASection.prototype=new Text();CDATASection.constructor=Text;function DocumentType(){this.name="";this.entities=new NamedNodeMap();this.notations=new NamedNodeMap();this.publicId="";this.systemId="";this.internalSubset="";this.nodeValue=null;this.nodeType=Node.DOCUMENT_TYPE_NODE;return this}DocumentType.prototype=new Node();DocumentType.constructor=Node;function Notation(){this.publicId=null;this.systemId=null;this.nodeValue=null;this.nodeType=Node.NOTATION_NODE;return this}Notation.prototype=new Node();Notation.constructor=Node;function Entity(){this.publicId=null;this.systemId=null;this.notationName=null;this.nodeValue=null;this.nodeType=Node.ENTITY_NODE;return this}Entity.prototype=new Node();Entity.constructor=Node;function EntityReference(){this.nodeValue=null;this.nodeType=Node.ENTITY_REFERENCE_NODE;return this}EntityReference.prototype=new Node();EntityReference.constructor=Node;function ProcessingInstruction(){this.nodeType=Node.PROCESSING_INSTRUCTION_NODE;return this}ProcessingInstruction.prototype=new Node();ProcessingInstruction.constructor=Node;function DocumentFragment(){this.nodeName="#document-fragment";this.nodeValue=null;this.nodeType=Node.DOCUMENT_FRAGMENT_NODE;return this}DocumentFragment.prototype=new Node();DocumentFragment.constructor=Node;function Document(){this.nodeName="#document";this.nodeValue=null;this.nodeType=Node.DOCUMENT_NODE;this._id={};return this}Document.prototype=new Node();Document.constructor=Node;Document.prototype.createElement=function(a){};Document.prototype.createDocumentFragment=function(){var a=new DocumentFragment();a.ownerDocument=this;return a};Document.prototype.createTextNode=function(b){var a=new Text();a.data=a.nodeValue=b+"";a.length=(b+"").length;a.ownerDocument=this;return a};Document.prototype.createComment=function(b){var a=new Comment();a.data=a.nodeValue=b;a.length=b.length;a.ownerDocument=this;return a};Document.prototype.createCDATASection=function(b){var a=new CDATASection();a.data=a.nodeValue=b;a.length=b.length;a.ownerDocument=this;return a};Document.prototype.createProcessingInstruction=function(c,b){var a=new ProcessingInstruction();a.target=a.nodeName=c;a.data=a.nodeValue=b;a.ownerDocument=this;return a};Document.prototype.createAttribute=function(a){};Document.prototype.createEntityReference=function(a){var b=new EntityReference();b.nodeName=a;b.ownerDocument=this;return b};Document.prototype.getElementsByTagName=function(a){};Document.prototype.importNode=function(l,o){var r,b=l.nodeType;if(b===1){r=this.createElementNS(l.namespaceURI,l.nodeName);var g=l.attributes,j;for(var f=0,k=g.length;f<k;++f){j=this.importNode(g[f],false);r.setAttributeNodeNS(j)}if(o){var q=l.firstChild,e;while(q){e=this.importNode(q,true);r.appendChild(e);q=q.nextSibling}}f=g=j=k=e=a=h=null}else{if(b===2){var c=l.namespaceURI;c=(c==="")?null:c;r=this.createAttributeNS(c,l.nodeName);r.nodeValue=l.nodeValue}else{if(b===3){r=this.createTextNode(l.data)}else{if(b===8){r=this.createComment(l.data)}else{if(b===Node.DOCUMENT_FRAGMENT_NODE){r=this.createDocumentFragment();if(o){var a=l.childNodes,e;for(var f=0,h=a.length;f<h;f++){e=this.importNode(a[f],true);r.appendChild(e)}}f=e=a=h=null}else{if(b===Node.CDATA_SECTION_NODE){r=this.createCDATASection(l.data)}else{if(b===Node.ENTITY_REFERENCE_NODE){r=this.createEntityReference(l.nodeName);if(o){var q=l.firstChild,e;while(q){e=this.importNode(q,true);r.appendChild(e);q=q.nextSibling}}}else{if(b===Node.ENTITY_NODE){r=new Entity();r.publicId=l.publicId;r.systemId=l.systemId;r.notationName=l.notationName}else{if(b===Node.PROCESSING_INSTRUCTION_NODE){r=this.createProcessingInstruction(l.nodeName,l.nodeValue)}else{if(b===Node.NOTATION_NODE){r=new Notation();r.publicId=l.publicId;r.systemId=l.systemId}else{throw (new DOMException(DOMException.NOT_SUPPORTED_ERR))}}}}}}}}}}l=o=null;return r};Document.prototype.createElementNS=function(b,h){var f,e=null,a=null;if(!h){throw (new DOMException(DOMException.INVALID_CHARACTER_ERR))}if(h.indexOf(":")!==-1){var g=h.split(":");e=g[0];a=g[1]}else{a=h}var i=false;if(b){var c=this.implementation;if(!!c[b]){if(!!c[b][a]){i=true}}}if(i){f=new (c[b][a])}else{f=new Element()}f.namespaceURI=b;f.nodeName=f.tagName=h;f.localName=a;f.prefix=e;f.ownerDocument=this;c=b=h=e=a=i=null;return f};Document.prototype.createAttributeNS=function(b,e){var a=new Attr();a.namespaceURI=b;a.nodeName=a.name=e;a.nodeValue=null;if(e.indexOf(":")!==-1){var c=e.split(":");a.prefix=c[0];a.localName=c[1]}else{a.prefix=null;a.localName=e}a.ownerDocument=this;return a};Document.prototype.getElementsByTagNameNS=function(b,a){var c=this.documentElement.getElementsByTagNameNS(b,a);return c};Document.prototype.getElementById=function(a){var b=!!this._id[a]?this._id[a]:null;return b};function STLog(a){this.jo=a;if(this.jo){this.p=document.createElement("div");this.p.innerHTML="<h1>例外処理のログ</h1>";document.body.insertBefore(this.p,document.body.firstChild)}return this}STLog.prototype.add=function(b,a){if(this.jo){this.p.innerHTML+="<p>"+a+":"+b.message+"</p>"}};function EventException(){DOMException.call(this,arguments);if(this.code===0){this.message="Uuspecified Event Type Error"}return this}EventException.UNSPECIFIED_EVENT_TYPE_ERR=0;EventException.prototype=new DOMException();EventException.constructor=DOMException;Node.prototype.addEventListener=function(f,h,a){try{this.removeEventListener(f,h,a);var c=new EventListener(a,f,h);this._capter[this._capter.length]=c;var b=f.charAt(0);if(b!=="D"&&b!=="S"&&f!=="beginEvent"&&f!=="endEvent"&&f!=="repeatEvent"){var g=this;g._tar.attachEvent("on"+f,function(){var e=g.ownerDocument.createEvent("MouseEvents");e.initMouseEvent(f,true,true,g.ownerDocument.defaultView,0);g.dispatchEvent(e);e=null})}c=b=null}catch(i){stlog.add(i,122)}};Node.prototype.removeEventListener=function(e,g,a){var f=this._capter;for(var c=0,b=f.length;c<b;c++){if(f[c].listener===g){f[c]=null}}};Node.prototype.dispatchEvent=function(l){if(!l.type||l.type===""){throw new EventException(EventException.UNSPECIFIED_EVENT_TYPE_ERR)}if(!this.ownerDocument._isLoaded){if(l.type==="SVGLoad"){this.ownerDocument._isLoaded=1}if(!this.ownerDocument._limit_time_){this.ownerDocument._limit_time_=l.timeStamp}else{var c=this.ownerDocument._limit_time_;if((l.timeStamp-c)>1000){if(this.ownerDocument.implementation._buffer_){var f=this.ownerDocument.implementation._buffer_;f[f.length]=this;f[f.length]=l}else{this.ownerDocument.implementation._buffer_=[]}return true}}}l.target=this;l.eventPhase=1;var b=this;var e=this.ownerDocument;e[3]=null;while(b.parentNode){b.parentNode[1]=b;b[3]=b.parentNode;b=b.parentNode}e[1]=b;b[3]=e;var k=1;while(e){l.currentTarget=e;if(e===this){k=2}l.eventPhase=k;var g=e._capter;for(var h=0,a=g.length;h<a;++h){if(g[h]&&(l.type===g[h]._type)){g[h].handleEvent(l)}}h=a=null;if(l._stop){break}if(e===this){if(!l.bubbles){break}k=3}e=e[k]}var i=l._default;l=b=s=d=g=n=e=k=null;return i};function EventListener(a,b,c){this._cap=a;this._type=b;this._listener=c;return this}EventListener.prototype={handleEvent:function(a){try{var f=a.eventPhase,b=this._cap;if(f===1){b=b?false:true}if(!b&&(a.type===this._type)){this._listener(a)}a=f=b=null}catch(c){}}};function Event(){return this}Event.CAPTURING_PHASE=1;Event.AT_TARGET=2;Event.BUBBLING_PHASE=3;Event.prototype={timeStamp:0,type:null,target:null,currentTarget:null,eventPhase:Event.CAPTURING_PHASE,bubbles:false,cancelable:false,_stop:false,_default:true,stopPropagation:function(){this._stop=true},preventDefault:function(){this._default=false;window.event.returnValue=false},initEvent:function(a,c,b){this.type=a;this.bubbles=c;this.cancelable=b}};Document.prototype.createEvent=function(b){var a;if(b==="MutationEvents"){a=new MutationEvent()}else{if(b==="MouseEvents"){a=new MouseEvent()}else{if(b==="UIEvents"){a=new UIEvent()}else{if(b==="SVGEvents"){a=new SVGEvent()}else{if(b==="TimeEvents"){a=new TimeEvent()}else{a=new Event()}}}}}a.type=b;a.timeStamp=+(new Date());return a};function UIEvent(){Event.call(this,arguments);this.view;this.detail=0;return this}UIEvent.prototype=new Event();UIEvent.constructor=Event;UIEvent.prototype.initUIEvent=function(b,f,e,c,a){this.initEvent(b,f,e);this.detail=a;this.view=c};function MouseEvent(a){UIEvent.call(this,arguments);this.screenX;this.screenY;this.clientX=0;this.clientY=0;this.ctrlKey=false;this.shiftKey=false;this.altKey=false;this.metaKey=false;this.button;this.relatedTarget;return this}MouseEvent.prototype=new UIEvent();MouseEvent.constructor=UIEvent;MouseEvent.prototype.initMouseEvent=function(r,e,o,f,i,l,g,a,k,h,t,c,q,j,b){this.initUIEvent(r,e,o,f,i);this.screenX=l;this.screenY=g;this.clientX=a;this.clientY=k;this.ctrlKey=h;this.shiftKey=c;this.altKey=t;this.metaKey=q;this.button=j;this.relatedTarget=b};function MutationEvent(){Event.call(this);return this}MutationEvent.prototype=new Event();MutationEvent.constructor=Event;(function(){this.initMutationEvent=function(a,g,f,b,i,c,e,h){this.initEvent(a,g,f);this.relatedNode=b;this.prevValue=i;this.newValue=c;this.attrName=e;this.attrChange=h;a=g=f=b=i=c=e=h=null};this.relatedNode=null;this.prevValue=null;this.newValue=null;this.attrName=null;this.attrChange=2}).apply(MutationEvent.prototype);MutationEvent.MODIFICATION=1;MutationEvent.ADDITION=2;MutationEvent.REMOVAL=3;Element.prototype.setAttributeNodeNS=function(c){if(c.ownerDocument!==this.ownerDocument){throw (new DOMException(DOMException.WRONG_DOCUMENT_ERR))}var b=this.attributes.setNamedItemNS(c);c.ownerElement=this;if(c.localName==="id"){this.ownerDocument._id[c.nodeValue]=this}var a=this.ownerDocument.createEvent("MutationEvents");if(!b){a.initEvent("DOMAttrModified",true,false);a.relatedNode=c;a.newValue=c.nodeValue;a.attrName=c.nodeName}else{a.initMutationEvent("DOMAttrModified",true,false,c,b.nodeValue,c.nodeValue,c.nodeName,MutationEvent.MODIFICATION)}this.dispatchEvent(a);a=null;return b};Node.prototype.insertBefore=function(b,c){var o=this.parentNode;if(o){while(!o){if(o===b){throw (new DOMException(DOMException.HIERARCHY_REQUEST_ERR))}o=o.parentNode}}if(this.ownerDocument!==b.ownerDocument){throw (new DOMException(DOMException.WRONG_DOCUMENT_ERR))}if(b.parentNode===this){this.removeChild(b)}if(!c){this.childNodes[this.childNodes.length]=b;if(this.lastChild){b.previousSibling=this.lastChild;this.lastChild.nextSibling=b}}else{if(c.parentNode!==this){throw (new DOMException(DOMException.NOT_FOUND_ERR))}this.childNodes.splice(c._num,1,b,c);var g=c.previousSibling;if(g){g.nextSibling=b}c.previousSibling=b}b.nextSibling=c;this.firstChild=this.childNodes[0];this.lastChild=this.childNodes[this.childNodes.length-1];b.parentNode=this;if((b.nodeType===5)||(b.nodeType===11)){var a=b.childNodes.concat([]);for(var f=0,k=a.length;f<k;f++){this.insertBefore(a[f],b)}a=null}var q=this.ownerDocument.createEvent("MutationEvents");q.initMutationEvent("DOMNodeInserted",true,false,this,null,null,null,null);b.dispatchEvent(q);var e=this,r;do{r=e;e=e.parentNode}while(e);if(r!==this.ownerDocument.documentElement){q=r=null;return b}q=this.ownerDocument.createEvent("MutationEvents");q.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);b.dispatchEvent(q);if(!b.hasChildNodes()){return b}var l=b.getElementsByTagNameNS("*","*");if(l){for(var f=0,h=l.length;f<h;++f){var j=l[f];j.dispatchEvent(q);j=null}}q=l=null;return b};Node.prototype.removeChild=function(g){if(!(g instanceof Node)){throw (new Error())}var a=this.ownerDocument.createEvent("MutationEvents");a.initMutationEvent("DOMNodeRemovedFromDocument",false,false,null,null,null,null,null);g.dispatchEvent(a);var c=g.getElementsByTagNameNS("*","*");if(c){a.initMutationEvent("DOMNodeRemovedFromDocument",false,false,null,null,null,null,null);for(var b=0,f=c.length;b<f;++b){var e=c[b];a.target=e;e.dispatchEvent(a);e=null}}a.initMutationEvent("DOMNodeRemoved",true,false,this,null,null,null,null);g.dispatchEvent(a);a=c=null;if(g.parentNode===this){this.childNodes.splice(g._num,1)}else{throw (new DOMException(DOMException.NOT_FOUND_ERR))}if(g.ownerDocument!==this.ownerDocument){throw (new Error())}return g};CharacterData.prototype.appendData=function(a){var c=this.data;this.data+=a;this.length=this.data.length;var b=this.ownerDocument.createEvent("MutationEvents");b.initMutationEvent("DOMCharacterDataModified",true,false,null,c,this.data,null,null);this.parentNode.dispatchEvent(b);b=a=c=null};CharacterData.prototype.insertData=function(g,a){var c=this.data;var f=this.substring(0,g-1);var e=this.substring(g,this.length-g);this.data=f+this.data+e;this.length=this.data.length;var b=this.ownerDocument.createEvent("MutationEvents");b.initMutationEvent("DOMCharacterDataModified",true,false,null,c,this.data,null,null);this.parentNode.dispatchEvent(b);b=a=c=null};CharacterData.prototype.deleteData=function(g,e){var b=this.data;var f=this.substring(0,g-1);var c=this.substring(g+e,this.length-1);if(g+e>this.length){c=""}this.data=f+c;this.length=this.data.length;var a=this.ownerDocument.createEvent("MutationEvents");a.initMutationEvent("DOMCharacterDataModified",true,false,null,b,this.data,null,null);this.parentNode.dispatchEvent(a);a=b=null};function StyleSheet(){this.type="text/css";this.disabled=false;this.ownerNode=null;this.parentStyleSheet=null;this.href=null;this.title="";this.media=new MediaList();return this}function MediaList(){this.mediaText="";this.length=0;return this}MediaList.prototype={item:function(a){return(this[a])},deleteMedium:function(a){for(var b=0,c=this.length;b<c;++b){if(this[b]===a){delete this[b];--this.length;return}}throw (new DOMException(DOMException.NOT_FOUND_ERR))},appendMedium:function(a){this[this.length]=a;++this.length}};function LinkStyle(){this.sheet=new StyleSheet();return this}function DocumentStyle(){this.styleSheets=[];return this}function CSSRule(){this.cssText="";this.parentStyleSheet;this.parentRule=null;return this}CSSRule.UNKNOWN_RULE=0;CSSRule.STYLE_RULE=1;CSSRule.CHARSET_RULE=2;CSSRule.IMPORT_RULE=3;CSSRule.MEDIA_RULE=4;CSSRule.FONT_FACE_RULE=5;CSSRule.PAGE_RULE=6;function CSSStyleRule(){CSSRule.call(this,arguments);this.type=CSSRule.STYLE_RULE;this.selectorText="";this.style=new CSSStyleDeclaration();this.style.parentRule=this;return this}CSSStyleRule.prototype=new CSSRule();CSSStyleRule.constructor=CSSRule;function CSSMediaRule(){CSSRule.call(this,arguments);this.type=CSSRule.MEDIA_RULE;this.media=new MediaList();this.cssRules=[];return this}CSSMediaRule.prototype=new CSSRule();CSSMediaRule.constructor=CSSRule;CSSMediaRule.prototype.insertRule=function(b,a){this.cssRules.splice(a,b,1);this.media.appendMedium(b);return this};CSSMediaRule.prototype.deleteRule=function(a){};function CSSFontFaceRule(){CSSRule.call(this,arguments);this.type=CSSRule.FONT_FACE_RULE;this.style;return this}CSSFontFaceRule.prototype=new CSSRule();CSSFontFaceRule.constructor=CSSRule;function CSSPageRule(){CSSRule.call(this,arguments);this.type=CSSRule.PAGE_RULE;this.selectorText="";this.style;return this}CSSPageRule.prototype=new CSSRule();CSSPageRule.constructor=CSSRule;function CSSImportRule(){CSSRule.call(this,arguments);this.type=CSSRule.IMPORT_RULE;this.href="";this.media=new MediaList();this.styleSheet=null;return this}CSSImportRule.prototype=new CSSRule();CSSImportRule.constructor=CSSRule;function CSSCharsetRule(){CSSRule.call(this,arguments);this.type=CSSRule.CHARSET_RULE;this.encoding="";return this}CSSCharsetRule.prototype=new CSSRule();CSSCharsetRule.constructor=CSSRule;function CSSUnknownRule(){CSSRule.call(this,arguments);this.type=CSSRule.UNKNOWN_RULE;return this}CSSUnknownRule.prototype=new CSSRule();CSSUnknownRule.constructor=CSSRule;function CSSStyleDeclaration(){this._list=[];this._def=this._list._fontSize=this._list._opacity=null;return this}CSSStyleDeclaration.prototype={cssText:"",length:0,parentRule:null,getPropertyValue:function(b){var c=this.getPropertyCSSValue(b);if(c){var a=c.cssText;return(a.substring(a.indexOf(":")+1,a.length))}else{return""}},getPropertyCSSValue:function(b){var g=b;b+=":";if(b===":"){return null}for(var c=0,f=this._list.length;c<f;++c){var e=this._list[c],a=e.cssText;if(a.indexOf(b)>-1){e._empercents=this._list._fontSize;a=g=b=null;return e}}if(this._def){a=b=null;return(this._def[g])}g=b=null;return null},removeProperty:function(a){var b=this.getPropertyCSSValue(a);if(b){this._list.splice(b._num,1);--this.length}},getPropertyPriority:function(a){var b=this.getPropertyCSSValue(a);if(b){return(b._priority)}else{return""}},setProperty:function(h,k,j){var e="";if(!!this[h]){var b=this.getPropertyCSSValue(h)}else{var b=null}e+=h;e+=":";e+=k;if(b){b._priority=j;b.cssText=e;var a=b}else{if((h==="fill")||(h==="stroke")){var a=new SVGPaint();var i=SVGPaint.SVG_PAINTTYPE_UNKNOWN,c=null,f=null;if(k==="none"){i=SVGPaint.SVG_PAINTTYPE_NONE}else{if(k==="currentColor"){i=SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR;f=this.getPropertyValue("color")}else{var g=/url\(#([^)]+)/;if(g.test(k)){i=SVGPaint.SVG_PAINTTYPE_URI;c=RegExp.$1}else{i=SVGPaint.SVG_PAINTTYPE_RGBCOLOR;f=k}}}a.setPaint(i,c,f,null);i=c=f=null}else{if(h==="color"){var a=new CSSPrimitiveValue();var o=this.getPropertyCSSValue("fill"),l=this.getPropertyCSSValue("stroke");if(o){if(o.paintType===SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR){o.setPaint(o.paintType,null,k,null)}}else{if(l){if(l.paintType===SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR){l.setPaint(o.paintType,null,k,null)}}}}else{var a=new CSSPrimitiveValue()}}a._priority=j;a.cssText=e;a._num=this._list.length;this._list[a._num]=a;this[h]=1;++this.length}if(k==="inherit"){a.cssValueType=CSSValue.CSS_INHERIT}else{if(h==="opacity"){this._list._opacity=parseFloat(k)}else{if(h==="font-size"){if(/(%|em)/.test(k)){this._list.fontSize=parseFloat(k)}}}}e=null},item:function(a){if(a>=this.length){var b=""}else{var b=this._list[a].cssText.substring(0,this._list[a].cssText.indexOf(":"))}return b}};function CSSValue(){return this}CSSValue.CSS_INHERIT=0;CSSValue.CSS_PRIMITIVE_VALUE=1;CSSValue.CSS_VALUE_LIST=2;CSSValue.CSS_CUSTOM=3;CSSValue.prototype={cssText:"",cssValueType:CSSValue.CSS_CUSTOM};function CSSPrimitiveValue(){return this}CSSPrimitiveValue.CSS_UNKNOWN=0;CSSPrimitiveValue.CSS_NUMBER=1;CSSPrimitiveValue.CSS_PERCENTAGE=2;CSSPrimitiveValue.CSS_EMS=3;CSSPrimitiveValue.CSS_EXS=4;CSSPrimitiveValue.CSS_PX=5;CSSPrimitiveValue.CSS_CM=6;CSSPrimitiveValue.CSS_MM=7;CSSPrimitiveValue.CSS_IN=8;CSSPrimitiveValue.CSS_PT=9;CSSPrimitiveValue.CSS_PC=10;CSSPrimitiveValue.CSS_DEG=11;CSSPrimitiveValue.CSS_RAD=12;CSSPrimitiveValue.CSS_GRAD=13;CSSPrimitiveValue.CSS_MS=14;CSSPrimitiveValue.CSS_S=15;CSSPrimitiveValue.CSS_HZ=16;CSSPrimitiveValue.CSS_KHZ=17;CSSPrimitiveValue.CSS_DIMENSION=18;CSSPrimitiveValue.CSS_STRING=19;CSSPrimitiveValue.CSS_URI=20;CSSPrimitiveValue.CSS_IDENT=21;CSSPrimitiveValue.CSS_ATTR=22;CSSPrimitiveValue.CSS_COUNTER=23;CSSPrimitiveValue.CSS_RECT=24;CSSPrimitiveValue.CSS_RGBCOLOR=25;CSSPrimitiveValue.prototype=new CSSValue();CSSPrimitiveValue.constructor=CSSValue;CSSPrimitiveValue.prototype._n=[1,0.01,1,1,1,35.43307,3.543307,90,1.25,15,1,180/Math.PI,90/100,1,1000,1,1000,1];CSSPrimitiveValue.prototype.cssValueType=CSSValue.CSS_PRIMITIVE_VALUE;CSSPrimitiveValue.prototype.primitiveType=CSSPrimitiveValue.CSS_UNKNOWN;CSSPrimitiveValue.prototype._value=1;CSSPrimitiveValue.prototype._percent=0;CSSPrimitiveValue.prototype._empercent=0;CSSPrimitiveValue.prototype.setFloatValue=function(a,b){if(CSSPrimitiveValue.CSS_UNKNOWN>=a&&a>=CSSPrimitiveValue.CSS_STRING){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}this.primitiveType=a;this._value=b*this._n[a-1]};CSSPrimitiveValue.prototype.getFloatValue=function(b){if(CSSPrimitiveValue.CSS_UNKNOWN>=b&&b>=CSSPrimitiveValue.CSS_STRING){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}var f=this.cssText.match(/\D+$/),e=0,a=parseFloat;var c=a(this.cssText.match(/[\d\.]+/));c=isNaN(c)?0:c;if(!!f){f=f[0]}if(!f){e=CSSPrimitiveValue.CSS_NUMBER}else{if(f==="%"){c*=this._percent;e=CSSPrimitiveValue.CSS_PERCENTAGE}else{if(f==="em"){c*=this._empercent;e=CSSPrimitiveValue.CSS_EMS}else{if(f==="ex"){e=CSSPrimitiveValue.CSS_EXS}else{if(f==="px"){e=CSSPrimitiveValue.CSS_PX}else{if(f==="cm"){e=CSSPrimitiveValue.CSS_CM}else{if(f==="mm"){e=CSSPrimitiveValue.CSS_MM}else{if(f==="in"){e=CSSPrimitiveValue.CSS_IN}else{if(f==="pt"){e=CSSPrimitiveValue.CSS_PT}else{if(f==="pc"){e=CSSPrimitiveValue.CSS_PC}}}}}}}}}}this.setFloatValue(e,c);return(this._value/this._n[b-1])};CSSPrimitiveValue.prototype.setStringValue=function(b,a){if(CSSPrimitiveValue.CSS_DIMENSION>=b&&b>=CSSPrimitiveValue.CSS_COUNTER){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}this.cssText=a};CSSPrimitiveValue.prototype.getStringValue=function(){if(CSSPrimitiveValue.CSS_DIMENSION>=stringType&&stringType>=CSSPrimitiveValue.CSS_COUNTER){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}return(this.cssText)};CSSPrimitiveValue.prototype.getCounterValue=function(){if(this.primitiveType!==CSSPrimitiveValue.CSS_COUNTER){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}return(new Counter())};CSSPrimitiveValue.prototype.getRectValue=function(){if(this.primitiveType!==CSSPrimitiveValue.CSS_RECT){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}return(new Rect())};CSSPrimitiveValue.prototype.getRGBColorValue=function(){if(this.primitiveType!==CSSPrimitiveValue.CSS_RGBCOLOR){throw new DOMException(DOMException.INVALID_ACCESS_ERR)}var a=new RGBColor();var b=this.cssText;var c=SVGColor.prototype._keywords[b];if(c!==void 0){b=c}if(b.indexOf("%",5)>0){b=b.replace(/[\d.]+%/g,function(f){return Math.round((2.55*parseFloat(f)))})}else{if(b.indexOf("#")>-1){b=b.replace(/[\da-f][\da-f]/gi,function(f){return parseInt(f,16)})}}var e=b.match(/\d+/g);a.red.setFloatValue(CSSPrimitiveValue.CSS_NUMBER,parseFloat(e[0]));a.green.setFloatValue(CSSPrimitiveValue.CSS_NUMBER,parseFloat(e[1]));a.blue.setFloatValue(CSSPrimitiveValue.CSS_NUMBER,parseFloat(e[2]));e=b=null;return(a)};function CSSValueList(){this.cssValueType=CSSValue.CSS_VALUE_LIST;this.length=0;return this}CSSValueList.prototype=new CSSValue();CSSValueList.constructor=CSSValue;CSSValueList.prototype.item=function(a){return(this[a])};function RGBColor(){this.red=new CSSPrimitiveValue();this.green=new CSSPrimitiveValue();this.blue=new CSSPrimitiveValue();return this}function Rect(){this.top=new CSSPrimitiveValue();this.right=new CSSPrimitiveValue();this.bottom=new CSSPrimitiveValue();this.left=new CSSPrimitiveValue();return this}function Counter(){this.identifier="";this.listStyle="";this.separator="";return this}function ElementCSSInlineStyle(){this.style=new CSSStyleDeclaration();this._attributeStyle=new CSSStyleDeclaration();return this}var CSS2Properties={fill:"black",stroke:"none",cursor:"auto",visibility:"visiblee",display:"inline-block",opacity:"1",fillOpacity:"1",strokeWidth:"1",strokeDasharray:"none",strokeDashoffset:"0",strokeLinecap:"butt",strokeLinejoin:"miter",strokeMiterlimit:"4",strokeOpacity:"1",writingMode:"lr-tb",fontFamily:"serif",fontSize:"12",color:"black",fontSizeAdjust:"none",fontStretch:"normal",fontStyle:"normal",fontVariant:"normal",fontWeight:"normal",font:"inline",stopColor:"black",stopOpacity:"1",textAnchor:"start",azimuth:"center",clip:"auto",direction:"ltr",letterSpacing:"normal",lineHeight:"normal",overflow:"visible",textAlign:"left",textDecoration:"none",textIndent:"0",textShadow:"none",textTransform:"none",unicodeBidi:"normal",verticalAlign:"baseline",whiteSpace:"normal",wordSpacing:"normal",zIndex:"auto",mask:"none",enableBackground:"accumulate",filter:"none",floodColor:"black",floodOpacity:"1",lightingColor:"white",pointerEvents:"visiblePainted",colorInterpolation:"sRGB",colorInterpolationFilters:"linearRGB",colorProfile:"auto",colorRendering:"auto",imageRendering:"auto",marker:"",markerEnd:"none",markerMid:"none",markerStart:"none",shapeRendering:"auto",textRendering:"auto",alignmentBaseline:"",baselineShift:"baseline",dominantBaseline:"auto",glyphOrientationHorizontal:"0deg",glyphOrientationVertical:"auto",kerning:"auto",fillRule:"nonzero"};CSS2Properties.visibility._n=1;function CSSStyleSheet(){this.ownerRule=null;this.cssRules=[];return this}CSSStyleSheet.prototype=new StyleSheet();CSSStyleSheet.constructor=StyleSheet;CSSStyleSheet.prototype.insertRule=function(c,a){var b=new CSSStyleRule();b.parentStyleSheet=this;b.cssText=c;this.cssRules.splice(a,b,1)};CSSStyleSheet.prototype.deleteRule=function(a){this.cssRules.splice(a,1)};Document.prototype.defaultView=new ViewCSS();function ViewCSS(){return this}ViewCSS.prototype.getComputedStyle=function(j,h){if(!!j._currentStyle){return(j._currentStyle)}var u=new CSSStyleDeclaration();j._currentStyle=u;var e=j.parentNode;if(e){var f=this.getComputedStyle(e,h)._list}else{var f={length:0,_opacity:1,_fontSize:12}}var b=u._list;if(!!j.style){var o=j.style._list,a=j._attributeStyle._list,t=CSSValue.CSS_INHERIT;for(var l=0,r=o.length;l<r;++l){b[b.length]=o[l]}for(var l=0,r=a.length;l<r;++l){b[b.length]=a[l]}o=a=null;for(var l=0,k=b.length;l<k;++l){if(b[l].cssValueType===t){b.splice(l,1);--k}}}for(var l=0,g=f.length;l<g;++l){b[b.length]=f[l]}if(j._runtimeStyle){b=j._runtimeStyle._list.concat(b)}u._def=this._defaultCSS;u._list=b;if(!!j.style){var c=j.style._list._opacity||j._attributeStyle._list._opacity}else{var c=1}u._list._opacity=f._opacity*(c||1);u._list._fontSize=f._fontSize;e=c=f=b=null;u._document=j.ownerDocument;return u};Document.prototype.getOverrideStyle=function(b,f){var a=b;if(!!a._runtimeStyle){return(a._runtimeStyle)}else{var e=new CSSStyleDeclaration(),c=e.setProperty;a._runtimeStyle=e}e.setProperty=function(o,t,r){c.call(e,o,t,r);var l=b,g=l._tar,k=isStroke=false;delete l._currentStyle;if((l.localName==="g")||(l.localName==="a")){var h=l.getElementsByTagNameNS("http://www.w3.org/2000/svg","*");if(h){for(var j=0,u=h.length;j<u;++j){var q=h[j];delete q._currentStyle;NAIBU._setPaint(q,q.getScreenCTM());q=null}h=null}g=null}if(!g){return}NAIBU._setPaint(l,l.getScreenCTM());g=l=t=null};return e};DOMImplementation.createCSSStyleSheet=function(h,g){var f=new CSSStyleSheet();f.title=h;var a=new MediaList();a.mediaText=g;if(g!==""){var b=g.split(",");for(var e=0,c=b.length;e<c;++e){a.appendMedium(b[e])}}f.media=a;return f};function TimeEvent(){Event.apply(this);this.view;this.detail;return this}TimeEvent.counstructor=Event;TimeEvent.prototype=new Event();TimeEvent.prototype.initTimeEvent=function(b,c,a){this.type=b;this.view=c;this.detail=a};var NAIBU={};function SVGException(a){this.code=a;if(this.code===SVGException.SVG_WRONG_TYPE_ERR){this.message="SVG Wrong Type Error"}else{if(this.code===SVGException.SVG_INVALID_VALUE_ERR){this.message="SVG Invalid Value Error"}else{if(this.code===SVGException.SVG_MATRIX_NOT_INVERTABLE){this.message="SVG　Matrix Not Invertable"}}}return this}SVGException.constructor=Error;SVGException.prototype=new Error();SVGException.SVG_WRONG_TYPE_ERR=0;SVGException.SVG_INVALID_VALUE_ERR=1;SVGException.SVG_MATRIX_NOT_INVERTABLE=2;function SVGElement(){Element.call(this);SVGStylable.call(this);this.transform=new SVGAnimatedTransformList();this.addEventListener("DOMAttrModified",function(evt){if(evt.eventPhase===Event.BUBBLING_PHASE){return}var name=evt.attrName,tar=evt.target;if(!!CSS2Properties[name]||name.indexOf("-")>-1){tar._attributeStyle.setProperty(name,evt.newValue,"")}if(evt.relatedNode.localName==="id"){tar.id=evt.newValue}else{if(name==="transform"&&!!tar.transform){var tft=evt.newValue,degR=tar._degReg;var coma=tft.match(tar._comaReg);var list=tft.match(tar._strReg);var a,b,c,d,e,f,lis,deg,rad,degli;for(var j=0,cli=coma.length;j<cli;j++){var s=evt.target.ownerDocument.documentElement.createSVGTransform();lis=list[j],com=coma[j];deg=lis.match(degR);degli=deg.length;if(degli===6){var cm=s.matrix;cm.a=+(deg[0]);cm.b=+(deg[1]);cm.c=+(deg[2]);cm.d=+(deg[3]);cm.e=+(deg[4]);cm.f=+(deg[5])}else{if(degli===3){var degz=+(deg[0]);s.setRotate(degz,+(deg[1]),+(deg[2]))}else{if(degli<=2){var degz=+(deg[0]);if(com==="translate"){s.setTranslate(degz,+(deg[1]||0))}else{if(com==="scale"){s.setScale(degz,+(deg[1]||deg[0]))}else{if(com==="rotate"){s.setRotate(degz,0,0)}else{if(com==="skewX"){s.setSkewX(degz)}else{if(com==="skewY"){s.setSkewY(degz)}}}}}}}}tar.transform.baseVal.appendItem(s);lis=com=deg=rad=null}list=coma=mat=null}else{if(name==="style"){var sc=evt.newValue,style=tar.style;style.cssText=sc;if(sc!==""){sc=sc.replace(tar._shouReg,"").replace(tar._conReg,":").replace(tar._bouReg,";");var a=sc.split(";");for(var i=0,ali=a.length;i<ali;++i){var ai=a[i],m=ai.split(":");if(ai!==""){style.setProperty(m[0],m[1])}ai=m=null}a=sc=null}}else{if(name==="class"){tar.className=evt.newValue}else{if(name.indexOf("on")===0){eval("document._s = (function(evt){"+evt.newValue+"})");var v=name.substring(2,name.length);if(v==="load"){v="SVGLoad"}else{if(v==="unload"){v="SVGUnload"}else{if(v==="abort"){v="SVGAbort"}else{if(v==="error"){v="SVGError"}else{if(v==="resize"){v="SVGResize"}else{if(v==="scroll"){v="SVGScroll"}else{if(v==="zoom"){v="SVGZoom"}else{if(v==="begin"){v="beginEvent"}else{if(v==="end"){v="endEvent"}else{if(v==="repeat"){v="repeatEvent"}}}}}}}}}}tar.addEventListener(v,document._s,false)}else{if(evt.relatedNode.nodeName==="xml:base"){tar.xmlbase=evt.newValue}else{if(!!tar[name]){var tea=tar[name],tod=tar.ownerDocument.documentElement;if(tea instanceof SVGAnimatedLength){var n=evt.newValue.match(tar._NaNReg),type=SVGLength.SVG_LENGTHTYPE_NUMBER,_parseFloat=parseFloat;if(!!n){n=n[0]}if(n==="%"){if((name==="x")||(name==="width")){tea.baseVal._percent*=tod.viewport.width}else{if((name==="y")||(name==="height")){tea.baseVal._percent*=tod.viewport.height}}type=SVGLength.SVG_LENGTHTYPE_PERCENTAGE}else{if(n==="em"){type=SVGLength.SVG_LENGTHTYPE_EMS}else{if(n==="ex"){type=SVGLength.SVG_LENGTHTYPE_EXS}else{if(n==="px"){type=SVGLength.SVG_LENGTHTYPE_PX}else{if(n==="cm"){type=SVGLength.SVG_LENGTHTYPE_CM}else{if(n==="mm"){type=SVGLength.SVG_LENGTHTYPE_MM}else{if(n==="in"){type=SVGLength.SVG_LENGTHTYPE_IN}else{if(n==="pt"){type=SVGLength.SVG_LENGTHTYPE_PT}else{if(n==="pc"){type=SVGLength.SVG_LENGTHTYPE_PC}}}}}}}}}var s=_parseFloat(evt.newValue);s=isNaN(s)?0:s;tea.baseVal.newValueSpecifiedUnits(type,s)}}}}}}}}evt=_parseFloat=name=tar=null},false);return this}SVGElement.constructor=Element;SVGElement.prototype=new Element();(function(){this._degReg=/[\-\d\.e]+/g;this._comaReg=/[A-Za-z]+(?=\s*\()/g;this._strReg=/\([^\)]+\)/g;this._syouReg=/^[^a-z\-]+/;this._conReg=/\:\s+/g;this._bouReg=/\s*;[^a-z\-]*/g;this._NaNReg=/\D+$/;this._cacheMatrix=null;this.id=null;this.xmlbase=null;this.ownerSVGElement;this.viewportElement;this.nearestViewportElement=null;this.farthestViewportElement=null;this.getBBox=function(){var q=new SVGRect();var e=this._tar.path.value,b=this.ownerDocument.documentElement.viewport;var a=b.width,k=b.height,o=0,h=0;var l=e.match(/[0-9\-]+/g);for(var c=0,j=l.length;c<j;c+=2){var g=+(l[c]),f=+(l[c+1]);a=a>g?g:a;k=k>f?f:k;o=o>g?o:g;h=h>f?h:f;g=f=null}e=l=null;q.x=a;q.y=k;q.width=o-a;q.height=h-k;a=k=o=h=b=null;return q};this.getCTM=function(){var b;if(!!this._cacheMatrix){b=this._cacheMatrix}else{var a=this.transform.baseVal.consolidate();if(a){a=a.matrix}else{a=this.ownerDocument.documentElement.createSVGMatrix()}if(this.parentNode&&!!this.parentNode.getCTM){b=this.parentNode.getCTM().multiply(a)}else{b=a}a=null;this._cacheMatrix=b}return b};this.getScreenCTM=function(){if(!this.parentNode){return null}var a=this.nearestViewportElement||this.ownerDocument.documentElement;var b=a.getScreenCTM().multiply(this.getCTM());return b};this.getTransformToElement=function(a){var b=this.getScreenCTM().inverse().multiply(a.getScreenCTM());return b}}).apply(SVGElement.prototype);function SVGAnimatedBoolean(){this.animVal=this.baseVal=true;return this}function SVGAnimatedString(){this.animVal=this.baseVal="";return this}function SVGStringList(){return this}SVGStringList.prototype=new Array();(function(){this.numberOfItems=0;this.clear=function(){for(var a=0,b=this.length;a<b;++a){delete this[a]}this.numberOfItems=0};this.initialize=function(a){this.clear();this[0]=a;this.numberOfItems=1;return a};this.getItem=function(a){if(a>=this.numberOfItems||a<0){throw (new DOMException(DOMException.INDEX_SIZE_ERR))}else{return(this[a])}};this.insertItemBefore=function(b,a){if(a>=this.numberOfItems){this.appendItem(b)}else{this.splice(a,1,b,this.getItem[a]);++this.numberOfItems}return b};this.replaceItem=function(b,a){if(a>=this.numberOfItems||a<0){throw (new DOMException(DOMException.INDEX_SIZE_ERR))}else{this.splice(a,1,b)}return b};this.removeItem=function(a){if(a>=this.numberOfItems||a<0){throw (new DOMException(DOMException.INDEX_SIZE_ERR))}else{this.splice(a,1);--this.numberOfItems}return newItem};this.appendItem=function(a){this[this.numberOfItems]=a;++this.numberOfItems}}).apply(SVGStringList.prototype);function SVGAnimatedEnumeration(){this.baseVal=0;this.animVal=0;return this}function SVGAnimatedInteger(){this.baseVal=0;this.animVal=0;return this}function SVGNumber(){this.value=0;return this}function SVGAnimatedNumber(){this.baseVal=this.animVal=0;return this}function SVGNumberList(){return this}for(var prop in SVGStringList.prototype){SVGNumberList.prototype[prop]=SVGStringList.prototype[prop]}function SVGAnimatedNumberList(){this.animVal=this.baseVal=new SVGNumberList();return this}function SVGLength(){return this}SVGLength.SVG_LENGTHTYPE_UNKNOWN=0;SVGLength.SVG_LENGTHTYPE_NUMBER=1;SVGLength.SVG_LENGTHTYPE_PERCENTAGE=2;SVGLength.SVG_LENGTHTYPE_EMS=3;SVGLength.SVG_LENGTHTYPE_EXS=4;SVGLength.SVG_LENGTHTYPE_PX=5;SVGLength.SVG_LENGTHTYPE_CM=6;SVGLength.SVG_LENGTHTYPE_MM=7;SVGLength.SVG_LENGTHTYPE_IN=8;SVGLength.SVG_LENGTHTYPE_PT=9;SVGLength.SVG_LENGTHTYPE_PC=10;SVGLength.prototype={unitType:SVGLength.SVG_LENGTHTYPE_UNKNOWN,value:0,valueInSpecifiedUnits:SVGLength.SVG_LENGTHTYPE_UNKNOWN,valueAsString:"0",_percent:0.01,_fontSize:12,newValueSpecifiedUnits:function(a,c){var e=1,b="";if(a===SVGLength.SVG_LENGTHTYPE_NUMBER){}else{if(a===SVGLength.SVG_LENGTHTYPE_PX){b="px"}else{if(a===SVGLength.SVG_LENGTHTYPE_PERCENTAGE){e=this._percent;b="%"}else{if(a===SVGLength.SVG_LENGTHTYPE_EMS){e=this._fontSize;b="em"}else{if(a===SVGLength.SVG_LENGTHTYPE_EXS){e=this._fontSize*0.5;b="ex"}else{if(a===SVGLength.SVG_LENGTHTYPE_CM){e=35.43307;b="cm"}else{if(a===SVGLength.SVG_LENGTHTYPE_MM){e=3.543307;b="mm"}else{if(a===SVGLength.SVG_LENGTHTYPE_IN){e=90;b="in"}else{if(a===SVGLength.SVG_LENGTHTYPE_PT){e=1.25;b="pt"}else{if(a===SVGLength.SVG_LENGTHTYPE_PC){e=15;b="pc"}else{throw new DOMException(DOMException.NOT_SUPPORTED_ERR)}}}}}}}}}}this.unitType=a;this.value=c*e;this.valueInSpecifiedUnits=c;this.valueAsString=c+b;e=b=null},convertToSpecifiedUnits:function(b){if(this.value===0){this.newValueSpecifiedUnits(b,0);return}var a=this.value;this.newValueSpecifiedUnits(b,this.valueInSpecifiedUnits);a=a/this.value*this.valueInSpecifiedUnits;this.newValueSpecifiedUnits(b,a)},_emToUnit:function(a){if((this.unitType===3)||(this.unitType===4)){this._fontSize=a;this.newValueSpecifiedUnits(this.unitType,this.valueInSpecifiedUnits)}}};function SVGAnimatedLength(){this.animVal;this.baseVal=new SVGLength();this.baseVal.unitType=1;return this}function SVGLengthList(){return this}for(var prop in SVGStringList.prototype){SVGLengthList.prototype[prop]=SVGStringList.prototype[prop]}function SVGAnimatedLengthList(){this.animVal=this.baseVal=new SVGLengthList();return this}function SVGAngle(){this.unitType=0;this.value=0;this.valueInSpecifiedUnits;this.valueAsString;return this}SVGAngle.prototype={newValueSpecifiedUnits:function(a,c){var e=1,b="";if(a===SVGAngle.SVG_ANGLETYPE_DEG){b="deg"}else{if(a===SVGAngle.SVG_ANGLETYPE_RAD){e=Math.PI/180;b="rad"}else{if(a===SVGAngle.SVG_ANGLETYPE_GRAD){e=9/10;b="grad"}}}this.unitType=a;this.value=c*e;this.valueInSpecifiedUnits=c;this.valuAsString=c+b;e=b=null},convertToSpecifiedUnits:function(a){this.newValueSpecifiedUnits(a,this.valueInSpecifiedUnits)}};SVGAngle.SVG_ANGLETYPE_UNKNOWN=0;SVGAngle.SVG_ANGLETYPE_UNSPECIFIED=1;SVGAngle.SVG_ANGLETYPE_DEG=2;SVGAngle.SVG_ANGLETYPE_RAD=3;SVGAngle.SVG_ANGLETYPE_GRAD=4;function SVGAnimatedAngle(){this.baseVal=new SVGAngle();this.animVal=this.baseVal;return this}function SVGColor(){CSSValue.call(this,arguments);this.colorType=SVGColor.SVG_COLORTYPE_UNKNOWN;this.rgbColor=new RGBColor();this.iccColor;return this}SVGColor.SVG_COLORTYPE_UNKNOWN=0;SVGColor.SVG_COLORTYPE_RGBCOLOR=1;SVGColor.SVG_COLORTYPE_RGBCOLOR_ICCCOLOR=2;SVGColor.SVG_COLORTYPE_CURRENTCOLOR=3;SVGColor.prototype=new CSSValue();SVGColor.constructor=CSSValue;SVGColor.prototype.setRGBColor=function(j){var k=this._keywords[j];if(k!==void 0){j=k}if(j.indexOf("%",5)>0){j=j.replace(/[\d.]+%/g,function(b){return Math.round((2.55*parseFloat(b)))});var f=j.match(/\d+/g)}else{if(j.indexOf("#")===0){var f=[],e=parseInt;var i=j.charAt(1),h=j.charAt(2),a=j.charAt(3);if(j.length<5){var l="#"+i+i+h+h+a+a;j=l;l=null}f[0]=e(i+j.charAt(2),16)+"";f[1]=e(j.charAt(3)+j.charAt(4),16)+"";f[2]=e(j.charAt(5)+j.charAt(6),16)+"";i=h=a=null}else{var f=j.match(/\d+/g);if(!!!f){j=null;return}}}this.rgbColor.red.cssText=f[0];this.rgbColor.green.cssText=f[1];this.rgbColor.blue.cssText=f[2];j=k=f=null};SVGColor.prototype.setColor=function(a,b,c){this.colorType=a;if((a===SVGColor.SVG_COLORTYPE_RGBCOLOR)||(a===SVGColor.SVG_COLORTYPE_CURRENTCOLOR)){this.setRGBColor(b)}};SVGColor.prototype._keywords={aliceblue:"rgb(240, 248, 255)",antiquewhite:"rgb(250, 235, 215)",aqua:"rgb( 0, 255, 255)",aquamarine:"rgb(127, 255, 212)",azure:"rgb(240, 255, 255)",beige:"rgb(245, 245, 220)",bisque:"rgb(255, 228, 196)",black:"rgb( 0, 0, 0)",blanchedalmond:"rgb(255, 235, 205)",blue:"rgb( 0, 0, 255)",blueviolet:"rgb(138, 43, 226)",brown:"rgb(165, 42, 42)",burlywood:"rgb(222, 184, 135)",cadetblue:"rgb( 95, 158, 160)",chartreuse:"rgb(127, 255, 0)",chocolate:"rgb(210, 105, 30)",coral:"rgb(255, 127, 80)",cornflowerblue:"rgb(100, 149, 237)",cornsilk:"rgb(255, 248, 220)",crimson:"rgb(220, 20, 60)",cyan:"rgb( 0, 255, 255)",darkblue:"rgb( 0, 0, 139)",darkcyan:"rgb( 0, 139, 139)",darkgoldenrod:"rgb(184, 134, 11)",darkgray:"rgb(169, 169, 169)",darkgreen:"rgb( 0, 100, 0)",darkgrey:"rgb(169, 169, 169)",darkkhaki:"rgb(189, 183, 107)",darkmagenta:"rgb(139, 0, 139)",darkolivegreen:"rgb( 85, 107, 47)",darkorange:"rgb(255, 140, 0)",darkorchid:"rgb(153, 50, 204)",darkred:"rgb(139, 0, 0)",darksalmon:"rgb(233, 150, 122)",darkseagreen:"rgb(143, 188, 143)",darkslateblue:"rgb( 72, 61, 139)",darkslategray:"rgb( 47, 79, 79)",darkslategrey:"rgb( 47, 79, 79)",darkturquoise:"rgb( 0, 206, 209)",darkviolet:"rgb(148, 0, 211)",deeppink:"rgb(255, 20, 147)",deepskyblue:"rgb( 0, 191, 255)",dimgray:"rgb(105, 105, 105)",dimgrey:"rgb(105, 105, 105)",dodgerblue:"rgb( 30, 144, 255)",firebrick:"rgb(178, 34, 34)",floralwhite:"rgb(255, 250, 240)",forestgreen:"rgb( 34, 139, 34)",fuchsia:"rgb(255, 0, 255)",gainsboro:"rgb(220, 220, 220)",ghostwhite:"rgb(248, 248, 255)",gold:"rgb(255, 215, 0)",goldenrod:"rgb(218, 165, 32)",gray:"rgb(128, 128, 128)",grey:"rgb(128, 128, 128)",green:"rgb( 0, 128, 0)",greenyellow:"rgb(173, 255, 47)",honeydew:"rgb(240, 255, 240)",hotpink:"rgb(255, 105, 180)",indianred:"rgb(205, 92, 92)",indigo:"rgb( 75, 0, 130)",ivory:"rgb(255, 255, 240)",khaki:"rgb(240, 230, 140)",lavender:"rgb(230, 230, 250)",lavenderblush:"rgb(255, 240, 245)",lawngreen:"rgb(124, 252, 0)",lemonchiffon:"rgb(255, 250, 205)",lightblue:"rgb(173, 216, 230)",lightcoral:"rgb(240, 128, 128)",lightcyan:"rgb(224, 255, 255)",lightgoldenrodyellow:"rgb(250, 250, 210)",lightgray:"rgb(211, 211, 211)",lightgreen:"rgb(144, 238, 144)",lightgrey:"rgb(211, 211, 211)",lightpink:"rgb(255, 182, 193)",lightsalmon:"rgb(255, 160, 122)",lightseagree:"rgb( 32, 178, 170)",lightskyblue:"rgb(135, 206, 250)",lightslategray:"rgb(119, 136, 153)",lightslategrey:"rgb(119, 136, 153)",lightsteelblue:"rgb(176, 196, 222)",lightyellow:"rgb(255, 255, 224)",lime:"rgb( 0, 255, 0)",limegreen:"rgb( 50, 205, 50)",linen:"rgb(250, 240, 230)",magenta:"rgb(255, 0, 255)",maroon:"rgb(128, 0, 0)",mediumaquamarine:"rgb(102, 205, 170)",mediumblue:"rgb( 0, 0, 205)",mediumorchid:"rgb(186, 85, 211)",mediumpurple:"rgb(147, 112, 219)",mediumseagreen:"rgb( 60, 179, 113)",mediumslateblue:"rgb(123, 104, 238)",mediumspringgreen:"rgb( 0, 250, 154)",mediumturquoise:"rgb( 72, 209, 204)",mediumvioletred:"rgb(199, 21, 133)",midnightblue:"rgb( 25, 25, 112)",mintcream:"rgb(245, 255, 250)",mistyrose:"rgb(255, 228, 225)",moccasin:"rgb(255, 228, 181)",navajowhite:"rgb(255, 222, 173)",navy:"rgb( 0, 0, 128)",oldlace:"rgb(253, 245, 230)",olive:"rgb(128, 128, 0)",olivedrab:"rgb(107, 142, 35)",orange:"rgb(255, 165, 0)",orangered:"rgb(255, 69, 0)",orchid:"rgb(218, 112, 214)",palegoldenrod:"rgb(238, 232, 170)",palegreen:"rgb(152, 251, 152)",paleturquoise:"rgb(175, 238, 238)",palevioletred:"rgb(219, 112, 147)",papayawhip:"rgb(255, 239, 213)",peachpuff:"rgb(255, 218, 185)",peru:"rgb(205, 133, 63)",pink:"rgb(255, 192, 203)",plum:"rgb(221, 160, 221)",powderblue:"rgb(176, 224, 230)",purple:"rgb(128, 0, 128)",red:"rgb(255, 0, 0)",rosybrown:"rgb(188, 143, 143)",royalblue:"rgb( 65, 105, 225)",saddlebrown:"rgb(139, 69, 19)",salmon:"rgb(250, 128, 114)",sandybrown:"rgb(244, 164, 96)",seagreen:"rgb( 46, 139, 87)",seashell:"rgb(255, 245, 238)",sienna:"rgb(160, 82, 45)",silver:"rgb(192, 192, 192)",skyblue:"rgb(135, 206, 235)",slateblue:"rgb(106, 90, 205)",slategray:"rgb(112, 128, 144)",slategrey:"rgb(112, 128, 144)",snow:"rgb(255, 250, 250)",springgreen:"rgb( 0, 255, 127)",steelblue:"rgb( 70, 130, 180)",tan:"rgb(210, 180, 140)",teal:"rgb( 0, 128, 128)",thistle:"rgb(216, 191, 216)",tomato:"rgb(255, 99, 71)",turquoise:"rgb( 64, 224, 208)",violet:"rgb(238, 130, 238)",wheat:"rgb(245, 222, 179)",white:"rgb(255, 255, 255)",whitesmoke:"rgb(245, 245, 245)",yellow:"rgb(255, 255, 0)",yellowgreen:"rgb(154, 205, 50)"};function SVGRect(){this.x=0;this.y=0;this.width=0;this.height=0;return this}function SVGAnimatedRect(){this.animVal=this.baseVal=new SVGRect();return this}SVGUnitTypes={SVG_UNIT_TYPE_UNKNOWN:0,SVG_UNIT_TYPE_USERSPACEONUSE:1,SVG_UNIT_TYPE_OBJECTBOUNDINGBOX:2};function SVGStylable(){this.className=new SVGAnimatedString();this.style=new CSSStyleDeclaration();this._attributeStyle=new CSSStyleDeclaration()}SVGElement.prototype.getPresentationAttribute=function(a){var b=this._attributeStyle.getPropertyCSSValue(a);if(b){return b}else{return null}};function SVGURIReference(){this.href=new SVGAnimatedString();this._instance=null;this._text="";this.addEventListener("DOMAttrModified",function(a){if(a.relatedNode.namespaceURI==="http://www.w3.org/1999/xlink"&&a.attrName==="xlink:href"){a.target.href.baseVal=a.newValue;a.target.ownerDocument.documentElement._svgload_limited++}a=null},false);this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===Event.BUBBLING_PHASE){return}a.addEventListener("DOMNodeInsertedIntoDocument",function(t){var j=t.target;if(j.href.baseVal!==""){var g,c=j.href.baseVal;var h=j.xmlbase;if(!h){var w=j.parentNode,o=null;while(!o&&w){o=w.xmlbase;w=w.parentNode}g=o;if(!o){if(c.indexOf("#")!==0){var u=location.href;g=u.replace(/\/[^\/]+?$/,"/")}else{g=location.href}}}else{g=h}if(c.indexOf(":")!==-1){g=""}var i=g+c,r=j.getAttributeNS("http://www.w3.org/1999/xlink","show")||"embed";if(c.indexOf(".")===0){i=c}if(r==="replace"){j._tar.setAttribute("href",i)}else{if(r==="new"){j._tar.setAttribute("target","_blank");j._tar.setAttribute("href",i)}else{if(r==="embed"){var f=NAIBU.xmlhttp;var l=i.indexOf("#");if(l>-1){var e=i.substring(l+1,i.length);i=i.replace(/#.+$/,"")}else{var e=null}if(c.indexOf("#")===0){var q=j.ownerDocument,v=q.getElementById(e);j._instance=v;var k=q.createEvent("SVGEvents");k.initEvent("SVGLoad",false,false);j.dispatchEvent(k);k=null;v=null}else{if(i.indexOf("data:")>-1){j._tar.src=i}else{if((i.indexOf("http:")>-1)||(i.indexOf(".")===0)){if(j.localName==="image"){j._tar.src=i}f.open("GET",i,false);f.setRequestHeader("X-Requested-With","XMLHttpRequest");f.onreadystatechange=function(){if(f.readyState===4&&f.status===200){var z=f.getResponseHeader("Content-Type")||"text";if((z.indexOf("text")>-1)||(z.indexOf("xml")>-1)||(z.indexOf("script")>-1)){if(j.localName!=="script"&&j.localName!=="style"){var C=new ActiveXObject("MSXML2.DomDocument");str=f.responseText.replace(/!DOCTYPE/,"!--").replace(/(dtd">|\]>)/,"-->");NAIBU.doc.async=false;NAIBU.doc.validateOnParse=false;NAIBU.doc.resolveExternals=false;NAIBU.doc.preserveWhiteSpace=false;C.loadXML(str);var B=C.documentElement;j._instance=j.ownerDocument.importNode(B,true);if(e){j._instance=j._instance.ownerDocument.getElementById(e)}}else{j._text=f.responseText}}else{if(!!j._tar){j._tar.src=i}}var A=j.ownerDocument.createEvent("SVGEvents");A.initEvent("SVGLoad",false,false);j.dispatchEvent(A);A=null;f.onreadystatechange=NAIBU.emptyFunction}};f.send(null)}}}}}}}t=j=null},false);a=b=null},false);return this}function SVGCSSRule(){CSSRule.apply(this,arguments);this.COLOR_PROFILE_RULE=7;return this}SVGCSSRule.constructor=CSSRule;SVGCSSRule.prototype=new CSSRule();function SVGDocument(){Document.apply(this,arguments);this.title="";this.referrer=document.referrer;this.domain=document.domain;this.URL=document.location;this.rootElement;return this}SVGDocument.constructor=Document;SVGDocument.prototype=new Document();function SVGSVGElement(){SVGElement.apply(this,arguments);this._tar=document.createElement("v:group");this._svgload_limited=0;this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.contentScriptType="application/ecmascript";this.contentStyleType="text/css";this.viewport=this.createSVGRect();this.useCurrentView=false;this.currentView=new SVGViewSpec(this);this.currentScale=1;this.currentTranslate=this.createSVGPoint();this.viewBox=this.currentView.viewBox;this.preserveAspectRatio=this.currentView.preserveAspectRatio;this.zoomAndPan=SVGZoomAndPan.SVG_ZOOMANDPAN_DISABLE;this._tx=0;this._ty=0;this._currentTime=0;this.addEventListener("DOMAttrModified",function(j){if(j.eventPhase===Event.BUBBLING_PHASE){return}var e=j.target,b=j.attrName;if(b==="viewBox"){e._cacheScreenCTM=null;var c=e.viewBox.baseVal;var i=j.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/);c.x=parseFloat(i[0]);c.y=parseFloat(i[1]);c.width=parseFloat(i[2]);c.height=parseFloat(i[3]);e.viewBox.baseVal._isUsed=1}else{if(b==="preserveAspectRatio"){e._cacheScreenCTM=null;var f=j.newValue,g=e.preserveAspectRatio.baseVal;var h=1,a=SVGPreserveAspectRatio.SVG_MEETORSLICE_UNKNOWN;if(!!f.match(/x(Min|Mid|Max)Y(Min|Mid|Max)(?:\s+(meet|slice))?/)){switch(RegExp.$1){case"Min":h+=1;break;case"Mid":h+=2;break;case"Max":h+=3;break}switch(RegExp.$2){case"Min":break;case"Mid":h+=3;break;case"Max":h+=6;break}if(RegExp.$3==="slice"){a=SVGPreserveAspectRatio.SVG_MEETORSLICE_SLICE}else{a=SVGPreserveAspectRatio.SVG_MEETORSLICE_MEET}}g.align=h;g.meetOrSlice=a}else{if(b==="width"){e.viewport.width=e.width.baseVal.value}else{if(b==="height"){e.viewport.height=e.height.baseVal.value}}}}j=b=null},false);this.addEventListener("SVGLoad",function(a){a.target.addEventListener("DOMAttrModified",function(e){if(e.eventPhase===Event.BUBBLING_PHASE){var c=e.target;if(c.parentNode){var b=c.ownerDocument.createEvent("MutationEvents");b.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);b.target=c;b.eventPhase=Event.AT_TARGET;var h=c._capter;for(var f=0,g=h.length;f<g;++f){if(h[f]){h[f].handleEvent(b)}}b=null}c=null}e=null},false);a=null},true);return this}SVGSVGElement.constructor=SVGElement;SVGSVGElement.prototype=new SVGElement();SVGSVGElement.prototype.forceRedraw=function(){};SVGSVGElement.prototype.getCurrentTime=function(){return(this._currentTime)};SVGSVGElement.prototype.setCurrentTime=function(a){this._currentTime=a};SVGSVGElement.prototype.createSVGNumber=function(){var a=new SVGNumber();a.value=0;return a};SVGSVGElement.prototype.createSVGLength=function(){var a=new SVGLength();a.unitType=1;return a};SVGSVGElement.prototype.createSVGPoint=function(){var a=new SVGPoint();return a};SVGSVGElement.prototype.createSVGMatrix=function(){var a=new SVGMatrix();return a};SVGSVGElement.prototype.createSVGRect=function(){var a=new SVGRect();return a};SVGSVGElement.prototype.createSVGTransform=function(){var a=this.createSVGTransformFromMatrix(this.createSVGMatrix());return a};SVGSVGElement.prototype.createSVGTransformFromMatrix=function(a){var b=new SVGTransform();b.setMatrix(a);return b};SVGSVGElement.prototype.getScreenCTM=function(){if(!!this._cacheScreenCTM){return(this._cacheScreenCTM)}var o=this.viewport.width,w=this.viewport.height;if(!this.useCurrentView){var t=this.viewBox.baseVal,k=this.preserveAspectRatio.baseVal}else{var t=this.currentView.viewBox.baseVal,k=this.currentView.preserveAspectRatio.baseVal}if(!!!t._isUsed){this._tx=this._ty=0;var q=this.createSVGMatrix();this._cacheScreenCTM=q;return q}else{var b=t.x,a=t.y,c=t.width,h=t.height;var f=o/c,l=w/h;var g=1,r=1,v=0,u=0;if(k.align===1){g=f;r=l;v=-b*g;u=-a*r}else{var j=(k.align+1)%3+1;var i=Math.round(k.align/3);switch(k.meetOrSlice){case 1:g=r=Math.min(f,l);break;case 2:g=r=Math.max(f,l);break}v=-b*g;u=-a*r;switch(j){case 1:break;case 2:v+=(o-c*g)/2;break;case 3:v+=o-c*g;break}switch(i){case 1:break;case 2:u+=(w-h*r)/2;break;case 3:u+=w-h*r;break}}}this._tx=v;this._ty=u;var e=this._tar.style;e.marginLeft=v+"px";e.marginTop=u+"px";var q=this.createSVGMatrix();q.a=g;q.d=r;this._cacheScreenCTM=q;return q};SVGZoomAndPan={SVG_ZOOMANDPAN_UNKNOWN:0,SVG_ZOOMANDPAN_DISABLE:1,SVG_ZOOMANDPAN_MAGNIFY:2};function SVGFitToViewBox(){this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();return this}function SVGViewSpec(a){SVGFitToViewBox.apply(this,arguments);this.transform=new SVGTransformList();this.viewTarget=a;this.viewBoxString="";this.preserveAspectRatioString="";this.transformString="";this.viewTargetString="";return this}SVGViewSpec.constructor=SVGFitToViewBox;SVGViewSpec.prototype=new SVGFitToViewBox();function SVGGElement(){SVGElement.apply(this);this._tar=document.createElement("v:group");this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===3){return}var e=a.nextSibling,f=a.parentNode,c=true;if(e&&e._tar&&f._tar&&(e._tar.parentNode===f._tar)){f._tar.insertBefore(a._tar,e._tar)}else{if(e&&!e._tar&&f._tar){while(e){if(e._tar&&(e._tar.parentNode===f._tar)){f._tar.insertBefore(a._tar,e._tar);c=false}e=e.nextSibling}if(c){f._tar.appendChild(a._tar)}}else{if(!e&&f._tar){f._tar.appendChild(a._tar)}}}e=f=c=null;a.addEventListener("DOMAttrModified",function(j){if(j.eventPhase===Event.BUBBLING_PHASE){return}var h=j.target;var o=h.getElementsByTagNameNS("http://www.w3.org/2000/svg","*");if(o){h._currentStyle=h._cacheMatrix=null;var g=h.ownerDocument.createEvent("MutationEvents");g.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);for(var l=0,k=o.length;l<k;++l){var q=o[l];q._currentStyle=q._cacheMatrix=null;q.dispatchEvent(g);q=null}g=null}j=h=o=null},false);b=a=null},false);return this}SVGGElement.constructor=SVGElement;SVGGElement.prototype=new SVGElement();function SVGDefsElement(){SVGElement.apply(this,arguments);this.style.setProperty("display","none");return this}SVGDefsElement.constructor=SVGElement;SVGDefsElement.prototype=new SVGElement();function SVGDescElement(){SVGElement.apply(this,arguments);return this}SVGDescElement.constructor=SVGElement;SVGDescElement.prototype=new SVGElement();function SVGTitleElement(){SVGElement.apply(this,arguments);this.addEventListener("DOMCharacterDataModified",function(a){a.target.ownerDocument.title=a.target.firstChild.nodeValue},false);return this}SVGTitleElement.constructor=SVGElement;SVGTitleElement.prototype=new SVGElement();function SVGSymbolElement(){SVGElement.apply(this,arguments);SVGURIReference.apply(this);return this}SVGDefsElement.constructor=SVGElement;SVGDefsElement.prototype=new SVGElement();function SVGUseElement(){SVGGElement.apply(this,arguments);this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.instanceRoot=new SVGElementInstance();this.animatedInstanceRoot=new SVGElementInstance();this.addEventListener("DOMNodeInserted",function(a){if(a.eventPhase===Event.BUBBLING_PHASE){return}a.target.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed")},false);this.addEventListener("SVGLoad",function(c){var b=c.target,f=b.ownerDocument.defaultView.getComputedStyle(b,"");var g=parseFloat(f.getPropertyValue("font-size"));b.x.baseVal._emToUnit(g);b.y.baseVal._emToUnit(g);b.width.baseVal._emToUnit(g);b.height.baseVal._emToUnit(g);b.instanceRoot=b.animatedInstanceRoot=b.ownerDocument.importNode(b._instance,true);var a=b.transform.baseVal;var e=b.ownerDocument.documentElement.createSVGTransform();e.setTranslate(b.x.baseVal.value,b.y.baseVal.value);a.appendItem(e);b.appendChild(b.instanceRoot);c=e=b=evtt=a=f=g=null},false);SVGURIReference.apply(this);return this}SVGUseElement.constructor=SVGElement;SVGUseElement.prototype=new SVGElement();function SVGElementInstance(){Node.apply(this,arguments);this.correspondingElement;this.correspondingUseElement;this.parentNode;this.childNodes;this.firstChild;this.lastChild;this.previousSibling;this.nextSibling;return this}SVGElementInstance.prototype=new Node();function SVGElementInstanceList(){this.length=0;return this}SVGElementInstanceList.prototype.item=function(a){return(this[a])};function SVGImageElement(){SVGElement.apply(this,arguments);this._tar=document.createElement("v:image");this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;a.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed");if(a.nextSibling){if(!!a.parentNode._tar&&!!a.nextSibling._tar){a.parentNode._tar.insertBefore(a._tar,a.nextSibling._tar)}}else{if(!!a.parentNode._tar){a.parentNode._tar.appendChild(a._tar)}}a.addEventListener("DOMNodeInsertedIntoDocument",function(k){var h=k.target,e=h.ownerDocument.defaultView.getComputedStyle(h,"");var l=parseFloat(e.getPropertyValue("font-size"));h.x.baseVal._emToUnit(l);h.y.baseVal._emToUnit(l);h.width.baseVal._emToUnit(l);h.height.baseVal._emToUnit(l);var i=h._tar.style;i.position="absolute";var g=h.getScreenCTM();var f=h.ownerDocument.documentElement.createSVGPoint();f.x=h.x.baseVal.value;f.y=h.y.baseVal.value;f=f.matrixTransform(g);i.left=f.x+"px";i.top=f.y+"px";i.width=h.width.baseVal.value*g.a+"px";i.height=h.height.baseVal.value*g.d+"px";var j=parseFloat(e.getPropertyValue("fill-opacity"));if(j!==1){i.filter="progid:DXImageTransform.Microsoft.Alpha";var c=h._tar.filters.item("DXImageTransform.Microsoft.Alpha");c.Style=0;c.Opacity=j*100}k=h=e=l=i=g=f=j=null},false);b=a=null},false);SVGURIReference.apply(this);return this}SVGImageElement.constructor=SVGElement;SVGImageElement.prototype=new SVGElement();function SVGSwitchElement(){SVGElement.apply(this,arguments);return this}SVGSwitchElement.constructor=SVGElement;SVGSwitchElement.prototype=new SVGElement();var sieb_s;function GetSVGDocument(a){this._tar=a;this._next=null;return this}GetSVGDocument.prototype={_init:function(){var c=NAIBU.xmlhttp,a=this._tar,b=this._ca;if(this._tar.nodeName==="OBJECT"){var e="data"}else{var e="src"}c.open("GET",a.getAttribute(e),true);a.style.display="none";c.setRequestHeader("X-Requested-With","XMLHttpRequest");this.xmlhttp=c;(function(g,f){f.onreadystatechange=function(){g._ca()}})(this,c);c.send(null)},_ca:function(){if((this.xmlhttp.readyState===4)&&(this.xmlhttp.status===200)){str=this.xmlhttp.responseText;NAIBU.doc.async=false;NAIBU.doc.validateOnParse=false;NAIBU.doc.resolveExternals=false;NAIBU.doc.preserveWhiteSpace=true;NAIBU.doc.loadXML(str);screen.updateInterval=999;var u=this._tar;if(/&[^;]+;/.test(str)){var L=str;var I=(NAIBU.doc.doctype)?NAIBU.doc.doctype.entities:{length:0};for(var T=0;T<I.length;T++){var A=I.item(T);var c=new RegExp("&"+A.nodeName+";","g");L=L.replace(c,A.firstChild.xml)}NAIBU.doc.loadXML(L);L=null}var J=DOMImplementation.createDocument("http://www.w3.org/2000/svg","svg");var G=J.documentElement,k=G.viewport;k.top=0;k.left=0;k.width=u.clientWidth;k.height=u.clientHeight;if(k.height<24){k.height=screen.availHeight}if(G.viewport.height<24){G.viewport.height=screen.width}var r=u.getAttribute("width"),v=u.getAttribute("height");if(r){G.setAttributeNS(null,"width",r)}if(v){G.setAttributeNS(null,"height",v)}var C=NAIBU.doc.documentElement.firstChild,O;var l=NAIBU.doc.documentElement.attributes,E;for(var T=0,a=l.length;T<a;++T){E=J.importNode(l[T],false);G.setAttributeNodeNS(E)}str=l=null;var N=G._tar,j=document.createElement("div"),Y=document.createElement("v:group");Y.style.width=k.width+"px";Y.style.height=k.height+"px";Y.coordsize=k.width+" "+k.height;j.appendChild(Y);u.parentNode.insertBefore(j,u);Y.appendChild(N);while(C){O=J.importNode(C,true);G.appendChild(O);C=C.nextSibling}C=null;var t=document.createElement("v:rect"),M=G.ownerDocument.defaultView.getComputedStyle(G,"");var o=parseFloat(M.getPropertyValue("font-size"));G.x.baseVal._emToUnit(o);G.y.baseVal._emToUnit(o);G.width.baseVal._emToUnit(o);G.height.baseVal._emToUnit(o);var H=k.width,U=k.height,f=G.width.baseVal.value,q=G.height.baseVal.value;t.style.position="absolute";t.style.width=H+"px";t.style.height=U+"px";t.style.zIndex=-1;t.stroked="false";t.filled="false";G._tar.appendChild(t);var aa=G._tar.style;var W=u.style;aa.visibility="visible";aa.position="absolute";aa.overflow="hidden";var R=t.currentStyle;var X=H>f?f:H,Z=U>q?q:U;var g=parseFloat(R.left),e=parseFloat(R.top);var S=-G._tx,K=-G._ty;if(g!==0&&!isNaN(g)){S=g;Y.style.left=-S+"px"}if(e!==0&&!isNaN(g)){K=e;Y.style.top=-K+"px"}var D=S+X+1;var V=K+Z+1;aa.clip="rect("+K+"px "+D+"px "+V+"px "+S+"px)";this._document=J;if("_svgload_limited" in J.documentElement){J.documentElement._svgload_limited--;if(J.documentElement._svgload_limited<0){var B=J.createEvent("SVGEvents");B.initEvent("SVGLoad",false,false);J.documentElement.dispatchEvent(B)}}var z=J.documentElement._tar.getElementsByTagName("div"),Q=parseFloat;for(var T=0,F=z.length;T<F;++T){var P=z[T];if(P.firstChild.nodeName!=="shape"){var b=P.style;b.left=Q(b.left)+S+"px";b.top=Q(b.top)+K+"px";b=null}}J.defaultView._cache=J.defaultView._cache_ele=null;B=u=G=k=r=v=O=E=N=j=Y=t=H=U=f=q=M=o=null;aa=W=R=X=Z=z=g=e=S=K=V=D=null;z=Q=null;this.xmlhttp.onreadystatechange=NAIBU.emptyFunction;if(this._next){J=null;this._next._init()}else{if(J.implementation._buffer_){screen.updateInterval=0;NAIBU._buff_num=0;NAIBU._buff=setInterval(function(){if(DOMImplementation._buffer_.length===0){clearInterval(Event._buff)}else{var ac=NAIBU._buff_num;for(var w=0;w<50;++w){var ab=DOMImplementation._buffer_[ac],h=DOMImplementation._buffer_[ac+1];ab.dispatchEvent(h);ac+=2;ab=h=null;if(ac>=DOMImplementation._buffer_.length){clearInterval(NAIBU._buff);DOMImplementation._buffer_=null;NAIBU.Time.start();return}}NAIBU._buff_num=ac;ac=null}},1);J=null}else{J=null;NAIBU.Time.start()}delete NAIBU.doc}}},getSVGDocument:function(){return(this._document)}};NAIBU.emptyFunction=function(){};function SVGStyleElement(){SVGElement.apply(this,arguments);this.xmlspace;this.type="text/css";this.media;this.title;return this}SVGStyleElement.constructor=SVGElement;SVGStyleElement.prototype=new SVGElement();function SVGPoint(){return this}SVGPoint.prototype.x=SVGPoint.prototype.y=0;SVGPoint.prototype.matrixTransform=function(b){var a=parseInt(b.a*this.x+b.c*this.y+b.e);var e=parseInt(b.b*this.x+b.d*this.y+b.f);if((-1<a)&&(a<1)){a=1}if((-1<e)&&(e<1)){e=1}var c=new SVGPoint();c.x=a;c.y=e;return c};function SVGPointList(){return this}for(var prop in SVGStringList.prototype){SVGPointList.prototype[prop]=SVGStringList.prototype[prop]}function SVGMatrix(){return this}SVGMatrix.prototype={a:1,b:0,c:0,d:1,e:0,f:0,multiply:function(b){var c=new SVGMatrix(),a=b;if(!isFinite(a.a)||!isFinite(a.b)||!isFinite(a.c)||!isFinite(a.d)||!isFinite(a.e)||!isFinite(a.f)){throw (new Error("引数の値がNumber型ではありません"))}c.a=this.a*a.a+this.c*a.b;c.b=this.b*a.a+this.d*a.b;c.c=this.a*a.c+this.c*a.d;c.d=this.b*a.c+this.d*a.d;c.e=this.a*a.e+this.c*a.f+this.e;c.f=this.b*a.e+this.d*a.f+this.f;a=b=null;return c},inverse:function(){var a=new SVGMatrix(),b=this._determinant();if(b!==0){a.a=this.d/b;a.b=-this.b/b;a.c=-this.c/b;a.d=this.a/b;a.e=(this.c*this.f-this.d*this.e)/b;a.f=(this.b*this.e-this.a*this.f)/b;return a}else{throw (new SVGException(SVGException.SVG_MATRIX_NOT_INVERTABLE))}},translate:function(b,e){var a=new SVGMatrix();a.e=b;a.f=e;var c=this.multiply(a);a=null;return c},scale:function(c){var a=new SVGMatrix();a.a=c;a.d=c;var b=this.multiply(a);a=null;return b},scaleNonUniform:function(b,e){var a=new SVGMatrix();a.a=b;a.d=e;var c=this.multiply(a);a=null;return c},rotate:function(e){var b=new SVGMatrix(),a=e/180*Math.PI;b.a=Math.cos(a);b.b=Math.sin(a);b.c=-b.b;b.d=b.a;var c=this.multiply(b);b=a=null;return c},rotateFromVector:function(c,f){if((c===0)||(f===0)||!isFinite(c)||!isFinite(f)){throw (new SVGException(SVGException.SVG_INVALID_VALUE_ERR))}var b=new SVGMatrix(),a=Math.atan2(f,c);b.a=Math.cos(a);b.b=Math.sin(a);b.c=-b.b;b.d=b.a;var e=this.multiply(b);b=a=null;return e},flipX:function(){var a=new SVGMatrix();a.a=-a.a;var b=this.multiply(a);a=null;return b},flipY:function(){var a=new SVGMatrix();a.d=-a.d;var b=this.multiply(a);a=null;return b},skewX:function(e){var b=new SVGMatrix(),a=e/180*Math.PI;b.c=Math.tan(a);var c=this.multiply(b);b=null;return c},skewY:function(e){var b=new SVGMatrix(),a=e/180*Math.PI;b.b=Math.tan(a);var c=this.multiply(b);b=null;return c},_determinant:function(){return(this.a*this.d-this.b*this.c)}};function SVGTransform(){this.matrix=new SVGMatrix();return this}SVGTransform.SVG_TRANSFORM_UNKNOWN=0;SVGTransform.SVG_TRANSFORM_MATRIX=1;SVGTransform.SVG_TRANSFORM_TRANSLATE=2;SVGTransform.SVG_TRANSFORM_SCALE=3;SVGTransform.SVG_TRANSFORM_ROTATE=4;SVGTransform.SVG_TRANSFORM_SKEWX=5;SVGTransform.SVG_TRANSFORM_SKEWY=6;SVGTransform.prototype={_matrix:(new SVGMatrix()),type:SVGTransform.SVG_TRANSFORM_UNKNOWN,angle:0,setMatrix:function(a){this.type=SVGTransform.SVG_TRANSFORM_MATRIX;this.matrix=this._matrix.multiply(a)},setTranslate:function(b,a){this.type=SVGTransform.SVG_TRANSFORM_TRANSLATE;this.matrix=this._matrix.translate(b,a)},setScale:function(b,a){this.type=SVGTransform.SVG_TRANSFORM_SCALE;this.matrix=this._matrix.scaleNonUniform(b,a)},setRotate:function(b,a,c){this.angle=b;this.type=SVGTransform.SVG_TRANSFORM_ROTATE;this.matrix=this._matrix.rotate(b);this.matrix.e=(1-this.matrix.a)*a-this.matrix.c*c;this.matrix.f=-this.matrix.b*a+(1-this.matrix.d)*c},setSkewX:function(a){this.angle=a;this.type=SVGTransform.SVG_TRANSFORM_SKEWX;this.matrix=this._matrix.skewX(a)},setSkewY:function(a){this.angle=a;this.type=SVGTransform.SVG_TRANSFORM_SKEWY;this.matrix=this._matrix.skewY(a)}};function SVGTransformList(){return this}for(var prop in SVGStringList.prototype){SVGTransformList.prototype[prop]=SVGStringList.prototype[prop]}SVGTransformList.prototype.createSVGTransformFromMatrix=function(a){var b=new SVGTransform();b.setMatrix(a);return b};SVGTransformList.prototype.consolidate=function(){if(this.numberOfItems===0){return null}else{var e=this.getItem(0),b=e.matrix;for(var c=1,a=this.numberOfItems;c<a;++c){b=b.multiply(this.getItem(c).matrix)}e.setMatrix(b);this.initialize(e);return e}};function SVGAnimatedTransformList(){this.animVal=this.baseVal=new SVGTransformList();return this}function SVGPreserveAspectRatio(){this.align=SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMID;this.meetOrSlice=SVGPreserveAspectRatio.SVG_MEETORSLICE_MEET;return this}SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_UNKNOWN=0;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_NONE=1;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMINYMIN=2;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMIN=3;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMAXYMIN=4;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMINYMID=5;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMID=6;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMAXYMID=7;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMINYMAX=8;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMAX=9;SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMAXYMAX=10;SVGPreserveAspectRatio.SVG_MEETORSLICE_UNKNOWN=0;SVGPreserveAspectRatio.SVG_MEETORSLICE_MEET=1;SVGPreserveAspectRatio.SVG_MEETORSLICE_SLICE=2;function SVGAnimatedPreserveAspectRatio(){this.animVal=this.baseVal=new SVGPreserveAspectRatio();return this}function SVGPathSeg(){this.pathSegType=SVGPathSeg.PATHSEG_UNKNOWN;this.pathSegTypeAsLetter=null;return this}SVGPathSeg.PATHSEG_UNKNOWN=0;SVGPathSeg.PATHSEG_CLOSEPATH=1;SVGPathSeg.PATHSEG_MOVETO_ABS=2;SVGPathSeg.PATHSEG_MOVETO_REL=3;SVGPathSeg.PATHSEG_LINETO_ABS=4;SVGPathSeg.PATHSEG_LINETO_REL=5;SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS=6;SVGPathSeg.PATHSEG_CURVETO_CUBIC_REL=7;SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_ABS=8;SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_REL=9;SVGPathSeg.PATHSEG_ARC_ABS=10;SVGPathSeg.PATHSEG_ARC_REL=11;SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_ABS=12;SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_REL=13;SVGPathSeg.PATHSEG_LINETO_VERTICAL_ABS=14;SVGPathSeg.PATHSEG_LINETO_VERTICAL_REL=15;SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_ABS=16;SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_REL=17;SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS=18;SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL=19;function SVGPathSegClosePath(){return this}SVGPathSegClosePath.prototype={pathSegType:SVGPathSeg.PATHSEG_CLOSEPATH,pathSegTypeAsLetter:"z"};function SVGPathSegMovetoAbs(){this.x;this.y;return this}SVGPathSegMovetoAbs.prototype={pathSegType:SVGPathSeg.PATHSEG_MOVETO_ABS,pathSegTypeAsLetter:"M"};function SVGPathSegMovetoRel(){this.x;this.y;return this}SVGPathSegMovetoRel.prototype={pathSegType:SVGPathSeg.PATHSEG_MOVETO_REL,pathSegTypeAsLetter:"m"};function SVGPathSegLinetoAbs(){this.x;this.y;return this}SVGPathSegLinetoAbs.prototype={pathSegType:SVGPathSeg.PATHSEG_LINETO_ABS,pathSegTypeAsLetter:"L"};function SVGPathSegLinetoRel(){this.x;this.y;return this}SVGPathSegLinetoRel.prototype={pathSegType:SVGPathSeg.PATHSEG_LINETO_REL,pathSegTypeAsLetter:"l"};function SVGPathSegCurvetoCubicAbs(){this.x;this.y;this.x1;this.y1;this.x2;this.y2;return this}SVGPathSegCurvetoCubicAbs.prototype={pathSegType:SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS,pathSegTypeAsLetter:"C"};function SVGPathSegCurvetoCubicRel(){this.x;this.y;this.x1;this.y1;this.x2;this.y2;return this}SVGPathSegCurvetoCubicRel.prototype={pathSegType:SVGPathSeg.PATHSEG_CURVETO_CUBIC_REL,pathSegTypeAsLetter:"c"};function SVGPathSegCurvetoQuadraticAbs(){this.x;this.y;this.x1;this.y1;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_ABS;this.pathSegTypeAsLetter="Q";return this}function SVGPathSegCurvetoQuadraticRel(){this.x;this.y;this.x1;this.y1;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_REL;this.pathSegTypeAsLetter="q";return this}function SVGPathSegArcAbs(){this.x;this.y;this.r1;this.r2;this.angle;return this}SVGPathSegArcAbs.prototype={largeArcFlag:true,sweepFlag:true,pathSegType:SVGPathSeg.PATHSEG_ARC_ABS,pathSegTypeAsLetter:"A"};function SVGPathSegArcRel(){this.x;this.y;this.r1;this.r2;this.angle;return this}SVGPathSegArcRel.prototype={largeArcFlag:true,sweepFlag:true,pathSegType:SVGPathSeg.PATHSEG_ARC_REL,pathSegTypeAsLetter:"a"};function SVGPathSegLinetoHorizontalAbs(){this.x;this.pathSegType=SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_ABS;this.pathSegTypeAsLetter="H";return this}function SVGPathSegLinetoHorizontalRel(){this.x;this.pathSegType=SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_REL;this.pathSegTypeAsLetter="h";return this}function SVGPathSegLinetoVerticalAbs(){this.y;this.pathSegType=SVGPathSeg.PATHSEG_LINETO_VERTICAL_ABS;this.pathSegTypeAsLetter="V";return this}function SVGPathSegLinetoVerticalRel(){this.y;this.pathSegType=SVGPathSeg.PATHSEG_LINETO_VERTICAL_REL;this.pathSegTypeAsLetter="v";return this}function SVGPathSegCurvetoCubicSmoothAbs(){this.x;this.y;this.x2;this.y2;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_ABS;this.pathSegTypeAsLetter="S";return this}function SVGPathSegCurvetoCubicSmoothRel(){this.x;this.y;this.x2;this.y2;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_REL;this.pathSegTypeAsLetter="s";return this}function SVGPathSegCurvetoQuadraticSmoothAbs(){this.x;this.y;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS;this.pathSegTypeAsLetter="T";return this}function SVGPathSegCurvetoQuadraticSmoothRel(){this.x;this.y;this.pathSegType=SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL;this.pathSegTypeAsLetter="t";return this}function SVGPathSegList(){return this}for(var prop in SVGStringList.prototype){SVGPathSegList.prototype[prop]=SVGStringList.prototype[prop]}(function(e,a,c){NAIBU._setPaint=function(O,M){var R=O.ownerDocument,f=O._tar;if(!f){return}var Q=R.defaultView.getComputedStyle(O,"");var K=Q.getPropertyCSSValue("fill"),v=Q.getPropertyCSSValue("stroke");if(K.paintType===1||K.paintType===102){if(K.paintType===102){Q.setProperty("color",Q.getPropertyValue("color"))}if(!!O._fillElement){var H=O._fillElement;var B=f.getElementsByTagName("fill");if(B.length>0){f.removeChild(B[0])}B=null}else{var H=e.createElement("v:fill")}var F=K.rgbColor,z=1;H.setAttribute("color","rgb("+F.red.getFloatValue(z)+","+F.green.getFloatValue(z)+","+F.blue.getFloatValue(z)+")");var L=+(Q.getPropertyValue("fill-opacity"))*Q._list._opacity;if(L<1){H.setAttribute("opacity",L+"")}if(!!!O._fillElement){f.appendChild(H);O._fillElement=H}else{f.appendChild(H)}H=F=z=L=null}else{if(K.uri){var C=R.getElementById(K.uri);if(C){var u=R.createEvent("MutationEvents");u.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);u._tar=!!O._fillElement?O._fillElement:e.createElement("v:fill");u._style=Q,u._ttar=O;C.dispatchEvent(u);if(C.localName!=="radialGradient"&&!!!O._fillElement){f.appendChild(u._tar);O._fillElement=u._tar}C=u=null}}else{f.filled="false"}}if(v.paintType===1||v.paintType===102){if(v.paintType===102){Q.setProperty("color",Q.getPropertyValue("color"))}if(!!O._strokeElement){var g=O._strokeElement;var q=f.getElementsByTagName("stroke");if(q.length>0){f.removeChild(q[0])}q=null}else{var g=e.createElement("v:stroke")}var I=Q.getPropertyCSSValue("stroke-width"),A=R.documentElement.viewport.width,P=R.documentElement.viewport.height;I._percent=c.sqrt((A*A+P*P)/2);var E=I.getFloatValue(CSSPrimitiveValue.CSS_NUMBER)*c.sqrt(c.abs(M._determinant()));g.setAttribute("weight",E+"px");I=A=P=null;if(!v.uri){var F=v.rgbColor,z=1;g.setAttribute("color","rgb("+F.red.getFloatValue(z)+","+F.green.getFloatValue(z)+","+F.blue.getFloatValue(z)+")");var l=+(Q.getPropertyValue("stroke-opacity"))*(+(Q.getPropertyValue("opacity")));if(E<1){l*=E}if(l<1){g.setAttribute("opacity",l+"")}F=z=l=null}g.setAttribute("miterlimit",Q.getPropertyValue("stroke-miterlimit"));g.setAttribute("joinstyle",Q.getPropertyValue("stroke-linejoin"));if(Q.getPropertyValue("stroke-linecap")==="butt"){g.setAttribute("endcap","flat")}else{g.setAttribute("endcap",Q.getPropertyValue("stroke-linecap"))}var k=Q.getPropertyValue("stroke-dasharray");if(k!=="none"){if(k.indexOf(",")>0){var G=k.split(",");for(var N=0,j=G.length;N<j;++N){G[N]=c.ceil(+(G[N])/parseFloat(Q.getPropertyValue("stroke-width")))}var r=G.join(" ");if(G.length%2===1){r+=" "+r}}g.setAttribute("dashstyle",r);k=G=null}if(!!!O._strokeElement){f.appendChild(g);O._strokeElement=g}else{f.appendChild(g)}g=k=null}else{f.stroked="false"}var o=Q.getPropertyValue("cursor");if(o!=="auto"&&o!==""){f.style.cursor=o}var D=Q.getPropertyValue("visibility");if(D!=="visiblee"){f.style.visibility=D}var J=Q.getPropertyValue("display");if(J==="none"){f.style.display="none"}else{if(J!=="inline-block"){f.style.display="inline-block"}}R=f=K=v=Q=o=O=M=D=J=null};function b(){SVGElement.apply(this);this._tar=e.createElement("v:shape");this.pathSegList=new SVGPathSegList();this.animatedPathSegList=this.pathSegList;this.normalizedPathSegList=new SVGPathSegList();this.animatedNormalizedPathSegList=this.normalizedPathSegList;this.pathLength=new SVGAnimatedNumber();this.addEventListener("DOMAttrModified",function(I){var N=I.target;if(I.attrName==="d"&&I.newValue!==""){var B=N.normalizedPathSegList,C=N.pathSegList,H=[];if(B.numberOfItems>0){B.clear();C.clear()}var w=N._com,t=w.isSp;var V=I.newValue.replace(w.isRa," -").replace(w.isRb," ").replace(w.isRc,",$1 ").replace(w.isRd,",$1 1").replace(w.isRe,"").split(",");for(var O=0,U=V.length;O<U;++O){H[O]=V[O].match(t);for(var M=1,F=H[O].length;M<F;++M){H[O][M]=+(H[O][M])}}t=V=null;var A=w._isZ,J=w._isM,R=w._isC,K=w._isL;for(var O=0,q=H.length;O<q;++O){var Q=H[O],G;for(var M=1,S=Q[0],F=Q.length;M<F;++M){if(J[S]){G=N.createSVGPathSegMovetoAbs(Q[M],Q[M+1]);++M}else{if(S==="m"){G=N.createSVGPathSegMovetoRel(Q[M],Q[M+1]);++M}else{if(K[S]){G=N.createSVGPathSegLinetoAbs(Q[M],Q[M+1]);++M}else{if(S==="l"){G=N.createSVGPathSegLinetoRel(Q[M],Q[M+1]);++M}else{if(R[S]){G=N.createSVGPathSegCurvetoCubicAbs(Q[M+4],Q[M+5],Q[M],Q[M+1],Q[M+2],Q[M+3]);M+=5}else{if(S==="c"){G=N.createSVGPathSegCurvetoCubicRel(Q[M+4],Q[M+5],Q[M],Q[M+1],Q[M+2],Q[M+3]);M+=5}else{if(S==="Q"){G=N.createSVGPathSegCurvetoQuadraticAbs(Q[M+2],Q[M+3],Q[M],Q[M+1]);M+=3}else{if(S==="q"){G=N.createSVGPathSegCurvetoQuadraticRel(Q[M+2],Q[M+3],Q[M],Q[M+1]);M+=3}else{if(S==="A"){G=N.createSVGPathSegArcAbs(Q[M+5],Q[M+6],Q[M],Q[M+1],Q[M+2],Q[M+3],Q[M+4]);M+=6}else{if(S==="a"){G=N.createSVGPathSegArcRel(Q[M+5],Q[M+6],Q[M],Q[M+1],Q[M+2],Q[M+3],Q[M+4]);M+=6}else{if(A[S]){G=N.createSVGPathSegClosePath()}else{if(S==="S"){G=N.createSVGPathSegCurvetoCubicSmoothAbs(Q[M+2],Q[M+3],Q[M],Q[M+1]);M+=3}else{if(S==="s"){G=N.createSVGPathSegCurvetoCubicSmoothRel(Q[M+2],Q[M+3],Q[M],Q[M+1]);M+=3}else{if(S==="T"){G=N.createSVGPathSegCurvetoQuadraticSmoothAbs(Q[M],Q[M+1]);++M}else{if(S==="t"){G=N.createSVGPathSegCurvetoQuadraticSmoothRel(Q[M],Q[M+1]);++M}else{if(S==="H"){G=N.createSVGPathSegLinetoHorizontalAbs(Q[M])}else{if(S==="h"){G=N.createSVGPathSegLinetoHorizontalRel(Q[M])}else{if(S==="V"){G=N.createSVGPathSegLinetoVerticalAbs(Q[M])}else{if(S==="v"){G=N.createSVGPathSegLinetoVerticalRel(Q[M])}else{G=new SVGPathSeg()}}}}}}}}}}}}}}}}}}}C.appendItem(G)}}H=null;var o=0,h=0;var E=0,T=0;var l=0,g=0;for(var M=0,L=C.numberOfItems;M<L;++M){var v=C.getItem(M),f=v.pathSegType,S=v.pathSegTypeAsLetter;if(f===SVGPathSeg.PATHSEG_UNKNOWN){}else{var u=o,r=h;if(f%2===1){o+=v.x;h+=v.y}else{o=v.x;h=v.y}if(J[S]){if(M!==0){var z=C.getItem(M-1);if(z.pathSegTypeAsLetter==="M"){B.appendItem(N.createSVGPathSegLinetoAbs(o,h));continue}}l=o;g=h;B.appendItem(v)}else{if(S==="m"){if(M!==0){var z=C.getItem(M-1);if(z.pathSegTypeAsLetter==="m"){B.appendItem(N.createSVGPathSegLinetoAbs(o,h));continue}}l=o;g=h;B.appendItem(N.createSVGPathSegMovetoAbs(o,h))}else{if(K[S]){B.appendItem(v)}else{if(S==="l"){B.appendItem(N.createSVGPathSegLinetoAbs(o,h))}else{if(R[S]){B.appendItem(v)}else{if(S==="c"){B.appendItem(N.createSVGPathSegCurvetoCubicAbs(o,h,v.x1+u,v.y1+r,v.x2+u,v.y2+r))}else{if(A[S]){o=l;h=g;B.appendItem(v)}else{if(S==="Q"){E=2*o-v.x1;T=2*h-v.y1;B.appendItem(N.createSVGPathSegCurvetoCubicAbs(o,h,(u+2*v.x1)/3,(r+2*v.y1)/3,(2*v.x1+o)/3,(2*v.y1+h)/3))}else{if(S==="q"){var P=v.x1+u,k=v.y1+r;E=2*o-P;T=2*h-k;B.appendItem(N.createSVGPathSegCurvetoCubicAbs(o,h,(u+2*P)/3,(r+2*k)/3,(2*P+o)/3,(2*k+h)/3));P=k=null}else{if(S==="A"||S==="a"){(function(X,at,ar,aw,au,aC,av){var aH=X.sweepFlag,aL=X.angle;if(X.r1===0||X.r2===0){return}var ak=c.abs(X.r1);var aj=c.abs(X.r2);var aq=(aw-at)/2,ap=(au-ar)/2;var W=c.cos(aL*c.PI/180),az=c.sin(aL*c.PI/180);var ay=W*aq+az*ap,ai=-1*az*aq+W*ap;var ah=ay*ay,ac=ai*ai;var ax=ak*ak,af=aj*aj;var aP=ah/ax+ac/af;var aI;if(aP>1){ak=c.sqrt(aP)*ak;aj=c.sqrt(aP)*aj;aI=0}else{var ae=1;if(X.largeArcFlag===aH){ae=-1}aI=ae*c.sqrt((ax*af-ax*ac-af*ah)/(ax*ac+af*ah))}var an=aI*ak*ai/aj,D=-1*aI*aj*ay/ak;var aK=W*an-az*D+(aw+at)/2,aJ=az*an+W*D+(au+ar)/2;var Z=c.atan2((ai-D)/aj,(ay-an)/ak)-c.atan2(0,1);var aM=(Z>=0)?Z:2*c.PI+Z;Z=c.atan2((-ai-D)/aj,(-ay-an)/ak)-c.atan2((ai-D)/aj,(ay-an)/ak);var ad=(Z>=0)?Z:2*c.PI+Z;if(!aH&&ad>0){ad-=2*c.PI}else{if(aH&&ad<0){ad+=2*c.PI}}var aa=ad*2/c.PI;var aA=c.ceil(aa<0?-1*aa:aa);var aB=ad/aA;var aF=8/3*c.sin(aB/4)*c.sin(aB/4)/c.sin(aB/2);var aE=W*ak,aD=W*aj;var j=az*ak,i=az*aj;var ao=c.cos(aM);var ag=c.sin(aM);var am=aw-aF*(aE*ag+i*ao),aO=au-aF*(j*ag-aD*ao);for(var aG=0;aG<aA;++aG){aM+=aB;ao=c.cos(aM);ag=c.sin(aM);var al=aE*ao-i*ag+aK,aN=j*ao+aD*ag+aJ;var ab=-aF*(aE*ag+i*ao),Y=-aF*(j*ag-aD*ao);av.appendItem(aC.createSVGPathSegCurvetoCubicAbs(al,aN,am,aO,al-ab,aN-Y));am=al+ab;aO=aN+Y}})(v,o,h,u,r,N,B)}else{if(S==="S"){if(M!==0){var z=B.getItem(B.numberOfItems-1);if(z.pathSegTypeAsLetter==="C"){var P=2*z.x-z.x2;var k=2*z.y-z.y2}else{var P=u,k=r}}else{var P=u,k=r}B.appendItem(N.createSVGPathSegCurvetoCubicAbs(o,h,P,k,v.x2,v.y2));P=k=null}else{if(S==="s"){if(M!==0){var z=B.getItem(B.numberOfItems-1);if(z.pathSegTypeAsLetter==="C"){var P=2*z.x-z.x2;var k=2*z.y-z.y2}else{var P=u,k=r}}else{var P=u,k=r}B.appendItem(N.createSVGPathSegCurvetoCubicAbs(o,h,P,k,v.x2+u,v.y2+r));P=k=null}else{if(S==="T"||S==="t"){if(M!==0){var z=C.getItem(M-1);if("QqTt".indexOf(z.pathSegTypeAsLetter)>-1){}else{E=u,T=r}}else{E=u,T=r}B.appendItem(N.createSVGPathSegCurvetoCubicAbs(o,h,(u+2*E)/3,(r+2*T)/3,(2*E+o)/3,(2*T+h)/3));E=2*o-E;T=2*h-T;xx1=yy1=null}else{if(S==="H"||S==="h"){B.appendItem(N.createSVGPathSegLinetoAbs(o,r));h=r}else{if(S==="V"||S==="v"){B.appendItem(N.createSVGPathSegLinetoAbs(u,h));o=u}}}}}}}}}}}}}}}}v=S=f=null}w=o=h=E=T=l=g=null}I=null},false);this.addEventListener("DOMNodeInserted",function(g){var f=g.target;if(g.eventPhase===3){return}var i=f.nextSibling,j=f.parentNode,h=true;if(i&&i._tar&&j._tar&&(i._tar.parentNode===j._tar)){j._tar.insertBefore(f._tar,i._tar)}else{if(i&&!i._tar&&j._tar){while(i){if(i._tar&&(i._tar.parentNode===j._tar)){j._tar.insertBefore(f._tar,i._tar);h=false}i=i.nextSibling}if(h){j._tar.appendChild(f._tar)}}else{if(!i&&j._tar){j._tar.appendChild(f._tar)}}}i=j=h=null;f.addEventListener("DOMNodeInsertedIntoDocument",function(A){var E=A.target,D=E.getScreenCTM(),u=E.normalizedPathSegList,C=a;var J=[],l=D.a,k=D.b,O=D.c,N=D.d,M=D.e,L=D.f;var o=E._com._nameCom,r=E._com._isZ,H=E._com._isC;for(var F=0,B=u.numberOfItems;F<B;++F){var q=u[F],I=q.pathSegTypeAsLetter;var z=o[I];if(H[I]){z+=([C(l*q.x1+O*q.y1+M,10),C(k*q.x1+N*q.y1+L,10),C(l*q.x2+O*q.y2+M,10),C(k*q.x2+N*q.y2+L,10),C(l*q.x+O*q.y+M,10),C(k*q.x+N*q.y+L,10)]).join(" ")}else{if(!r[I]){z+=C(l*q.x+O*q.y+M,10)+" "+C(k*q.x+N*q.y+L,10)}}J[F]=z}var K=E.ownerDocument.documentElement;var v=K.width.baseVal.value,G=K.height.baseVal.value;J[J.length]=" e";E._tar.path=J.join(" ");E._tar.coordsize=v+" "+G;NAIBU._setPaint(E,D);delete E._cacheMatrix,E._currentStyle;A=E=J=z=v=G=D=u=x=y=C=l=k=O=N=M=L=K=r=H=F=B=I=q=o=null},false);g=f=null},false);return this}b.constructor=SVGElement;b.prototype=new SVGElement();b.prototype._com={_nameCom:{z:" x ",Z:" x ",C:"c",L:"l",M:"m"},_isZ:{z:1,Z:1},_isC:{C:1},_isL:{L:1},_isM:{M:1},isRa:/\-/g,isRb:/,/g,isRc:/([a-yA-Y])/g,isRd:/([zZ])/g,isRe:/,/,isSp:/\S+/g};b.prototype.getTotalLength=function(){var l=0,h=this.normalizedPathSegList;for(var k=1,o=h.numberOfItems,j=null;k<o;++k){var g=h.getItem(k);if(g.pathSegType===SVGPathSeg.PATHSEG_LINETO_ABS){var q=h.getItem(k-1);l+=c.sqrt(c.pow((g.x-q.x),2)+c.pow((g.y-q.y),2))}else{if(g.pathSegType===SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS){var q=h.getItem(k-1),f=0;f+=c.sqrt(c.pow((g.x1-q.x),2)+c.pow((g.y1-q.y),2));f+=c.sqrt(c.pow((g.x2-g.x1),2)+c.pow((g.y2-g.y1),2));f+=c.sqrt(c.pow((g.x2-g.x1),2)+c.pow((g.y2-g.y1),2));f+=c.sqrt(c.pow((g.x-q.x),2)+c.pow((g.y-q.y),2));l+=f/2}else{if(g.pathSegType===SVGPathSeg.PATHSEG_CLOSEPATH){var q=h.getItem(k-1),j=h.getItem(0);l+=c.sqrt(c.pow((q.x-j.x),2)+c.pow((q.y-j.y),2))}}}}this.pathLength.baseVal=l;return l};b.prototype.getPointAtLength=function(i){var j=this.getPathSegAtLength(i),q=0,o=0,g=this.normalizedPathSegList,k=g.getItem(j);var v=this.ownerDocument.documentElement.createSVGPoint();if((j-1)<=0){v.x=k.x;v.y=k.y;return v}var f=g.getItem(j-1);if(k.pathSegType===SVGPathSeg.PATHSEG_LINETO_ABS){var l=c.sqrt(c.pow((k.x-f.x),2)+c.pow((k.y-f.y),2));var u=(l+this._dis)/l;v.x=f.x+u*(k.x-f.x);v.y=f.y+u*(k.y-f.y)}else{if(k.pathSegType===SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS){var r=0;r+=c.sqrt(c.pow((k.x1-f.x),2)+c.pow((k.y1-f.y),2));r+=c.sqrt(c.pow((k.x2-k.x1),2)+c.pow((k.y2-k.y1),2));r+=c.sqrt(c.pow((k.x2-k.x1),2)+c.pow((k.y2-k.y1),2));r+=c.sqrt(c.pow((k.x-f.x),2)+c.pow((k.y-f.y),2));var l=r/2;var u=(l+this._dis)/l;v.x=(3*k.x1+k.x-3*k.x2-f.x)*c.pow(u,3)+3*(f.x-2*k.x1+k.x2)*c.pow(u,2)+3*(k.x1-f.x)*u+f.x;v.y=(3*k.y1+k.y-3*k.y2-f.y)*c.pow(u,3)+3*(f.y-2*k.y1+k.y2)*c.pow(u,2)+3*(k.y1-f.y)*u+f.y}else{if(k.pathSegType===SVGPathSeg.MOVETO_ABS){v.x=k.x;v.y=k.y}else{if(k.pathSegType===SVGPathSeg.PATHSEG_CLOSEPATH){var h=g.getItem(0),l=c.sqrt(c.pow((k.x-mx.x),2)+c.pow((k.y-h.y),2));var u=(l+this._dis)/l;v.x=h.x+u*(k.x-h.x);v.y=h.y+u*(k.y-h.y)}}}}return v};b.prototype.getPathSegAtLength=function(q){var h=this.normalizedPathSegList;for(var k=0,l=h.numberOfItems,j=null;k<l;++k){var g=h.getItem(k);if(g.pathSegType===SVGPathSeg.PATHSEG_LINETO_ABS){var o=h.getItem(k-1);q-=c.sqrt(c.pow((g.x-o.x),2)+c.pow((g.y-o.y),2))}else{if(g.pathSegType===SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS){var o=h.getItem(k-1),f=0;f+=c.sqrt(c.pow((g.x1-o.x),2)+c.pow((g.y1-o.y),2));f+=c.sqrt(c.pow((g.x2-g.x1),2)+c.pow((g.y2-g.y1),2));f+=c.sqrt(c.pow((g.x2-g.x1),2)+c.pow((g.y2-g.y1),2));f+=c.sqrt(c.pow((g.x-o.x),2)+c.pow((g.y-o.y),2));q-=f/2;f=null}else{if(g.pathSegType===SVGPathSeg.PATHSEG_CLOSEPATH){var o=h.getItem(k-1),j=h.getItem(0);q-=c.sqrt(c.pow((o.x-j.x),2)+c.pow((o.y-j.y),2))}}}if(q<=0){this._dis=q;q=null;return k}}return(h.numberOfItems-1)};b.prototype.createSVGPathSegClosePath=function(){var f=SVGPathSegClosePath;return(new f())};b.prototype.createSVGPathSegMovetoAbs=function(f,i){var h=SVGPathSegMovetoAbs,g=new h();g.x=f;g.y=i;return g};b.prototype.createSVGPathSegMovetoRel=function(f,h){var g=new SVGPathSegMovetoRel();g.x=f;g.y=h;return g};b.prototype.createSVGPathSegLinetoAbs=function(f,h){var g=new SVGPathSegLinetoAbs();g.x=f;g.y=h;return g};b.prototype.createSVGPathSegLinetoRel=function(f,h){var g=new SVGPathSegLinetoRel();g.x=f;g.y=h;return g};b.prototype.createSVGPathSegCurvetoCubicAbs=function(g,o,i,l,h,j){var f=SVGPathSegCurvetoCubicAbs,k=new f();k.x=g;k.y=o;k.x1=i;k.y1=l;k.x2=h;k.y2=j;return k};b.prototype.createSVGPathSegCurvetoCubicRel=function(f,l,h,k,g,i){var j=new SVGPathSegCurvetoCubicRel();j.x=f;j.y=l;j.x1=h;j.y1=k;j.x2=g;j.y2=i;return j};b.prototype.createSVGPathSegCurvetoQuadraticAbs=function(f,j,g,i){var h=new SVGPathSegCurvetoQuadraticAbs();h.x=f;h.y=j;h.x1=g;h.y1=i;return h};b.prototype.createSVGPathSegCurvetoQuadraticRel=function(f,j,g,i){var h=new SVGPathSegCurvetoQuadraticRel();h.x=f;h.y=j;h.x1=g;h.y1=i;return h};b.prototype.createSVGPathSegArcAbs=function(f,o,h,g,l,k,j){var i=new SVGPathSegArcAbs();i.x=f;i.y=o;i.r1=h;i.r2=g;i.angle=l;i.largeArcFlag=k;i.sweepFlag=j;return i};b.prototype.createSVGPathSegArcRel=function(f,o,h,g,l,k,j){var i=new SVGPathSegArcRel();i.x=f;i.y=o;i.r1=h;i.r2=g;i.angle=l;i.largeArcFlag=k;i.sweepFlag=j;return i};b.prototype.createSVGPathSegLinetoHorizontalAbs=function(f){var g=new SVGPathSegLinetoHorizontalAbs();g.x=f;g.y=0;return g};b.prototype.createSVGPathSegLinetoHorizontalRel=function(f){var g=new SVGPathSegLinetoHorizontalRel();g.x=f;g.y=0;return g};b.prototype.createSVGPathSegLinetoVerticalAbs=function(g){var f=new SVGPathSegLinetoVerticalAbs();f.x=0;f.y=g;return f};b.prototype.createSVGPathSegLinetoVerticalRel=function(g){var f=new SVGPathSegLinetoVerticalRel();f.x=0;f.y=g;return f};b.prototype.createSVGPathSegCurvetoCubicSmoothAbs=function(f,j,g,h){var i=new SVGPathSegCurvetoCubicSmoothAbs();i.x=f;i.y=j;i.x2=g;i.y2=h;return i};b.prototype.createSVGPathSegCurvetoCubicSmoothRel=function(f,j,g,h){var i=new SVGPathSegCurvetoCubicSmoothRel();i.x=f;i.y=j;i.x2=g;i.y2=h;return i};b.prototype.createSVGPathSegCurvetoQuadraticSmoothAbs=function(f,h){var g=new SVGPathSegCurvetoQuadraticSmoothAbs();g.x=f;g.y=h;return g};b.prototype.createSVGPathSegCurvetoQuadraticSmoothRel=function(f,h){var g=new SVGPathSegCurvetoQuadraticSmoothRel();g.x=f;g.y=h;return g};NAIBU.SVGPathElement=b})(document,parseInt,Math);function SVGRectElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.rx=new SVGAnimatedLength();this.ry=new SVGAnimatedLength();this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===3){return}var e=a.nextSibling,f=a.parentNode,c=true;if(e&&e._tar&&f._tar&&(e._tar.parentNode===f._tar)){f._tar.insertBefore(a._tar,e._tar)}else{if(e&&!e._tar&&f._tar){while(e){if(e._tar&&(e._tar.parentNode===f._tar)){f._tar.insertBefore(a._tar,e._tar);c=false}e=e.nextSibling}if(c){f._tar.appendChild(a._tar)}}else{if(!e&&f._tar){f._tar.appendChild(a._tar)}}}e=f=c=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(E){var K=E.target,M=K.ownerDocument.defaultView.getComputedStyle(K,"");var l=parseFloat(M.getPropertyValue("font-size"));K.x.baseVal._emToUnit(l);K.y.baseVal._emToUnit(l);K.width.baseVal._emToUnit(l);K.height.baseVal._emToUnit(l);var q=K.getAttributeNS(null,"rx"),o=K.getAttributeNS(null,"ry");var A=K.x.baseVal.value,z=K.y.baseVal.value,u=A+K.width.baseVal.value,W=z+K.height.baseVal.value;var N;if((q||o)&&(q!=="0")&&(o!=="0")){K.rx.baseVal._emToUnit(l);K.ry.baseVal._emToUnit(l);var j=K.rx.baseVal,g=K.ry.baseVal;j.value=q?j.value:g.value;g.value=o?g.value:j.value;var S=K.width.baseVal.value,k=K.height.baseVal.value;if(j.value>S/2){j.value=S/2}if(g.value>k/2){g.value=k/2}var v=j.value,I=g.value;var t=v*0.55228,r=I*0.55228;var V=u-v,R=A+v,Q=z+I,P=W-I;N=["m",R,z,"l",V,z,"c",V+t,z,u,Q-r,u,Q,"l",u,P,"c",u,P+r,V+t,W,V,W,"l",R,W,"c",R-t,W,A,P+r,A,P,"l",A,Q,"c",A,Q-r,R-t,z,R,z]}else{N=["m",A,z,"l",A,W,u,W,u,z,"x e"]}var D=K.ownerDocument.documentElement,U=K.getScreenCTM();for(var J=0,H=N.length;J<H;){if(isNaN(N[J])){++J;continue}var G=D.createSVGPoint();G.x=N[J];G.y=N[J+1];var F=G.matrixTransform(U);N[J]=F.x;++J;N[J]=F.y;++J;G=F=null}var O=N.join(" ");var C=K._tar,T=K.ownerDocument.documentElement;var B=T.width.baseVal.value,L=T.height.baseVal.value;C.path=O;C.coordsize=B+" "+L;NAIBU._setPaint(K,U);delete K._cacheMatrix,K._currentStyle;E=K=M=N=O=C=T=l=null},false);b=a=null},false);return this}SVGRectElement.constructor=SVGElement;SVGRectElement.prototype=new SVGElement();function SVGCircleElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.cx=new SVGAnimatedLength();this.cy=new SVGAnimatedLength();this.r=new SVGAnimatedLength();this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===3){return}var e=a.nextSibling,f=a.parentNode,c=true;if(e&&e._tar&&f._tar&&(e._tar.parentNode===f._tar)){f._tar.insertBefore(a._tar,e._tar)}else{if(e&&!e._tar&&f._tar){while(e){if(e._tar&&(e._tar.parentNode===f._tar)){f._tar.insertBefore(a._tar,e._tar);c=false}e=e.nextSibling}if(c){f._tar.appendChild(a._tar)}}else{if(!e&&f._tar){f._tar.appendChild(a._tar)}}}e=f=c=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(A){var F=A.target,I=F.ownerDocument.defaultView.getComputedStyle(F,"");var j=parseFloat(I.getPropertyValue("font-size"));F.cx.baseVal._emToUnit(j);F.cy.baseVal._emToUnit(j);F.r.baseVal._emToUnit(j);var k=F.cx.baseVal.value,g=F.cy.baseVal.value,o=ry=F.r.baseVal.value;var B=g-ry,l=k-o,t=g+ry,L=k+o;var r=o*0.55228,q=ry*0.55228;var J=["m",k,B,"c",k-r,B,l,g-q,l,g,l,g+q,k-r,t,k,t,k+r,t,L,g+q,L,g,L,g-q,k+r,B,k,B,"x e"];var z=F.ownerDocument.documentElement,N=F.getScreenCTM();for(var G=0,E=J.length;G<E;){if(isNaN(J[G])){++G;continue}var D=z.createSVGPoint();D.x=J[G];D.y=J[G+1];var C=D.matrixTransform(N);J[G]=C.x;++G;J[G]=C.y;++G;D=C=null}var K=J.join(" ");var v=F._tar,M=F.ownerDocument.documentElement;var u=M.width.baseVal.value,H=M.height.baseVal.value;v.path=K;v.coordsize=u+" "+H;NAIBU._setPaint(F,N);delete F._cacheMatrix,F._currentStyle;A=F=J=I=j=K=v=null},false);b=a=null},false);return this}SVGCircleElement.constructor=SVGElement;SVGCircleElement.prototype=new SVGElement();function SVGEllipseElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.cx=new SVGAnimatedLength();this.cy=new SVGAnimatedLength();this.rx=new SVGAnimatedLength();this.ry=new SVGAnimatedLength();this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===3){return}var e=a.nextSibling,f=a.parentNode,c=true;if(e&&e._tar&&f._tar&&(e._tar.parentNode===f._tar)){f._tar.insertBefore(a._tar,e._tar)}else{if(e&&!e._tar&&f._tar){while(e){if(e._tar&&(e._tar.parentNode===f._tar)){f._tar.insertBefore(a._tar,e._tar);c=false}e=e.nextSibling}if(c){f._tar.appendChild(a._tar)}}else{if(!e&&f._tar){f._tar.appendChild(a._tar)}}}e=f=c=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(B){var H=B.target,J=H.ownerDocument.defaultView.getComputedStyle(H,"");var j=parseFloat(J.getPropertyValue("font-size"));H.cx.baseVal._emToUnit(j);H.cy.baseVal._emToUnit(j);H.rx.baseVal._emToUnit(j);H.ry.baseVal._emToUnit(j);var k=H.cx.baseVal.value,g=H.cy.baseVal.value,q=H.rx.baseVal.value,o=H.ry.baseVal.value;var C=g-o,l=k-q,u=g+o,M=k+q;var t=q*0.55228,r=o*0.55228;var K=["m",k,C,"c",k-t,C,l,g-r,l,g,l,g+r,k-t,u,k,u,k+t,u,M,g+r,M,g,M,g-r,k+t,C,k,C,"x e"];var A=H.ownerDocument.documentElement,O=H.getScreenCTM();for(var G=0,F=K.length;G<F;){if(isNaN(K[G])){++G;continue}var E=A.createSVGPoint();E.x=K[G];E.y=K[G+1];var D=E.matrixTransform(O);K[G]=D.x;++G;K[G]=D.y;++G;E=D=null}var L=K.join(" ");var z=H._tar,N=H.ownerDocument.documentElement;var v=N.width.baseVal.value,I=N.height.baseVal.value;z.path=L;z.coordsize=v+" "+I;NAIBU._setPaint(H,O);delete H._cacheMatrix,H._currentStyle;B=z=H=J=j=L=K=O=v=I=null},false);b=a=null},false);return this}SVGEllipseElement.constructor=SVGElement;SVGEllipseElement.prototype=new SVGElement();function SVGLineElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.x1=new SVGAnimatedLength();this.y1=new SVGAnimatedLength();this.x2=new SVGAnimatedLength();this.y2=new SVGAnimatedLength();this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===3){return}var e=a.nextSibling,f=a.parentNode,c=true;if(e&&e._tar&&f._tar&&(e._tar.parentNode===f._tar)){f._tar.insertBefore(a._tar,e._tar)}else{if(e&&!e._tar&&f._tar){while(e){if(e._tar&&(e._tar.parentNode===f._tar)){f._tar.insertBefore(a._tar,e._tar);c=false}e=e.nextSibling}if(c){f._tar.appendChild(a._tar)}}else{if(!e&&f._tar){f._tar.appendChild(a._tar)}}}e=f=c=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(t){var q=t.target,g=q.ownerDocument.defaultView.getComputedStyle(q,"");var z=parseFloat(g.getPropertyValue("font-size"));q.x1.baseVal._emToUnit(z);q.y1.baseVal._emToUnit(z);q.x2.baseVal._emToUnit(z);q.y2.baseVal._emToUnit(z);var k=q.ownerDocument.documentElement,l=q.getScreenCTM();var u="m ";var i=k.createSVGPoint();i.x=q.x1.baseVal.value;i.y=q.y1.baseVal.value;var j=i.matrixTransform(l);u+=j.x+" "+j.y+" l ";i.x=q.x2.baseVal.value;i.y=q.y2.baseVal.value;j=i.matrixTransform(l);u+=j.x+" "+j.y;i=j=null;var v=q._tar,r=k.width.baseVal.value,o=k.height.baseVal.value;v.path=u;v.coordsize=r+" "+o;NAIBU._setPaint(q,l);delete q._cacheMatrix,q._currentStyle;t=v=q=g=z=u=list=l=k=r=o=null},false);b=a=null},false);return this}SVGLineElement.constructor=SVGElement;SVGLineElement.prototype=new SVGElement();function SVGPolylineElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.animatedPoints=this.points=new SVGPointList();this.addEventListener("DOMAttrModified",function(b){var a=b.target;if(b.attrName==="points"){var j=a.points,f=a.ownerDocument.documentElement;var g=b.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/);for(var e=0,h,c=g.length;e<c;e+=2){if(isNaN(g[e])){--e;continue}h=f.createSVGPoint();h.x=parseFloat(g[e]);h.y=parseFloat(g[e+1]);j.appendItem(h)}}b=a=g=j=f=h=null},false);this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===3){return}var e=a.nextSibling,f=a.parentNode,c=true;if(e&&e._tar&&f._tar&&(e._tar.parentNode===f._tar)){f._tar.insertBefore(a._tar,e._tar)}else{if(e&&!e._tar&&f._tar){while(e){if(e._tar&&(e._tar.parentNode===f._tar)){f._tar.insertBefore(a._tar,e._tar);c=false}e=e.nextSibling}if(c){f._tar.appendChild(a._tar)}}else{if(!e&&f._tar){f._tar.appendChild(a._tar)}}}e=f=c=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(A){var t=A.target,v=t.points;var o=t.getScreenCTM();for(var l=0,u=[],r=v.numberOfItems;l<r;++l){var g=v.getItem(l);var k=g.matrixTransform(o);u[2*l]=k.x;u[2*l+1]=k.y;g=k=null}u.splice(2,0,"l");var B="m"+u.join(" ")+"e";var C=t._tar,j=t.ownerDocument.documentElement;var z=j.width.baseVal.value,q=j.height.baseVal.value;C.path=B;C.coordsize=z+" "+q;NAIBU._setPaint(t,o);delete t._cacheMatrix,t._currentStyle;A=C=t=B=u=o=z=q=null},false);b=a=null},false);return this}SVGPolylineElement.constructor=SVGElement;SVGPolylineElement.prototype=new SVGElement();function SVGPolygonElement(){SVGElement.apply(this);this._tar=document.createElement("v:shape");this.animatedPoints=this.points=new SVGPointList();this.addEventListener("DOMAttrModified",function(b){var a=b.target;if(b.attrName==="points"){var j=a.points,f=a.ownerDocument.documentElement;var g=b.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/);for(var e=0,h,c=g.length;e<c;e+=2){if(isNaN(g[e])){--e;continue}h=f.createSVGPoint();h.x=parseFloat(g[e]);h.y=parseFloat(g[e+1]);j.appendItem(h)}}b=a=g=j=f=h=null},false);this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;var e=a.nextSibling,f=a.parentNode;if(e&&!!f._tar){if(!!!e._tar){var c=true;while(e){if(!!e._tar){f._tar.insertBefore(a._tar,e._tar);c=false}e=e.nextSibling}if(c){f._tar.appendChild(a._tar)}c=null}else{f._tar.insertBefore(a._tar,e._tar)}}else{if(!!f._tar){f._tar.appendChild(a._tar)}}e=f=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(A){var t=A.target,v=t.points;var o=t.getScreenCTM();for(var l=0,u=[],r=v.numberOfItems;l<r;++l){var g=v.getItem(l);var k=g.matrixTransform(o);u[2*l]=k.x;u[2*l+1]=k.y;g=k=null}u.splice(2,0,"l");var B="m"+u.join(" ")+"x e";var C=t._tar,j=t.ownerDocument.documentElement;var z=j.width.baseVal.value,q=j.height.baseVal.value;C.path=B;C.coordsize=z+" "+q;NAIBU._setPaint(t,o);delete t._cacheMatrix,t._currentStyle;A=C=t=B=u=o=z=q=null},false);b=a=null},false);return this}SVGPolygonElement.constructor=SVGElement;SVGPolygonElement.prototype=new SVGElement();function SVGTextContentElement(){SVGElement.apply(this);this._list=null;this._length=0;this._stx=this._sty=0;this._chars=0;this.textLength=new SVGAnimatedLength();this.lengthAdjust=new SVGAnimatedEnumeration(SVGTextContentElement.LENGTHADJUST_UNKNOWN);this._isYokogaki=true;this.addEventListener("DOMNodeInserted",function(c){var b=c.target,j=c.currentTarget;if((c.eventPhase===Event.CAPTURING_PHASE)&&(b.localName==="a")&&(b.namespaceURI==="http://www.w3.org/2000/svg")&&b.firstChild){b=b.firstChild}if((c.eventPhase===Event.CAPTURING_PHASE)&&(b.nodeType===Node.TEXT_NODE)&&!!!b._tars){b._tars=[];var g=b.data.replace(/^\s+/,"").replace(/\s+$/,"");b.data=g;g=g.split("");for(var e=0,a=g.length;e<a;++e){var h=document.createElement("div"),f=h.style;f.position="absolute";f.marginLeft=f.marginRight=f.marginTop="0px";f.paddingTop=f.paddingLeft="0px";f.whiteSpace="nowrap";f.textIndent="0px";h.appendChild(document.createTextNode(g[e]));b._tars[b._tars.length]=h}g=null;j._length+=b._tars.length}else{if((c.eventPhase===Event.CAPTURING_PHASE)&&(b instanceof SVGTextContentElement)&&!!!b._tars){j._length+=b._length}}c=b=j=null},true);return this}SVGTextContentElement.constructor=SVGElement;SVGTextContentElement.prototype=new SVGElement();SVGTextContentElement.LENGTHADJUST_UNKNOWN=0;SVGTextContentElement.LENGTHADJUST_SPACING=1;SVGTextContentElement.LENGTHADJUST_SPACINGANDGLYPHS=2;SVGTextContentElement.prototype.getNumberOfChars=function(){return(this._length)};SVGTextContentElement.prototype.getComputedTextLength=function(){var a=this.textLength.baseVal;if((a.value===0)&&(this.getNumberOfChars()>0)){a.newValueSpecifiedUnits(SVGLength.SVG_LENGTHTYPE_NUMBER,this.getSubStringLength(0,this.getNumberOfChars()))}a=null;return(this.textLength.baseVal.value)};SVGTextContentElement.prototype.getSubStringLength=function(c,g){if(g===0){return 0}var f=this.getNumberOfChars();if(f<(g+c)){g=f-c+1}var a=this.getEndPositionOfChar(g+c-1),b=this.getStartPositionOfChar(c);if(this._isYokogaki){var e=a.x-b.x}else{var e=a.y-b.y}f=a=b=null;return e};SVGTextContentElement.prototype.getStartPositionOfChar=function(b){if(b>this.getNumberOfChars()||b<0){throw (new DOMException(DOMException.INDEX_SIZE_ERR))}else{var I=this,j=I.firstChild,f=I.parentNode;if(!!!I._list){I._list=[];var w=I._chars;var u=I._stx,t=I._sty,B=0;var J=I.ownerDocument.defaultView.getComputedStyle(I,null);var q=((J.getPropertyValue("writing-mode"))==="lr-tb")?true:false;var h=parseFloat(J.getPropertyValue("font-size"));var N=I.x.baseVal,M=I.y.baseVal,C=I.dx.baseVal,A=I.dy.baseVal;if(f&&((f.localName==="text")||(f.localName==="tspan"))){var L=f.x.baseVal,K=f.y.baseVal,r=f.dx.baseVal,o=f.dy.baseVal}else{var L=K=r=o={numberOfItems:0}}var k="f ijltIr.,:;'-\"()",g="1234567890abcdeghknopquvxyz";if(q&&(I.localName==="text")){t+=h*0.2}else{if(I.localName==="text"){u-=h*0.5}}while(j){if(j.nodeType===Node.TEXT_NODE){var a=j._tars;for(var H=0,E=a.length;H<E;++H){if(B<L.numberOfItems-w){u=L.getItem(B).value;if(!q){u-=h*0.5}}else{if(B<N.numberOfItems){u=N.getItem(B).value;if(!q){u-=h*0.5}}}if(B<K.numberOfItems-w){t=K.getItem(B).value;if(q){t+=h*0.2}}else{if(B<M.numberOfItems){t=M.getItem(B).value;if(q){t+=h*0.2}}}if(B<r.numberOfItems-w){u+=r.getItem(B).value}else{if(B<C.numberOfItems){u+=C.getItem(B).value}}if(B<o.numberOfItems-w){t+=o.getItem(B).value}else{if(B<A.numberOfItems){t+=A.getItem(B).value}}var e=0;if(q){var c=j.data.charAt(H);if(k.indexOf(c)>-1){e=h*0.68}else{if(c==="s"){e=h*0.52}else{if((c==="C")||(c==="D")||(c==="M")||(c==="W")||(c==="G")||(c==="m")){e=h*0.2}else{if(g.indexOf(c)>-1){e=h*0.45}else{e=h*0.3}}}}var D=c.charCodeAt(0);if((12288<=D)&&(D<=65533)){e=-h*0.01;if((c==="う")||(c==="く")||(c==="し")||(c==="ち")){e+=h*0.2}}D=null}I._list[I._list.length]=u;I._list[I._list.length]=t;I._list[I._list.length]=h-e;if(q){u+=h;u-=e}else{t+=h}++B}w+=E;if(j.parentNode&&(j.parentNode.localName==="a")){j=j.parentNode}j=j.nextSibling}else{if((j.localName==="tspan")&&(j.namespaceURI==="http://www.w3.org/2000/svg")&&j.firstChild){j._stx=u;j._sty=t;j._chars=w;var z=j.getStartPositionOfChar(j.getNumberOfChars());var G=0,F=0;if(q){G=j._list[j._list.length-1]}else{F=j._list[j._list.length-1]}u=j._list[j._list.length-3]+G;t=j._list[j._list.length-2]+F;I._list=I._list.concat(j._list);var l=j.getNumberOfChars();B+=l;w+=l;z=l=null;j=j.nextSibling}else{if((j.localName==="a")&&(j.namespaceURI==="http://www.w3.org/2000/svg")&&j.firstChild){j=j.firstChild}else{j=j.nextSibling}}}}I._isYokogaki=q;I=j=f=L=K=N=M=w=J=u=t=q=null}var v=this.ownerDocument.documentElement.createSVGPoint();v.x=this._list[b*3];v.y=this._list[b*3+1];v=v.matrixTransform(this.getScreenCTM());return v}};SVGTextContentElement.prototype.getEndPositionOfChar=function(a){if(a>this.getNumberOfChars()||a<0){throw (new DOMException(DOMException.INDEX_SIZE_ERR))}else{var b=this.getStartPositionOfChar(a);var c=this._list[a*3+2]*Math.sqrt(Math.abs(this.getScreenCTM()._determinant()));if(this._isYokogaki){b.x+=c}else{b.y+=c}return b}};SVGTextContentElement.prototype.getExtentOfChar=function(a){};SVGTextContentElement.prototype.getRotationOfChar=function(a){};SVGTextContentElement.prototype.getCharNumAtPosition=function(a){};SVGTextContentElement.prototype.selectSubString=function(a,b){};function SVGTextPositioningElement(){SVGTextContentElement.apply(this);this.x=new SVGAnimatedLengthList();this.y=new SVGAnimatedLengthList();this.dx=new SVGAnimatedLengthList();this.dy=new SVGAnimatedLengthList();this.rotate=new SVGAnimatedNumberList();this.addEventListener("DOMAttrModified",function(q){var j=q.target,c=q.attrName,g=j.ownerDocument.documentElement;var f=parseFloat;if((c==="x")||(c==="y")||(c==="dx")||(c==="dy")){var l=q.newValue.replace(/^\s+|\s+$/g,"").split(/[\s,]+/),r=j[c].baseVal;for(var h=0,b=l.length;h<b;++h){var o=g.createSVGLength();var e=l[h].match(/\D+$/),k=0;if(!!e){e=e[0]}if(!e){k=SVGLength.SVG_LENGTHTYPE_NUMBER}else{if(e==="%"){if((c==="x")||(c==="dx")){o._percent*=g.viewport.width}else{if((c==="y")||(c==="dy")){o._percent*=g.viewport.height}}k=SVGLength.SVG_LENGTHTYPE_PERCENTAGE}else{if(e==="em"){var a=j.ownerDocument.defaultView.getComputedStyle(j,null);o._percent*=f(a.getPropertyValue("font-size"));a=null;k=SVGLength.SVG_LENGTHTYPE_EMS}else{if(e==="ex"){k=SVGLength.SVG_LENGTHTYPE_EXS}else{if(e==="px"){k=SVGLength.SVG_LENGTHTYPE_PX}else{if(e==="cm"){k=SVGLength.SVG_LENGTHTYPE_CM}else{if(e==="mm"){k=SVGLength.SVG_LENGTHTYPE_MM}else{if(e==="in"){k=SVGLength.SVG_LENGTHTYPE_IN}else{if(e==="pt"){k=SVGLength.SVG_LENGTHTYPE_PT}else{if(e==="pc"){k=SVGLength.SVG_LENGTHTYPE_PC}}}}}}}}}}var t=f(l[h]);t=isNaN(t)?0:t;o.newValueSpecifiedUnits(k,t);r.appendItem(o)}j._list=null}q=j=null},false);this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){var a=b.target;if(a.nodeType!==Node.TEXT_NODE){a._list=null;b.currentTarget._list=null}b=a=null}},false);return this}SVGTextPositioningElement.constructor=SVGTextContentElement;SVGTextPositioningElement.prototype=new SVGTextContentElement();function SVGTextElement(){SVGTextPositioningElement.apply(this);this._tar=document.createElement("v:group");this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===3){return}var a=b.target;var e=a.nextSibling,f=a.parentNode,c=true;if(e&&e._tar&&f._tar&&(e._tar.parentNode===f._tar)){f._tar.insertBefore(a._tar,e._tar)}else{if(e&&!e._tar&&f._tar){while(e){if(e._tar&&(e._tar.parentNode===f._tar)){f._tar.insertBefore(a._tar,e._tar);c=false}e=e.nextSibling}if(c){f._tar.appendChild(a._tar)}}else{if(!e&&f._tar){f._tar.appendChild(a._tar)}}}e=f=c=null;a.addEventListener("DOMNodeInsertedIntoDocument",function(z){var G=z.target,o=G.firstChild,q=G._tar;q.style.cssText=G.style.cssText;var I=G.ownerDocument.defaultView.getComputedStyle(G,null);var B=parseFloat(I.getPropertyValue("font-size"))*Math.sqrt(Math.abs(G.getScreenCTM()._determinant()));q.style.fontSize=B+"px";q.style.fontFamily=I.getPropertyValue("font-family");var J=G.ownerDocument.documentElement,t=q;var g=G.getComputedTextLength(),r=I.getPropertyValue("text-anchor");for(var H=0,F=0,D=G.getNumberOfChars();H<D;++H){if(o){if(!!o._tars&&(o._tars.length!==0)){var u=(H>F)?H-F:F-H;var v=o._tars[u].style,A=G.getStartPositionOfChar(H);v.position="absolute";if(G._isYokogaki){if(r==="middle"){A.x-=g/2}else{if(r==="end"){A.x-=g}}}else{if(r==="middle"){A.y-=g/2}else{if(r==="end"){A.y-=g}}}v.left=A.x+"px";v.top=A.y+"px";v.width="0px";v.height="0px";v.marginTop=G._isYokogaki?-B+"px":"0px";v.lineHeight=B+"px";q.appendChild(o._tars[u]);v=A=null}if(o.nodeName==="#text"){if((o.data.length+F)<=H+1){F=F+o.data.length;if(o.parentNode.localName==="a"){o=o.parentNode;q=t}o=o.nextSibling}}else{if(!!o.getNumberOfChars){if((o.getNumberOfChars()+F)<=H+1){F=F+o.getNumberOfChars();o=o.nextSibling}}else{if((o.localName==="a")&&(o.namespaceURI==="http://www.w3.org/2000/svg")&&o.firstChild){q=o._tar;o=o.firstChild;H-=2}}}}}var E=I.getPropertyValue("fill");if(E==="none"){G._tar.style.color="transparent"}else{if(E.indexOf("url")===-1){G._tar.style.color=E}else{G._tar.style.color="black"}}var l=I.getPropertyValue("cursor");if(l!=="auto"&&l!==""){G._tar.style.cursor=l}var w=I.getPropertyValue("visibility");if(w!=="visiblee"){G._tar.style.visibility=w}var k=true;if(q.lastChild){if(q.lastChild.nodeName!=="rect"){k=false}}else{k=false}if(!k){var C=document.createElement("v:rect");var h=C.style;h.width="1px";h.height="1px";h.left="0px";h.top="0px";C.stroked="false";C.filled="false";q.appendChild(C)}delete G._cacheMatrix,G._currentStyle;k=z=G=I=tpp=t=null},false);b=a=null},false);return this}SVGTextElement.constructor=SVGTextPositioningElement;SVGTextElement.prototype=new SVGTextPositioningElement();function SVGTSpanElement(){SVGTextElement.apply(this,arguments);return this}SVGTSpanElement.constructor=SVGTextPositioningElement;SVGTSpanElement.prototype=new SVGTextPositioningElement();function SVGTRefElement(){SVGTextPositioningElement.apply(this,arguments);SVGURIReference.apply(this,arguments);return this}SVGTRefElement.constructor=SVGTextPositioningElement;SVGTRefElement.prototype=new SVGTextPositioningElement();function SVGTextPathElement(){SVGTextContentElement.apply(this,arguments);this.startOffset;this.method;this.spacing;SVGURIReference.apply(this,arguments);return this}SVGTextPathElement.constructor=SVGTextContentElement;SVGTextPathElement.prototype=new SVGTextContentElement();SVGTextPathElement.TEXTPATH_METHODTYPE_UNKNOWN=0;SVGTextPathElement.TEXTPATH_METHODTYPE_ALIGN=1;SVGTextPathElement.TEXTPATH_METHODTYPE_STRETCH=2;SVGTextPathElement.TEXTPATH_SPACINGTYPE_UNKNOWN=0;SVGTextPathElement.TEXTPATH_SPACINGTYPE_AUTO=1;SVGTextPathElement.TEXTPATH_SPACINGTYPE_EXACT=2;function SVGAltGlyphElement(){SVGTextPositioningElement.apply(this,arguments);this.glyphRef;this.format;SVGURIReference.apply(this,arguments);return this}SVGAltGlyphElement.constructor=SVGTextPositioningElement;SVGAltGlyphElement.prototype=new SVGTextPositioningElement();function SVGAltGlyphDefElement(){SVGElement.apply(this,arguments);return this}SVGAltGlyphDefElement.constructor=SVGElement;SVGAltGlyphDefElement.prototype=new SVGElement();function SVGAltGlyphItemElement(){SVGElement.apply(this,arguments);return this}SVGAltGlyphItemElement.constructor=SVGElement;SVGAltGlyphItemElement.prototype=new SVGElement();function SVGGlyphRefElement(){SVGElement.apply(this,arguments);this.glyphRef;this.format;this.x;this.y;this.dx;this.dy;SVGURIReference.apply(this,arguments);return this}SVGGlyphRefElement.constructor=SVGElement;SVGGlyphRefElement.prototype=new SVGElement();function SVGPaint(){SVGColor.apply(this,arguments);this.paintType=SVGPaint.SVG_PAINTTYPE_UNKNOWN;this.uri=null;return this}SVGPaint.constructor=SVGColor;SVGPaint.prototype=new SVGColor();SVGPaint.SVG_PAINTTYPE_UNKNOWN=0;SVGPaint.SVG_PAINTTYPE_RGBCOLOR=1;SVGPaint.SVG_PAINTTYPE_RGBCOLOR_ICCCOLOR=2;SVGPaint.SVG_PAINTTYPE_NONE=101;SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR=102;SVGPaint.SVG_PAINTTYPE_URI_NONE=103;SVGPaint.SVG_PAINTTYPE_URI_CURRENTCOLOR=104;SVGPaint.SVG_PAINTTYPE_URI_RGBCOLOR=105;SVGPaint.SVG_PAINTTYPE_URI_RGBCOLOR_ICCCOLOR=106;SVGPaint.SVG_PAINTTYPE_URI=107;SVGPaint.prototype.setUri=function(a){this.setPaint(SVGPaint.SVG_PAINTTYPE_URI_NONE,a,null,null)};SVGPaint.prototype.setPaint=function(a,c,b,e){if((a<101&&c)||(a>102&&!c)){throw new SVGException(SVGException.SVG_INVALID_VALUE_ERR)}this.uri=c;this.paintType=a;if(a===SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR){a=SVGColor.SVG_COLORTYPE_CURRENTCOLOR}this.setColor(a,b,e)};function SVGMarkerElement(){SVGElement.apply(this,arguments);this.refX=new SVGAnimatedLength();this.refY=new SVGAnimatedLength();this.markerUnits=new SVGAnimatedEnumeration();this.markerWidth=new SVGAnimatedLength();this.markerHeight=new SVGAnimatedLength();this.orientType=new SVGAnimatedEnumeration();this.orientAngle=new SVGAnimatedAngle();this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.zoomAndPan=SVGZoomAndPan.SVG_ZOOMANDPAN_DISABLE;return this}SVGMarkerElement.SVG_MARKERUNITS_UNKNOWN=0;SVGMarkerElement.SVG_MARKERUNITS_USERSPACEONUSE=1;SVGMarkerElement.SVG_MARKERUNITS_STROKEWIDTH=2;SVGMarkerElement.SVG_MARKER_ORIENT_UNKNOWN=0;SVGMarkerElement.SVG_MARKER_ORIENT_AUTO=1;SVGMarkerElement.SVG_MARKER_ORIENT_ANGLE=2;SVGMarkerElement.constructor=SVGElement;SVGMarkerElement.prototype=new SVGElement();SVGMarkerElement.prototype.setOrientToAuto=function(){};SVGMarkerElement.prototype.setOrientToAngle=function(a){};function SVGColorProfileElement(){SVGElement.apply(this);this._local;this.name;this.renderingIntent;SVGURIReference.apply(this,arguments);return this}SVGColorProfileElement.constructor=SVGElement;SVGColorProfileElement.prototype=new SVGElement();function SVGColorProfileRule(){SVGCSSRule.apply(this);this.src;this.name;this.renderingIntent;return this}SVGColorProfileRule.constructor=SVGCSSRule;SVGColorProfileRule.prototype=new SVGCSSRule();function SVGGradientElement(){SVGElement.apply(this,arguments);SVGURIReference.apply(this,arguments);this.gradientUnits=new SVGAnimatedEnumeration();this.gradientTransform=new SVGAnimatedTransformList();this.spreadMethod=new SVGAnimatedEnumeration();this.addEventListener("DOMNodeInsertedIntoDocument",function(o){var l=o.target,u=o._tar,r=o._style;if(!!!u){return}if(l){var h=l;while(h&&!h.hasChildNodes()){var b=h.getAttributeNS("http://www.w3.org/1999/xlink","href");if(b){b.match(/#(.+)/);h=o.target.ownerDocument.getElementById(RegExp.$1)}else{break}}var q=h.getElementsByTagNameNS("http://www.w3.org/2000/svg","stop");if(!q){l=h=q=null;return}var c=q.length;var f=[],a=[],j=[];for(var g=0;g<c;++g){var k=q[g],e=k.ownerDocument.defaultView.getComputedStyle(k,"");f[g]=e.getPropertyValue("stop-color");a[g]=k.offset.baseVal+" "+f[g];j[g]=(e.getPropertyValue("stop-opacity")||1)*r.getPropertyValue("fill-opacity")*r.getPropertyValue("opacity")}u.setAttribute("method","none");u.setAttribute("color",f[0]);u.setAttribute("color2",f[c-1]);u.setAttribute("colors",a.join(","));u.setAttribute("opacity",j[c-1]+"");u.setAttribute("o:opacity2",j[0]+"");l._color=f;l=u=q=lengh=f=a=j=null}o=r=null},false);return this}SVGGradientElement.constructor=SVGElement;SVGGradientElement.prototype=new SVGElement();SVGGradientElement.SVG_SPREADMETHOD_UNKNOWN=0;SVGGradientElement.SVG_SPREADMETHOD_PAD=1;SVGGradientElement.SVG_SPREADMETHOD_REFLECT=2;SVGGradientElement.SVG_SPREADMETHOD_REPEAT=3;function SVGLinearGradientElement(){SVGGradientElement.apply(this,arguments);this.x1=new SVGAnimatedLength();this.y1=new SVGAnimatedLength();this.x2=new SVGAnimatedLength();this.y2=new SVGAnimatedLength();this.addEventListener("DOMNodeInsertedIntoDocument",function(a){var g=a.target,e=a._tar,f=270;if(!!!e){return}var b=g.ownerDocument.defaultView.getComputedStyle(g,"");var c=parseFloat(b.getPropertyValue("font-size"));g.x1.baseVal._emToUnit(c);g.y1.baseVal._emToUnit(c);g.x2.baseVal._emToUnit(c);g.y2.baseVal._emToUnit(c);f=270-Math.atan2(g.y2.baseVal.value-g.y1.baseVal.value,g.x2.baseVal.value-g.x1.baseVal.value)*180/Math.PI;if(f>=360){f-=360}e.setAttribute("type","gradient");e.setAttribute("angle",f+"");a=e=g=f=b=c=null},false);return this}SVGLinearGradientElement.constructor=SVGGradientElement;SVGLinearGradientElement.prototype=new SVGGradientElement();function SVGRadialGradientElement(){SVGGradientElement.apply(this);this.cx=new SVGAnimatedLength();this.cy=new SVGAnimatedLength();this.r=new SVGAnimatedLength();this.fx=new SVGAnimatedLength();this.fy=new SVGAnimatedLength();this.cx.baseVal.value=this.cy.baseVal.value=this.r.baseVal.value=0.5;this.addEventListener("DOMNodeInsertedIntoDocument",function(B){var k=B.target,X=B._tar,D=B._ttar;if(!!!X){return}X.setAttribute("type","gradientTitle");X.setAttribute("focus","100%");X.setAttribute("focusposition","0.5 0.5");if(D.localName==="rect"){var L=k.ownerDocument.defaultView.getComputedStyle(D,"");var j=parseFloat(L.getPropertyValue("font-size"));k.cx.baseVal._emToUnit(j);k.cy.baseVal._emToUnit(j);k.r.baseVal._emToUnit(j);k.fx.baseVal._emToUnit(j);k.fy.baseVal._emToUnit(j);var v=k.cx.baseVal.value,t=k.cy.baseVal.value;var H=k.r.baseVal.value,A,z;A=z=H;var F=D.getBBox();var o=D.ownerDocument.documentElement.viewport;var T=o.width|0,I=o.height|0,N=0,a=0;var U=k.getAttributeNS(null,"gradientUnits");if(!U||U==="objectBoundingBox"){v=v>1?v/100:v;t=t>1?t/100:t;H=H>1?H/100:H;var O=F.x,K=F.y,S=F.width,Q=F.height;v=v*S+O;t=t*Q+K;A=H*S;z=H*Q;O=K=S=Q=null}var c=k.getAttributeNS(null,"gradientTransform");if(c){k.setAttributeNS(null,"transform",c)}var C=D.getScreenCTM().multiply(k.getCTM());T=v-A;I=t-z;N=v+A;a=t+z;var g=A*0.55228,f=z*0.55228;var u=["m",v,I,"c",v-g,I,T,t-f,T,t,T,t+f,v-g,a,v,a,v+g,a,N,t+f,N,t,N,t-f,v+g,I,v,I,"x e"];for(var P=0,M=u.length;P<M;){if(isNaN(u[P])){++P;continue}var J=k.ownerDocument.documentElement.createSVGPoint();J.x=parseFloat(u[P]);J.y=parseFloat(u[P+1]);var e=J.matrixTransform(C);u[P]=e.x;P++;u[P]=e.y;P++;J=e=null}var W=u.join(" ");var b=document.getElementById("_NAIBU_outline");var E=document.createElement("div"),q=E.style;q.position="absolute";q.display="inline-block";var G=o.width,R=o.height;q.textAlign="left";q.top="0px";q.left="0px";q.width=G+"px";q.height=R+"px";b.appendChild(E);q.filter="progid:DXImageTransform.Microsoft.Compositor";E.filters.item("DXImageTransform.Microsoft.Compositor").Function=23;var l='<v:shape style="display:inline-block; position:relative; antialias:false; top:0px; left:0px;" coordsize="'+G+" "+R+'" path="'+W+'" stroked="f">'+X.outerHTML+"</v:shape>";var V=D._tar.path.value;E.innerHTML='<v:shape style="display:inline-block; position:relative; top:0px; left:0px;" coordsize="'+G+" "+R+'" path="'+V+'" stroked="f" fillcolor="'+k._color[k._color.length-1]+'" ></v:shape>';E.filters[0].apply();E.innerHTML=l;E.filters[0].play();D._tar.parentNode.insertBefore(E,D._tar);D._tar.filled="false";W=b=E=L=j=q=l=V=u=c=v=t=H=G=R=C=null}else{if(!X.parentNode){D._tar.appendChild(X)}}B=D=X=gard=null},false);return this}SVGRadialGradientElement.constructor=SVGGradientElement;SVGRadialGradientElement.prototype=new SVGGradientElement();function SVGStopElement(){SVGElement.apply(this,arguments);this.offset=new SVGAnimatedNumber();this.addEventListener("DOMAttrModified",function(a){if(a.attrName==="offset"){a.target.offset.baseVal=parseFloat(a.newValue)}a=null},false);return this}SVGStopElement.constructor=SVGElement;SVGStopElement.prototype=new SVGElement();function SVGPatternElement(){SVGElement.apply(this,arguments);this.patternUnits=new SVGAnimatedEnumeration();this.patternContentUnits=new SVGAnimatedEnumeration();this.patternTransform=new SVGAnimatedTransformList();this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();SVGURIReference.apply(this,arguments);this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.zoomAndPan=SVGZoomAndPan.SVG_ZOOMANDPAN_DISABLE;return this}SVGPatternElement.constructor=SVGElement;SVGPatternElement.prototype=new SVGElement();function SVGClipPathElement(){SVGElement.apply(this,arguments);this.clipPathUnits=new SVGAnimatedEnumeration();return this}SVGClipPathElement.constructor=SVGElement;SVGClipPathElement.prototype=new SVGElement();function SVGMaskElement(){SVGElement.apply(this,arguments);this.maskUnits=new SVGAnimatedEnumeration();this.maskContentUnits=new SVGAnimatedEnumeration();this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();return this}SVGMaskElement.constructor=SVGElement;SVGMaskElement.prototype=new SVGElement();function SVGFilterElement(){SVGElement.apply(this,arguments);this.filterUnits=new SVGAnimatedEnumeration();this.primitiveUnits=new SVGAnimatedEnumeration();this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.filterResX=new SVGAnimatedInteger();this.filterResY=new SVGAnimatedInteger();SVGURIReference.apply(this,arguments);return this}SVGFilterElement.constructor=SVGElement;SVGFilterElement.prototype=new SVGElement();function SVGFilterPrimitiveStandardAttributes(a){SVGStylable.apply(this,arguments);this._tar=a;this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();this.result=new SVGAnimatedLength()}SVGFilterPrimitiveStandardAttributes.constructor=SVGStylable;SVGFilterPrimitiveStandardAttributes.prototype=new SVGStylable();function SVGFEBlendElement(){SVGElement.apply(this,arguments);this.in1=new SVGAnimatedString();this.in2=new SVGAnimatedString();this.mode=new SVGAnimatedEnumeration();this._fpsa=SVGFilterPrimitiveStandardAttributes(this);return this}SVGFEBlendElement.constructor=SVGElement;SVGFEBlendElement.prototype=new SVGElement();SVGFEBlendElement.SVG_FEBLEND_MODE_UNKNOWN=0;SVGFEBlendElement.SVG_FEBLEND_MODE_NORMAL=1;SVGFEBlendElement.SVG_FEBLEND_MODE_MULTIPLY=2;SVGFEBlendElement.SVG_FEBLEND_MODE_SCREEN=3;SVGFEBlendElement.SVG_FEBLEND_MODE_DARKEN=4;SVGFEBlendElement.SVG_FEBLEND_MODE_LIGHTEN=5;function SVGFEGaussianBlurElement(){SVGElement.apply(this,arguments);this.in1=new SVGAnimatedString();this.stdDeviationX=new SVGAnimatedNumber();this.stdDeviationY=new SVGAnimatedNumber();this._fpsa=SVGFilterPrimitiveStandardAttributes(this);return this}SVGFEGaussianBlurElement.constructor=SVGElement;SVGFEGaussianBlurElement.prototype=new SVGElement();SVGFEGaussianBlurElement.prototype.setStdDeviation=function(b,a){};function SVGCursorElement(){SVGElement.apply(this,arguments);this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();SVGURIReference.apply(this,arguments);return this}SVGCursorElement.constructor=SVGElement;SVGCursorElement.prototype=new SVGElement();function SVGAElement(){SVGElement.apply(this);this._tar=document.createElement("a");this.target=new SVGAnimatedString();this.addEventListener("DOMAttrModified",function(b){var a=b.target;if(b.eventPhase===Event.BUBBLING_PHASE){return}if(b.attrName==="target"){a.target.baseVal=b.newValue}else{if(b.attrName==="xlink:title"){a._tar.setAttribute("title",b.newValue)}}b=null},false);this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===Event.BUBBLING_PHASE){return}if(a.nextSibling){if(!!a.parentNode._tar&&!!a.nextSibling._tar){a.parentNode._tar.insertBefore(a._tar,a.nextSibling._tar)}}else{if(!!a.parentNode._tar){a.parentNode._tar.appendChild(a._tar)}}var e=a._tar.style;e.cursor="hand";e.left="0px";e.top="0px";e.textDecoration="none";e=null;var f=a.target.baseVal;var c="replace";if(f==="_blank"){c="new"}a.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show",c);a.addEventListener("DOMAttrModified",function(j){var h=j.target;var o=h.getElementsByTagNameNS("http://www.w3.org/2000/svg","*");if(o){var g=h.ownerDocument.createEvent("MutationEvents");g.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);for(var l=0,k=o.length;l<k;++l){var q=o[l];q.dispatchEvent(g);q=null}g=null}j=h=o=null},false);a=b=null},false);this.addEventListener("DOMNodeInsertedIntoDocument",function(b){var a=b.target;if(!!a._tar&&(a.nodeType===Node.ELEMENT_NODE)){var c=a._tar.style;c.cursor="hand";c.textDecoration="none";c=null}a=b=null;return},true);SVGURIReference.apply(this,arguments);return this}SVGAElement.constructor=SVGElement;SVGAElement.prototype=new SVGElement();function SVGViewElement(){SVGElement.apply(this,arguments);this.viewTarget=new SVGStringList();this.viewBox=new SVGAnimatedRect();this.preserveAspectRatio=new SVGAnimatedPreserveAspectRatio();this.zoomAndPan=SVGZoomAndPan.SVG_ZOOMANDPAN_DISABLE;return this}SVGViewElement.constructor=SVGElement;SVGViewElement.prototype=new SVGElement();function SVGScriptElement(){SVGElement.apply(this);this.type;SVGURIReference.apply(this,arguments);this.addEventListener("DOMAttrModified",function(evt){if(evt.attrName==="type"){evt.target.type=evt.newValue}evt=null},false);this.addEventListener("SVGLoad",function(evt){var tar=evt.target,script=tar._text;var tod=tar.ownerDocument;NAIBU._temp_doc=tod;script=script.replace(/function\s+(\w+)/g,"$1 = function");script="(function(document){"+script+"})(NAIBU._temp_doc);";eval(script);tod.documentElement._svgload_limited--;if(tod.documentElement._svgload_limited<0){evt=tod.createEvent("SVGEvents");evt.initEvent("SVGLoad",false,false);tod.documentElement.dispatchEvent(evt)}tar=evt=script=null},false);this.addEventListener("DOMNodeInserted",function(evt){var tar=evt.target;if(evt.eventPhase===Event.BUBBLING_PHASE){if(tar.nodeName==="#cdata-section"){evt.currentTarget._text=tar.data}return}tar.addEventListener("DOMNodeInsertedIntoDocument",function(evt){var tar=evt.target;if(evt.eventPhase===Event.AT_TARGET&&!tar.getAttributeNodeNS("http://www.w3.org/1999/xlink","xlink:href")){var evtt=tar.ownerDocument.createEvent("SVGEvents");evtt.initEvent("SVGLoad",false,false);evt.currentTarget.dispatchEvent(evtt)}tar=evt=null},false)},false);return this}SVGScriptElement.constructor=SVGElement;SVGScriptElement.prototype=new SVGElement();function SVGEvent(){Event.apply(this,arguments);return this}SVGEvent.constructor=Event;SVGEvent.prototype=new Event();function SVGZoomEvent(){UIEvent.apply(this,arguments);this.zoomRectScreen=new SVGRect();this.previousScale=1;this.previousTranslate=new SVGPoint();this.newScale=1;this.newTranslate=new SVGPoint();return this}SVGZoomEvent.constructor=UIEvent;SVGZoomEvent.prototype=new UIEvent();function SVGAnimationElement(a){if(!!a){return this}SVGElement.apply(this);this.style.setProperty=function(){};this._tar=null;this.targetElement;this._beginValue="0ms";this._endValue=null;this._currentFrame=0;this._currentCount=0;this._maxCount=0;this._maxDur=0;this._isRepeat=false;this._simpleDuration=null;this._begin=null;this._end=null;this._from=this._to=this._values=this._by=null;this._keyTimes=null;this.addEventListener("beginEvent",function(c){var b=c.target;if(!b.isRepeat){b.endElementAt(b.getSimpleDuration())}else{b.beginElementAt(b.getSimpleDuration());if(b.getCurrentTime()!==0){var e=b.ownerDocument,c=e.createEvent("TimeEvents");b._currentCount++;c.initTimeEvent("repeatEvent",e.defaultView,b._currentCount);b.dispatchEvent(c)}}},false);this.addEventListener("DOMAttrModified",function(c){if(c.eventPhase===Event.BUBBLING_PHASE){return}var b=c.target,e=c.attrName;if(e==="begin"){b._beginValue=c.newValue}else{if(e==="end"){b._endValue=c.newValue}else{if(e==="dur"){b._simpleDuration=b._getOffset(c.newValue)}else{if(e==="repeatCount"){b._maxCount=parseFloat(c.newValue);b._isRepeat=true}else{if(e==="repeatDur"){b._maxDur=parseFloat(c.newValue);b._isRepeat=true}else{if(e==="from"){b._from=c.newValue}else{if(e==="to"){b._to=c.newValue}else{if(e==="values"){b._values=c.newValue.split(";")}else{if(e==="by"){b._by=c.newValue}else{if(e==="keyTimes"){var g=c.newValue.split(";");b._keyTimes=[];for(var f=0;f<g.length;++f){b._keyTimes[f]=parseFloat(g[f])}g=null}}}}}}}}}}c=null},false);this.addEventListener("DOMNodeInserted",function(c){if(c.eventPhase===Event.BUBBLING_PHASE){return}var b=c.target;b.addEventListener("DOMNodeInsertedIntoDocument",function(f){var e=f.target;if(e._values){}else{if(e._from&&e._to){e._values=[e._from,e._to]}else{if(e._from&&e._by){var h=parseFloat(e._from)+parseFloat(e._by),g=e._from.match(/\D+/)||[""];e._values=[e._from,h+g[0]]}else{if(e._to){e._values=[null,e._to]}else{if(e._by){e._values=[null,null,e._by]}else{if(!e.hasChildNodes()&&!e.hasAttributeNS(null,"path")){return this}}}}}}if(e.hasAttributeNS("http://www.w3.org/1999/xlink","xlink:href")){e.targetElement=e.ownerDocument.getElementById(e.getAttributeNS("http://www.w3.org/1999/xlink","xlink:href").substring(1))}else{e.targetElement=e.parentNode}e._eventSync(e._beginValue,(function(l,j,i,k){i.addEventListener(k.match(l._eventRegExp)[0],function(){if(j!==0){l.beginElementAt(j)}else{l._begin=NAIBU.Time.currentFrame;l.beginElement();l._currentFrame++}},false)}),"beginElementAt");if(e._endValue){e._eventSync(e._endValue,(function(l,j,i,k){i.addEventListener(k.match(l._eventRegExp)[0],function(){l.endElementAt(j)},false)}),"endElementAt")}f=e=null},false);c=b=null},false);this.addEventListener("repeatEvent",function(c){var b=c.target;if((b._currentCount>=b._maxCount)||(b.getCurrentTime()>=(b._maxDur+b.getStartTime()))){b._isRepeat=false}},false);return this}SVGAnimationElement.constructor=SVGElement;SVGAnimationElement.prototype=new SVGElement();SVGAnimationElement.prototype.beginElement=function(){var b=this.ownerDocument,a=b.createEvent("TimeEvents");a.initTimeEvent("beginEvent",b.defaultView,0);this.dispatchEvent(a)};SVGAnimationElement.prototype.endElement=function(){var b=this.ownerDocument,a=b.createEvent("TimeEvents");a.initTimeEvent("endEvent",b.defaultView,0);this.dispatchEvent(a)};SVGAnimationElement.prototype.beginElementAt=function(b){var a=this.ownerDocument.documentElement.getCurrentTime();this._begin=b+a};SVGAnimationElement.prototype.endElementAt=function(b){var a=this.ownerDocument.documentElement.getCurrentTime();this._end=b+a};SVGAnimationElement.prototype._eventRegExp=/(mouse|activ|clic)[a-z]+/;SVGAnimationElement.prototype._timeRegExp=/[\-\d\.]+(h|min|s|ms)?/;SVGAnimationElement.prototype._unit={h:2880000,min:48000,s:800,ms:0.8};SVGAnimationElement.prototype._getOffset=function(a){var c=parseFloat(a.match(this._timeRegExp));if(!isNaN(c)&&RegExp.$1){var b=c*this._unit[RegExp.$1]}else{if(!isNaN(c)){var b=c}else{var b=0}}c=a=null;return b};SVGAnimationElement.prototype._eventSync=function(c,e,b){var g=this._getOffset(c);this._begin=NAIBU.Time.Max;if(/(mouse|activ|click)/.test(c)){var a;if(/([^;]+)\.\D/.test(c)){a=this.ownerDocument.getElementById(RegExp.$1)}else{a=this.targetElement}if(!g&&g!==0){g=NAIBU.Time.Max}e(this,g,a,c)}else{if(!g&&(c!=="undefined")&&(g!==0)){this._begin=0}else{this[b](g)}}};SVGAnimationElement.prototype.getStartTime=function(){if(!!this._begin||this._begin===0){return(this._begin)}else{throw new DOMException(DOMException.INVALID_STATE_ERR)}};SVGAnimationElement.prototype.getCurrentTime=function(){return(this._currentFrame*125*0.8)};SVGAnimationElement.prototype.getSimpleDuration=function(){if(!!!this._simpleDuration&&!!!this._end&&this._simpleDuration!==0){throw new DOMException(DOMException.NOT_SUPPORTED_ERR)}else{if(!!this._simpleDuration&&!!this._end){var a=(this._simpleDuration>this._end-this._begin)?this._end-this._begin:this._simpleDuration}else{var a=!!this._end?this._end-this._begin:this._simpleDuration}}return a};NAIBU.Time={currentFrame:0,Max:7000,start:function(){if(NAIBU.Clip.length>0){screen.updateInterval=42;window.onscroll=function(){screen.updateInterval=0;screen.updateInterval=42};NAIBU.stop=setInterval((function(){var b=NAIBU.Time.currentFrame++;var g=NAIBU.Clip;var f=b*100;if(b>NAIBU.Time.Max){clearInterval(NAIBU.stop)}for(var e=0,a=g.length;e<a;++e){var c=g[e];c.ownerDocument.documentElement.setCurrentTime(f);if("_begin" in c){if(c.getStartTime()<=f){if(c.getCurrentTime()===0){c.beginElement()}c._currentFrame++}if(c._end&&(c._end<=f)&&(c.getCurrentTime()!==0)){c.endElement();if(!!c._frame){c._frame()}c._currentFrame=0;delete c._begin;c._end=null}else{if(!!c._frame){c._frame()}}}c=null}}),1)}else{window.onscroll=function(){screen.updateInterval=0;window.onscroll=NAIBU.emptyFunction}}}};NAIBU.Clip=[];function SVGAnimateElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this._valueList=[];this._isDiscrete=false;this.addEventListener("DOMAttrModified",function(a){if(a.eventPhase===Event.BUBBLING_PHASE){return}if((a.attrName==="calcMode")&&(a.newValue==="discrete")){a.target._isDiscrete=true}},false);this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;a.addEventListener("DOMNodeInsertedIntoDocument",function(r){var j=r.target,l=j.getAttributeNS(null,"attributeName"),t=j.targetElement,k=t[l];var g=t.cloneNode(false);if(!j._values[0]){j._values[0]=t.getAttributeNS(null,l)||t.style.getPropertyValue(l);if(!j._values[1]){var q=parseFloat(j._values[0])+parseFloat(j._values[2]),o=j._values[0].match(/\D+/)||[""];j._values[1]=q+o[0];j._values.pop();q=o=null}}if(!!k){k.animVal=g[l].baseVal;for(var h=0,f=j._values,e=f.length;h<e;++h){var c=t.cloneNode(false);delete c._tar;c.setAttributeNS(null,l,f[h]);j._valueList[j._valueList.length]=c[l].baseVal}}else{if(!!CSS2Properties[l]||l.indexOf("-")>-1){for(var h=0,f=j._values,e=f.length;h<e;++h){j._valueList[h]=parseFloat(f[h])}}else{if("animatedPoints" in t){t.animatedPoints=g.points;for(var h=0,f=j._values,e=f.length;h<e;++h){var c=t.cloneNode(false);delete c._tar;c.setAttributeNS(null,"points",f[h]);j._valueList[j._valueList.length]=c.points}}else{if("normalizedPathSegList" in t){t.animatedNormalizedPathSegList=g.normalizedPathSegList;for(var h=0,f=j._values,e=f.length;h<e;++h){var c=t.cloneNode(false);delete c._tar;c.setAttributeNS(null,"d",f[h]);j._valueList[j._valueList.length]=c.normalizedPathSegList}}else{g=null;return}}}}r=k=c=g=null},false)},false);this.addEventListener("beginEvent",function(c){var b=c.target;var e=b.getAttributeNS(null,"attributeName"),g=b.targetElement.attributes.getNamedItemNS(null,e);var f=b.targetElement,a=f[e];b._frame=function(){var o=b.getSimpleDuration()*0.8,k=b._valueList.length-1,j=b.getCurrentTime();if((k!==-1)&&(o!==0)&&(j<=o)){if(b._isDiscrete){++k}var z=Math.floor((j*k)/o);if(z===k){z-=1}}else{return}var w=b.ownerDocument.createEvent("MutationEvents");w.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);if(b._keyTimes){var q=(b._keyTimes[z+1]-b._keyTimes[z])*o;var h=b._keyTimes[z]}else{var q=o/k;var h=z/k}if(!!a){var i=a.baseVal,l=a.animVal;var t=b._valueList[z].value;if(!b._isDiscrete){var r=b._valueList[z+1].value,u=t+(r-t)*(j-h*o)/q}else{var u=t}l.newValueSpecifiedUnits(i.unitType,u);a.baseVal=l;l=null;f.dispatchEvent(w);a.animVal=a.baseVal;a.baseVal=i;q=null}else{if(!!CSS2Properties[e]||e.indexOf("-")>-1){var i=null;var t=b._valueList[z].value,r=b._valueList[z+1].value;if(!b._isDiscrete){var u=t+(r-t)*(j-h*o)/q}else{var u=t}}else{if("animatedPoints" in f){var i=f.points;f.points=f.animatedPoints;f.dispatchEvent(w);f.animatedPoints=f.points;f.points=i}else{if("normalizedPathSegList" in f){var i=f.normalizedPathSegList;f.normalizedPathSegList=f.animatedNormalizedPathSegList;f.dispatchEvent(w);f.animatedNormalizedPathSegList=f.normalizedPathSegList;f.normalizedPathSegList=i}}}}w=t=r=u=o=k=z=j=null};c=vir=null},false);this.addEventListener("endEvent",function(b){var a=b.target,c=a.getAttributeNS(null,"fill");if(!c||(c==="remove")){var b=a.ownerDocument.createEvent("MutationEvents");b.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);a.targetElement.dispatchEvent(b);b=null}},false);this.addEventListener("repeatEvent",function(b){var a=b.target},false);return this}SVGAnimateElement.constructor=SVGAnimationElement;SVGAnimateElement.prototype=new SVGAnimationElement(1);function SVGSetElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this._to="";this.addEventListener("DOMAttrModified",function(b){var a=b.target,c=b.attrName;if(c==="to"){a._to=b.newValue}a=c=null},false);this.addEventListener("beginEvent",function(c){var b=c.target;if(b.targetElement){var e=b.getAttributeNS(null,"attributeName"),h=b.targetElement.attributes.getNamedItemNS(null,e);var a=b.targetElement[e];if(!!a){var g=a.baseVal;if(g instanceof SVGLength){a.baseVal=b.ownerDocument.documentElement.createSVGLength()}else{if(g instanceof SVGRect){a.baseVal=b.ownerDocument.documentElement.createSVGRect()}}var c=b.ownerDocument.createEvent("MutationEvents");c.initMutationEvent("DOMAttrModified",true,false,h,h,b._to,e,MutationEvent.MODIFICATION);b.targetElement.dispatchEvent(c);c=null;a.animVal=a.baseVal;a.baseVal=g}else{var f=b.ownerDocument.getOverrideStyle(b.targetElement,"");f.setProperty(e,b.getAttributeNS(null,"to"),null);f=null}}c=b=e=null},false);this.addEventListener("endEvent",function(c){var b=c.target,g=b.getAttributeNS(null,"fill");if(!g||(g==="remove")){var e=b.getAttributeNS(null,"attributeName"),f=b.ownerDocument.defaultView.getComputedStyle(b.targetElement,"");b.targetElement.style.setProperty(e,f.getPropertyValue(e),null);var a=b.ownerDocument.createEvent("MutationEvents");a.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);b.targetElement.dispatchEvent(a);e=f=a=null}b=g=null},false);this.addEventListener("repeatEvent",function(b){var a=b.target,c=a.getAttributeNS(null,"attributeName"),e=a.ownerDocument.defaultView.getComputedStyle(a.targetElement,"")},false);return this}SVGSetElement.constructor=SVGAnimationElement;SVGSetElement.prototype=new SVGAnimationElement(1);function SVGAnimateMotionElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this.addEventListener("DOMAttrModified",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target,c=b.attrName;if(c==="path"){var e=a.ownerDocument.createElementNS("http://www.w3.org/2000/svg","path");e.setAttributeNS(null,"d",b.newValue);a._path=e;e=null}},false);this.addEventListener("beginEvent",function(b){var a=b.target,c=a.targetElement.transform;c.animVal=new SVGTransformList();if(c.baseVal.numberOfItems!==0){c.animVal.initialize(c.baseVal.createSVGTransformFromMatrix(c.baseVal.getItem(0).matrix))}c.animVal.appendItem(a.ownerDocument.documentElement.createSVGTransform());a._frame=function(){var g=a,f=g._path;if(!!f){var k=g.getSimpleDuration();if(k===0){k=null;return}var h=(f.getTotalLength()/k)*g.getCurrentTime()/125*0.8;var l=f.getPointAtLength(h),i=g.targetElement.transform;l=l.matrixTransform(g.targetElement.getScreenCTM());i.animVal.getItem(i.animVal.numberOfItems-1).setTranslate(l.x,l.y);var j=i.baseVal;i.baseVal=i.animVal;var e=g.ownerDocument.createEvent("MutationEvents");e.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);g.targetElement.dispatchEvent(e);i.baseVal=j;e=j=i=h=k=l=null}};b=c=null},false);this.addEventListener("endEvent",function(c){var b=c.target,e=b.targetElement.transform;e.animVal=e.baseVal;var a=b.ownerDocument.createEvent("MutationEvents");a.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);b.targetElement.dispatchEvent(a);b._frame=c=a=null},false);this.addEventListener("repeatEvent",function(b){var a=b.target},false);return this}SVGAnimateMotionElement.constructor=SVGAnimationElement;SVGAnimateMotionElement.prototype=new SVGAnimationElement(1);function SVGMPathElement(){SVGElement.apply(this);SVGURIReference.apply(this);return this}SVGMPathElement.constructor=SVGElement;SVGMPathElement.prototype=new SVGElement();function SVGAnimateColorElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this._valueList=[];this.addEventListener("DOMNodeInserted",function(b){if(b.eventPhase===Event.BUBBLING_PHASE){return}var a=b.target;a.addEventListener("DOMNodeInsertedIntoDocument",function(l){var h=l.target,j=h.getAttributeNS(null,"attributeName"),o=h.targetElement;var f=h.ownerDocument.defaultView.getComputedStyle(o,"");if(!h._values[0]){h._values[0]=f.getPropertyValue(j)}for(var g=0,e=h._values,c=e.length;g<c;++g){var k=new SVGColor();k.setRGBColor(h._values[g]);h._valueList[h._valueList.length]=k;k=null}},false)},false);this.addEventListener("beginEvent",function(b){var a=b.target,e=a.getAttributeNS(null,"attributeName");var f=a.ownerDocument.getOverrideStyle(a.targetElement,"");var c=a.ownerDocument.defaultView.getComputedStyle(a.targetElement,"");if(a._values[0]!==null){f.setProperty(e,a._values[0],null)}a._frame=function(){var D=a;var A=D.getSimpleDuration()*0.8,l=D._valueList.length-1,k=D.getCurrentTime();if((l!==-1)&&(A!==0)&&(k<=A)){var E=Math.floor((k*l)/A);if(E===l){E-=1}}else{return}if(a._keyTimes){var B=(a._keyTimes[E+1]-a._keyTimes[E])*A;var j=a._keyTimes[E]}else{var B=A/l;var j=E/l}var o=D._valueList[E].rgbColor,u=D._valueList[E+1].rgbColor,t=(k-j*A)/B,v=CSSPrimitiveValue.CSS_NUMBER;var z=o.red.getFloatValue(v),i=o.green.getFloatValue(v),q=o.blue.getFloatValue(v);var h=z+(u.red.getFloatValue(v)-z)*t;var w=i+(u.green.getFloatValue(v)-i)*t;var C=q+(u.blue.getFloatValue(v)-q)*t;f.setProperty(e,"rgb("+Math.ceil(h)+","+Math.ceil(w)+","+Math.ceil(C)+")",null);D=A=l=k=o=u=z=i=q=v=h=w=C=null}},false);this.addEventListener("endEvent",function(c){var b=c.target;var a=b.ownerDocument.createEvent("MutationEvents");a.initMutationEvent("DOMNodeInsertedIntoDocument",false,false,null,null,null,null,null);b.targetElement.dispatchEvent(a);b._frame=c=a=null},false);this.addEventListener("repeatEvent",function(b){var a=b.target},false);return this}SVGAnimateColorElement.constructor=SVGAnimationElement;SVGAnimateColorElement.prototype=new SVGAnimationElement(1);function SVGAnimateTransformElement(){SVGAnimationElement.apply(this);NAIBU.Clip[NAIBU.Clip.length]=this;this.addEventListener("beginEvent",function(b){var a=b.target,c=a.targetElement.transform;c.animVal=new SVGTransformList();if(c.baseVal.numberOfItems!==0){c.animVal.initialize(c.baseVal.createSVGTransformFromMatrix(c.baseVal.getItem(0).matrix))}c.animVal.appendItem(a.ownerDocument.documentElement.createSVGTransform())},false);this.addEventListener("endEvent",function(b){var a=b.target},false);this.addEventListener("repeatEvent",function(b){var a=b.target},false);return this}SVGAnimateTransformElement.constructor=SVGAnimationElement;SVGAnimateTransformElement.prototype=new SVGAnimationElement(1);function SVGFontElement(){SVGElement.apply(this);this._isExternal=0;this.addEventListener("DOMNodeInserted",function(b){var a=b.target;if(b.eventPhase===Event.BUBBLING_PHASE){return}a.addEventListener("DOMNodeInsertedIntoDocument",function(e){var c=e.target,f="http://www.w3.org/2000/svg",h=c.getElementsByTagNameNS(f,"font-face").item(0);var g=function(v){var r=v.target;var o=h.getAttributeNS(null,"font-family");var t=c.ownerDocument.getElementsByTagNameNS(f,"text");for(var q=0,u=c,k=t.length;q<k;++q){var l=t[q],j=u.ownerDocument.defaultView.getComputedStyle(l,"");if(j.getPropertyValue("font-family",null).indexOf(o)>-1){NAIBU._noie_createFont(l,u,true)}}v=c=r=curt=textElments=f=u=null};if(!h.__isLinked||c._isExternal){c.ownerDocument.documentElement._svgload_limited=0;c.ownerDocument.documentElement.addEventListener("SVGLoad",g,false)}},false)},false);return this}SVGFontElement.constructor=SVGElement;SVGFontElement.prototype=new SVGElement();function SVGGlyphElement(){SVGElement.apply(this);return this}SVGGlyphElement.constructor=SVGElement;SVGGlyphElement.prototype=new SVGElement();function SVGMissingGlyphElement(){SVGElement.apply(this);return this}SVGMissingGlyphElement.constructor=SVGElement;SVGMissingGlyphElement.prototype=new SVGElement();function SVGHKernElement(){SVGElement.apply(this);return this}SVGHKernElement.constructor=SVGElement;SVGHKernElement.prototype=new SVGElement();function SVGVKernElement(){SVGElement.apply(this);return this}SVGVKernElement.constructor=SVGElement;SVGVKernElement.prototype=new SVGElement();function SVGFontFaceElement(){SVGElement.apply(this);this._isLinked=0;this.addEventListener("DOMNodeInserted",function(a){if(a.eventPhase===Event.BUBBLING_PHASE){if(a.target.localName==="font-face-uri"){a.currentTarget._isLinked=1}return}},false);return this}SVGFontFaceElement.constructor=SVGElement;SVGFontFaceElement.prototype=new SVGElement();function SVGFontFaceSrcElement(){SVGElement.apply(this);return this}SVGFontFaceSrcElement.constructor=SVGElement;SVGFontFaceSrcElement.prototype=new SVGElement();function SVGFontFaceUriElement(){SVGElement.apply(this);this.addEventListener("DOMNodeInserted",function(a){if(a.eventPhase===Event.BUBBLING_PHASE){return}a.target.ownerDocument.documentElement._svgload_limited--;a.target.setAttributeNS("http://www.w3.org/1999/xlink","xlink:show","embed")},false);this.addEventListener("SVGLoad",function(b){var a=b.target,c=a.parentNode.parentNode.parentNode;if(c.localName==="defs"){c=a.parentNode.parentNode}a._instance._isExternal=1;c.parentNode.appendChild(a._instance);b=a=c=null},false);SVGURIReference.apply(this);return this}SVGFontFaceUriElement.constructor=SVGElement;SVGFontFaceUriElement.prototype=new SVGElement();function SVGFontFaceFormatElement(){SVGElement.apply(this);return this}SVGFontFaceFormatElement.constructor=SVGElement;SVGFontFaceFormatElement.prototype=new SVGElement();function SVGFontFaceNameElement(){SVGElement.apply(this);return this}SVGFontFaceNameElement.constructor=SVGElement;SVGFontFaceNameElement.prototype=new SVGElement();function SVGDefinitionSrcElement(){SVGElement.apply(this);return this}SVGDefinitionSrcElement.constructor=SVGElement;SVGDefinitionSrcElement.prototype=new SVGElement();function SVGMetadataElement(){SVGElement.apply(this);return this}SVGMetadataElement.constructor=SVGElement;SVGMetadataElement.prototype=new SVGElement();function SVGForeignObjectElement(){SVGElement.apply(this);this.x=new SVGAnimatedLength();this.y=new SVGAnimatedLength();this.width=new SVGAnimatedLength();this.height=new SVGAnimatedLength();return this}SVGForeignObjectElement.constructor=SVGElement;SVGForeignObjectElement.prototype=new SVGElement();DOMImplementation["http://www.w3.org/2000/svg"]={Document:SVGDocument,svg:SVGSVGElement,g:SVGGElement,path:NAIBU.SVGPathElement,title:SVGTitleElement,desc:SVGDescElement,defs:SVGDefsElement,linearGradient:SVGLinearGradientElement,radialGradient:SVGRadialGradientElement,stop:SVGStopElement,rect:SVGRectElement,circle:SVGCircleElement,ellipse:SVGEllipseElement,polyline:SVGPolylineElement,polygon:SVGPolygonElement,text:SVGTextElement,tspan:SVGTSpanElement,image:SVGImageElement,line:SVGLineElement,a:SVGAElement,altGlyphDef:SVGAltGlyphDefElement,altGlyph:SVGAltGlyphElement,altGlyphItem:SVGAltGlyphItemElement,animateColor:SVGAnimateColorElement,animate:SVGAnimateElement,animateMotion:SVGAnimateMotionElement,animateTransform:SVGAnimateTransformElement,clipPath:SVGClipPathElement,colorProfile:SVGColorProfileElement,cursor:SVGCursorElement,definitionSrc:SVGDefinitionSrcElement,feBlend:SVGFEBlendElement,feGaussianBlur:SVGFEGaussianBlurElement,filter:SVGFilterElement,font:SVGFontElement,"font-face":SVGFontFaceElement,"font-face-format":SVGFontFaceFormatElement,"font-face-name":SVGFontFaceNameElement,"font-face-src":SVGFontFaceSrcElement,"font-face-uri":SVGFontFaceUriElement,foreignObject:SVGForeignObjectElement,glyph:SVGGlyphElement,glyphRef:SVGGlyphRefElement,hkern:SVGHKernElement,marker:SVGMarkerElement,mask:SVGMaskElement,metadata:SVGMetadataElement,missingGlyph:SVGMissingGlyphElement,mpath:SVGMPathElement,script:SVGScriptElement,set:SVGSetElement,style:SVGStyleElement,"switch":SVGSwitchElement,textPath:SVGTextPathElement,tref:SVGTRefElement,use:SVGUseElement,view:SVGViewElement,vkern:SVGVKernElement,pattern:SVGPatternElement};NAIBU._fontSearchURI=function(a){var g=a.target.ownerDocument;var b=g.getElementsByTagNameNS("http://www.w3.org/2000/svg","font-face-uri");for(var e=0;e<b.length;++e){var h=b[e].getAttributeNS("http://www.w3.org/1999/xlink","href");var f=h.substring(h.indexOf("#")+1,h.length);var c=NAIBU.xmlhttp;c.open("GET",h.replace(/#.+$/,""),true);c.setRequestHeader("X-Requested-With","XMLHttpRequest");c.onreadystatechange=function(){if((c.readyState===4)&&(c.status===200)){var i=(new DOMParser()).parseFromString(c.responseText,"text/xml");NAIBU._font({document:i,docu:g,id:f});c=g=i=null}};c.send(null)}};NAIBU._font=function(h){var l=h.document,f="http://www.w3.org/2000/svg";var e=l.getElementsByTagNameNS(f,"font").item(0);var g=e.getElementsByTagNameNS(f,"font-face").item(0).getAttributeNS(null,"font-family");if(g&&(e.getAttributeNS(null,"id")===h.id)){var k=h.docu.getElementsByTagNameNS(f,"text");for(var j=0,c=k.length;j<c;++j){var b=k[j],a=h.docu.defaultView.getComputedStyle(b,"");if(a.getPropertyValue("font-family",null).indexOf(g)>-1){NAIBU._noie_createFont(b,e,false)}}}l=h=null};NAIBU._noie_createFont=function(a,R,k){var K=a.ownerDocument.defaultView.getComputedStyle(a,""),S="http://www.w3.org/2000/svg";var L=a.getAttributeNS(null,"writing-mode")||a.parentNode.getAttributeNS(null,"writing-mode"),o=L?"vert-adv-y":"horiz-adv-x";var A=a.firstChild,T,h=R.getElementsByTagNameNS(S,"glyph");var P=parseFloat(R.getElementsByTagNameNS(S,"font-face").item(0).getAttribute("units-per-em")||1000);var J=parseFloat((R.getAttributeNS(null,o)||P));var e=parseFloat(a.getAttributeNS(null,"x")||0),q=parseFloat(K.getPropertyValue("font-size")),c=parseFloat(a.getAttributeNS(null,"y")||0),D=q/P;var g=false,f=["fill","fill-opacity","stroke","stroke-width","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-dasharray","stroke-opacity","opacity","cursor"];if(k){var B="n"+Math.random();a._tar.firstChild.setAttribute("id",B);var w=document.getElementById(B);q=parseFloat(w.currentStyle.fontSize);D=q/P;B=w=null}if(/a/[-1]==="a"){g=true}else{if(k||L){g=true}}if(g){while(A){if(!h){break}T=A.data;if(T!==void 0){var V=[],H=[];for(var N=0,F=h.length;N<F;++N){var v=h[N],t=v.getAttributeNS(null,"unicode")||"なし";var u=v.getAttributeNS(null,"orientation"),Q=true,l=true;if(u){if(u==="h"){Q=false}}else{l=false}if((L&&Q)||!(L||Q)||!l){var C=T.indexOf(t);while(C>-1){V[C]=parseFloat(v.getAttributeNS(null,o)||J);H[C]=v.getAttributeNS(null,"d");C=T.indexOf(t,C+1)}}}for(var N=0,O=0;N<T.length;++N){if(V[N]!==void 0){var I=a.ownerDocument.createElementNS(S,"path");var z=a.ownerDocument.documentElement.createSVGMatrix();z.a=D;z.d=-D;for(var M=0;M<f.length;++M){var U=f[M],b=a.getAttributeNS(null,U);if(b){I.setAttributeNS(null,U,b)}}if(L){var E=c+O*D,G=e;if("、。".indexOf(T.charAt(N))>-1){var r=q/Math.SQRT2;G+=r;E-=r;r=null}z.e=G;z.f=E}else{z.e=e+O*D;z.f=c}I.setAttributeNS(null,"transform","matrix("+z.a+","+z.b+","+z.c+","+z.d+","+z.e+","+z.f+")");I.setAttributeNS(null,"d",H[N]);a.parentNode.insertBefore(I,a);O+=V[N];z=null}}O=V=H=null}else{if("tspan|a".indexOf(A.localName)>-1){NAIBU._noie_createFont(A,R,k)}}A=A.nextSibling}if(k){var K=a.ownerDocument.getOverrideStyle(a,null);K.setProperty("visibility","hidden");K=null}else{a.setAttributeNS(null,"opacity","0")}}T=L=o=P=J=e=c=q=K=S=A=null};(function(){var e=new CSSStyleDeclaration(),f=0;for(var c in CSS2Properties){if(CSS2Properties.hasOwnProperty(c)){var b=c.replace(/([A-Z])/,"-");if(!!RegExp.$1){var a="-"+RegExp.$1.toLowerCase()}else{var a="-"}b=b.replace(/\-/,a);e.setProperty(b,CSS2Properties[c]);e._list[b]=e._list[f];++f;p=m=c=b=a=null}}e._list._opacity=1;e._list._fontSize=12;CSS2Properties._list=e._list;Document.prototype.defaultView._defaultCSS=e._list;e=null})();NAIBU.addEvent=function(a,b){if(window.addEventListener){window.addEventListener(a,b,false)}else{if(window.attachEvent){window.attachEvent("on"+a,b)}else{window["on"+a]=b}}if(sieb_s){b()}};function unsvgtovml(){try{if("stop" in NAIBU){clearInterval(NAIBU.stop)}window.onscroll=NAIBU.emptyFunction;window.detachEvent("onload",NAIBU._main);Element=SVGElement=Attr=NamedNodeMap=CSS2Properties=CSSValue=CSSPrimitiveValue=NAIBU.xmlhttp=Node=Event=NAIBU=stlog=STLog=null;Array=ActiveXObject=null}catch(a){}}NAIBU._main=(function(){stlog=new STLog(false);var g;try{g=new ActiveXObject("Msxml2.XMLHTTP")}catch(o){try{g=new ActiveXObject("Microsoft.XMLHTTP")}catch(w){g=false}}if(!g){try{g=new XMLHttpRequest()}catch(o){g=false}}NAIBU.xmlhttp=g;var j;if(("namespaces" in document)&&!document.namespaces.v){NAIBU.doc=new ActiveXObject("MSXML2.DomDocument");j=NAIBU.doc;document.namespaces.add("v","urn:schemas-microsoft-com:vml");document.namespaces.add("o","urn:schemas-microsoft-com:office:office");var u=document.createStyleSheet();var q="behavior: url(#default#VML);display: inline-block;} ";u.cssText="v\\:rect{"+q+"v\\:image{"+q+"v\\:fill{"+q+"v\\:stroke{"+q+"o\\:opacity2{"+q+"dn\\:defs{display:none}v\\:group{text-indent:0px;position:relative;width:100%;height:100%;"+q+"v\\:shape{width:100%;height:100%;"+q}var h=document.getElementsByTagName("script");for(var k=0;k<h.length;++k){var r=h[k].type;if(h[k].type==="image/svg+xml"){var l=h[k].text;if(sieb_s&&l.match(/&lt;svg/)){l=l.replace(/<.+?>/g,"");l=l.replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&quot;/g,'"').replace(/&amp;/g,"&")}if(NAIBU.isMSIE){var a=new GetSVGDocument(h[k]);a.xmlhttp={readyState:4,status:200,responseText:l.replace(/\shref=/g," target='_top' xlink:href=")};a._ca()}else{var f=location.href.replace(/\/[^\/]+?$/,"/");l=l.replace(/\shref=(['"a-z]+?):\/\//g," target='_top' xlink:href=$1://").replace(/\shref=(.)/g," target='_top' xlink:href=$1"+f);var v=NAIBU.textToSVG(l,h[k].getAttribute("width"),h[k].getAttribute("height"));h[k].parentNode.insertBefore(v,h[k])}l=null}r=null}NAIBU.doc=j;j=h=null;if(g&&NAIBU.isMSIE){if(!!document.createElementNS){if(!!document.createElementNS("http://www.w3.org/2000/svg","svg").createSVGRect){}}else{var t=document.createElement("div");t.setAttribute("id","_NAIBU_outline");document.body.appendChild(t);var c=document.getElementsByTagName("object"),b=document.getElementsByTagName("embed");var k=0,v=[];for(;k<c.length;++k){v[v.length]=new GetSVGDocument(c[k])}for(k=0;k<b.length;++k){v[v.length]=new GetSVGDocument(b[k])}for(k=0;k<v.length;++k){if(k<v.length-1){v[k]._next=v[k+1]}}if(k>0){v[0]._init()}v=null}}else{var c=document.getElementsByTagName("object");for(var k=0;k<c.length;++k){if(c[k].contentDocument){NAIBU._fontSearchURI({target:{ownerDocument:c[k].contentDocument}})}else{if(c[k].getSVGDocument){c[k].getSVGDocument().documentElement.addEventListener("SVGLoad",NAIBU._fontSearchURI,false)}else{}}}}g=null});NAIBU.addEvent("load",NAIBU._main);NAIBU.utf16=function(a){return unescape(a)};NAIBU.unescapeUTF16=function(a){return a.replace(/%u\w\w\w\w/g,NAIBU.utf16)};NAIBU.textToSVG=function(f,a,c){if(navigator.userAgent.indexOf("WebKit")>-1||navigator.userAgent.indexOf("Safari")>-1){var e="data:image/svg+xml;charset=utf-8,"+NAIBU.unescapeUTF16(escape(f));var b=document.createElement("object");b.setAttribute("data",e);b.setAttribute("width",a);b.setAttribute("height",c);b.setAttribute("type","image/svg+xml");return b}else{var g=(new DOMParser()).parseFromString(f,"text/xml");return(document.importNode(g.documentElement,true))}};NAIBU.addEvent("unload",unsvgtovml);
NAIBU.isMSIE=/*@cc_on!@*/false;