﻿/*SIE-SVG without Plugin under LGPL2.1 & GPL2.0 & Mozilla Public Lisence
 *公式ページは http://sie.sourceforge.jp/
 *利用方法は <script defer="defer" type="text/javascript" src="sie.js"></script>
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Mozilla SVG Cairo Renderer project.
 *
 * The Initial Developer of the Original Code is IBM Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Parts of this file contain code derived from the following files(s)
 * of the Mozilla SVG project (these parts are Copyright (C) by their
 * respective copyright-holders):
 *    layout/svg/renderer/src/libart/nsSVGLibartBPathBuilder.cpp
 *
 * Contributor(s):DHRNAME revulo
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

//これを頭に付けたら、内部処理用
var  NAIBU = {};
//documentを速くするために
/*@cc_on  _d=document;eval('var  document=_d')@*/
//bookmarkletから呼び出されたらtrue
var sieb_s;

//svgtovml load時に、最初に起動する関数
function svgtovml() {
  var isMSIE = /*@cc_on!@*/false; //IEだったらtrueを返す
  var ary = document.getElementsByTagName("script");
  for (var i=0; i < ary.length; i++)  {//全script要素をチェックして、type属性がimage/svg+xmlならば、中身をSVGとして処理する
    var hoge = ary[i].type;
    if (ary[i].type == "image/svg+xml")  {
      var ait = ary[i].text;
      if (sieb_s && ait.match(/&lt;svg/)) {
        //ソース内のタグを除去
        ait = ait.replace(/<.+?>/g, "");
        //エンティティを文字に戻す
        ait = ait.replace(/&lt;/g, "<").replace(/&gt;/g, ">").replace(/&quot;/g, '"').replace(/&amp;/g, "&");
      }
      if (isMSIE) {
        setVMLNameSpace();
        var da = {};
        da.obj = new Array(i); da.obj[i] = ary[i]; da.num = i + 1; da.content = ait; da.success = true;
        ca(da);
      }  else{
        var s = textToSVG(ait,ary[i].getAttribute("width"),ary[i].getAttribute("height"));
        ary[i].parentNode.insertBefore(s,ary[i]);
      }
    }
  }
  if (isMSIE) {
    var st = setVMLNameSpace();
    NAIBU.STObject = new Objectembeds();
    NAIBU.STObject.next();
    success = true;
  }
}

//vmlの名前空間をセット（必須）
function setVMLNameSpace() {
  document.namespaces.add("v","urn:schemas-microsoft-com:vml");
  document.namespaces.add("o","urn:schemas-microsoft-com:office:office");
  var st = document.createStyleSheet();
  st.addRule("v\\:*","behavior: url(#default#VML);display:inline-block;font-size:12px;");//inline-blockはIEのバグ対策
  st.addRule("o\\:*","behavior: url(#default#VML);display:inline-block");
  st.addRule("dn\\:*","display:none");
  st.addRule("v\\:group", "position:relative;width:100%;height:100%;");
  st.addRule("v\\:shape", "width:100%;height:100%;");
  return st;
}

//loadイベントに関数を追加
if (window.addEventListener) {
  window.addEventListener('load', svgtovml, false);
} else if (window.attachEvent) {
  window.attachEvent('onload', svgtovml);
} else {
  window.onload = svgtovml;
}

//以下は例外処理のログをとるためのもの。開発者以外は削除すること
var  stlog = new STLog(false);
function STLog(jou) {
this.jo = jou;
if (this.jo) {
  this.p = document.createElement("div");
  this.p.innerHTML = "<h1>例外処理のログ</h1>";
  document.body.insertBefore(this.p,document.body.firstChild);
}
  return this;
}
STLog.prototype.add = function(e,code) {
if (this.jo) {
  this.p.innerHTML += "<p>"+code+":"+e.message+"</p>";
}
}

//SVGtoVML 本体。SVGDocumentの代わりを担う
//object要素の幅と高さがwとh（単位はpxに統一）。svg要素の幅と高さがswi.valueとshi.value。svg要素にwidth属性が指定されていない場合、swi.value=wである。
//progとprgはプログレスバーのスタイル情報
function SVGtoVML( /*element*/ obc, /*float*/ w, /*float*/ h, /*STLength*/ swi, /*STLength*/ shi, /*CSS2Properties */ prog, /*CSS2Properties */ prg) {
  this.obc = obc; this.w = w; this.h = h; this.swi = swi; this.shi = shi; this.prog = prog; this.prg = prg;
  return this;
}
SVGtoVML.prototype.read = function stvread() {
  obc = this.obc;
  this.rootElement = obc;
  this.rootElement.style.visibility = "hidden";
  this.vi = new STViewSpec(this.rootElement);
  this.getObject("USE", STUseElement, "use");
  try{
  this.path = new Array();
  this.rect = [];
  this.circle = [];
  this.ellipse = [];
  this.polygon = [];
  this.polyline = [];
  this.line = [];
  this.text = []; this.a = []; this.image = [];
  var sw = this.swi.value,  sh = this.shi.value;
  var mat = this.vi.set(sw,sh); //返り値はMatrix型
  this.chset(obc,mat);
  } catch(n) {stlog.add(n,109);}
}
SVGtoVML.prototype.getObject = function stvgetob( /*string*/ tag, /*object*/ st, /*string*/nodes) {
  try {
  var li = this.rootElement.getElementsByTagName(tag);
  var la = new Array();
  for (var i=0,lli=li ? li.length : 0;i<lli;i++) {
    la[i] = new st(li[i]);
  }
  this[nodes] = la;
  } catch(e) {stlog.add(e,129);
    this[nodes] = new Array();
  }
}
SVGtoVML.prototype.set = function stvset() {
  var w = this.w, h = this.h, c = this.circle,  r = this.rect,  s = this.path,  l = this.line,  text = this.text,  el = this.ellipse,  pg = this.polygon,  pl = this.polyline,  a = this.a,  lin = this.line, imag = this.image;
  var sw = this.swi.value,  sh = this.shi.value;
  try {
  } catch(e) {stlog.add(e,1109);}
  try {
  this.setObject(this.use,sw,sh);
  this.setObject(s,sw,sh);
  this.setObject(c,sw,sh);
  this.setObject(r,sw,sh);
  this.setObject(el,sw,sh);
  this.setObject(pg,sw,sh);
  this.setObject(pl,sw,sh);
  this.setObject(lin,sw,sh);
  this.setObject(imag,sw,sh);
  this.setObject(text,sw,sh);
  this.setObject(a,sw,sh);
  var backr = document.createElement("v:rect"); //背景の作成
  backr.style.position = "absolute";
  backr.style.width = w;
  backr.style.height = h;
  backr.style.zIndex = -1;
  backr.setAttribute("stroked","false");
  backr.setAttribute("filled","false");
  this.rootElement.parentNode.appendChild(backr);
  var trstyle = this.rootElement.style;
  var tpstyle = this.rootElement.parentNode.style;
  trstyle.visibility = "visible";
  //以下、画像を切り取り
  trstyle.overflow = "hidden";
  var backrs = backr.currentStyle;
  var viewWidth = w > sw ? sw : w;
  var viewHeight = h > sh ? sh : h;
  var backright = parseFloat(backrs.left) + viewWidth + 1;
  var backdown = parseFloat(backrs.top) + viewHeight + 1;
  trstyle.clip = "rect(" +backrs.top+ " " +backright+ "px " +backdown+ "px " +backrs.left+ ")";
  tpstyle.left = -parseFloat(backrs.left);
  tpstyle.top = -parseFloat(backrs.top);
  } catch(e) {stlog.add(e,138);}
}
SVGtoVML.prototype.setObject = function stvsetob( /*SVGElement*/ arr, /*float*/ sw, /*float*/ sh) {
  try {
  for (var i=0,arri=arr.length;i<arri;i++) {
    try {
      arr[i].set(sw,sh);
    } catch(ee){}
  }
  } catch(e) {stlog.add(e,170);}
}

//chset childNodesで要素を作成していく
SVGtoVML.prototype.chset = function( /*element*/ ele, /*Matrix*/ matrix){
  var nods = ele.childNodes;
  var name = new RegExp("^(group|shape|defs|STOP|fill|stroke|DIV|SPAN|A|image|rect|USE)$");
  var cmatrix = matrix; //子要素に継がせるCTM
  for (var i=0,nodesli=nods.length;i<nodesli;i++) {
  try{
    var te = nods[i];
    if (!te.nodeName.match(name)) {
      ele.removeChild(te);
      i--; nodesli--;
    } else {
      if (te.nodeType == 1) { //要素ならば
        if (te.nodeName == "shape") {
          switch (te.getAttribute("tag")) {
            case "path":
              this.path[this.path.length] = new STPath(te, matrix);
            break;
            case "rect":
              this.rect[this.rect.length] = new STRectElement(te, matrix);
            break;
            case "circle":
              this.circle[this.circle.length] = new STCircle(te, matrix);
            break;
            case "ellipse":
              this.ellipse[this.ellipse.length] = new STEllipse(te, matrix);
            break;
            case "polyline":
              this.polyline[this.polyline.length] = new STPolyline(te, matrix);
            break;
            case "polygon":
              this.polygon[this.polygon.length] = new STPolygon(te, matrix);
            break;
            case "line":
              this.line[this.line.length] = new STLine(te, matrix);
            break;
          }
        } else if (te.nodeName == "DIV") {
          this.text[this.text.length] = new STText(te, matrix);
        } else if (te.nodeName == "group") {
          cmatrix = matrix.multiply((new TransformList(te)).tr.matrix); //g要素のtransform属性を前もって処理
        } else if (te.nodeName == "A") {
          this.a[this.a.length] = new STAElement(te, matrix);
          cmatrix = this.a[this.a.length-1].transformable.tr.matrix;
        } else if (te.nodeName == "image") {
          this.image[this.image.length] = new STImage(te, matrix);
        }
        if (!te.nodeName.match(/^(DIV|SPAN)$/)) {
          this.chset(te, cmatrix);
        }
      }
    }
  } catch(e){stlog.add(e,3002);}
  }
}

//object要素とembed要素の取得を総括して行う
function Objectembeds(){
  this.obj = document.getElementsByTagName("object") || {length:0};
  this.emd = document.getElementsByTagName("embed") || {length:0};
  this.onumber = this.enumber = 0;
  return this;
}
Objectembeds.prototype.next = function(){
  try{
  if (this.onumber < this.obj.length) { //object要素の読み込みをまず行う
    var n = this.onumber;
    this.onumber++;
    if (!"getSVGDocument" in this.obj[n]) {this.obj[n].getSVGDocument = function() {return STdocument[n];}}//object要素にgetSVGDocumentメソッドをつける(for IE)
    try {
      getURL(this.obj[n].getAttribute("data"),object_ca,this.obj,n+1); //data属性をロード
    } catch(e) {stlog.add(e,177);this.next();}
  } else if (this.enumber < this.emd.length) { //object要素が終われば、次にembed要素の読み込み
    var n = this.onumber+this.enumber
    this.enumber++;
    if (!"getSVGDocument" in this.emd[n]) {this.emd[n].getSVGDocument = function() {return STdocument[n];}}
      try {
        getURL(this.emd[n].src,embed_ca,this.emd,n+1);
      } catch(e) {stlog.add(e,185);this.next();}
  }
  } catch(e) {stlog.add(e,293);this.onumber++;this.next();}
}

//a要素の処理
function STAElement( /*element*/ a, /*Matrix*/ matrix) {
  this.xlink = new NAIBU.XLink(a);
  this.target = a.getAttribute("target");
  this.transformable = new TransformList(a);
  this.transformable.rmultiply(matrix);
  return this;
}
STAElement.prototype.set = function aset() {
  try {
    var t = this.target;
    var st = "replace";
    if (t == "_blank") {
      st = "new";
    }
    this.xlink.tar.setAttribute("xlink:show",st);
    this.xlink.set();
    var txts = this.xlink.tar.style;
    txts.cursor = "hand";
    txts.left = 0;
    txts.top = 0;
    txts.textDecoration = "none";
    var txt = this.xlink.tar.getElementsByTagName("div");
    for (var i=0,txti=txt.length;i<txti;i++) {
      var ts = txt[i].style;
      ts.marginLeft = -parseFloat(ts.fontSize);
      ts.cursor = "hand";
    }
  }  catch(e) {stlog.add(e,204);}
}

//text要素の処理
function STText( /*element*/ te, /*Matrix*/ matrix) {
  this.tar = te;
  var x = te.getAttribute("x");
  var y = te.getAttribute("y");
  this.paint = new NAIBU.FontStyle(te);
  this.transformable = new TransformList(te);
  this.transformable.rmultiply(matrix);
  try { //子要素のtspan要素を処理
    var li = this.tar.getElementsByTagName("SPAN");
    var lli = li.length;
    var l = new Array(lli);
    for (var i=0,lli=li.length;i<lli;i++) {
      l[i] = new STTSpanElement(li[i],x,y,this.transformable.tr.matrix);
    }
    this.tspan = l;
    this.x = x || 0; this.y = y || 0;
  } catch(e) {stlog.add(e,129264);}
  return this;
}
STText.prototype.set = function textset( /*float*/ w, /*float*/ h) {
  try {
  var ttm = this.transformable.tr.matrix;
  var p = new Point(parseFloat(this.x),parseFloat(this.y));
  var ptm = p.matrixTransform(ttm);
  var tts = this.tar.style;
  tts.position = "absolute";
  var backr = document.createElement("v:rect");
  var backrs = backr.style; //ずれを修正するためのもの
  backrs.width = 1;
  backrs.height = 1;
  backrs.left = 0;
  backrs.top = 0;
  backr.setAttribute("stroked", "false");
  backr.setAttribute("filled", "false");
  var ttp = this.tar.parentNode;
  if (ttp.lastChild.nodeName != "rect") {
    ttp.appendChild(backr);
  }
  tts.left = ptm.x;
  tts.top = ptm.y;
  tts.width = 0;
  tts.height = 0;
  this.paint.fset(this.tar,w,h,ttm)
  } catch(e) {stlog.add(e,236);}
  try {
    var arr = this.tspan;
    for (var i=0,arri=arr.length;i<arri;i++) {
      arr[i].set(ttm);
    }
  } catch(e) {stlog.add(e,2831);}
}
//fontset フォントの大きさを幅と高さを使ってpx単位に変換
function fontset( /*float*/ f, /*float*/ w, /*float*/ h, /*Matrix*/ ttm) {
  try {
  var sw = new STLength(f, Math.sqrt((w*w + h*h) / 2));
  var swx = sw.value * Math.sqrt(Math.abs(ttm.determinant()));
  } catch(e) {stlog.add(e,282);swx=f;}
  return swx;
}

//span要素の処理
function STTSpanElement( /*element*/ ele, /*float*/ x, /*float*/ y, /*Matrix*/ matrix) {
  this.tar = ele;
  this.x = parseFloat(ele.getAttribute("x") || x || 0);
  this.y = parseFloat(ele.getAttribute("y") || y || 0);
  this.fs = ele.getAttribute("fontSize") || ele.style.fontSize || ele.currentStyle.fontSize;
  this.paint = new NAIBU.PaintColor(ele);
  this.transformable = new TransformList(ele);
  this.transformable.rmultiply(matrix);
  return this;
}
STTSpanElement.prototype.set = function( /*Matrix*/ matrix) {
  try {
  var p = new Point(this.x, this.y);
  var ptm = p.matrixTransform(matrix);
  var tts = this.tar.style;
  tts.position = "absolute";
  tts.left = ptm.x - parseFloat(this.tar.parentNode.style.left);
  tts.top = ptm.y - parseFloat(this.tar.parentNode.style.top);// - parseFloat(this.fs);
  tts.whiteSpace = "nowrap";
  tts.color = this.paint.fill;
  } catch(e) {stlog.add(e,304);}
}

//line要素の処理
function STLine( /*element*/ li, /*Matrix*/ matrix) {
  this.tar = li;
  this.x1 = parseFloat(li.getAttribute("x1") || 0);
  this.y1 = parseFloat(li.getAttribute("y1") || 0);
  this.x2 = parseFloat(li.getAttribute("x2") || 0);
  this.y2 = parseFloat(li.getAttribute("y2") || 0);
  this.paint = new NAIBU.PaintColor(li);
  this.transformable = new TransformList(li);
  this.transformable.rmultiply(matrix);
  return this;
}
STLine.prototype.set = function lineset(w,h) {
  try {
    var ttm = this.transformable.tr.matrix;
    var list = ["m", this.x1, this.y1, "l", this.x2, this.y2];
    var pl = new PList(list);
    var plm = pl.matrixTransform(ttm);
    var dat = plm.list.join(" ");
    var ele = this.tar;
    ele.setAttribute("path", dat);
    ele.setAttribute("coordsize", w + " " + h);
    this.paint.set(ele, w, h, ttm);
  } catch(e) {stlog.add(e,257);}
}

//path要素の処理
function STPath( /*element*/ ele, /*Matrix*/ matrix) {
  this.tar = ele;
  this.d = ele.getAttribute("d");
  this.paint = new NAIBU.PaintColor(ele);
  this.transformable = new TransformList(ele);
  this.transformable.rmultiply(matrix);
  return this;
}
STPath.prototype.set = function shapeset( /*float*/ w, /*float*/ h) {
  var dat;
  try {
    var dd = this.d
      .replace(/\s*([A-DF-Z])/gi, '],["$1" ') //convert to JSON array
      .replace(/^\],/, "[")
      .replace(/\s*$/, "]]")
      .replace(/[\s,]{2,}|\s/g, ",")
      .replace(/([\d.])-/g, "$1,-");
    var D = eval('('+dd+')'); //ここまでd属性のパーサ
    var ttm = this.transformable.tr.matrix;
    var G = new Array();
    var preCom;
    var x = 0, y = 0;   //現在の点の絶対座標
    var x0 = 0, y0 = 0; //subpath の始点の絶対座標
    var dx = 0, dy = 0;
    for (var i = 0, Dli = D.length; i < Dli; i++) {
      var F = D[i];
      var com = F[0].toLowerCase(); //F[0]の値はコマンド文字
      var rel = (com == F[0]);      //相対座標のコマンドならtrue
      if (com == "z") {
        F = ["x"];
        x = x0; y = y0;
      } else if (com == "a") { //ArcTo
        F[0] = "c";
        preCom = com;
        var relx = 0, rely = 0;
        if (rel) {
          relx = x; rely = y;
        }
        var ar = new STArc();
        ar.sset(x, y, F, relx, rely);
        x = F[F.length-2] + relx;
        y = F[F.length-1] + rely;
        var pl = new PList(ar.D);
        var plm = pl.matrixTransform(ttm);
        F = ["c"].concat(plm.list);
        if (F.length == 8) {
          F[7] = "";
        }
      } else {
        var rx = x, ry = y;
        if (rel) {
          rx = ry = 0;
        }
        switch (com) {
          case "h": F = ["l", F[F.length-1], ry];
          break;
          case "v": F = ["l", rx, F[F.length-1]];
          break;
          case "s": F[0] = "c"; if (preCom != "c") {dx = dy = 0;} F = NAIBU.nst(6, F, rx + dx, ry + dy);
          break;
          case "t": F[0] = "q"; if (preCom != "q") {dx = dy = 0;} F = NAIBU.nst(4, F, rx + dx, ry + dy);
          break;
          default:  F[0] = com; //"M", "L", "C", "Q" は小文字に変換
        }
        if (rel) {
          F = NAIBU.reltoabs(x, y, F); //絶対座標に変換
        }
        preCom = com = F[0];
        if (com == "c" || com == "q") {
          dx = F[F.length-2] - F[F.length-4];
          dy = F[F.length-1] - F[F.length-3];
        }
        if (com == "q") {
          F = NAIBU.qtoc(x, y, F); //二次ベジェは三次ベジェに変換
        }
        if (com == "m") {
          x0 = F[1]; y0 = F[2]; //subpath の始点を記憶
        }
        var Fli = F.length;
        x = F[Fli-2];
        y = F[Fli-1];
        for (var j = 1; j < Fli; j += 2) { //CTMで座標変換
          var _x = parseInt(ttm.a * F[j] + ttm.c * F[j+1] + ttm.e);
          var _y = parseInt(ttm.b * F[j] + ttm.d * F[j+1] + ttm.f);
          if (-1 < _x && _x < 1) {_x=1;}
          if (-1 < _y && _y < 1) {_y=1;}
          F[j]   = _x;
          F[j+1] = _y;
        }
        if (com == "m" && Fli > 3) { //MoveToが複数の座標ならば、2番目以降の座標ペアをLineToとして処理
          F.splice(3, 0, "l");
        }
      }
      G[i] = F.join(" ");
      F = null;
    }
    dat = G.join(" ");
  } catch(e) {if(this.d == ""){/*d属性が空*/}else{stlog.add(e,355);}}
  try {
    var ele = this.tar;
    ele.setAttribute("path", dat + " e");
    ele.setAttribute("coordsize", w + " " + h);
    this.paint.set(ele, w, h, ttm);
  } catch(e) {stlog.add(e,372);}
}

//QからCに変換
NAIBU.qtoc = function (/*float*/ x, /*float*/ y, /*Array*/ F) {
  F[0] = "c";
  for (var i = 1; i < F.length; i += 6) {
    var x1 = F[i], y1 = F[i+1], x2 = F[i+2], y2 = F[i+3];
    F.splice(i, 2, (x + 2 * x1) / 3, (y + 2 * y1) / 3, (2 * x1 + x2) / 3, (2 * y1 + y2) / 3);
    x = x2; y = y2;
  }
  return F;
}

//前回の座標を反転させる。それを挿入
NAIBU.nst = function ( /*int*/ skip, /*Array*/ F, /*float*/ x1, /*float*/ y1) {
  F.splice(1, 0, x1, y1);
  for (var i = skip+1; i < F.length; i += skip) {
    x1 = 2 * F[i-2] - F[i-4];
    y1 = 2 * F[i-1] - F[i-3];
    F.splice(i, 0, x1, y1);
  }
  return F;
}

//相対座標を絶対座標に変換
NAIBU.reltoabs = function (/*float*/ x, /*float*/ y, /*Array*/ F) {
  var skip = 2;
  if (F[0] == "c") { 
    skip = 6;
  } else if (F[0] == "q") {
    skip = 4;
  }
  for (var i = 1, Fli = F.length; i < Fli; i += 2) {
    F[i] += x; F[i+1] += y;
    if ((i+1) % skip == 0) {
      x = F[i]; y = F[i+1];
    }
  }
  return F;
}

//polygon要素を処理
function STPolygon( /*element*/ ele, /*Matrix*/ matrix) {
  this.tar = ele;
  this.points = ele.attributes["points"].nodeValue;
  this.paint = new NAIBU.PaintColor(ele);
  this.transformable = new TransformList(ele);
  this.transformable.rmultiply(matrix);
  return this;
}
STPolygon.prototype.set = function polygonset(w,h) {
  var dat;
  var ttm = this.transformable.tr.matrix;
  try {
    var F = this.points.replace(/^\s+|\s+$/g, "").split(/[\s,]+/);
    var pl = new PList(F);
    var plm = pl.matrixTransform(ttm);
    plm.list.splice(2, 0, "l");
    dat = "m" + plm.list.join(" ") + "x e";
  } catch(e) {stlog.add(e,395);}
  try {
    var ele = this.tar;
    ele.setAttribute("path", dat);
    ele.setAttribute("coordsize", w + " " + h);
    this.paint.set(ele, w, h, ttm);
  } catch(e) {stlog.add(e,406);}
}

//polyline要素を処理
function STPolyline( /*element*/ ele, /*Matrix*/ matrix) {
  this.tar = ele;
  this.points = ele.attributes["points"].nodeValue;
  this.paint = new NAIBU.PaintColor(ele);
  this.transformable = new TransformList(ele);
  this.transformable.rmultiply(matrix);
  return this;
}
STPolyline.prototype.set = function polylineset(w,h) {
  var dat;
  var ttm = this.transformable.tr.matrix;
  try {
    var F = this.points.replace(/^\s+|\s+$/g, "").split(/[\s,]+/);
    var pl = new PList(F);
    var plm = pl.matrixTransform(ttm);
    plm.list.splice(2, 0, "l");
    dat = "m" + plm.list.join(" ") + "e";
  } catch(e) {stlog.add(e,429);}
  try {
    var ele = this.tar;
    ele.setAttribute("path", dat);
    ele.setAttribute("coordsize", w + " " + h);
    this.paint.set(ele, w, h, ttm);
  } catch(e) {stlog.add(e,440);}
}

//circle要素を処理
function STCircle( /*element*/ ele, /*Matrix*/ matrix) {
  this.tar = ele;
  try {
    this.cx = parseFloat(ele.getAttribute("cx") || 0);
    this.cy = parseFloat(ele.getAttribute("cy") || 0);
    this.r = parseFloat(ele.getAttribute("r"));
    this.paint = new NAIBU.PaintColor(ele);
    this.transformable = new TransformList(ele);
    this.transformable.rmultiply(matrix);
  } catch(e) {stlog.add(e,450);}
  return this;
}
//ベジェ曲線で円を表現する
STCircle.prototype.set = function ovalset(w,h) {
  var cx = this.cx, cy = this.cy, rx = ry = this.r;
  var top = cy - ry, left = cx - rx, bottom = cy + ry, right = cx + rx;
  try {
  var ttm = this.transformable.tr.matrix;
  var rrx = rx * 0.55228, rry = ry * 0.55228;
  var list = ["m", cx,top, "c", cx-rrx,top, left,cy-rry, left,cy, left,cy+rry, cx-rrx,bottom, cx,bottom, cx+rrx,bottom, right,cy+rry, right,cy, right,cy-rry, cx+rrx,top, cx,top, "x e"];
  var pl = new PList(list);
  var plm = pl.matrixTransform(ttm);
  var dat = plm.list.join(" ");
  } catch(e) {stlog.add(e,468);}
  try {
    var ele = this.tar;
    ele.setAttribute("path", dat);
    ele.setAttribute("coordsize", w + " " + h);
    this.paint.set(ele, w, h, ttm);
  } catch(e) {stlog.add(e,479);}
}

//ellipse要素を処理
function STEllipse( /*element*/ ele, /*Matrix*/ matrix) {
  this.tar = ele;
  try {
    this.cx = parseFloat(ele.getAttribute("cx") || 0);
    this.cy = parseFloat(ele.getAttribute("cy") || 0);
    this.rx = parseFloat(ele.getAttribute("rx"));
    this.ry = parseFloat(ele.getAttribute("ry"));
    this.paint = new NAIBU.PaintColor(ele);
    this.transformable = new TransformList(ele);
    this.transformable.rmultiply(matrix);
  } catch(e) {stlog.add(e,490);}
  return this;
}
STEllipse.prototype.set = function elliset(w,h) {
  var cx = this.cx, cy = this.cy, rx = this.rx, ry = this.ry;
  var top = cy - ry, left = cx - rx, bottom = cy + ry, right = cx + rx;
  try {
  var ttm = this.transformable.tr.matrix;
  var rrx = rx * 0.55228, rry = ry * 0.55228;
  var list = ["m", cx,top, "c", cx-rrx,top, left,cy-rry, left,cy, left,cy+rry, cx-rrx,bottom, cx,bottom, cx+rrx,bottom, right,cy+rry, right,cy, right,cy-rry, cx+rrx,top, cx,top, "x e"];
  var pl = new PList(list);
  var plm = pl.matrixTransform(ttm);
  var dat = plm.list.join(" ");
  } catch(e) {stlog.add(e,508);}
  try {
    var ele = this.tar;
    ele.setAttribute("path", dat);
    ele.setAttribute("coordsize", w + " " + h);
    this.paint.set(ele, w, h, ttm);
  } catch(e) {stlog.add(e,519);}
}

//rect要素を処理
function STRectElement( /*element*/ rect, /*Matrix*/ matrix) {
  this.tar = rect;
  try {
    this.x = parseFloat(rect.getAttribute("x") || 0);
    this.y = parseFloat(rect.getAttribute("y") || 0);
    this.width = parseFloat(rect.getAttribute("svgwidth"));
    this.height = parseFloat(rect.getAttribute("svgheight"));
    if (rect.getAttribute("rx") || rect.getAttribute("ry")) {
      this.rx = parseFloat(rect.getAttribute("rx") || rect.getAttribute("ry"));
      this.ry = parseFloat(rect.getAttribute("ry") || rect.getAttribute("rx"));
      if (this.rx > this.width / 2) { //rx属性が幅より大きければ、幅の半分を属性に設定
        this.rx = this.width / 2;
      }
      if (this.ry > this.height / 2) {
        this.ry = this.height / 2;
      }
    }
  } catch(oe) {stlog.add(oe,541);}
  try {
    this.paint = new NAIBU.PaintColor(rect);
    this.transformable = new TransformList(rect);
    this.transformable.rmultiply(matrix);
  } catch(ee) {stlog.add(ee,545);}
  return this;
}
STRectElement.prototype.set = function rectset(w,h) {
  try {
    var x = this.x, y = this.y, xw = x + this.width, yh = y + this.height;
    var list;
    if (this.rx) {
      var rx = this.rx, ry = this.ry;
      var rrx = rx * 0.55228, rry = ry * 0.55228;
      var a = xw - rx, b = x + rx, c = y + ry, d = yh - ry;
      list = ["m",b,y, "l",a,y, "c",a+rrx,y,xw,c-rry,xw,c, "l",xw,d, "c",xw,d+rry,a+rrx,yh,a,yh, "l",b,yh, "c",b-rrx,yh,x,d+rry,x,d, "l",x,c, "c",x,c-rry,b-rrx,y,b,y];
    } else {
      list = ["m",x,y, "l",x,yh, xw,yh, xw,y, "x e"];
    }
    var ttm = this.transformable.tr.matrix;
    var pl = new PList(list);
    var plm = pl.matrixTransform(ttm);
    var dat = plm.list.join(" ");
  } catch(e) {stlog.add(e,564);}
  try {
    var ele = this.tar;
    ele.setAttribute("path", dat);
    ele.setAttribute("coordsize", w + " " + h);
    this.paint.set(ele, w, h, ttm);
  } catch(ee) {stlog.add(ee,576);}
}

//image要素の処理
function STImage( /*element*/ ele, /*Matrix*/ matrix){
  this.tar = ele;
  this.x = parseFloat(ele.getAttribute("x") || 0);
  this.y = parseFloat(ele.getAttribute("y") || 0);
  this.width = parseFloat(ele.getAttribute("svgwidth"));
  this.height = parseFloat(ele.getAttribute("svgheight"));
  ele.setAttribute("xlink:show", "embed");
  this.xlink = new NAIBU.XLink(ele);
  this.paint = new NAIBU.PaintColor(ele, this.width, this.height);
  this.transformable = new TransformList(ele);
  this.transformable.rmultiply(matrix);
  return this;
}
STImage.prototype.set = function imagesets(w,h){
  try {
    var ttm = this.transformable.tr.matrix;
    var ts = this.tar.style;
    ts.position = "absolute";
    var pt = new Point(this.x, this.y);
    var ptt = pt.matrixTransform(ttm);
    ts.left = ptt.x;
    ts.top =  ptt.y;
    ts.width = this.width * ttm.a;
    ts.height = this.height * ttm.d;
    if (ttm.b != 0 || ttm.c != 0 || this.paint.fillopacity != 1) {//フィルター　プロパティを使うと、PNGの透過性がなくなるので注意
      ts.filter = "progid:DXImageTransform.Microsoft.Matrix progid:DXImageTransform.Microsoft.Alpha";
      var ttfi = this.tar.filters.item('DXImageTransform.Microsoft.Matrix');
      ttfi.M11 = 1;
      ttfi.M12 = ttm.b;
      ttfi.M21 = ttm.c;
      ttfi.M22 = 1;
      ttfi.sizingMethod = "auto expand";
      var ttfia = this.tar.filters.item('DXImageTransform.Microsoft.Alpha');
      ttfia.Style = 0;
      ttfia.Opacity = parseFloat(this.paint.fillopacity)*100;
    }
    this.xlink.set();
  } catch(e) {stlog.set(e,21896);}
}

/*use要素の処理*/
function STUseElement( /*element*/ ele){
  this.tar = ele;
  var tns = ele.nextSibling;
  tns.setAttribute("xlink:show", "embed")
  this.x = parseFloat(tns.getAttribute("x") || 0);
  this.y = parseFloat(tns.getAttribute("y") || 0);
  this.width = tns.getAttribute("svgwidth");
  this.height = tns.getAttribute("svgheight");
  this.xlink = new NAIBU.XLink(tns);
  var ts = tns.getAttribute("transform") || "";
  this.xlink.set();
  tns.setAttribute("transform", ts+ " translate(" +this.x+ "," +this.y+ ")");
  tns.firstChild.setAttribute("id","");
  tns.setAttribute("coordorgin","0  0");
  this.paint = new NAIBU.PaintColor(this.xlink.resource);
  this.paint.tar = tns;
  return this;
}
STUseElement.prototype.set = function(){
  try {
    this.paint.setStyle();
  } catch(e) {stlog.set(e,85436);}
}

//色のキーワード
//PaintColor 色、線などをすべてコントロール
NAIBU.PaintColor = function( /*element*/ ele, /*float*/ w, /*float*/ h) {
if (ele) {
  this.tar = ele;
  var defaults = this.defaults;
  var parent = this.getParent(ele); //親要素のPaintColorオブジェクト
  if (parent) {
    for (var name in defaults) {
      if (name == "opacity") {
        this[name] = (this.getAttribute(name) || 1) * parent[name]; //親要素のopacityを掛け合わせる
      } else {
        this[name] = this.getAttribute(name) || parent[name]; //指定がなければ親要素の値を継承
        if(this[name] == "inherit") { //値がinheritなら親のを継承
          this[name] = parent[name];
        }
      }
    }
  } else {
    for (var name in defaults) {
      this[name] = this.getAttribute(name) || defaults[name]; //指定がなければデフォルト値に設定
    }
  }
}
  return this;
}
//デフォルト値のリスト
NAIBU.PaintColor.prototype.defaults = {
  fill: "black",
  fillopacity: 1,
  stroke: "none",
  strokewidth: "1",
  strokelinecap: "butt",
  strokelinejoin: "miter",
  strokemiterlimit: "4",
  strokedasharray: "none",
  strokeopacity: 1,
  opacity: 1,
  cursor: "default"
};
//キャッシュ用
NAIBU.PaintColor.prototype.cache = {};
//親コンテナ要素のPaintColorオブジェクトを返す
NAIBU.PaintColor.prototype.getParent = function( /*element*/ ele) {
  var parent = ele.parentNode;
  if (parent.tagName != "group" && parent.tagName != "A") {
    return null;
  } else {
    var cache = this.cache;
    var id = parent.uniqueID;
    if (!cache[id]) {
      cache[id] = new NAIBU.PaintColor(parent);
    }
    return cache[id];
  }
}
NAIBU.PaintColor.prototype.getAttribute = function pcgetAttribute( /*string*/ name) {
  try {
    var element = this.tar;
    var style = element.style[name];
    if (style) {
      return style;
    }
    var attribute = element.attributes[name];
    var s = attribute ? attribute.nodeValue : null;
    return s;
  } catch(e) {stlog.add(e,659); return null;}
}
//内部プロパティを、styleに設定する
NAIBU.PaintColor.prototype.setStyle = function() {
  try {
    var tst = this.tar
    for (var i in this) {
      if ((typeof this[i]) == "string") { //string型以外は除く
        tst.style[name] = this[i];
      }
    }
  } catch(e) {stlog.add(e,899); return "";}
}
NAIBU.PaintColor.prototype.set = function pcset( /*element*/ el, /*float*/ w, /*float*/ h, /*Matrix*/ matrix) {
  if (this.fill == "none") {
    el.setAttribute("filled", "false");
  } else {
    var fillElement = document.createElement("v:fill");
    try {
    if (this.fill.match(/url\(#([^)]+)/)) { //fill属性の値がurl(#id)ならば、idを設定したグラデーション関連要素を呼び出す
      this.gradient(fillElement, RegExp.$1);
    } else {
      fillElement.setAttribute("color", this.color(this.fill));
      var fillOpacity = this.fillopacity * this.opacity; //opacityを掛け合わせる
      if (fillOpacity < 1) {
        fillElement.setAttribute("opacity", fillOpacity);
      }
    }
    } catch(e) {stlog.add(e,682); fillElement.setAttribute("on", "true");
    fillElement.setAttribute("color", "black");}
    el.appendChild(fillElement);
  }
  if (this.stroke == "none") {
    el.setAttribute("stroked", "false");
  } else {
    var strokeElement = document.createElement("v:stroke");
    try {
    var sw = new STLength(this.strokewidth, Math.sqrt((w*w + h*h) / 2));
    var swx = sw.value * Math.sqrt(Math.abs(matrix.determinant()));
    strokeElement.setAttribute("weight", swx + "px");
    if (this.stroke.match(/url\(#([^)]+)/)) {
      this.gradient(strokeElement, RegExp.$1);
    } else {
      strokeElement.setAttribute("color", this.color(this.stroke));
      var strokeOpacity = this.strokeopacity * this.opacity; //opacityを掛け合わせる
      if (swx < 1) {
        strokeOpacity *= swx; //太さが1px未満なら色を薄くする
      }
      if (strokeOpacity < 1) {
        strokeElement.setAttribute("opacity", strokeOpacity);
      }
    }
    strokeElement.setAttribute("miterlimit", this.strokemiterlimit);
    strokeElement.setAttribute("joinstyle", this.strokelinejoin);
    if (this.strokelinecap == "butt") {
      strokeElement.setAttribute("endcap", "flat");
    } else {
      strokeElement.setAttribute("endcap", this.strokelinecap);
    }
    var tsd = this.strokedasharray;
    if (tsd != "none") {
      if (tsd.indexOf(",") > 0) { //コンマ区切りの文字列の場合
        var strs = tsd.split(",");
        for (var i = 0, sli = strs.length; i < sli; i++) {
          strs[i] = Math.ceil(parseFloat(strs[i]) / parseFloat(this.strokewidth)); //精密ではないので注意
        }
        this.strokedasharray = strs.join(" ");
        if (strs.length % 2 == 1) {
          this.strokedasharray += " " + this.strokedasharray;
        }
      }
      strokeElement.setAttribute("dashstyle", this.strokedasharray);
    }
    } catch(e) {stlog.add(e,720); strokeElement.setAttribute("on", "false");}
    el.appendChild(strokeElement);
  }
  if (this.cursor != "default") {
    this.tar.style.cursor = this.cursor;
  }
}
//色キーワード
NAIBU.PaintColor.prototype.keywords = {
  aliceblue: "#F0F8FF",
  antiquewhite: "#FAEBD7",
  aquamarine: "#7FFFD4",
  azure: "#F0FFFF",
  beige: "#F5F5DC",
  bisque: "#FFE4C4",
  blanchedalmond: "#FFEBCD",
  blueviolet: "#8A2BE2",
  brown: "#A52A2A",
  burlywood: "#DEB887",
  cadetblue: "#5F9EA0",
  chartreuse: "#7FFF00",
  chocolate: "#D2691E",
  coral: "#FF7F50",
  cornflowerblue: "#6495ED",
  cornsilk: "#FFF8DC",
  crimson: "#DC143C",
  cyan: "#00FFFF",
  darkblue: "#00008B",
  darkcyan: "#008B8B",
  darkgoldenrod: "#B8860B",
  darkgray: "#A9A9A9",
  darkgreen: "#006400",
  darkgrey: "#A9A9A9",
  darkkhaki: "#BDB76B",
  darkmagenta: "#8B008B",
  darkolivegreen: "#556B2F",
  darkorange: "#FF8C00",
  darkorchid: "#9932CC",
  darkred: "#8B0000",
  darksalmon: "#E9967A",
  darkseagreen: "#8FBC8F",
  darkslateblue: "#483D8B",
  darkslategray: "#2F4F4F",
  darkslategrey: "#2F4F4F",
  darkturquoise: "#00CED1",
  darkviolet: "#9400D3",
  deeppink: "#FF1493",
  deepskyblue: "#00BFFF",
  dimgray: "#696969",
  dimgrey: "#696969",
  dodgerblue: "#1E90FF",
  firebrick: "#B22222",
  floralwhite: "#FFFAF0",
  forestgreen: "#228B22",
  gainsboro: "#DCDCDC",
  ghostwhite: "#F8F8FF",
  gold: "#FFD700",
  goldenrod: "#DAA520",
  grey: "#808080",
  greenyellow: "#ADFF2F",
  honeydew: "#F0FFF0",
  hotpink: "#FF69B4",
  indianred: "#CD5C5C",
  indigo: "#4B0082",
  ivory: "#FFFFF0",
  khaki: "#F0E68C",
  lavender: "#E6E6FA",
  lavenderblush: "#FFF0F5",
  lawngreen: "#7CFC00",
  lemonchiffon: "#FFFACD",
  lightblue: "#ADD8E6",
  lightcoral: "#F08080",
  lightcyan: "#E0FFFF",
  lightgoldenrodyellow: "#FAFAD2",
  lightgray: "#D3D3D3",
  lightgreen: "#90EE90",
  lightgrey: "#D3D3D3",
  lightpink: "#FFB6C1",
  lightsalmon: "#FFA07A",
  lightseagreen: "#20B2AA",
  lightskyblue: "#87CEFA",
  lightslategray: "#778899",
  lightslategrey: "#778899",
  lightsteelblue: "#B0C4DE",
  lightyellow: "#FFFFE0",
  limegreen: "#32CD32",
  linen: "#FAF0E6",
  magenta: "#FF00FF",
  mediumaquamarine: "#66CDAA",
  mediumblue: "#0000CD",
  mediumorchid: "#BA55D3",
  mediumpurple: "#9370DB",
  mediumseagreen: "#3CB371",
  mediumslateblue: "#7B68EE",
  mediumspringgreen: "#00FA9A",
  mediumturquoise: "#48D1CC",
  mediumvioletred: "#C71585",
  midnightblue: "#191970",
  mintcream: "#F5FFFA",
  mistyrose: "#FFE4E1",
  moccasin: "#FFE4B5",
  navajowhite: "#FFDEAD",
  oldlace: "#FDF5E6",
  olivedrab: "#6B8E23",
  orange: "#FFA500",
  orangered: "#FF4500",
  orchid: "#DA70D6",
  palegoldenrod: "#EEE8AA",
  palegreen: "#98FB98",
  paleturquoise: "#AFEEEE",
  palevioletred: "#DB7093",
  papayawhip: "#FFEFD5",
  peachpuff: "#FFDAB9",
  peru: "#CD853F",
  pink: "#FFC0CB",
  plum: "#DDA0DD",
  powderblue: "#B0E0E6",
  rosybrown: "#BC8F8F",
  royalblue: "#4169E1",
  saddlebrown: "#8B4513",
  salmon: "#FA8072",
  sandybrown: "#F4A460",
  seagreen: "#2E8B57",
  seashell: "#FFF5EE",
  sienna: "#A0522D",
  skyblue: "#87CEEB",
  slateblue: "#6A5ACD",
  slategray: "#708090",
  slategrey: "#708090",
  snow: "#FFFAFA",
  springgreen: "#00FF7F",
  steelblue: "#4682B4",
  tan: "#D2B48C",
  thistle: "#D8BFD8",
  tomato: "#FF6347",
  turquoise: "#40E0D0",
  violet: "#EE82EE",
  wheat: "#F5DEB3",
  whitesmoke: "#F5F5F5",
  yellowgreen: "#9ACD32"
};
//<color>をVML用に変換
NAIBU.PaintColor.prototype.color = function( /*string*/ color) {
  if (this.keywords[color]) {
    return this.keywords[color];
  }
  if (color.indexOf("%", 5) > 0) { // %を含むrgb形式の場合
    return color.replace(/[\d.]+%/g, function(s) {
      return Math.round(2.55 * parseFloat(s));
    });
  }
  return color;
}
//linearGradient、radialGradient要素を処理
NAIBU.PaintColor.prototype.gradient = function pcgradient( /*element*/ ele, /*string*/ id) {
  var grad = document.getElementById(id);
  var grad2 = grad;
  while (grad2 && !grad2.hasChildNodes()) { //stopを子要素に持つgradient要素を探す
    grad2.getAttribute("xlink:href").match(/#(.+)/);
    grad2 = document.getElementById(RegExp.$1);
  }
  if (grad2) {
    var stops = grad2.getElementsByTagName("stop");
    if (!stops) {
      return;
    }
  } else {
    return;
  }
  var length = stops.length;
  var color = [], colors = [], opacity = [];
  for (var i = 0; i < length; i++) {
    var stop = stops[i];
    color[i] = this.color(stop.style.stopcolor || stop.getAttribute("stopcolor")) || "black";
    colors[i] = stop.getAttribute("offset") + " " + color[i];
    opacity[i] = (stop.style.stopopacity || stop.getAttribute("stopopacity") || 1) * this.fillopacity * this.opacity;
  }
  ele.setAttribute("method", "none");
  ele.setAttribute("color",  color[0]);
  ele.setAttribute("color2", color[length-1]);
  ele.setAttribute("colors", colors.join(","));
  // When colors attribute is used, the meanings of opacity and o:opacity2 are reversed.
  ele.setAttribute("opacity", opacity[length-1]);
  ele.setAttribute("o:opacity2", opacity[0]);

  var type = grad.getAttribute("type");
  if (type == "gradient") {
  try {
    var angle;
    var x1 = parseFloat(grad.getAttribute("x1").replace(/%/, ""));
    var y1 = parseFloat(grad.getAttribute("y1").replace(/%/, ""));
    var x2 = parseFloat(grad.getAttribute("x2").replace(/%/, ""));
    var y2 = parseFloat(grad.getAttribute("y2").replace(/%/, ""));
    angle = 270 - Math.atan2(y2-y1, x2-x1) * 180 / Math.PI;
    if (angle >= 360) {
      angle -= 360;
    }
  } catch(e) {stlog.add(e,749); angle = 270;}
    ele.setAttribute("type", "gradient");
    ele.setAttribute("angle", angle + "");
  } else if (type == "gradientRadial") {
    ele.setAttribute("type", "gradientTitle");
    ele.setAttribute("focus", "100%");
    ele.setAttribute("focusposition", "0.5 0.5");
  }
}

//font属性、関連プロパティを処理する
//PaintColorを継承
NAIBU.FontStyle = function( /*element*/ ele) {
  var td = this.defaults;
  td["font-size"] = ele.currentStyle.fontSize;
  td["font-family"] = "sans-serif";
  td["font-style"] = "normal";
  td["font-weight"] = "400";
  td["text-transform"] = "none";
  td["text-decoration"] = "none";
  td["writing-mode"] = "lr-tb";
  NAIBU.PaintColor.apply(this,arguments);
  return this;
}
NAIBU.FontStyle.prototype = new NAIBU.PaintColor(false);
//キャッシュ用
NAIBU.FontStyle.prototype.cache = {};
//親コンテナ要素のPaintColorオブジェクトを返す
NAIBU.FontStyle.prototype.getParent = function( /*element*/ ele) {
  try{
  var parent = ele.parentNode;
  if (parent.tagName != "group" && parent.tagName != "A") {
    return null;
  }
  var cache = this.cache;
  var id = parent.uniqueID;
  if (!cache[id]) {
    cache[id] = new NAIBU.FontStyle(parent);
  }
  } catch(e){stlog.add(e,1179);}
  return cache[id];
}

//内部プロパティを、styleに設定する
NAIBU.FontStyle.prototype.setStyle = function() {
  try {
    var tst = this.tar
    for (var i in this) {
      if ((typeof this[i]) == "string") { //string型以外は除く
        var sname = i.replace(/\-([a-z])/, "-").replace(/\-/,RegExp.$1.toUpperCase());
        tst.style[sname] = this[i];
      }
    }
  } catch(e) {stlog.add(e,899); return "";}
}
NAIBU.FontStyle.prototype.fset = function( /*element*/ el, /*float*/ w, /*float*/ h, /*Matrix*/ matrix) {
  try{
  this.setStyle();
  var tts = el.style;
  tts.whiteSpace = "nowrap";
  tts.color = this.fill == "none" ? "transparent"  :  this.fill;
  tts.fontSize = fontset(this["font-size"],w,h,matrix);
  if (this.cursor != "default") {tts.cursor = this.cursor;}
  tts.marginTop = -parseFloat(tts.fontSize);
 } catch(e){stlog.add(e,1185);}
}


//transform属性を処理
function TransformList( /*element*/ ele) {
  try {
  var tft = (ele.getAttribute("transform") || null);
  this.tr = new Transform();
  if (tft) {
    var coma = tft.match(/[A-Za-z]+(?=\s*\()/g);
    var list = tft.match(/\([^\)]+\)/g);
    this.tr.matrix = this.tr.getMatrix(list[0],coma[0]);
    for (var i=1;i<coma.length;i++) {
      this.tr.set(list[i],coma[i]);
    }
    list = null;
  } else {
    this.tr.matrix = new Matrix(1,0,0,1,0,0);
  }
  }  catch(e) {stlog.add(e,816);}
  return this;
}
TransformList.prototype.rmultiply = function(mat) {
  this.tr.matrix = mat.multiply(this.tr.matrix);
}

function Transform() {
  this.matrix = new Matrix(1,0,0,1,0,0);
  return this;
}
Transform.prototype.set = function transformset(list,c) {
  var matri = this.getMatrix(list,c);
  var mat = this.matrix;
  this.matrix = mat.multiply(matri);
}
Transform.prototype.getMatrix = function transformgetMatrix(list,com) {
  var a,b,c,d,e,f;
  var deg = list.match(/[\-\d\.e]+/g);
  var rad =   parseFloat(deg[0]) / 180 * Math.PI;
  for (var i=0,degli=deg.length;i<degli;i++) {
    var et = deg[i].match(/([\-\d\.]+)e([\-\d\.]+)/);
    if (et) {
      deg[i] = parseFloat(RegExp.$1) * Math.pow(10,parseFloat(RegExp.$2));
    }
  }
  if (deg.length == 6) {
    a = parseFloat(deg[0]); b = parseFloat(deg[1]); c = parseFloat(deg[2]); d = parseFloat(deg[3]); e = parseFloat(deg[4]); f = parseFloat(deg[5]);
  } else if (deg.length == 3) {
    var cx = parseFloat(deg[1]), cy = parseFloat(deg[2]);
    a = Math.cos(rad); b = Math.sin(rad); c = -b; d = a; e = (1-a)*cx-c*cy; f = -b*cx+(1-d)*cy;
  } else if (deg.length <= 2) {
    switch (com) {
      case "translate":
        a = 1; b = 0; c = 0; d = 1; e = parseFloat(deg[0]); f = parseFloat(deg[1] || 0);
      break;
      case "scale":
        a = parseFloat(deg[0]); b = 0; c = 0; d = parseFloat(deg[1] || deg[0]); e = 0; f = 0;
      break;
      case "rotate":
        a = Math.cos(rad); b = Math.sin(rad); c = -b; d = a; e = 0; f = 0;
      break;
      case "skewX":
        a = 1; b = 0; c = Math.tan(rad); d = 1; e = 0; f = 0;
      break;
      case "skewY":
        a = 1; b = Math.tan(rad); c = 0; d = 1; e = 0; f = 0;
      break;
    }
  }
  var matri = new Matrix(a,b,c,d,e,f);
  return matri;
}

//SVGPointを参照
function Point( /*number*/ x, /*number*/ y) {
  this.x = x; this.y = y;
  return this;
}
Point.prototype.matrixTransform = function pmatrixtransform( /*Matrix*/ m) {
  var x = parseInt(m.a * this.x + m.c * this.y + m.e);
  var y = parseInt(m.b * this.x + m.d * this.y + m.f);
  if (-1 < x && x < 1) {x=1;}
  if (-1 < y && y < 1) {y=1;}
  var s = new Point(x,y);
  return s;
}

//Pointのリスト。一括で処理できる
function PList( /*Array*/ d) {
  this.list = d;
  return this;
}
PList.prototype.matrixTransform = function plmatrixtransform( /*Matrix*/ ttm) {
  var F = this.list;
  for (var i = 0, Fli = F.length; i < Fli;) {
    if (isNaN(F[i])) { //コマンド文字は読み飛ばす
      i++;
      continue;
    }
    var p = new Point(parseFloat(F[i]), parseFloat(F[i+1]));
    var pmt = p.matrixTransform(ttm);
    F[i++] = pmt.x;
    F[i++] = pmt.y;
  }
  var s = new PList(F);
  return s;
}

//SVGMatrixを参照。行列
function Matrix(a,b,c,d,e,f) { //引数はすべてNumber型
  this.a = a; this.b = b; this.c = c; this.d = d; this.e = e; this.f = f;
  return this;
}
//Matrix同士の積を算出
Matrix.prototype.multiply = function matrixmultiply( /*Matrix*/ m) {
  var a = this.a * m.a + this.c * m.b;
  var b = this.b * m.a + this.d * m.b;
  var c = this.a * m.c + this.c * m.d;
  var d = this.b * m.c + this.d * m.d;
  var e = this.a * m.e + this.c * m.f + this.e;
  var f = this.b * m.e + this.d * m.f + this.f;
  var s = new Matrix(a,b,c,d,e,f);
  return s;
}
//行列式
Matrix.prototype.determinant = function() {
  return (this.a * this.d - this.b * this.c);
}

//SVGViewSpecを参照
function STViewSpec( /*element*/ ele) {
  this.tar = ele;
  var vb = ele.getAttribute("viewBox");
  if (vb) {
    var ovb = vb.replace(/^\s+|\s+$/g, "").split(/[\s,]+/);
    this.viewBox = new STRect(parseFloat(ovb[0]), parseFloat(ovb[1]), parseFloat(ovb[2]), parseFloat(ovb[3]));
  }
  var par = ele.getAttribute("preserveAspectRatio") || "xMidYMid meet";
  var sa = 1, mos = 0;
  if (par.match(/x(Min|Mid|Max)Y(Min|Mid|Max)(?:\s+(meet|slice))?/)) {
    switch (RegExp.$1) {
      case "Min":
        sa += 1;
      break;
      case "Mid":
        sa += 2;
      break;
      case "Max":
        sa += 3;
      break;
    }
    switch (RegExp.$2) {
      case "Min":
      break;
      case "Mid":
        sa += 3;
      break;
      case "Max":
        sa += 6;
      break;
    }
    if (RegExp.$3 == "slice") {
      mos = 2;
    } else {
      mos = 1;
    }
  }
  this.preserveAspectRatio = new STPreserveAspectRatio(sa, mos);
  vb = par = null;
  return this;
}
STViewSpec.prototype.set = function vss( /*float*/ vw, /*float*/ vh) {
  var vB = this.viewBox, par = this.preserveAspectRatio;
  try {
  if (!vB) {
    return new Matrix(1, 0, 0, 1, 0, 0);
  }
  var vbx = vB.x, vby = vB.y, vbw = vB.width, vbh = vB.height;
  var rw = vw / vbw, rh = vh / vbh;
  var xr = 1, yr = 1, tx, ty;
  if (par.align == 1) { //none
    xr = rw;
    yr = rh;
    tx = -vbx * xr;
    ty = -vby * yr;
  } else {
    var ax = (par.align + 1) % 3 + 1;
    var ay = Math.round(par.align / 3);
    switch (par.meetOrSlice) {
      case 1: //meet
        xr = yr = Math.min(rw, rh);
      break;
      case 2: //slice
        xr = yr = Math.max(rw, rh);
      break;
    }
    tx = -vbx * xr;
    ty = -vby * yr;
    switch (ax) {
      case 1: //xMin
      break;
      case 2: //xMid
        tx += (vw - vbw * xr) / 2;
      break;
      case 3: //xMax
        tx += vw - vbw * xr;
      break;
    }
    switch (ay) {
      case 1: //YMin
      break;
      case 2: //YMid
        ty += (vh - vbh * yr) / 2;
      break;
      case 3: //YMax
        ty += vh - vbh * yr;
      break;
    }
  }
  this.tar.parentNode.style.marginLeft = tx;
  this.tar.parentNode.style.marginTop = ty;
  var m = new Matrix(xr, 0, 0, yr, 0, 0);
  return m;
  } catch(e) {stlog.add(e,1031);}
}

//SVGRectを参照
function STRect(x,y,w,h) { //引数はすべてNumber型
  this.x = x; this.y = y;
  this.width = w; this.height = h;
  return this;
}

//SVGPreserveAspectRatioを参照
function STPreserveAspectRatio( /*int*/ a, /*int*/ mos) {this.align=a;this.meetOrSlice=mos;
  return this;
}

//path要素のd属性で使われるA（rcTo）コマンドを処理
function STArc() {
  return this;
}
STArc.prototype.matrixTransform = function arcmatrixTransform( /*Matrix*/ matrix) {
  var plst = new PList(this.D);
  var s = new STArc();
  s.D = plst.matrixTransform(matrix).list;
  plst = null;
  return s;
}
//2つの点から角度を算出
STArc.prototype.CVAngle = function starccvangle(ux,uy,vx,vy) {
  var rad = Math.atan2(vy, vx) - Math.atan2(uy, ux);
  return (rad >= 0) ? rad : 2 * Math.PI + rad;
}
//弧をベジェ曲線に変換
STArc.prototype.set = function starcset(x1,y1,rx,ry,psai,fA,fS,x4,y4) {
  var fS = parseFloat(fS),  rx = parseFloat(rx),  ry = parseFloat(ry),  psai = parseFloat(psai),  x1 = parseFloat(x1),  x4 = parseFloat(x4),  y1 = parseFloat(y1),  y4 = parseFloat(y4);
  if (rx == 0 || ry == 0) {throw "line";}
  rx = Math.abs(rx); ry = Math.abs(ry);
  var ccx = (x1 - x4) / 2,  ccy = (y1 - y4) / 2;
  var cpsi = Math.cos(psai*Math.PI/180),  spsi = Math.sin(psai*Math.PI/180);
  var x1d = cpsi*ccx + spsi*ccy,  y1d = -1*spsi*ccx + cpsi*ccy;
  var x1dd = x1d * x1d, y1dd = y1d * y1d;
  var rxx = rx * rx, ryy = ry * ry;
  var lamda = x1dd/rxx + y1dd/ryy;
  var sds;
  if (lamda > 1) {
    rx = Math.sqrt(lamda) * rx;
    ry = Math.sqrt(lamda) * ry;
    sds = 0;
  }  else{
    var seif = 1;
    if (fA == fS) {
      seif = -1;
    }
    sds = seif * Math.sqrt((rxx*ryy - rxx*y1dd - ryy*x1dd) / (rxx*y1dd + ryy*x1dd));
  }
  var cxd = sds*rx*y1d / ry,  cyd = -1 * sds*ry*x1d / rx;
  var cx = cpsi*cxd - spsi*cyd + (x1+x4)/2, cy = spsi*cxd + cpsi*cyd + (y1+y4)/2;
  var s1 = this.CVAngle(1,0,(x1d-cxd)/rx,(y1d-cyd)/ry);
  var dr = this.CVAngle((x1d-cxd)/rx,(y1d-cyd)/ry,(-x1d-cxd)/rx,(-y1d-cyd)/ry);
  if (!fS  &&  dr > 0) {
    dr -=   2*Math.PI;
  } else if (fS  &&  dr < 0) {
    dr += 2*Math.PI;
  }
  var sse = dr * 2 / Math.PI;
  var seg = Math.ceil(sse<0 ? -1*sse  :  sse);
  var segr = dr / seg;
  var nea = new Array();
  var t = 8/3 * Math.sin(segr/4) * Math.sin(segr/4) / Math.sin(segr/2);
  var cpsirx = cpsi * rx;
  var cpsiry = cpsi * ry;
  var spsirx = spsi * rx;
  var spsiry = spsi * ry;
  var mc = Math.cos(s1);
  var ms = Math.sin(s1);
  var x2 = x1 - t * (cpsirx * ms + spsiry * mc);
  var y2 = y1 - t * (spsirx * ms - cpsiry * mc);
  for (var i = 0; i < seg; i++) {
    s1 += segr;
    mc = Math.cos(s1);
    ms = Math.sin(s1);
    var x3 = cpsirx * mc - spsiry * ms + cx;
    var y3 = spsirx * mc + cpsiry * ms + cy;
    var dx = -t * (cpsirx * ms + spsiry * mc);
    var dy = -t * (spsirx * ms - cpsiry * mc);
    nea = nea.concat([x2, y2, x3 - dx, y3 - dy, x3, y3]);
    x2 = x3 + dx;
    y2 = y3 + dy;
  }
  this.D = (this.D ? this.D.concat(nea) : nea);
  nea = null;
  return true;
}
//setをできるだけ繰り返す
STArc.prototype.sset = function starcsset( /*float*/ nox, /*float*/ noy, /*array*/ f, /*float*/ rx, /*float*/ ry) {
  for (var i=1,fli=f.length;i<fli+1;i+=7){
    this.set(nox,noy,f[i],f[i+1],f[i+2],f[i+3],f[i+4],f[i+5]+rx,f[i+6]+ry);
    nox = f[i+5]+rx; noy = f[i+6]+ry;
  }
}

//SVGLengthを参照
function STLength( /*string or number*/ d, /*float*/ wort, /*float*/ f) {
  d += "";
  this.unitType = 0;//unknown
  this.wort = wort;
  this.fontSize = f;
  try {
  var v = parseFloat(d);
  var tani = d.match(/\D+$/);
  this.newValueSpecifiedUnits(tani,v);
  }  catch(e) {stlog.add(e,1133); this.value = 1000;}
  return this;
}
STLength.prototype.newValueSpecifiedUnits = function stlengthnvsu( /*string or number*/ tani, /*number*/ value) {
  var n = 1,  ut;
  switch (tani+"") {
    case "pt":  n = 1.25; ut = 9;
    break;
    case "pc":  n = 15; ut = 10;
    break;
    case "mm":  n = 3.543307; ut = 7;
    break;
    case "cm":  n = 35.43307; ut = 6;
    break;
    case "in":  n = 90; ut = 8;
    break;
    case "em":  n = this.fontSize; ut = 3;
    break;
    case "ex":  ut = 4;
    break;
    case "px":  ut = 5;
    break;
    case "%":  n = 0.01 * this.wort; ut = 2;
    break;
    default:  ut = 1;
    break;
  }
  this.unitType = ut;
  this.value = value * n;
  this.valueInSpecifiedUnits = value;
}

//XLink言語を処理
NAIBU.XLink = function( /*element*/ ele) {
  this.tar = ele;
  var href = ele.getAttribute("xlink:href");
  this.href = href ? href  :  null;
  this.show = ele.getAttribute("xlink:show");
  var base;
  var egbase = ele.getAttribute("xml:base");
  if (!egbase) {
    var ep = ele.parentNode, b = null;
    while(!b  &&  ep.tagName == "group") {
      b = ep.getAttribute("xml:base");
      ep = ep.parentNode;
    }
    base = b || location.href;
  }  else{
    base = egbase;
  }
  if (href.indexOf(":") == -1) {
    this.base = base;
  }  else{
    this.base  ="";
  }
  return this;
}
NAIBU.XLink.prototype.set = function() {
  if (this.href) {
    var tbth = this.base + this.href;
    if (this.href.indexOf(".") == 0) {
      tbth = this.href;
    }
    var uri = tbth;
    var attr = "href";
    switch (this.show) {
      case "embed":
        if (this.tar.tagName == "image") {
          attr = "src";
        }  else{
          uri.match(/#(.+)$/);
          this.resource = document.getElementById(RegExp.$1);
          var dc = this.resource.cloneNode(true);
          this.tar.appendChild(dc);
        }
      break;
      case "new":
        this.tar.setAttribute("target","_blank");
      break;
      default:
      break;
    }
    this.tar.setAttribute(attr,uri);
  }
}

function utf16( /*string*/ s)  {
  return unescape(s);
}
function unescapeUTF16( /*string*/ s) {
  return s.replace(/%u\w\w\w\w/g,  utf16);
}

//Text2SVG機能。SVGのソース（文章）をSVG画像に変換できる。（必須ではない）
function textToSVG( /*string*/ source, /*float*/ w, /*float*/ h) {
  var data = 'data:image/svg+xml,' + unescapeUTF16(escape(source));
  var ob = document.createElement("object");
  ob.setAttribute("data",data);
  ob.setAttribute("width",w);
  ob.setAttribute("height",h);
  ob.setAttribute("type","image/svg+xml");
  return ob;
}

//XMLHttpRequestオブジェクトの作成
function HTTP() {
  var xmlhttp;
  try {
    xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
  } catch (e) {
    try {
      xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
    } catch (E) {
      xmlhttp = false;
    }
  }
  if (!xmlhttp) {
    try {
      xmlhttp = new XMLHttpRequest();
    } catch (e) {
      xmlhttp = false;
    }
  }
  return xmlhttp;
}
var success = true;
//SVGDocumentを収納しておく
var STdocument = new Array();

//次のembed,object要素を読み込む処理
function embed_ca( /*object*/ data) {
if (success  &&  data.success) {
  ca(data);
}
}
function object_ca( /*object*/ data) {
if (success  &&  data.success) {
  ca(data);
}
}

//IE用。object要素のデータからVMLを作成
function ca( /*object*/ data) {
  var dn = data.num-1;
  try {
    var obj = data.obj[dn];
    var obw = new STLength(obj.getAttribute("width"),obj.clientWidth),  obh = new STLength(obj.getAttribute("height"),obj.clientHeight);
    var obwidth = obw.value,  obheight = obh.value;
  } catch(e) {stlog.add(e,1209);}
  //正規表現でソースをVML用に書き換え
  var dc = data.content
    .replace(/<!DOCTYPE/, "<!--")
    .replace(/(?:dtd">|\]>)/, "-->")
    .replace(/<\?[^>]+\?>/g, "")
    .replace(/<!\[CDATA\[/g, "<!--")
    .replace(/\]\]>/g, "-->")
    .replace(/xmlns="[^"]+"/g, "")
    .replace(/<svg(?=\s|>)/g, "<v:group")
    .replace(/\/svg>/g, "/v:group>")
    .replace(/<path\s/g, '<v:shape tag="path" ')
    .replace(/\/path>/g, "/v:shape>")
    .replace(/<rect\s/g, '<v:shape tag="rect" ')
    .replace(/\/rect>/g, "/v:shape>")
    .replace(/<line\s/g, '<v:shape tag="line" ')
    .replace(/\/line>/g, "/v:shape>")
    .replace(/<circle\s/g, '<v:shape tag="circle" ')
    .replace(/\/circle>/g, "/v:shape>")
    .replace(/<ellipse\s/g, '<v:shape tag="ellipse" ')
    .replace(/\/ellipse>/g, "/v:shape>")
    .replace(/<polyline\s/g, '<v:shape tag="polyline" ')
    .replace(/\/polyline>/g, "/v:shape>")
    .replace(/<polygon\s/g, '<v:shape tag="polygon" ')
    .replace(/\/polygon>/g, "/v:shape>")
    .replace(/<text(?=\s|>)/g, "<div")
    .replace(/\/text>/g, "/div>")
    .replace(/<g(?=\s|>)/g, "<v:group")
    .replace(/\/g>/g, "/v:group>")
    .replace(/<linearGradient\s/g, '<v:fill type="gradient" ')
    .replace(/\/linearGradient>/g, "/v:fill>")
    .replace(/<radialGradient\s/g, '<v:fill type="gradientRadial" ')
    .replace(/\/radialGradient>/g, "/v:fill>")
    .replace(/fill-/g, "fill")
    .replace(/stroke-/g, "stroke")
    .replace(/stop-/g, "stop")
    .replace(/\bwidth=/g, "svgwidth=")
    .replace(/\bheight=/g, "svgheight=")
    .replace(/<tspan\s/g, "<span ")
    .replace(/\/tspan>/g, "/span>")
    .replace(/<image\s/g, "<v:image ")
    .replace(/\/image>/g, "/v:image>")
    .replace(/<use\s/g, "<use /><v:group ")
    .replace(/\/use>/g, "/v:group>")
    .replace(/<defs(?=\s|>)/g, "<dn:defs")
    .replace(/\/defs>/g, "/dn:defs>");
  var ob = document.createElement("v:group");
  var obst = ob.style;
  ob.innerHTML = dc;
  var obc = ob.getElementsByTagName("group").item(0);
  var regaw = obc.getAttribute("svgwidth") || obwidth;
  var regah = obc.getAttribute("svgheight") || obheight;
  regw = new STLength(regaw,obwidth);
  regh = new STLength(regah,obheight);
  var regwv = regw.value,  reghv = regh.value;
  obst.width = regwv;
  obst.height = reghv;
  ob.setAttribute("coordsize",regwv  +" "+  reghv);
  obj.parentNode.insertBefore(ob,obj);
  STdocument[dn] = new SVGtoVML(obc,obwidth,obheight,regw,regh,data.progress,data.pst);
  STdocument[dn].read();
  STdocument[dn].set();
  if (typeof NAIBU.STObject != "undefined") {NAIBU.STObject.next();}
  dc = null;
}

//指定したURLの文章データを取得
function getURL( /*string*/ url, /*function*/ fn, /*Array*/ ob, /*int*/ n) {  
  var xmlhttp= new HTTP();
  if (xmlhttp) {
    var obn = ob[n-1];
    obn.style.display = "none";
    xmlhttp.open("GET",url,true);
    xmlhttp.setRequestHeader("X-Requested-With", "XMLHttpRequest");
    xmlhttp.onreadystatechange = function() {
      if (xmlhttp.readyState == 4  &&  xmlhttp.status == 200) {
fn({success:true, status:xmlhttp.status,content:xmlhttp.responseText,contentType:xmlhttp.getResponseHeader("Content-Type"),obj:ob,num:n});
        xmlhttp = null;
      }
    }
    xmlhttp.send(null);
  } else {
    fn({success:false});
  }
}

//Sieb用
if (sieb_s) {svgtovml();}
