<?php

/**
 * sie.php
 *
 * Copyright (c) 2008 revulo
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * @package     sie
 * @author      revulo <revulon@gmail.com>
 * @copyright   2008 revulo
 * @license     http://www.opensource.org/licenses/mit-license.php  MIT License
 * @version     Release: 0.2
 * @link        http://sie.sourceforge.jp/
 * @link        http://www.revulo.com/blog/20080510.html
 */

// Filename of SIE JavaScript library.
define('SIE_JS', 'sie.js');

// Gets the path of the requested file.
$file = $_SERVER['DOCUMENT_ROOT'] . $_SERVER['REQUEST_URI'];

// Checks the file extension.
$extension = pathinfo($file, PATHINFO_EXTENSION);
if (strcasecmp($extension, 'svg') != 0) {
    header('HTTP/1.1 403 Forbidden');
    exit;
}

// Returns a 404 status code if the SVG file is not found.
if (is_readable($file) === false) {
    header('HTTP/1.1 404 Not Found');
    exit;
}

// If the request is an Ajax request, outputs the raw contents.
if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && $_SERVER['HTTP_X_REQUESTED_WITH'] == 'XMLHttpRequest') {
    header('Content-Disposition: inline');
    header('Content-Length: ' . filesize($file));
    header('Content-Type: image/svg+xml');
    readfile($file);
    exit;
}

// Strips <script> tags from the file contents.
$data = file_get_contents($file);
$data = preg_replace('/<script.*?\/script>/is', '', $data);

// Gets the absolute-path reference to the JavaScript file.
$javascript = dirname($_SERVER['SCRIPT_NAME']) . '/' . SIE_JS;

// Disables browser caching.
header('Expires: Thu, 01 Jan 1970 00:00:00 GMT');

?>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
</head>
<body>
<script type="image/svg+xml" width="1000" height="1000">
<?php echo $data ?>
</script>
<script type="text/javascript" src="<?php echo $javascript ?>"></script>
</body>
</html>
