﻿/*SIE-SVG without Plugin under LGPL2.1 & GPL2.0 & Mozilla Public Lisence
 *公式ページは http://sie.sourceforge.jp/
 *利用方法は <script defer="defer" type="text/javascript" src="sie.js"></script>
 *http://sie.sourceforge.jp/
 *Usage: <script defer="defer" type="text/javascript" src="sie.js"></script>
 */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Mozilla SVG Cairo Renderer project.
 *
 * The Initial Developer of the Original Code is IBM Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Parts of this file contain code derived from the following files(s)
 * of the Mozilla SVG project (these parts are Copyright (C) by their
 * respective copyright-holders):
 *    layout/svg/renderer/src/libart/nsSVGLibartBPathBuilder.cpp
 *
 * Contributor(s):DHRNAME revulo
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

//これを頭に付けたら、内部処理用
var  NAIBU = {};

//documentを速くするために
/*@cc_on  _d=document;eval('var  document=_d')@*/
//svgtovml load時に、最初に起動する関数
function svgtovml() {
  var isMSIE = /*@cc_on!@*/false; //IEだったらtrueを返す
  var ary = document.getElementsByTagName("script");
  for (var i=0; i < ary.length; i++)  {//全script要素をチェックして、type属性がimage/svg+xmlならば、中身をSVGとして処理する
    var hoge = ary[i].type;
    if (ary[i].type == "image/svg+xml")  {
      var ait = ary[i].text;
      if (ait.match(/lt;/)) {
        ait = ait.replace(/<.+?>/g,''); //ソース内のタグを除去
      };
      //エンティティを文字に戻す
      ait = ait.replace(/.lt;/g,'<').replace(/.gt;/g,'>').replace(/.quot;/g,'"');
      if (isMSIE) {
        setVMLNameSpace();
        var da = {};
        da.obj = new Array(i); da.obj[i] = ary[i]; da.num = i + 1; da.content = ait; da.success = true;
        ca(da);
      }  else{
        var s = textToSVG(ait,ary[i].getAttribute("width"),ary[i].getAttribute("height"));
        ary[i].parentNode.insertBefore(s,ary[i]);
      }
    }
  }
  if (isMSIE) {
    var lh = location.href;
    if (lh.indexOf("?") != -1) {
      var uri = lh.match(/[^\?]+\.svg$/);
      document.body.innerHTML = "";
      var od = document.createElement("object");
      od.setAttribute("data", uri);
      od.setAttribute("width", "100%"); od.setAttribute("height","100%"); od.setAttribute("type","image/svg+xml");
      document.body.appendChild(od);
    }
    var st = setVMLNameSpace();
    st.addRule("object","display: none;");
    st.addRule("embed","display: none;");
    var obj = document.getElementsByTagName("object");
    var emd = document.getElementsByTagName("embed");
    docme = new Array(obj.length+emd.length);
    getObject(obj,0);
    getEmbed(emd,0);
    success = true;
    delete lhi;
  }
}

//vmlの名前空間をセット（必須）
function setVMLNameSpace() {
  document.namespaces.add("v","urn:schemas-microsoft-com:vml");
  document.namespaces.add("o","urn:schemas-microsoft-com:office:office");
  document.namespaces.add("t","urn:schemas-microsoft-com:time");
  var st = document.createStyleSheet();
  st.addRule("v\\:*","behavior: url(#default#VML);display:inline-block;font-size:12px");//inline-blockはIEのバグ対策
  st.addRule("o\\:*","behavior: url(#default#VML);display:inline-block");
  st.addRule("t\\:*","behavior: url(#default#time);display:inline-block");
  return st;
}

//loadイベントに関数を追加
if (window.addEventListener) {
  window.addEventListener('load', svgtovml, false);
} else if (window.attachEvent) {
  window.attachEvent('onload', svgtovml);
} else {
  window.onload = svgtovml;
}

//以下は例外処理のログをとるためのもの。開発者以外は削除すること
var  stlog = new STLog(false);
function STLog(jou) {
this.jo = jou;
if (this.jo) {
  this.p = document.createElement("div");
  this.p.innerHTML = "<h1>例外処理のログ</h1>";
  document.body.insertBefore(this.p,document.body.firstChild);
}
  return this;
}
STLog.prototype.add = function(e,code) {
if (this.jo) {
  this.p.innerHTML += "<p>"+code+":"+e.message+"</p>";
}
}

//SVGtoVML 本体。SVGDocumentの代わりを担う
function SVGtoVML() {
  return this;
}
SVGtoVML.prototype.read = function stvread( /*element*/ obc) {
  this.rootElement = obc;
  this.rootElement.style.visibility = "hidden";
  this.vi = new STViewSpec(this.rootElement);
  var sh = obc.getElementsByTagName("shape");
  this.shape = sh;
  var slen = 0, rlen = 0, clen = 0, elen = 0, pllen = 0, plen = 0, llen = 0;
  var s = new Array(slen), r = new Array(rlen), c = new Array(clen), e = new Array(elen), pl = new Array(pllen), p = new Array(plen), li = new Array(llen);
  try {
  for (var i=0,shli=sh.length;i<shli;i++) {
    switch (sh[i].getAttribute("tag")) {
    case "path":
      s[slen] = new STPath(sh[i]); slen++;
    break;
    case "rect":
      r[rlen] = new STRectElement(sh[i]); rlen++;
    break;
    case "circle":
      c[clen] = new STCircle(sh[i]); clen++;
    break;
    case "ellipse":
      e[elen] = new STEllipse(sh[i]); elen++;
    break;
    case "polyline":
      pl[pllen] = new STPolyline(sh[i]); pllen++;
    break;
    case "polygon":
      p[plen] = new STPolygon(sh[i]); plen++;
    break;
    case "line":
      li[llen] = new STLine(sh[i]); llen++;
    break;
    default:  break;
    }
  }
  var l = null,t = null,a = null;
  this.getObject("div",STText,"text");
  this.getObject("a",STAElement,"a");
  this.getObject("image",STImage,"image");
  } catch(n) {stlog.add(n,109);}
  this.path = s;
  this.rect = r;
  this.circle = c;
  this.ellipse = e;
  this.polygon = p;
  this.polyline = pl;
  this.line = li;
}
SVGtoVML.prototype.getObject = function stvgetob( /*string*/ tag, /*object*/ st, /*string*/nodes) {
  try {
  var li = this.rootElement.getElementsByTagName(tag);
  var lli = li.length;
  var l = new Array(lli);
  for (var i=0,lli=li.length;i<lli;i++) {
    l[i] = new st(li[i]);
  }
  this[nodes] = l;
  } catch(e) {stlog.add(e,129);
    this[nodes] = new Array();
  }
}
//object要素の幅と高さがwとh。 wとhの単位を統一し、px単位に変換したものがswi、shi
SVGtoVML.prototype.set = function stvset( /*float*/ w, /*float*/ h, /*STLength*/ swi, /*STLength*/ shi) {
  var c = this.circle,  r = this.rect,  s = this.path,  l = this.line,  text = this.text,  el = this.ellipse,  pg = this.polygon,  pl = this.polyline,  a = this.a,  lin = this.line, imag = this.image;
  var sw = swi.value,  sh = shi.value;
  try {
  var mat = this.vi.set(sw,sh); //返り値はMatrix型
  } catch(e) {stlog.add(e,1109);}
  try {
  for (var i=0,sli=this.shape.length;i<sli;i++) {
    var tss = this.shape[i].style;
    tss.width = "100%";
    tss.height = "100%";
    tss.posLeft = 0;
    tss.posTop = 0;
  }
  this.setObject(s,sw,sh,mat);
  this.setObject(c,sw,sh,mat);
  this.setObject(r,sw,sh,mat);
  this.setObject(el,sw,sh,mat);
  this.setObject(pg,sw,sh,mat);
  this.setObject(pl,sw,sh,mat);
  this.setObject(a,sw,sh,mat);
  this.setObject(lin,sw,sh,mat);
  this.setObject(imag,sw,sh,mat);
  this.setObject(text,sw,sh,mat);
  var nods = this.rootElement;
  chset(nods);
  var backr = document.createElement("v:rect"); //背景の作成
  backr.style.width = w;
  backr.style.height = h;
  backr.style.zIndex = -1;
  backr.setAttribute("stroked","false");
  backr.setAttribute("filled","false");
  this.rootElement.parentNode.appendChild(backr);
  this.rootElement.style.visibility = "visible";
  } catch(e) {stlog.add(e,138);}
}
SVGtoVML.prototype.setObject = function stvsetob( /*SVGElement*/ arr, /*float*/ sw, /*float*/ sh, /*Matrix*/ mat) {
  try {
  for (var i=0,arri=arr.length;i<arri;i++) {
    try {
      arr[i].set(sw,sh,mat);
    } catch(ee){}
  }
  } catch(e) {stlog.add(e,170);}
}

//chset childNodesで取捨選択
function chset( /*element*/ ele){
  var nods = ele.childNodes;
  for (var i=0,nodesli=nods.length;i<nodesli;i++) {
    var te = nods[i];
    if (!te.nodeName.match(/^(group|shape|fill|stroke|DIV|SPAN|A|image|rect)$/)) {
      ele.removeChild(te);
      i--; nodesli--;
    } else {
      if(te.nodeType == 1 && !te.nodeName.match(/^(DIV|SPAN)$/)) {
        chset(te);
      }
    }
  }
}

//getObject object要素を取得して、data属性のファイルをロード
function getObject( /*Array*/ obb, /*int*/ n) {
  if (n < obb.length) {
  if (!"getSVGDocument" in obb[n]) {obb[n].getSVGDocument = function() {return STdocument[n];}}//object要素にgetSVGDocumentメソッドをつける(for IE)
    try {
      getURL(obb[n].getAttribute("data"),object_ca,obb,n+1);
    } catch(e) {stlog.add(e,177);getObject(obb,n+1);}
  }
}

//getObject embed要素を取得して、data属性のファイルをロード
function getEmbed(obb,n) {
  if (n < obb.length) {
  if (!"getSVGDocument" in obb[n]) {obb[n].getSVGDocument = function() {return STdocument[n];}}
    try {
      getURL(obb[n].src,embed_ca,obb,n+1);
    } catch(e) {stlog.add(e,185);getEmbed(obb,n+1);}
  }  else{
  }
}

//a要素の処理
function STAElement( /*element*/ a) {
  this.xlink = new NAIBU.XLink(a);
  this.target = a.getAttribute("target");
  return this;
}
STAElement.prototype.set = function aset() {
  try {
    var t = this.target;
    var st = "replace";
    if (t == "_blank") {
      st = "new";
    }
    this.xlink.tar.setAttribute("xlink:show",st)
    this.xlink.set();
    var txts = this.xlink.tar.style;
    txts.cursor = "hand";
    txts.left = 0;
    txts.top = 0;
  }  catch(e) {stlog.add(e,204);}
}

//text要素の処理
function STText( /*element*/ te) {
  this.tar = te;
  var x = te.getAttribute("x");
  var y = te.getAttribute("y");
  this.fs = te.style.fontSize || te.getAttribute("fontSize");
  this.fs = this.fs || te.currentStyle.fontSize;
  this.paint = new NAIBU.PaintColor(te);
  this.transformable = new TransformList(te);
  try { //子要素のtspan要素を処理
    var li = this.tar.getElementsByTagName("SPAN");
    var lli = li.length;
    var l = new Array(lli);
    for (var i=0,lli=li.length;i<lli;i++) {
      l[i] = new STTSpanElement(li[i],x,y);
    }
    this.tspan = l;
    this.x = x || 0; this.y = y || 0;
  } catch(e) {stlog.add(e,129264);}
  return this;
}
STText.prototype.set = function textset( /*float*/ w, /*float*/ h, /*Matrix*/ matrix) {
  try {
  var ttm = matrix.multiply(this.transformable.tr.matrix);
  var p = new Point(parseFloat(this.x),parseFloat(this.y));
  var ptm = p.matrixTransform(ttm);
  var tts = this.tar.style;
  tts.position = "absolute";
  var backr = document.createElement("v:rect")
  var backrs = backr.style; //ずれを修正するためのもの
  backrs.width = 1;
  backrs.height = 1;
  backrs.left = 0;
  backrs.top = 0;
  backr.setAttribute("stroked", "false");
  backr.setAttribute("filled", "false");
  var ttp = this.tar.parentNode
  if (ttp.lastChild.nodeName != "rect") {
    ttp.appendChild(backr);
  }
  tts.left = ptm.x;
  tts.top = ptm.y;
  tts.width = 0;
  tts.height = 0;
  tts.whiteSpace = "nowrap";
  tts.color = this.paint.fill == "none" ? "transparent"  :  this.paint.fill;
  tts.fontSize = fontset(this.fs,w,h,ttm);
  tts.marginTop = -parseFloat(tts.fontSize);
  } catch(e) {stlog.add(e,236);}
  try {
    var arr = this.tspan;
    for (var i=0,arri=arr.length;i<arri;i++) {
      arr[i].set(ttm);
    }
  } catch(e) {stlog.add(e,2831);}
  delete sw,p,ptm;
}
//fontset フォントの大きさを幅と高さを使ってpx単位に変換
function fontset( /*flaot*/ f, /*flaot*/ w, /*flaot*/ h, /*Matrix*/ ttm) {
  try {
  var wwhh = w*w + h*h;
  var msms = Math.sqrt(wwhh / 2);
  var sw = new STLength(f,msms);
  var swx = sw.value * Math.sqrt(Math.abs(ttm.a * ttm.d - ttm.b * ttm.c));
  } catch(e) {stlog.add(e,282);swx=f;}
  return swx;
}

//span要素の処理
function STTSpanElement( /*element*/ ele, /*flaot*/ x, /*flaot*/ y) {
  this.tar = ele;
  this.x = ele.getAttribute("x") || x;
  this.y = ele.getAttribute("y") || y;
  this.x = this.x || 0;
  this.y = this.y || 0;
  this.fs = ele.getAttribute("fontSize") || ele.style.fontSize;
  this.fs = this.fs || ele.currentStyle.fontSize;
  this.paint = new NAIBU.PaintColor(ele);
  this.transformable = new TransformList(ele);
  return this;
}
STTSpanElement.prototype.set = function( /*Matrix*/ matrix) {
  try {
  var p = new Point(parseFloat(this.x),parseFloat(this.y));
  var ptm = p.matrixTransform(matrix);
  var tts = this.tar.style;
  tts.position = "absolute";
  tts.left = ptm.x - parseFloat(this.tar.parentNode.style.left);
  tts.top = ptm.y - parseFloat(this.tar.parentNode.style.top);// - parseFloat(this.fs);
  tts.whiteSpace = "nowrap";
  tts.color = this.paint.fill;
  } catch(e) {stlog.add(e,304);}
  delete p,ptm;
}

//line要素の処理
function STLine( /*element*/ li) {
  this.tar = li;
  this.x1 = li.getAttribute("x1");
  this.y1 = li.getAttribute("y1");
  this.x2 = li.getAttribute("x2");
  this.y2 = li.getAttribute("y2");
  this.paint = new NAIBU.PaintColor(li);
  this.transformable = new TransformList(li);
  return this;
}
STLine.prototype.set = function lineset(w,h,matrix) {
  try {
    var ttm = matrix.multiply(this.transformable.tr.matrix);
    var pl = new PList([parseFloat(this.x1),parseFloat(this.y1),parseFloat(this.x2),parseFloat(this.y2)]);
    var plm = pl.matrixTransform(ttm);
    this.tar.setAttribute("path",  "m"+  plm.list[0]  +" "+  plm.list[1]  +" l "+  plm.list[2]  +" "+  plm.list[3]);
    this.tar.setAttribute("coordsize",w  +" "+  h);
    this.paint.set(this.tar,w,h,ttm);
  }  catch(e) {stlog.add(e,257);}
}

//path要素の処理
function STPath( /*element*/ cir) {
  this.tar = cir;
  this.d = this.tar.getAttribute("d");

  this.paint = new NAIBU.PaintColor(this.tar);
  this.transformable = new TransformList(cir);
  return this;
}
STPath.prototype.set = function shapeset( /*flaot*/ w, /*flaot*/ h, /*Matrix*/ matrix) {
  var dat;
  var minx = 0; var miny = 0;
  try {
    dat = this.d;
    var zok = false;
    dat = dat.replace(/l/g,"r").replace(/t/g,"u").replace(/v/g,"w").replace(/m/g,"t").replace(/c/g,"v");
    dat = dat.replace(/,/g," ").replace(/([a-z-])/gi," $1");
    var datt = dat;
    var dd = "[["+datt.replace(/(\d)\s/g,"$1,").replace(/\s/g,"").replace(/,$/,"").replace(/\(/g,"").replace(/([tM])/,'"$1",').replace(/,z/gi,'],["x",').replace(/,([A-W])/gi,'],["$1",').replace(/"x",$/,'" x e"')+"]]";
    var D = eval('('+dd+')'); //ここまでd属性のパーサ
    var ttm = matrix.multiply(this.transformable.tr.matrix);
    var G = new Array(D.length);
    var dim,  preCom = "";
    var mf1 = 0,  mf2 = 0,  mf3 = 0,  mf4 = 0;
    var nox = 0,  noy = 0,  crx = 0,  cry = 0;
    var axe = new RegExp("[Aaxe]"),  big = new RegExp("[B-W]"),  small = new RegExp("[b-w]"),aaa = new RegExp("[Aa]");
    for (var i=0,Dli=D.length;i<Dli;i++) {
      var F = D[i]; //F[0]の値はコマンド文字
      var com = F[0],  qor = false;
      if (!axe.test(com)) {
        var scom = com.match(small);
        var relx = 0,  rely = 0;
        var skip = 0;
        if (scom) { //相対座標
          relx = nox; rely = noy;
          switch (scom.toString()) {
            case "t":  skip = 2; if (i==0) {F[0] = "m";relx = F[1];rely = F[2];F[1] = 0;F[2] = 0}else{F[0] = "m";}
            break;
            case "r":  F[0] = "l";skip = 2;
            break;
            case "v":  F[0] = "c";skip = 6;
            break;
            case "q":  F[0] = "qb"; skip = 4;
            break;
            case "s":  F[0] = "S"; crx -= relx; cry -= rely; skip = 6;
            break;
            case "u":  F[0] = "T"; crx -= relx; cry -= rely; skip = 4;
            break;
            case "h":  F[0] = "l"; F = NAIBU.hnst(1,F,0); skip = 2;
            break;
            case "w":  F[0] = "l"; F = NAIBU.vnst(1,F,0); skip = 2;
            break;
          }
        }
        com = F[0];
        var bcom = com.match(big);
        if (bcom) { //絶対座標
          switch (bcom.toString()) {
            case "C":  F[0] = "c";
            break;
            case "L":  F[0] = "l";
            break;
            case "M":  F[0] = "m";
            break;
            case "H":  F[0] = "l"; F = NAIBU.hnst(1,F,noy);
            break;
            case "V":  F[0] = "l"; F = NAIBU.vnst(1,F,nox);
            break;
            case "Q":  F[0] = "qb";
            break;
            case "S":  F[0] = "c"; if (preCom != "c") {crx=nox;cry=noy;}; F = NAIBU.nst(4,F,crx,cry);
            break;
            case "T":  F[0] = "qb  "; if (preCom != "qb") {crx=nox;cry=noy}; F = NAIBU.nst(2,F,crx,cry);
            break;
          };
        }
        var fl2 = F[F.length - 2],  fl1 = F[F.length - 1];
        preCom = F[0];
        if (F.length > 4) {
          mf4 = F[F.length-4]; mf3 = F[F.length-3]; mf2 = F[F.length-2]; mf1 = F[F.length-1];
          crx = 2*mf2 - mf4 + relx; cry = 2*mf1 - mf3 + rely;
        }
        var b = 1;
        for (var j=1;j<F.length;j+=2) { //CTMで座標変換
          var p = new Point(F[j]+relx,F[j+1]+rely);
          var pmt = p.matrixTransform(ttm);
          if (j == skip*b-1) {
            relx += F[j]; rely += F[j+1]; b++;
          }
          F[j] = parseFloat(pmt.x);
          F[j+1] = parseFloat(pmt.y);
          minx = Math.min(minx,F[j]); //負の値があれば、minx,yに入れる
          miny = Math.min(miny,F[j+1]);
          delete p,  pmt;
        }
        if (b > 1) { fl2 = 0; fl1 = 0;}
        if (!isNaN(fl2)) { //相対座標を絶対座標に変換
          nox = fl2+relx;
        }
        if (!isNaN(fl1)) {
          noy = fl1+rely;
        }
      } else if (aaa.test(com)) { //ArcTo
        F[0] = "c"; preCom = "A";
        var relx = 0, rely = 0;
        if (com.indexOf("a") != -1){
          preCom = "a";
          relx = nox; rely = noy;
        }
        var ar = new STArc();
        ar.sset(nox,noy,F,relx,rely);
        nox = F[F.length-2] + relx; noy = F[F.length-1] + rely;
        var pl = new PList(ar.D);
        var a = pl.matrixTransform(ttm);
        delete pl;
        for (var k=0,ard=a.list,dli=ard.length;k<dli;k++) {
          F[k+1] = ard[k];
        }
        if (F.length == 8){
          F[7] = "";
        }
      }
      if (F[0] == "qb") { //最後も曲線となるVMLの仕様を避けるため
        for (var c=1,n = (F.length-1)/4;c<=n;c++) {
          F[4*c+1] = " l "+  F[2*c+1]  +" "+  F[3*c+1];
        }
      } else if (F[0] == "m") { //MoveToが複数の座標ならば、2番目以降の座標ペアをLineToとして処理
        if (F.length > 3) {
          var f2 = F[2];
          F.splice(2,1,f2,"l");
        }
      }
      D[i] = F;
      G[i] = F.join(" ");
    }
    if (minx != 0 || miny != 0) {
      G = D._minm(minx,miny);
    }
    if (!G[G.length-1].match(/e\s?$/)) { G[G.length-1] += "e"; }//最後がeで終わらなければ、eをつける
    dat = G.join(" ");
    delete axe,big,small,aaa;
  }  catch(e) {stlog.add(e,355);}
  try {
    this.tar.setAttribute("path",dat);
    this.tar.setAttribute("coordsize",w  +" "+  h);
    this.tar.setAttribute("coordorgin","0  0");
    this.paint.set(this.tar,w,h,ttm);
    if (minx != 0 || miny != 0) {
      this.tar.style.posLeft = minx;
      this.tar.style.posTop = miny;
    }
  }  catch(e) {stlog.add(e,372);}
}

//前回の座標を反転させる。それを挿入
NAIBU.nst = function ( /*int*/ skip, /*Array*/ F, /*float*/ crx, /*float*/ cry) {
  for (var w=1,n = (F.length-1)/skip;w<=n;w++) {
    var ski = skip + 2,  sk = skip + 1;
    var it = ski * w - sk;
    var fit = F[it];
    F.splice(it,1,crx,cry,fit);
    cry = 2*F[ski*w] - F[ski*w-2]; crx = 2*F[ski*w-1] - F[ski*w-3];
  }
  return F;
}
//vnstはVコマンド用。hnstはHコマンド用
NAIBU.vnst = function (skip,F,nox) {
  for (var w=1,n = F.length-1;w<=n;w++) {
    var it = 2 * w - 1;
    F.splice(it,1,nox,F[it]);
  }
  return F;
}
NAIBU.hnst = function (skip,F,noy) {
  for (var w=1,n = F.length-1;w<=n;w++) {
    var it = 2 * w - 1;
    F.splice(it,1,F[it],noy);
  }
  return F;
}
//配列の座標値すべてに、minxとminy分を引く
Array.prototype._minm = function( /*float*/ minx, /*float*/ miny) {
  var self = this;
  var g = new Array(self.length);
  try {
  for (var i=0,ili=self.length;i<ili;i++) {
    var ar = self[i];
    var com = ar[0];
    for (var j=1,ari=ar.length;j<ari;j+=2) {
      if (isNaN(ar[j])) {j--;
      }  else{
        ar[j] = ar[j] - minx;
        ar[j+1] = ar[j+1] - miny;
      }
    }
    g[i] = ar.join(" ");
  }
  }  catch(e) {stlog.add(e,4472);}
  return g;
}

//polygon要素を処理
function STPolygon( /*element*/ cir) {
  this.tar = cir;
  this.spoints = this.tar.attributes["points"].nodeValue;
  this.paint = new NAIBU.PaintColor(this.tar);
  this.transformable = new TransformList(cir);
  return this;
}
STPolygon.prototype.set = function polygonset(w,h,matrix) {
  var dat;
  var ttm = matrix.multiply(this.transformable.tr.matrix);
  try {
    dat = this.spoints;
    var datt = dat;
    var F = datt.replace(/^\s+|\s+$/g, "").replace(/[\s,]{2,}|\s/g, ",").split(","); //区切り文字を,（コンマ）に統一
    var pl = new PList(F);
    var plm = pl.matrixTransform(ttm);
    dat = plm.list.join(" ");
    dat = "m  " + dat;
    dat = dat.replace(/m  (\d+)[\s,]+(\d+)/,"m $1 $2 l") + "x e";
    delete pl,  plm;
  } catch(e) {stlog.add(e,395);}
  try {
    this.tar.setAttribute("path",dat);
    this.tar.setAttribute("coordsize",w  +" "+  h);
    this.tar.setAttribute("coordorgin","0  0");
    this.paint.set(this.tar,w,h,ttm);
  } catch(e) {stlog.add(e,406);}
}

//polyline要素を処理
function STPolyline( /*element*/ cir) {
  this.tar = cir;
  this.spoints = this.tar.attributes["points"].nodeValue;
  this.paint = new NAIBU.PaintColor(this.tar);
  this.transformable = new TransformList(cir);
  return this;
}
STPolyline.prototype.set = function polylineset(w,h,matrix) {
  var dat;
  var ttm = matrix.multiply(this.transformable.tr.matrix);
  try {
    dat = this.spoints;
    var datt = dat;
    var F = datt.replace(/^\s+|\s+$/g, "").replace(/[\s,]{2,}|\s/g, ",").split(",");
    var pl = new PList(F);
    var plm = pl.matrixTransform(ttm);
    dat = plm.list.join(" ");
    dat = "m  " + dat;
    dat = dat.replace(/m  (\d+)[\s,]+(\d+)/,"m  $1  $2  l") + "  e";
    delete pl,  plm;
  }  catch(e) {stlog.add(e,429);}
  try {
    this.tar.setAttribute("path",dat);
    this.tar.setAttribute("coordsize",w  +" "+  h);
    this.tar.setAttribute("coordorgin","0  0");
    this.paint.set(this.tar,w,h,ttm);
  }  catch(e) {stlog.add(e,440);}
}

//circle要素を処理
function STCircle( /*element*/ cir) {
  this.tar = cir;
  try {
    this.paint = new NAIBU.PaintColor(cir)
    this.cx = parseFloat(cir.getAttribute("cx"));
    this.cy = parseFloat(cir.getAttribute("cy"));
    this.r = parseFloat(cir.getAttribute("r"));
    this.transformable = new TransformList(cir);
  } catch(e) {stlog.add(e,450);}
  return this;
}
//ベジェ曲線で円を表現する
STCircle.prototype.set = function ovalset(w,h,matrix) {
  var cx = this.cx,  cy = this.cy,  rx = this.r,  ry=  this.r;
  if (!cx) {cx = 0;}
  if (!cy) {cy = 0;}
  var top = cy - ry,  left = cx - rx,  bottom = cy + ry,  right = cx + rx;
  try {
  var ttm = matrix.multiply(this.transformable.tr.matrix);
  var rrx = rx*0.55228,  rry = ry*0.55228;
  var list = new Array(cx,top,cx-rrx,top,left,cy-rry,left,cy,left,cy+rry,cx-rrx,bottom,cx,bottom,cx+rrx,bottom,right,cy+rry,right,cy,right,cy-rry,cx+rrx,top,cx,top);
  var pl = new PList(list);
  var plm = pl.matrixTransform(ttm);
  plm.list[0] = "m"  +plm.list[0];
  plm.list[1] = plm.list[1]+  "c";
  var dat = plm.list.join(" ");
  delete pl; delete plm;
  } catch(e) {stlog.add(e,468);}
  try {
    this.tar.setAttribute("path",dat+"x  e");
    this.tar.setAttribute("coordsize",w  +" "+  h);
    this.tar.setAttribute("coordorgin","0  0");
    this.paint.set(this.tar,w,h,ttm);
  } catch(e) {stlog.add(e,479);}
}

//ellipse要素を処理
function STEllipse( /*element*/ cir) {
  this.tar = cir;
  try {
    this.paint = new NAIBU.PaintColor(cir)
    this.transformable = new TransformList(cir);
    this.cx = parseFloat(cir.getAttribute("cx"));
    this.cy = parseFloat(cir.getAttribute("cy"));
    this.rx = parseFloat(cir.getAttribute("rx"));
    this.ry = parseFloat(cir.getAttribute("ry"));
  } catch(e) {stlog.add(e,490);}
  return this;
}
STEllipse.prototype.set = function elliset(w,h,matrix) {
  var cx = this.cx,  cy = this.cy,  rx = this.rx,  ry=  this.ry;
  if (!cx) {cx = 0;}
  if (!cy) {cy = 0;}
  var top = cy - ry,  left = cx - rx,  bottom = cy + ry,  right = cx + rx;
  try {
  var ttm = matrix.multiply(this.transformable.tr.matrix);
  var rrx = rx*0.55228,  rry = ry*0.55228;
  var list = new Array(cx,top,cx-rrx,top,left,cy-rry,left,cy,left,cy+rry,cx-rrx,bottom,cx,bottom,cx+rrx,bottom,right,cy+rry,right,cy,right,cy-rry,cx+rrx,top,cx,top);
  var pl = new PList(list);
  var plm = pl.matrixTransform(ttm);
  plm.list[0] = "m"  +plm.list[0];
  plm.list[1] = plm.list[1]+  "c";
  var dat = plm.list.join(" ");
  delete pl,  plm;
  } catch(e) {stlog.add(e,508);}
  try {
    this.tar.setAttribute("path",dat+"x  e");
    this.tar.setAttribute("coordsize",w  +" "+  h);
    this.tar.setAttribute("coordorgin","0  0");
    this.paint.set(this.tar,w,h,ttm);
  } catch(e) {stlog.add(e,519);}
}

//rect要素を処理
function STRectElement( /*element*/ rect) {
  this.tar = rect;
  try {
    this.x = parseFloat(rect.getAttribute("x"));
    this.y = parseFloat(rect.getAttribute("y"));
    this.width = parseFloat(rect.getAttribute("svgwidth"));
    this.height = parseFloat(rect.getAttribute("svgheight"));
    if (rect.getAttribute("rx") || rect.getAttribute("ry")) {
      this.rx = parseFloat(rect.getAttribute("rx"));
      this.ry = parseFloat(rect.getAttribute("ry"));
      if (!this.rx) {this.rx = this.ry;
      } else if (this.width/2 < this.rx) { //rx属性が幅より大きければ、幅の半分を属性に設定
        this.rx = this.width/2;
      }
      if (!this.ry) {this.ry = this.rx;
      } else if (this.height/2 < this.ry) {
        this.ry = this.height/2;
      }
    }
  }  catch(oe) {stlog.add(oe,541);}
  try {
    this.transformable = new TransformList(this.tar);
    this.paint = new NAIBU.PaintColor(this.tar);
  }  catch(ee) {stlog.add(ee,545);}
  return this;
}
STRectElement.prototype.set = function rectset(w,h,matrix) {
  try {
    var ttm = matrix.multiply(this.transformable.tr.matrix);
    var p1 = new Point(this.x,this.y),  p2 = new Point(this.x,this.y+this.height),  p3 = new Point(this.x+this.width,this.y+this.height),  p4 = new Point(this.x+this.width,this.y);
    var p1mt = p1.matrixTransform(ttm),  p2mt = p2.matrixTransform(ttm),  p3mt = p3.matrixTransform(ttm),  p4mt = p4.matrixTransform(ttm);
    var dat = "m  " +p1mt.x+ "  " +p1mt.y+ "l " +p2mt.x+ " " +p2mt.y+ "l " +p3mt.x+ " " +p3mt.y+ "l " +p4mt.x+ " " +p4mt.y+ " x e";
    delete p,  p1mt;
    if (this.rx) {
      var xw = this.x + this.width,  yh = this.y + this.height;
      var rrx = 0.5228 * this.rx,  rry = 0.5228 * this.ry;
      var a = xw - this.rx,  b = this.x + this.rx,  c = this.y + this.ry,  d = yh - this.ry;
      var list = new Array(b,this.y,"l",a,this.y,"c",a+rrx,this.y,xw,c-rry,xw,c,"l",xw,d,"c",xw,d+rry,a+rrx,yh,a,yh,"l",b,yh,"c",b-rrx,yh,this.x,d+rry,this.x,d,"l",this.x,c,"c",this.x,c-rry,b-rrx,this.y,b,this.y);
      var pl = new PList(list);
      var plm = pl.matrixTransform(ttm);
      dat = "m" + plm.list.join(" ");
      delete list,  pl,  plm;
    }
  }  catch(e) {stlog.add(e,564);}
  try {
    this.tar.setAttribute("path",dat);
    this.tar.setAttribute("coordsize",w  +" "+  h);
    this.tar.setAttribute("coordorgin","0  0");
    this.paint.set(this.tar,w,h,ttm);
  }  catch(ee) {stlog.add(ee,576);}
}

//image要素の処理
function STImage( /*element*/ ele){
  this.tar = ele;
  this.transformable = new TransformList(ele);
  this.x = ele.getAttribute("x") || 0;
  this.y = ele.getAttribute("y") || 0;
  this.width = ele.getAttribute("svgwidth");
  this.height = ele.getAttribute("svgheight");
  ele.setAttribute("xlink:show", "embed")
  this.xlink = new NAIBU.XLink(ele);
  this.paint = new NAIBU.PaintColor(ele,this.width,this.height);
  return this;
}
STImage.prototype.set = function imagesets(w,h,matrix){
  try {
    var ttm = matrix.multiply(this.transformable.tr.matrix);
    var ts = this.tar.style;
    ts.position = "absolute";
    var pt = new Point(parseFloat(this.x), parseFloat(this.y));
    var ptt = pt.matrixTransform(ttm);
    ts.left = ptt.x;
    ts.top =  ptt.y;
    ts.width =  parseFloat(this.width) * ttm.a;
    ts.height = parseFloat(this.height) * ttm.d;
    if (ttm.b != 0 || ttm.c != 0 || this.paint.fillopacity) {//フィルター　プロパティを使うと、PNGの透過性がなくなるので注意
      ts.filter = "progid:DXImageTransform.Microsoft.Matrix progid:DXImageTransform.Microsoft.Alpha";
      var ttfi = this.tar.filters.item('DXImageTransform.Microsoft.Matrix');
      ttfi.M11 = 1;
      ttfi.M12 = ttm.b;
      ttfi.M21 = ttm.c;
      ttfi.M22 = 1;
      ttfi.sizingMethod = "auto expand";
      var ttfia = this.tar.filters.item('DXImageTransform.Microsoft.Alpha');
      ttfia.Style = 0;
      ttfia.Opacity = parseFloat(this.paint.fillopacity)*100;
    }
    this.xlink.set();
    delete pt, ptt;
  } catch(e) {stlog.set(e,21896);}
}

//色のキーワード
var colorsname = {"aliceblue":"#F0F8FF","antiquewhite":"#FAEBD7","aqua":"#00FFFF","aquamarine":"#7FFFD4","azure":"#F0FFFF","beige":"#F5F5DC","bisque":"#FFE4C4","black":"#000000","blanchedalmond":"#FFEBCD","blue":"#0000FF","blueviolet":"#8A2BE2","brown":"#A52A2A","burlywood":"#DEB887","cadetblue":"#5F9EA0","chartreuse":"#7FFF00","chocolate":"#D2691E","coral":"#FF7F50","cornflowerblue":"#6495ED","cornsilk":"#FFF8DC","crimson":"#DC143C","cyan":"#00FFFF","darkblue":"#00008B","darkcyan":"#008B8B","darkgoldenrod":"#B886B","darkgray":"#A9A9A9","darkgreen":"#006400","darkgrey":"#A9A9A9","darkkhaki":"#BDB76B","darkmagenta":"#8B008B","darkolivegreen":"#556B2F","darkorange":"#FF8C00","darkorchid":"#9932CC","darkred":"#8B0000","darksalmon":"#E9967A","darkseagreen":"#8FBC8F","darkslateblue":"#483D8B","darkslategray":"#2F4F4F","darkslategrey":"#2F4F4F","darkturquoise":"#00CED1","darkviolet":"#9400D3","deeppink":"#FF1493","deepskyblue":"#00BFFF","dimgray":"#696969","dimgrey":"#696969","dodgerblue":"#1E90FF","firebrick":"#B22222","floralwhite":"#FFFAF0","forestgreen":"#228B22","fuchsia":"#FF00FF","gainsboro":"#DCDCDC","ghostwhite":"#F8F8FF","gold":"#FFD700","goldenrod":"#DAA520","gray":"#808080","grey":"#808080","green":"#008000","greenyellow":"#ADFF2F","honeydew":"#F0FFF0","hotpink":"#FF69B4","indianred":"#CD5C5C","indigo":"#4B0082","ivory":"#FFFFF0","khaki":"#F0E68C","lavender":"#E6E6FA","lavenderblush":"#FFF0F5","lawngreen":"#7CFC00","lemonchiffon":"#FFFACD","lightblue":"#ADD8E6","lightcoral":"#F08080","lightcyan":"#E0FFFF","lightgoldenrodyellow":"#FAFAD2","lightgray":"#D3D3D3","lightgreen":"#90EE90","lightgrey":"#D3D3D3","lightpink":"#FFB6C1","lightsalmon":"#FFA07A","lightseagreen":"#20B2AA","lightskyblue":"#87CEFA","lightslategray":"#778899","lightslategrey":"#778899","lightsteelblue":"#B0C4DE","lightyellow":"#FFFFE0","lime":"#00FF00","limegreen":"#32CD32","linen":"#FAF0E6","magenta":"#FF00FF","maroon":"#800000","mediumaquamarine":"#66CDAA","mediumblue":"#0000CD","mediumorchid":"#BA55D3","mediumpurple":"#9370DB","mediumseagreen":"#3CB371","mediumslateblue":"#7B68EE","mediumspringgreen":"#00FA9A","mediumturquoise":"#48D1CC","mediumvioletred":"#C71585","midnightblue":"#191970","mintcream":"#F5FFFA","mistyrose":"#FFE4E1","moccasin":"#FFE4B5","navajowhite":"#FFDEAD","navy":"#000080","oldlace":"#FDF5E6","olive":"#808000","olivedrab":"#6B8E23","orange":"#FFA500","orangered":"#FF4500","orchid":"#DA70D6","palegoldenrod":"#EEE8AA","palegreen":"#98FB98","paleturquoise":"#AFEEEE","palevioletred":"#DB7093","papayawhip":"#FFEFD5","peachpuff":"#FFDAB9","peru":"#CD853F","pink":"#FFC0CB","plum":"#DDA0DD","powderblue":"#B0E0E6","purple":"#800080","red":"#FF0000","rosybrown":"#BC8F8F","royalblue":"#4169E1","saddlebrown":"#8B4513","salmon":"#FA8072","sandybrown":"#F4A460","seagreen":"#2E8B57","seashell":"#FFF5EE","sienna":"#A0522D","silver":"#C0C0C0","skyblue":"#87CEEB","slateblue":"#6A5ACD","slategray":"#708090","slategrey":"#708090","snow":"#FFFAFA","springgreen":"#00FF7F","steelblue":"#4682B4","tan":"#D2B48C","teal":"#008080","thistle":"#D8BFD8","tomato":"#FF6347","turquoise":"#40E0D0","violet":"#EE82EE","wheat":"#F5DEB3","white":"#FFFFFF","whitesmoke":"#F5F5F5","yellow":"#FFFF00","yellowgreen":"#9ACD32"};
//PaintColor 色、線などをすべてコントロール
NAIBU.PaintColor = function( /*element*/ ele, /*float*/ w, /*float*/ h) {
  this.tar = ele;
  this.fillopacity = null;
  this.strokeopacity = null;
  this.fill = "black";
  this.stroke = "none";
  this.fillon = true;
  this.strokeon = true;
  this.strokeweight = "1";
  this.strokelinejoin = "miter";
  this.strokemiterlimit = "4";
  this.strokeendcap = "butt";
if (ele) { //親要素の値を継承
  var elpn = ele.parentNode;
  if (elpn.tagName == "group") {
    var pnp = new NAIBU.PaintColor(elpn);
    for (var p  in  pnp) {
      if (p == "tar" || p == "fillon" || p == "strokeon") {
      }  else{
        this[p] = pnp[p];
      }
    }
  }
  var f = this.getAttribute("fill");
  if (f) {
    this.fill = colorsname[f] ? colorsname[f] : f;
  }
  var s = this.getAttribute("stroke");
  if (s) {
    this.stroke = colorsname[s] ? colorsname[s] : s;
  }
  if (this.fill == "none") {
    this.fillon = false;
  }
  if (this.stroke == "none") {
    this.strokeon = false;
  }
  var op = this.getAttribute("opacity");
  if (op) {
    this.fillopacity = op;
    this.strokeopacity = op;
  }
  var fo = this.getAttribute("fillopacity");
  if (fo) {
    this.fillopacity = fo;
  }
  var so = this.getAttribute("strokeopacity");
  if (so) {
    this.strokeopacity = so;
  }
  var sw = this.getAttribute("strokewidth") || this.getAttribute("strokesvgwidth");
  if (sw) {
    this.strokeweight = sw;
  }
  var sj = this.getAttribute("strokelinejoin");
  if (sj) {
    this.strokejoin = sj;
  }
  var smili = this.getAttribute("strokemiterlimit");
  if (smili) {
    this.strokemiterlimit = smili;
  }
  var scap = this.getAttribute("strokelinecap");
  if (scap) {
    this.strokeendcap = scap;
  }
  if (this.strokeendcap == "butt") {  this.strokeendcap = "flat"; }
  var sdash = this.getAttribute("strokedasharray");
  if (sdash) {
    if (sdash == "none") {  sdash = "solid"; }
    var strs = sdash.split(",");
    for (var i=0,sli=strs.length;i<sli;i++) {
      strs[i] = Math.ceil(parseFloat(strs[i]) / parseFloat(this.strokeweight)); //精密ではないので注意
    }
    this.strokedashstyle = strs.join(" ");
    if (strs.length % 2 == 1) { this.strokedashstyle += " " +this.strokedashstyle;}
  }
}
  return this;
}
NAIBU.PaintColor.prototype.getAttribute = function pcgetAttribute( /*string*/ name) {
  try {
    var element = this.tar;
    var style = element.style[name];
    if (style) {
      return style;
    }
    var attribute = element.attributes[name];
    var s = attribute ? attribute.nodeValue : null;
    return s;
  }  catch(e) {stlog.add(e,659); return null;}
}
NAIBU.PaintColor.prototype.set = function pcset( /*element*/ el, /*float*/ w, /*float*/ h, /*Matrix*/ matrix) {
  var fillElement = document.createElement("v:fill");
  var strokeElement = document.createElement("v:stroke");
  if (this.fillon) {
    try {
    if (this.fillopacity) {
      fillElement.setAttribute("opacity", this.fillopacity);
    }
    if (this.fill.match(/url\(#(\w+)/)) { //fill属性の値がurl(#id)ならば、idを設定したグラデーション関連要素を呼び出す
      var gradfill = document.getElementById(RegExp.$1);
      var ftype = gradfill.getAttribute("type");
      this.gradient(gradfill,fillElement,ftype);
    }  else{
      fillElement.setAttribute("color",this.fill);
    }
    }  catch(e) {stlog.add(e,682); fillElement.setAttribute("on","true");
      fillElement.setAttribute("color","black");}
  }  else{
    fillElement.setAttribute("on","false");
  }
  if (this.strokeon) {
    try {
    strokeElement.setAttribute("joinstyle",this.strokejoin);
    if (this.strokedashstyle) {
    strokeElement.setAttribute("dashstyle",this.strokedashstyle);
    }
    strokeElement.setAttribute("miterlimit",this.strokemiterlimit);
    strokeElement.setAttribute("endcap",this.strokeendcap);
    var wwhh = w*w + h*h;
    var msms = Math.sqrt(wwhh / 2);
    var sw = new STLength(this.strokeweight, msms);
    var swx = sw.value * Math.sqrt(Math.abs(matrix.a * matrix.d - matrix.b * matrix.c));
    strokeElement.setAttribute("weight", swx + "px");
    if (swx < 1) {
      this.strokeopacity = this.strokeopacity ? this.strokeopacity * swx : swx;
    }
    if (this.strokeopacity) {
      strokeElement.setAttribute("opacity", this.strokeopacity);
    }
    if (this.stroke.match(/url\(#(\w+)/)) {
      var gradstroke = document.getElementById(RegExp.$1);
      var stype = gradstroke.getAttribute("type");
      this.gradient(gradstroke,strokeElement,stype);
    }  else{
      strokeElement.setAttribute("color",this.stroke);
    }
    }  catch(e) {stlog.add(e,720); strokeElement.setAttribute("on","false"); }
  }  else{
    strokeElement.setAttribute("on","false");
  }
  el.appendChild(fillElement);
  el.appendChild(strokeElement);
}

//linearGradient、radialGradient要素を処理
NAIBU.PaintColor.prototype.gradient = function pcgradient( /*element*/ gel, /*element*/ ele, /*string*/ type) {
  var tgc = gel;
  var pgs;
  var ang; var rsize; var rf;
  ele.setAttribute("method","sigma");
  try {
  if (type == "gradient") {
    var x1 = parseFloat(gel.getAttribute("x1").replace(/%/,"")),  y1 = parseFloat(gel.getAttribute("y1").replace(/%/,""));
    var x2 = parseFloat(gel.getAttribute("x2").replace(/%/,"")),  y2=  parseFloat(gel.getAttribute("y2").replace(/%/,""));
    ang =   270 - Math.atan2(y2-y1,x2-x1)*180/Math.PI; if (ang>=360) {ang = ang-360;}
    ele.setAttribute("angle",ang+"");
    ele.setAttribute("focus","0%");
  } else if (type == "gradientRadial") {
    var cx = Math.round(parseFloat(gel.getAttribute("cx"))*100)/100,  cy = Math.round(parseFloat(gel.getAttribute("cy"))*100)/100;
    var rx = Math.round(parseFloat(gel.getAttribute("rx"))*100)/100,  ry = Math.round(parseFloat(gel.getAttribute("ry"))*100)/100;
    rsize = rx+  ","  +ry;
    var x = cx - rx,  y = cy - ry;
    rf = x+  ","  +y;
    ele.setAttribute("focus","100%");
    ele.setAttribute("focussize",rsize);
    ele.setAttribute("focusposition",rf);
  }
  }  catch(e) {stlog.add(e,749);if (ele) {ele.setAttribute("angle","270");}}
  try {
  ele.setAttribute("type",type);
  if (gel.getAttribute("xlink:href")) {
    pgs = document.getElementById(gel.getAttribute("xlink:href").match(/\w+/));
  }  else{
    pgs = tgc;
  }
  var tc = pgs.getElementsByTagName("stop");
  var ttc = new Array(tc.length),  ttco = new Array(tc.length);
  for (var i=0,tci=tc.length;i<tci;i++) {
    var tcp = new NAIBU.PaintColor(tc[i]);
    ttc[i] = tcp.getAttribute("stopcolor");
    ttco[i] = tcp.getAttribute("stopopacity");
    delete tcp;
  }
  if (ttco[0]) {ele.setAttribute("o:opacity2",ttco[0]);}
  if (ttco[ttco.length-1]) {ele.setAttribute("opacity",ttco[ttco.length-1]);}
  if (ttc.length > 2) {
    var tgoff = tc[0].getAttribute("offset");
    if (!tgoff.match(/%/)) {tgoff = Math.round(parseFloat(tgoff)*100);}
    var cst = "";
    ele.setAttribute("color",ttc[0]);
    ele.setAttribute("color2",ttc[ttc.length-1]);
    for (var i=0;i<ttc.length;i++) {
      var tgoff = tc[i].getAttribute("offset");
      if (!tgoff.match(/%/)) {tgoff = Math.round(parseFloat(tgoff)*100);}
      cst = cst  +tgoff+  "%  "  +ttc[i]+  ",";
    }
    ele.setAttribute("colors",cst);
  }  else{
    ele.setAttribute("color",ttc[0]);
    ele.setAttribute("color2",ttc[ttc.length-1]);
  }
  delete ttc,  ttco;
  }  catch(e) {stlog.add(e,784);}
}

//transform属性を処理
function TransformList( /*element*/ ele) {
  this.on = true;
  try {
  var ep = ele.parentNode;
  var tf = "";
  if (ele.getAttribute("transform")) {
    tf = ele.getAttribute("transform");
  }
  while(ep.tagName == "group" || ep.tagName == "A") { //先祖要素のtransform属性を取得
    if (ep.getAttribute("transform")) {
      tf = ep.getAttribute("transform") + tf;
      ele.setAttribute("transform",tf);
    }
    ep = ep.parentNode;
  }
  this.tr = new Transform();
  var tft =   ele.getAttribute("transform");
  if (tft) {
    var coma = tft.match(/[A-Za-z]+(?=\s*\()/g);
    var list = tft.match(/\([^\)]+\)/g);
    this.tr.matrix = this.tr.getMatrix(list[0],coma[0]);
    for (var i=1;i<coma.length;i++) {
      this.tr.set(list[i],coma[i]);
    }
    delete coma,  list;
  }  else{
    this.on = false;
    this.tr.matrix = new Matrix(1,0,0,1,0,0);
  }
  }  catch(e) {stlog.add(e,816);}
  return this;
}

function Transform() {
  this.matrix = new Matrix(1,0,0,1,0,0);
  return this;
}
Transform.prototype.set = function transformset(list,c) {
  var matri = this.getMatrix(list,c);
  var mat = this.matrix;
  this.matrix = mat.multiply(matri);
  delete mat,  matri;
}
Transform.prototype.getMatrix = function transformgetMatrix(list,com) {
  var a,b,c,d,e,f;
  var deg = list.match(/[\-\d\.e]+/g);
  var rad =   parseFloat(deg[0]) / 180 * Math.PI;
  for (var i=0,degli=deg.length;i<degli;i++) {
    var et = deg[i].match(/([\-\d\.]+)e([\-\d\.]+)/);
    if (et) {
      deg[i] = parseFloat(RegExp.$1) * Math.pow(10,parseFloat(RegExp.$2));
    }
  }
  if (deg.length == 6) {
    a = parseFloat(deg[0]); b = parseFloat(deg[1]); c = parseFloat(deg[2]); d = parseFloat(deg[3]); e = parseFloat(deg[4]); f = parseFloat(deg[5]);
  } else if (deg.length == 3) {
    var cx = parseFloat(deg[1]), cy = parseFloat(deg[2]);
    a = Math.cos(rad); b = Math.sin(rad); c = -b; d = a; e = (1-a)*cx-c*cy; f = -b*cx+(1-d)*cy;
  } else if (deg.length <= 2) {
    switch (com) {
      case "translate":
        a = 1; b = 0; c = 0; d = 1; e = parseFloat(deg[0]); f = parseFloat(deg[1] || 0);
      break;
      case "scale":
        a = parseFloat(deg[0]); b = 0; c = 0; d = parseFloat(deg[1] || deg[0]); e = 0; f = 0;
      break;
      case "rotate":
        a = Math.cos(rad); b = Math.sin(rad); c = -b; d = a; e = 0; f = 0;
      break;
      case "skewX":
        a = 1; b = 0; c = Math.tan(rad); d = 1; e = 0; f = 0;
      break;
      case "skewY":
        a = 1; b = Math.tan(rad); c = 0; d = 1; e = 0; f = 0;
      break;
    }
  }
  var matri = new Matrix(a,b,c,d,e,f);
  return matri;
}

//SVGPointを参照
function Point( /*number*/ x, /*number*/ y) {
  this.x = x; this.y = y;
  return this;
}
Point.prototype.matrixTransform = function pmatrixtransform( /*Matrix*/ m) {
  var x = parseInt(m.a * this.x + m.c * this.y + m.e);
  var y = parseInt(m.b * this.x + m.d * this.y + m.f);
  if (-1 < x) {if (x < 1) {x=1;}}
  if (-1 < y) {if (y < 1) {y=1;}}
  var s = new Point(x,y);
  return s;
}

//Pointのリスト。一括で処理できる
function PList( /*Array*/ d) {
  this.list = d;
  return this;
}
PList.prototype.matrixTransform = function plmatrixtransform( /*Matrix*/ ttm) {
  var F = this.list;
  for (var j=0,Fli=F.length;j<Fli;j+=2) {
    if (isNaN(F[j])) {
      if (F[j].match(/[a-z]/i)) {
        j--; continue;
      }
    }
    var p = new Point(parseFloat(F[j]),parseFloat(F[j+1]));
    var pmt = p.matrixTransform(ttm);
    F[j] = parseFloat(pmt.x);
    F[j+1] = parseFloat(pmt.y);
    delete p,  pmt;
  }
  var s = new PList(F);
  return s;
}

//SVGMatrixを参照。行列
function Matrix(a,b,c,d,e,f) { //引数はすべてNumber型
  this.a = a; this.b = b; this.c = c; this.d = d; this.e = e; this.f = f;
  this.antor = Math.PI/180;
  return this;
}
//Matrix同士の積を算出
Matrix.prototype.multiply = function matrixmultiply( /*Matrix*/ m) {
  var a = this.a * m.a + this.c * m.b;
  var b = this.b * m.a + this.d * m.b;
  var c = this.a * m.c + this.c * m.d;
  var d = this.b * m.c + this.d * m.d;
  var e = this.a * m.e + this.c * m.f + this.e;
  var f = this.b * m.e + this.d * m.f + this.f;
  var s = new Matrix(a,b,c,d,e,f);
  return s;
}

//SVGViewSpecを参照
function STViewSpec( /*element*/ ele) {
  this.tar = ele;
  var vb = ele.getAttribute("viewBox");
  if (vb) {
    var ovb = vb.replace(/[\s,]+/g, " ").split(" ");
    this.viewBox = new STRect(parseFloat(ovb[0]), parseFloat(ovb[1]), parseFloat(ovb[2]), parseFloat(ovb[3]));
  }
  var par = ele.getAttribute("preserveAspectRatio") || "xMidYMid meet";
  var sa = 1, mos = 0;
  if (par.match(/x(Min|Mid|Max)Y(Min|Mid|Max)(?:\s+(meet|slice))?/)) {
    switch (RegExp.$1) {
      case "Min":
        sa += 1;
      break;
      case "Mid":
        sa += 2;
      break;
      case "Max":
        sa += 3;
      break;
    }
    switch (RegExp.$2) {
      case "Min":
      break;
      case "Mid":
        sa += 3;
      break;
      case "Max":
        sa += 6;
      break;
    }
    if (RegExp.$3 == "slice") {
      mos = 2;
    } else {
      mos = 1;
    }
  }
  this.preserveAspectRatio = new STPreserveAspectRatio(sa, mos);
  return this;
}
STViewSpec.prototype.set = function vss( /*float*/ vw, /*float*/ vh) {
  var vB = this.viewBox, par = this.preserveAspectRatio;
  try {
  if (!vB) {
    return new Matrix(1, 0, 0, 1, 0, 0);
  }
  var vbx = vB.x, vby = vB.y, vbw = vB.width, vbh = vB.height;
  var rw = vw / vbw, rh = vh / vbh;
  var xr = 1, yr = 1, tx, ty;
  if (par.align == 1) { //none
    xr = rw;
    yr = rh;
    tx = -vbx * xr;
    ty = -vby * yr;
  } else {
    var ax = (par.align + 1) % 3 + 1;
    var ay = Math.round(par.align / 3);
    switch (par.meetOrSlice) {
      case 1: //meet
        xr = yr = Math.min(rw, rh);
      break;
      case 2: //slice
        xr = yr = Math.max(rw, rh);
      break;
    }
    tx = -vbx * xr;
    ty = -vby * yr;
    switch (ax) {
      case 1: //xMin
      break;
      case 2: //xMid
        tx += (vw - vbw * xr) / 2;
      break;
      case 3: //xMax
        tx += vw - vbw * xr;
      break;
    }
    switch (ay) {
      case 1: //YMin
      break;
      case 2: //YMid
        ty += (vh - vbh * yr) / 2;
      break;
      case 3: //YMax
        ty += vh - vbh * yr;
      break;
    }
  }
  this.tar.parentNode.style.marginLeft = tx;
  this.tar.parentNode.style.marginTop = ty;
  var m = new Matrix(xr, 0, 0, yr, 0, 0);
  return m;
  } catch(e) {stlog.add(e,1031);}
}

//SVGRectを参照
function STRect(x,y,w,h) { //引数はすべてNumber型
  this.x = x; this.y = y; 
  this.width = w; this.height = h;
  return this;
}

//SVGPreserveAspectRatioを参照
function STPreserveAspectRatio( /*int*/ a, /*int*/ mos) {this.align=a;this.meetOrSlice=mos;
  return this;
}

//path要素のd属性で使われるA（rcTo）コマンドを処理
function STArc() {
  return this;
}
STArc.prototype.matrixTransform = function arcmatrixTransform( /*Matrix*/ matrix) {
  var plst = new PList(this.D);
  var s = new STArc();
  s.D = plst.matrixTransform(matrix).list;
  delete plst;
  return s;
}
//2つの点から角度を算出
STArc.prototype.CVAngle = function starccvangle(ux,uy,vx,vy)
{
  ta = Math.atan2(uy,  ux);
  tb = Math.atan2(vy,  vx);
  if  (tb  >=  ta) {
    var s = tb - ta;
    return s;
  }
  var s =   6.28318530718 - (ta-tb);
  return s;
}
//弧をベジェ曲線に変換
STArc.prototype.set = function starcset(x1,y1,rx,ry,psai,fA,fS,x4,y4) {
  var fS = parseFloat(fS),  rx = parseFloat(rx),  ry = parseFloat(ry),  psai = parseFloat(psai),  x1 = parseFloat(x1),  x4 = parseFloat(x4),  y1 = parseFloat(y1),  y4 = parseFloat(y4);
  if (rx == 0 || ry == 0) {throw "line";}
  rx = Math.abs(rx); ry = Math.abs(ry);
  var ccx = (x1 - x4) / 2,  ccy = (y1 - y4) / 2;
  var cpsi = Math.cos(psai*Math.PI/180),  spsi = Math.sin(psai*Math.PI/180);
  var x1d = cpsi*ccx + spsi*ccy,  y1d = -1*spsi*ccx + cpsi*ccy;
  var x1dd = x1d * x1d, y1dd = y1d * y1d;
  var rxx = rx * rx, ryy = ry * ry;
  var lamda = x1dd/rxx + y1dd/ryy;
  var sds;
  if (lamda > 1) {
    rx = Math.sqrt(lamda) * rx;
    ry = Math.sqrt(lamda) * ry;
    sds = 0;
  }  else{
    var seif = 1;
    if (fA == fS) {
      seif = -1;
    }
    sds = seif * Math.sqrt((rxx*ryy - rxx*y1dd - ryy*x1dd) / (rxx*y1dd + ryy*x1dd));
  }
  var cxd = sds*rx*y1d / ry,  cyd = -1 * sds*ry*x1d / rx;
  var cx = cpsi*cxd - spsi*cyd + (x1+x4)/2,  cy = spsi*cxd + cpsi*cyd + (y1+y4)/2; 
  var s1 = this.CVAngle(1,0,(x1d-cxd)/rx,(y1d-cyd)/ry);
  var dr = this.CVAngle((x1d-cxd)/rx,(y1d-cyd)/ry,(-x1d-cxd)/rx,(-y1d-cyd)/ry);
  if (!fS  &&  dr > 0) {
    dr -=   2*Math.PI;
  } else if (fS  &&  dr < 0) {
    dr += 2*Math.PI;
  }
  var sse = dr * 2 / Math.PI;
  var seg = Math.ceil(sse<0 ? -1*sse  :  sse);
  var segr = dr / seg;
  var nea = new Array();
  var t = 8/3 * Math.sin(segr/4) * Math.sin(segr/4) / Math.sin(segr/2);
  var cpsirx = cpsi * rx;
  var cpsiry = cpsi * ry;
  var spsirx = spsi * rx;
  var spsiry = spsi * ry;
  var mc = Math.cos(s1);
  var ms = Math.sin(s1);
  var x2 = x1 - t * (cpsirx * ms + spsiry * mc);
  var y2 = y1 - t * (spsirx * ms - cpsiry * mc);
  for (var i = 0; i < seg; i++) {
    s1 += segr;
    mc = Math.cos(s1);
    ms = Math.sin(s1);
    var x3 = cpsirx * mc - spsiry * ms + cx;
    var y3 = spsirx * mc + cpsiry * ms + cy;
    var dx = -t * (cpsirx * ms + spsiry * mc);
    var dy = -t * (spsirx * ms - cpsiry * mc);
    nea = nea.concat([x2, y2, x3 - dx, y3 - dy, x3, y3]);
    x2 = x3 + dx;
    y2 = y3 + dy;
  }
  this.D = (this.D ? this.D.concat(nea) : nea);
  delete nea;
  return true;
}
//setをできるだけ繰り返す
STArc.prototype.sset = function starcsset( /*float*/ nox, /*float*/ noy, /*array*/ f, /*float*/ rx, /*float*/ ry) {
  for (var i=1,fli=f.length;i<fli+1;i+=7){
    this.set(nox,noy,f[i],f[i+1],f[i+2],f[i+3],f[i+4],f[i+5]+rx,f[i+6]+ry)
    nox = f[i+5]+rx; noy = f[i+6]+ry;
  }
}

//SVGLenghtを参照
function STLength( /*string or number*/ d, /*boolean*/ wort, /*float*/ f) {
  d += "";
  this.unitType = 0;//unknown
  this.wort = wort;
  this.fontSize = f;
  try {
  var v = parseFloat(d);
  var tani = d.match(/\D+$/);
  this.newValueSpecifiedUnits(tani,v);
  }  catch(e) {stlog.add(e,1133); this.value = 1000;}
  return this;
}
STLength.prototype.newValueSpecifiedUnits = function stlengthnvsu( /*string or number*/ tani, /*number*/ value) {
  var n = 1,  ut;
  switch (tani+"") {
    case "pt":  n = 1.25; ut = 9;
    break;
    case "pc":  n = 15; ut = 10;
    break;
    case "mm":  n = 3.543307; ut = 7;
    break;
    case "cm":  n = 35.43307; ut = 6;
    break;
    case "in":  n = 90; ut = 8;
    break;
    case "em":  n = this.fontSize; ut = 3;
    break;
    case "ex":  ut = 4;
    break;
    case "px":  ut = 5;
    break;
    case "%":  n = 0.01 * this.wort; ut = 2;
    break;
    default:  ut = 1;
    break;
  }
  this.unitType = ut;
  this.value = value * n;
  this.valueInSpecifiedUnits = value;
}

//XLink言語を処理
NAIBU.XLink = function( /*element*/ ele) {
  this.tar = ele;
  var href = ele.getAttribute("xlink:href");
  this.href = href ? href  :  null;
  this.show = ele.getAttribute("xlink:show");
  var base;
  var egbase = ele.getAttribute("xml:base");
  if (!egbase) {
    var ep = ele.parentNode, b = null;
    while(!b  &&  ep.tagName == "group") {
      b = ep.getAttribute("xml:base");
      ep = ep.parentNode;
    }
    base = b || location.href;
  }  else{
    base = egbase;
  }
  if (href.indexOf(":") == -1) {
    this.base = base;
  }  else{
    this.base  ="";
  }
  return this;
}
NAIBU.XLink.prototype.set = function() {
  if (this.href) {
    var tbth = this.base + this.href;
    if (this.href.indexOf(".") == 0) {
      tbth = this.href;
    }
    var uri = tbth;
    var attr = "href";
    switch (this.show) {
      case "embed":
        if (this.tar.tagName == "image") {
          attr = "src";
        }  else{
          uri.match(/#(.+)$/);
          this.resource = document.getElementById(RegExp.$1);
          dc = this.resource.cloneNode(true);
          this.tar.appendChld(dc);
        }
      break;
      case "new":
        this.tar.setAttribute("target","_blank");
      break;
      default:
        if (uri.match(/\.svg#?/)) { //svgが拡張子ならば
          uri = this.base+ "?" +uri;
        }     
      break;
    }
    this.tar.setAttribute(attr,uri);
  }
}

function utf16( /*string*/ s)  {
  return unescape(s);
}
function unescapeUTF16( /*string*/ s) {
  return s.replace(/%u\w\w\w\w/g,  utf16);
}

//Text2SVG機能。SVGのソース（文章）をSVG画像に変換できる。（必須ではない）
function textToSVG( /*string*/ source, /*flaot*/ w, /*float*/ h) {
  var data = 'data:image/svg+xml,' + unescapeUTF16(escape(source));
  var ob = document.createElement("object");
  ob.setAttribute("data",data);
  ob.setAttribute("width",w);
  ob.setAttribute("height",h);
  ob.setAttribute("type","image/svg+xml");
  return ob;
}

//XMLHttpRequestオブジェクトの作成
function HTTP() {
  var xmlhttp;
  try {
    xmlhttp=new ActiveXObject("Msxml2.XMLHTTP")
  } catch (e)  {
    try  {
      xmlhttp=new ActiveXObject("Microsoft.XMLHTTP")
    } catch (E) {
        xmlhttp=false
    }
  }
  if (!xmlhttp) {
    try {
      xmlhttp = new XMLHttpRequest();
    }  catch (e) {
      xmlhttp=false
    }
  }
  return xmlhttp
}
var success = true;
//SVGDocumentを収納しておく
var STdocument = new Array();

//次のembed,object要素を読み込む処理
function embed_ca( /*object*/ data) {
  ca(data);
  getEmbed(data.obj,data.num);
}
function object_ca( /*object*/ data) {
  ca(data);
  getObject(data.obj,data.num);
}

//IE用。object要素のデータからVMLを作成
function ca( /*object*/ data) {
if (success  &&  data.success) {
  var dn = data.num-1;
  try {
    var obj = data.obj[dn];
    var obw = new STLength(obj.getAttribute("width"),obj.clientWidth),  obh = new STLength(obj.getAttribute("height"),obj.clientHeight);
    var obwidth = obw.value,  obheight = obh.value;
    delete obw,  obh;
  } catch(e) {stlog.add(e,1209);}
  //正規表現でソースをVML用に書き換え
  var dc = data.content.replace(/!DOCTYPE/,"!--").replace(/(dtd">|\]>)/g,"-->").replace(/<script.+>/g,"").replace(/<\?.+\?>/g,"").replace(/xmlns="[^"]+"/,"").replace(/<svg/,"<v:group style='position:relative;top:0;left:0;width:100%;height:100%'").replace(/<\/svg/,"</v:group").replace(/<path\s/g,"<v:shape tag='path' ").replace(/<\/path/g,"</v:shape").replace(/<rect/g,"<v:shape tag='rect'").replace(/<text/g,"<div").replace(/<\/text/g,"</div").replace(/<\/rect/g,"</v:shape").replace(/<line\s/g,"<v:shape tag='line' ").replace(/<\/line>/g,"</v:shape>").replace(/<circle\s/g,"<v:shape tag='circle' ").replace(/<\/circle/g,"</v:shape").replace(/<ellipse\s/g,"<v:shape tag='ellipse' ").replace(/<\/ellipse/g,"</v:shape").replace(/<g(\s|>)/g,"<v:group style='top:0;left:0;position:relative;width:100%;height:100%'$1").replace(/<\/g>/g,"</v:group>").replace(/<polyline\s/g,"<v:shape tag='polyline' ").replace(/<\/polyline/g,"</v:shape").replace(/<polygon\s/g,"<v:shape tag='polygon' ").replace(/<\/polygon/g,"</v:shape").replace(/<use\s/g,"<v:group tag='use' ").replace(/<\/use/g,"</v:group").replace(/<linearGradient/g,"<v:fill type='gradient'").replace(/<\/linearGradient/g,"</v:fill").replace(/<radialGradient/g,"<v:fill type='gradientRadial'").replace(/<\/radialGradient/g,"</v:fill").replace(/width="/g,'svgwidth="').replace(/height="/g,'svgheight="').replace(/stroke-/g,"stroke").replace(/(<[^<]+)\sfont-size=/g,'$1 fontSize=').replace(/(<[^<]+)\swriting-mode=/g,'$1 writingMode=').replace(/stop-/g,"stop").replace(/fill-/g,"fill").replace(/<tspan\s/g,"<span ").replace(/<\/tspan>/g,"</span>").replace(/<image/g,"<v:image").replace(/<\/image>/g,"</v:image>").replace(/<set\s/g,"<t:set ").replace(/<\/set/g,"</t:set").replace(/<animate\s/g,"<t:animate ").replace(/<\/animate/g,"</t:animate");
  var ob = document.createElement("v:group");
  var obst = ob.style;
  obst.position = "relative";
  obst.overflow = "hidden";
  ob.innerHTML = dc;
  var obc = ob.getElementsByTagName("group").item(0);
  var regaw = obc.getAttribute("svgwidth");
  if (!regaw) {regaw = obwidth;}
  var regah = obc.getAttribute("svgheight");
  if (!regah) {regah = obheight;}
  regw = new STLength(regaw,obwidth);
  regh = new STLength(regah,obheight);
  var regwv = regw.value,  reghv = regh.value;
  obst.width = regwv;
  obst.height = reghv;
  ob.setAttribute("coordsize",regwv  +" "+  reghv);
  obj.parentNode.insertBefore(ob,obj);
  STdocument[dn] = new SVGtoVML();
  STdocument[dn].read(obc);
  STdocument[dn].set(obwidth,obheight,regw,regh);
}
}

//指定したURLの文章データを取得
function getURL( /*string*/ url, /*function*/ fn, /*Array*/ ob, /*int*/ n) {  
    var xmlhttp=new  HTTP();
    if (xmlhttp) {
        xmlhttp.open("GET",url,true);
        xmlhttp.setRequestHeader("X-Requested-With", "XMLHttpRequest");
        xmlhttp.onreadystatechange=function() {
        if (xmlhttp.readyState==4  &&  xmlhttp.status == 200) {
fn({success:true,  status:xmlhttp.status,content:xmlhttp.responseText,contentType:xmlhttp.getResponseHeader("Content-Type"),obj:ob,num:n});
        }
      }
      xmlhttp.send(null)
    } else {
            fn({success:false});
    }
}

//Sieb用
try{if (sieb_s) {svgtovml();}} catch(e) {}
