SELECT a.*,
       b.serverFileId AS profileImageId,
       b.name         AS profileImageName,
       b.mime         AS profileImageMime,
       b.size         AS profileImageSize,
       b.charset      AS profileImageCharset,
       b.width        AS profileImageWidth,
       b.height       AS profileImageHeight,
       b.createdTime  AS profileImageCreatedTime,
       c.serverFileId AS backgroundImageId,
       c.name         AS backgroundImageName,
       c.mime         AS backgroundImageMime,
       c.size         AS backgroundImageSize,
       c.charset      AS backgroundImageCharset,
       c.width        AS backgroundImageWidth,
       c.height       AS backgroundImageHeight,
       c.createdTime  AS backgroundImageCreatedTime,
       d.*
FROM ((users AS a LEFT JOIN
       serverfiles AS b ON a.profileImageId = b.serverFileId) LEFT JOIN
      serverfiles AS c ON a.backgroundImageId = c.serverFileId) LEFT JOIN
     devices AS d ON a.userId = d.userId
WHERE d.address = /*address*/'' AND
      d.type = /*deviceType*/''
