/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.service.impl;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.sourceforge.shovel.AvailabilityType;
import jp.sourceforge.shovel.DeviceType;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.SearchFriendsType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.StatusType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.entity.IDedicatedClient;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IDirectMessage;
import jp.sourceforge.shovel.entity.IFavorite;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IStatusWrapper;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IMobilePhoneLogic;
import jp.sourceforge.shovel.logic.IShovelLogic;
import jp.sourceforge.shovel.mobilephone.IMobilePhone;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IServerFileService;
import jp.sourceforge.shovel.service.IShovelService;
import jp.sourceforge.shovel.service.impl.ShovelServiceImpl;
import org.apache.commons.lang.ArrayUtils;
import org.apache.struts.util.MessageResources;
import org.seasar.framework.container.S2Container;

public class ShovelServiceImpl
implements IShovelService {
    Map<Long, IStatus> statusMap_ = new HashMap();
    IMobilePhone mobilePhone_;
    IDirectoryService directoryService_;
    IServerFileService serverFileService_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    S2Container container_;
    IShovelLogic shovelLogic_;
    IMobilePhoneLogic mobilePhoneLogic_;

    void cacheStatus(IStatus status) {
        if (status != null) {
            this.statusMap_.put(status.getStatusId(), status);
        }
    }

    void cacheStatuses(IStatus[] statuses) {
        for (IStatus status : statuses) {
            this.cacheStatus(status);
        }
    }

    void purgeStatuses() {
        this.statusMap_.clear();
    }

    IStatus fetchStatus(long statusId) {
        return (IStatus)this.statusMap_.get(statusId);
    }

    int correctLimit(int limit) {
        IUser user = this.getDirectoryService().getLoginUser();
        if (user != null && limit <= 0) {
            limit = user.getViewLines();
            if (limit <= 0 || limit > 20) {
                limit = 20;
            }
        } else {
            limit = 20;
        }
        return limit;
    }

    public IStatus[] getFavorites(String foreignKey, int page, int limit) throws ApplicationException {
        IUser user = this.getDirectoryService().getUser(foreignKey);
        if (user == null) {
            throw new ApplicationException("");
        }
        limit = this.correctLimit(limit);
        IStatus[] statuses = this.getShovelLogic().getFavorites(user.getUserId(), page * limit, limit + 1);
        this.cacheStatuses(statuses);
        return statuses;
    }

    public IStatus[] getReplies(String foreignKey, int page, int limit) throws ApplicationException {
        if (foreignKey == null) {
            throw new ApplicationException("");
        }
        IUser user = this.getDirectoryService().getLoginUser();
        if (user == null || foreignKey.compareTo(user.getForeignKey()) != 0) {
            user = this.getDirectoryService().getUser(foreignKey);
        }
        limit = this.correctLimit(limit);
        IStatus[] statuses = this.getShovelLogic().getReplies(user.getUserId(), page * limit, limit + 1);
        this.cacheStatuses(statuses);
        return statuses;
    }

    public IStatus getRecent() {
        IUser user = this.getDirectoryService().getLoginUser();
        IStatus status = this.getShovelLogic().getRecent(user.getUserId());
        this.cacheStatus(status);
        return status;
    }

    public IStatus getRecent(String foreignKey) throws ApplicationException {
        IUser user = this.getDirectoryService().getUser(foreignKey);
        if (user == null) {
            throw new ApplicationException("");
        }
        IStatus status = this.getShovelLogic().getRecent(user.getUserId());
        this.cacheStatus(status);
        return status;
    }

    public IStatus getRecent(long userId) throws ApplicationException {
        IStatus status = this.getShovelLogic().getRecent(userId);
        this.cacheStatus(status);
        return status;
    }

    public IStatus getStatus(long statusId) {
        IStatus status = this.fetchStatus(statusId);
        if (status == null) {
            status = this.getShovelLogic().getStatus(statusId);
            this.cacheStatus(status);
        }
        return status;
    }

    public IStatus[] getRecents(long[] userIds) {
        IStatus[] statuses = this.getShovelLogic().getRecents(userIds);
        this.cacheStatuses(statuses);
        return statuses;
    }

    public IStatus[] getStatuses(int page, int limit) {
        limit = this.correctLimit(limit);
        IStatus[] statuses = this.getShovelLogic().getStatuses(page * limit, limit + 1);
        this.cacheStatuses(statuses);
        return statuses;
    }

    public IStatus[] getStatuses(String since, boolean useRemoved, int limit) throws ApplicationException {
        IStatus[] statuses = this.getShovelLogic().getStatuses(since, useRemoved, limit);
        ArrayList<IStatus> lists = new ArrayList<IStatus>();
        if (useRemoved) {
            for (IStatus status : statuses) {
                if (status.isRemove()) continue;
                lists.add(status);
            }
            IStatus[] cacheStatuses = lists.toArray(new IStatus[lists.size()]);
            this.cacheStatuses(cacheStatuses);
        } else {
            this.cacheStatuses(statuses);
        }
        return statuses;
    }

    public IStatus[] getStatuses(long sinceId, int limit) {
        limit = this.correctLimit(limit);
        IStatus[] statuses = this.getShovelLogic().getStatuses(sinceId, limit);
        this.cacheStatuses(statuses);
        return statuses;
    }

    public IStatus[] getStatuses(SortType sortType, SortOrderType sortOrderType, int limit) {
        limit = this.correctLimit(limit);
        IStatus[] statuses = this.getShovelLogic().getStatuses(sortType, sortOrderType, limit);
        this.cacheStatuses(statuses);
        return statuses;
    }

    public IStatus[] getStatuses(String foreignKey, boolean withFriends, String since, int limit) throws ApplicationException {
        if (foreignKey == null) {
            throw new ApplicationException("");
        }
        limit = this.correctLimit(limit);
        IUser user = this.getDirectoryService().getLoginUser();
        if (user == null || foreignKey.compareTo(user.getForeignKey()) != 0) {
            user = this.getDirectoryService().getUser(foreignKey);
        }
        IStatus[] statuses = this.getShovelLogic().getStatuses(user.getUserId(), withFriends, user.getRepliesType(), since, limit);
        this.cacheStatuses(statuses);
        return statuses;
    }

    public IStatus[] getStatuses(String foreignKey, boolean withFriends, int page, int limit, int correctedOffset, int correctedLimit) throws ApplicationException {
        if (foreignKey == null) {
            throw new ApplicationException("");
        }
        limit = this.correctLimit(limit);
        int offset = page * limit + correctedOffset;
        limit += correctedLimit;
        IUser user = this.getDirectoryService().getLoginUser();
        if (user == null || foreignKey.compareTo(user.getForeignKey()) != 0) {
            user = this.getDirectoryService().getUser(foreignKey);
        }
        IStatus[] statuses = this.getShovelLogic().getStatuses(user.getUserId(), withFriends, user.getRepliesType(), offset, limit);
        this.cacheStatuses(statuses);
        return statuses;
    }

    public int destroyStatus(long statusId) throws ApplicationException {
        int result;
        IUser user = this.getDirectoryService().getLoginUser();
        IStatus status = this.getStatus(statusId);
        if (status == null) {
            throw new ApplicationException("");
        }
        if (user.getUserId() != status.getSenderId()) {
            throw new ApplicationException("");
        }
        if (!this.isMobilePhone()) {
            this.getDirectoryService().decrementStatuses(user.getUserId());
            this.getDirectoryService().decrementFavoritesAll(statusId);
            this.getShovelLogic().clearStatusReference(statusId);
        }
        if ((result = this.getShovelLogic().destroyStatus(statusId, this.isMobilePhone())) <= 0) {
            throw new ApplicationException("");
        }
        return result;
    }

    public IStatusWrapper updateStatus(String text, String source) throws ApplicationException {
        IDirectoryService directoryService = this.getDirectoryService();
        if (this.isMobilePhone()) {
            IUser sender = directoryService.getLoginUser();
            this.getShovelLogic().updateStatus(text, sender.getLocation(), "mobile web", 0L, false, sender.getUserId(), true);
            return null;
        }
        IStatusWrapper statusWrapper = this.getShovelLogic().parseStatus(text);
        String foreignKey = statusWrapper.getForeignKey();
        switch (1.$SwitchMap$jp$sourceforge$shovel$StatusType[statusWrapper.getStatusType().ordinal()]) {
            case 1: {
                IUser referenceSender;
                long referenceSenderId = 0L;
                if (foreignKey != null && (referenceSender = directoryService.getUser(foreignKey)) != null) {
                    referenceSenderId = referenceSender.getUserId();
                }
                IUser sender = directoryService.getLoginUser();
                directoryService.incrementStatuses(sender.getUserId());
                IStatus status = this.getShovelLogic().updateStatus(text, sender.getLocation(), source, referenceSenderId, statusWrapper.isOpen(), sender.getUserId(), false);
                statusWrapper.setStatus(status);
                break;
            }
            case 2: {
                text = statusWrapper.getText();
                IDirectMessage directMessage = this.createDirectMessage(foreignKey, text, source);
                statusWrapper.setDirectMessage(directMessage);
                break;
            }
            case 3: {
                IFavorite favorite = this.createFavorite(foreignKey);
                statusWrapper.setFavorite(favorite);
                break;
            }
            case 4: {
                IFriendship friend = this.createFriendship(foreignKey);
                IUser passive = directoryService.getUser(foreignKey);
                if (passive.isProtect() && !friend.isAccept()) {
                    statusWrapper.setStatusType(StatusType.FRIEND_REQUEST);
                }
                statusWrapper.setFriend(friend);
                break;
            }
            case 5: {
                IFriendship friend = this.destroyFriendship(foreignKey);
                statusWrapper.setFriend(friend);
                break;
            }
            case 6: {
                this.updateNotification(foreignKey, true);
                break;
            }
            case 7: {
                this.updateNotification(foreignKey, false);
                break;
            }
            case 8: {
                this.updateDevice(AvailabilityType.OFF);
                break;
            }
            case 9: {
                this.updateDevice(AvailabilityType.ON);
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        return statusWrapper;
    }

    public IStatus[] truncate(IStatus[] statuses, int offset, int limit) {
        limit = this.correctLimit(limit);
        return (IStatus[])ArrayUtils.subarray((Object[])statuses, (int)offset, (int)(offset + limit));
    }

    public IUser[] truncate(IUser[] users, int limit) {
        if (users.length > (limit = this.correctLimit(limit))) {
            users = (IUser[])ArrayUtils.subarray((Object[])users, (int)0, (int)limit);
        }
        return users;
    }

    public IFriendship[] truncate(IFriendship[] friends, int limit) {
        if (friends.length > (limit = this.correctLimit(limit))) {
            friends = (IFriendship[])ArrayUtils.subarray((Object[])friends, (int)0, (int)limit);
        }
        return friends;
    }

    public void prepareForView(IStatus status) throws ApplicationException {
        if (status == null) {
            throw new ApplicationException("");
        }
        String source = status.getSource();
        IDedicatedClient client = this.getClient(source);
        status.setDedicatedClient(client);
        if (this.getDirectoryService().getLoginUser() != null) {
            IFavorite favorite = this.getFavorite(status.getStatusId());
            status.setFavorite(favorite);
        }
        HashSet<Long> userIdSet = new HashSet<Long>();
        userIdSet.add(status.getReferenceSenderId());
        userIdSet.add(status.getSenderId());
        IFavorite[] otherFavorites = this.getFavoritesByStatus(status.getStatusId(), 13);
        if (otherFavorites != null || otherFavorites.length <= 0) {
            status.setOtherFavorites(otherFavorites);
        }
        for (IFavorite favorite : otherFavorites) {
            userIdSet.add(favorite.getUserId());
        }
        Long[] userIds = userIdSet.toArray(new Long[userIdSet.size()]);
        IUser[] users = this.getDirectoryService().getUsers(ArrayUtils.toPrimitive((Long[])userIds));
        HashMap<Long, IUser> userMap = new HashMap<Long, IUser>();
        for (IUser iUser : users) {
            IServerFile serverFile = iUser.getProfileImage();
            if (serverFile != null) {
                serverFile.prepareForView();
            }
            userMap.put(iUser.getUserId(), iUser);
        }
        for (IUser iUser : otherFavorites) {
            iUser.setUser((IUser)userMap.get(iUser.getUserId()));
        }
        long userId = status.getReferenceSenderId();
        status.setReferenceSender((IUser)userMap.get(userId));
        userId = status.getSenderId();
        status.setSender((IUser)userMap.get(userId));
    }

    /*
     * WARNING - void declaration
     */
    public IStatus[] prepareForView(IStatus[] statuses, int limit, boolean truncate) {
        IFavorite[] otherFavorites;
        if (truncate && statuses.length > limit) {
            statuses = this.truncate(statuses, 0, limit);
        }
        if (statuses == null || statuses.length <= 0) {
            return new IStatus[0];
        }
        HashSet<Long> userIdSet = new HashSet<Long>();
        HashSet<String> sourceSet = new HashSet<String>();
        long[] statusIds = new long[statuses.length];
        int i = 0;
        for (IStatus status : statuses) {
            userIdSet.add(status.getReferenceSenderId());
            userIdSet.add(status.getSenderId());
            sourceSet.add(status.getSource());
            statusIds[i++] = status.getStatusId();
        }
        HashMap othrerFavoriteListMap = new HashMap();
        for (IFavorite favorite : otherFavorites = this.getFavoritesByStatuses(statusIds, 13)) {
            void var16_22;
            long statusId = favorite.getStatusId();
            List list = (List)othrerFavoriteListMap.get(statusId);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                othrerFavoriteListMap.put(statusId, arrayList);
            }
            var16_22.add(favorite);
            userIdSet.add(favorite.getUserId());
        }
        Long[] userIds = userIdSet.toArray(new Long[userIdSet.size()]);
        IUser[] users = this.getDirectoryService().getUsers(ArrayUtils.toPrimitive((Long[])userIds));
        HashMap<Long, IUser> userMap = new HashMap<Long, IUser>();
        for (IUser iUser : users) {
            IServerFile serverFile = iUser.getProfileImage();
            if (serverFile != null) {
                serverFile.prepareForView();
            }
            userMap.put(iUser.getUserId(), iUser);
        }
        for (IUser iUser : otherFavorites) {
            iUser.setUser((IUser)userMap.get(iUser.getUserId()));
        }
        HashMap<Long, IFavorite> favoriteMap = new HashMap<Long, IFavorite>();
        IUser user = this.getDirectoryService().getLoginUser();
        if (user != null) {
            IFavorite[] myFavorites;
            for (IFavorite favorite : myFavorites = this.getFavorites(statusIds)) {
                favoriteMap.put(favorite.getStatusId(), favorite);
            }
        }
        String[] keys = sourceSet.toArray(new String[sourceSet.size()]);
        IDedicatedClient[] iDedicatedClientArray = this.getClients(keys);
        HashMap<String, IDedicatedClient> clientMap = new HashMap<String, IDedicatedClient>();
        for (IDedicatedClient iDedicatedClient : iDedicatedClientArray) {
            clientMap.put(iDedicatedClient.getText(), iDedicatedClient);
        }
        for (IDedicatedClient iDedicatedClient : statuses) {
            String source = iDedicatedClient.getSource();
            IDedicatedClient client = (IDedicatedClient)clientMap.get(source);
            if (client != null) {
                iDedicatedClient.setDedicatedClient(client);
            }
            long userId = iDedicatedClient.getReferenceSenderId();
            iDedicatedClient.setReferenceSender((IUser)userMap.get(userId));
            userId = iDedicatedClient.getSenderId();
            iDedicatedClient.setSender((IUser)userMap.get(userId));
            long statusId = iDedicatedClient.getStatusId();
            iDedicatedClient.setFavorite((IFavorite)favoriteMap.get(statusId));
            List favoriteList = (List)othrerFavoriteListMap.get(statusId);
            if (favoriteList == null) continue;
            iDedicatedClient.setOtherFavorites(favoriteList.toArray(new IFavorite[favoriteList.size()]));
        }
        return statuses;
    }

    public void outputFeed(FormatType formatType, ViewType viewType, IUser user, IStatus[] statuses) throws ApplicationException {
        HttpServletRequest request = (HttpServletRequest)this.getContainer().getComponent((Object)"request");
        HttpServletResponse response = (HttpServletResponse)this.getContainer().getComponent((Object)"response");
        MessageResources resources = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        String displayName = null;
        String foreignKey = null;
        if (user != null) {
            displayName = user.getDisplayName();
            foreignKey = user.getForeignKey();
        }
        Object[] args = new Object[]{displayName, formatType.getId()};
        String title = resources.getMessage("feed." + viewType.getId() + ".title", args);
        String server = request.getServerName();
        if (request.getServerPort() != 80) {
            server = server + ":" + String.valueOf(request.getServerPort());
        }
        String link = (String)request.getAttribute("request-url");
        args = new Object[]{resources.getMessage("product.name"), displayName, foreignKey};
        String description = resources.getMessage("feed." + viewType.getId() + ".description", args);
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle(title);
        feed.setLink(link);
        feed.setDescription(description);
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        for (IStatus s : statuses) {
            IUser sender = s.getSender();
            args = new Object[]{sender.getForeignKey(), s.getBody()};
            title = resources.getMessage("feed.statuses.entry.description", args);
            args = new Object[]{server, sender.getForeignKey(), s.getStatusId()};
            link = resources.getMessage("feed.statuses.entry.link", args);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(s.getSentTime());
            Date publishedDate = calendar.getTime();
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(title);
            entry.setLink(link);
            entry.setPublishedDate(publishedDate);
            entry.setUpdatedDate(publishedDate);
            SyndContentImpl html = new SyndContentImpl();
            html.setType("html");
            html.setValue(title);
            entry.setDescription((SyndContent)html);
            entries.add(entry);
        }
        feed.setEntries(entries);
        try {
            feed.setFeedType(formatType.getFeedType());
            String mimeType = formatType.getMimeType();
            response.setContentType(mimeType + "; charset=UTF-8");
            SyndFeedOutput output = new SyndFeedOutput();
            output.output((SyndFeed)feed, (Writer)response.getWriter());
        }
        catch (FeedException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public IDirectMessage createDirectMessage(String foreignKey, String text, String source) throws ApplicationException {
        IDirectoryService directoryService = this.getDirectoryService();
        IUser recipient = directoryService.getUser(foreignKey);
        if (recipient == null) {
            throw new ApplicationException("");
        }
        IFriendship follower = this.getFollower(foreignKey);
        if (follower == null) {
            throw new ApplicationException("");
        }
        IUser sender = directoryService.getLoginUser();
        directoryService.incrementDirectMessages(recipient.getUserId());
        return this.getShovelLogic().createDirectMessage(text, source, sender.getUserId(), recipient.getUserId(), this.isMobilePhone());
    }

    public IDirectMessage createDirectMessage(long userId, String text, String source) throws ApplicationException {
        IDirectoryService directoryService = this.getDirectoryService();
        IUser recipient = directoryService.getUser(userId);
        if (recipient == null) {
            throw new ApplicationException("");
        }
        return this.createDirectMessage(recipient.getForeignKey(), text, source);
    }

    public IDirectMessage destroyDirectMessage(long directMessageId) throws ApplicationException {
        IDirectMessage directMessage = this.getShovelLogic().getDirectMessage(directMessageId);
        IDirectoryService directoryService = this.getDirectoryService();
        IUser user = directoryService.getLoginUser();
        boolean sent = true;
        if (directMessage.getRecipientId() == user.getUserId()) {
            if (!this.isMobilePhone()) {
                directoryService.decrementDirectMessages(user.getUserId());
            }
            sent = false;
        } else if (directMessage.getSenderId() != user.getUserId()) {
            throw new ApplicationException("");
        }
        int result = this.getShovelLogic().destroyDirectMessage(directMessageId, sent, this.isMobilePhone());
        if (result <= 0) {
            throw new ApplicationException("");
        }
        return directMessage;
    }

    public IDirectMessage getDirectMessage(long directMessageId) {
        return this.getShovelLogic().getDirectMessage(directMessageId);
    }

    IDirectMessage[] truncate(IDirectMessage[] directMessages) {
        IUser login = this.getDirectoryService().getLoginUser();
        int limit = 10;
        if (login != null) {
            limit = login.getViewLines();
        }
        if (directMessages.length > limit) {
            directMessages = (IDirectMessage[])ArrayUtils.subarray((Object[])directMessages, (int)0, (int)limit);
        }
        return directMessages;
    }

    public IDirectMessage[] getDirectMessages(boolean sent, int page, int limit) {
        IUser user = this.getDirectoryService().getLoginUser();
        limit = this.correctLimit(limit);
        return this.getShovelLogic().getDirectMessages(user.getUserId(), sent, page * limit, limit + 1);
    }

    public IDirectMessage[] getDirectMessages(boolean sent, long sinceId, int limit) {
        IUser user = this.getDirectoryService().getLoginUser();
        limit = this.correctLimit(limit);
        return this.getShovelLogic().getDirectMessages(user.getUserId(), sent, sinceId, limit);
    }

    public IDirectMessage[] getDirectMessages(boolean sent, String since, int limit) throws ApplicationException {
        IUser user = this.getDirectoryService().getLoginUser();
        limit = this.correctLimit(limit);
        return this.getShovelLogic().getDirectMessages(user.getUserId(), sent, since, limit);
    }

    public IDirectMessage[] prepareForView(IDirectMessage[] directMessages, boolean truncate) {
        if (truncate) {
            directMessages = this.truncate(directMessages);
        }
        if (directMessages == null || directMessages.length <= 0) {
            return new IDirectMessage[0];
        }
        HashSet<Long> userIdSet = new HashSet<Long>();
        for (IDirectMessage directMessage : directMessages) {
            userIdSet.add(directMessage.getSenderId());
            userIdSet.add(directMessage.getRecipientId());
        }
        Long[] userIds = userIdSet.toArray(new Long[userIdSet.size()]);
        IUser[] users = this.getDirectoryService().getUsers(ArrayUtils.toPrimitive((Long[])userIds));
        HashMap<Long, IUser> userMap = new HashMap<Long, IUser>();
        for (IUser iUser : users) {
            IServerFile serverFile = iUser.getProfileImage();
            if (serverFile != null) {
                serverFile.prepareForView();
            }
            userMap.put(iUser.getUserId(), iUser);
        }
        for (IUser iUser : directMessages) {
            long userId = iUser.getSenderId();
            iUser.setSender((IUser)userMap.get(userId));
            userId = iUser.getRecipientId();
            iUser.setRecipient((IUser)userMap.get(userId));
        }
        return directMessages;
    }

    public void outputFeed(FormatType formatType, ViewType viewType, IUser user, IDirectMessage[] directMessages) throws ApplicationException {
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        MessageResources resources = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        Object[] args = new Object[]{user.getForeignKey()};
        String title = resources.getMessage("feed." + viewType.getId() + ".title", args);
        String server = request.getServerName();
        if (request.getServerPort() != 80) {
            server = server + ":" + String.valueOf(request.getServerPort());
        }
        String link = (String)request.getAttribute("request-url");
        String description = resources.getMessage("feed." + viewType.getId() + ".description", args);
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle(title);
        feed.setLink(link);
        feed.setDescription(description);
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        for (IDirectMessage dm : directMessages) {
            IUser sender = dm.getSender();
            IUser recipient = dm.getRecipient();
            args = new Object[]{sender.getForeignKey(), recipient.getForeignKey()};
            title = resources.getMessage("feed." + viewType.getId() + ".entry.title", args);
            args = new Object[]{dm.getText()};
            description = resources.getMessage("feed." + viewType.getId() + ".entry.description", args);
            args = new Object[]{server, dm.getDirectMessageId()};
            link = resources.getMessage("feed." + viewType.getId() + ".entry.link", args);
            SyndContentImpl content = new SyndContentImpl();
            content.setValue(description);
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(dm.getSentTime());
            Date publishedDate = calendar.getTime();
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(title);
            if (formatType.isRss()) {
                entry.setDescription((SyndContent)content);
            } else {
                ArrayList<SyndContentImpl> contents = new ArrayList<SyndContentImpl>();
                contents.add(content);
                entry.setContents(contents);
            }
            entry.setPublishedDate(publishedDate);
            entry.setLink(link);
            entries.add(entry);
        }
        feed.setEntries(entries);
        try {
            feed.setFeedType(formatType.getFeedType());
            String mimeType = formatType.getMimeType();
            response.setContentType(mimeType + "; charset=UTF-8");
            SyndFeedOutput output = new SyndFeedOutput();
            output.output((SyndFeed)feed, (Writer)response.getWriter());
        }
        catch (FeedException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public IFriendship[] getFriends(String foreignKey, int offset, int limit) throws ApplicationException {
        IUser user = this.getDirectoryService().getUser(foreignKey);
        if (user == null) {
            throw new ApplicationException("");
        }
        limit = this.correctLimit(limit);
        return this.getShovelLogic().getFriends(user.getUserId(), offset, limit + 1);
    }

    public IFriendship[] getFriends(String foreignKey, boolean withFollower, int page, int limit) throws ApplicationException {
        limit = this.correctLimit(limit);
        IUser user = this.getDirectoryService().getUser(foreignKey);
        IFriendship[] friends = this.getShovelLogic().getFriends(user.getUserId(), page * limit, limit + 1);
        if (friends != null && friends.length > 0) {
            IFriendship[] mines;
            HashMap<Long, IFriendship> friendMap = new HashMap<Long, IFriendship>();
            long[] passiveIds = new long[friends.length];
            int i = 0;
            for (IFriendship friendship : friends) {
                long passiveId = friendship.getPassiveId();
                passiveIds[i++] = passiveId;
                friendMap.put(passiveId, friendship);
            }
            for (IFriendship mine : mines = this.getShovelLogic().getFriends(user.getUserId(), passiveIds)) {
                IFriendship peoples = (IFriendship)friendMap.get(mine.getPassiveId());
                peoples.setFriend(mine);
            }
            if (withFollower) {
                IFriendship[] others;
                for (IFriendship other : others = this.getShovelLogic().getFollowers(user.getUserId(), passiveIds)) {
                    IFriendship peoples = (IFriendship)friendMap.get(other.getActiveId());
                    peoples.setFollower(other);
                }
            }
        }
        return friends;
    }

    public IFriendship getFriend(String foreignKey) throws ApplicationException {
        IUser active = this.getDirectoryService().getLoginUser();
        if (active == null) {
            return null;
        }
        return this.getShovelLogic().getFriendship(active.getUserId(), foreignKey);
    }

    public IFriendship getFriend(long passiveId) throws ApplicationException {
        IUser active = this.getDirectoryService().getLoginUser();
        if (active == null) {
            return null;
        }
        return this.getShovelLogic().getFriendship(active.getUserId(), passiveId);
    }

    public IFriendship getFollower(String foreignKey) throws ApplicationException {
        IUser passive = this.getDirectoryService().getLoginUser();
        if (passive == null) {
            return null;
        }
        IUser active = this.getDirectoryService().getUser(foreignKey);
        if (active == null) {
            throw new ApplicationException("");
        }
        return this.getShovelLogic().getFriendship(active.getUserId(), passive.getUserId());
    }

    public IFriendship[] getFriends(long[] passiveIds) throws ApplicationException {
        IUser user = this.getDirectoryService().getLoginUser();
        if (user == null) {
            throw new ApplicationException("");
        }
        return this.getShovelLogic().getFriends(user.getUserId(), passiveIds);
    }

    public IFriendship[] getFollowers(String foreignKey, boolean withFriends, int page, int limit) throws ApplicationException {
        IUser user = this.getDirectoryService().getUser(foreignKey);
        long passiveId = user.getUserId();
        limit = this.correctLimit(limit);
        user = this.getDirectoryService().getLoginUser();
        IFriendship[] followers = this.getShovelLogic().getFollowers(passiveId, false, page * limit, limit);
        if (followers != null && followers.length > 0) {
            HashMap<Long, IFriendship> followerMap = new HashMap<Long, IFriendship>();
            long[] passiveIds = new long[followers.length];
            int i = 0;
            for (IFriendship friendship : followers) {
                passiveId = friendship.getActiveId();
                passiveIds[i++] = passiveId;
                followerMap.put(passiveId, friendship);
            }
            if (withFriends) {
                IFriendship[] mines;
                for (IFriendship mine : mines = this.getShovelLogic().getFriends(user.getUserId(), passiveIds)) {
                    IFriendship peoples = (IFriendship)followerMap.get(mine.getPassiveId());
                    peoples.setFriend(mine);
                }
            }
        }
        return followers;
    }

    public IFriendship[] searchFriends(long userId, String keywords, SearchFriendsType type, int page, int limit) {
        String[] parsedKeywords = null;
        if (keywords != null && keywords.length() > 0) {
            parsedKeywords = keywords.split("\\s");
        }
        limit = this.correctLimit(limit);
        switch (1.$SwitchMap$jp$sourceforge$shovel$SearchFriendsType[type.ordinal()]) {
            default: {
                return this.getShovelLogic().searchFollowing(userId, parsedKeywords, page * limit, limit);
            }
            case 2: {
                return this.getShovelLogic().searchReciprocalFollow(userId, parsedKeywords, page * limit, limit);
            }
            case 3: {
                return this.getShovelLogic().searchFollowingOnly(userId, parsedKeywords, page * limit, limit);
            }
            case 4: 
        }
        return this.getShovelLogic().searchFollowersOnly(userId, parsedKeywords, page * limit, limit);
    }

    public IFriendship[] getRequests(long activeId) throws ApplicationException {
        IUser passive = this.getDirectoryService().getLoginUser();
        if (passive == null) {
            return new IFriendship[0];
        }
        return this.getShovelLogic().getRequests(activeId, passive.getUserId());
    }

    public IFriendship[] getRequests(String foreignKey, int page, int limit) throws ApplicationException {
        IUser user = this.getDirectoryService().getLoginUser();
        limit = this.correctLimit(limit);
        user = this.getDirectoryService().getUser(foreignKey);
        return this.getShovelLogic().getRequests(user.getUserId(), page * limit, limit + 1);
    }

    public int countFriends(String foreignKey) {
        IUser user = this.getDirectoryService().getUser(foreignKey);
        long userId = user.getUserId();
        int friends = this.getShovelLogic().countPublicFriends(userId);
        return friends += this.getShovelLogic().countProtectFriends(userId);
    }

    public int countFollows(String foreignKey) {
        IUser user = this.getDirectoryService().getUser(foreignKey);
        long userId = user.getUserId();
        int followers = user.isProtect() ? this.getShovelLogic().countAcceptFollowers(userId) : this.getShovelLogic().countAllFollowers(userId);
        return followers;
    }

    public int countRequests(String foreignKey) {
        IUser user = this.getDirectoryService().getUser(foreignKey);
        long userId = user.getUserId();
        return this.getShovelLogic().countRequestFollowers(userId);
    }

    IFriendship createFriendship(IUser active, IUser passive) throws ApplicationException {
        if (passive == null || passive.isRemove()) {
            throw new ApplicationException("");
        }
        return this.getShovelLogic().createFriendship(active.getUserId(), passive.getUserId(), active.isProtect(), this.isMobilePhone());
    }

    public IFriendship createFriendship(String passiveId) throws ApplicationException {
        IDirectoryService directoryService = this.getDirectoryService();
        IUser active = directoryService.getLoginUser();
        IUser passive = directoryService.getUser(passiveId);
        return this.createFriendship(active, passive);
    }

    public IFriendship createFriendship(long passiveId) throws ApplicationException {
        IDirectoryService directoryService = this.getDirectoryService();
        IUser active = directoryService.getLoginUser();
        IUser passive = directoryService.getUser(passiveId);
        return this.createFriendship(active, passive);
    }

    IFriendship acceptFriendship(IUser active, IUser passive) throws ApplicationException {
        if (active == null) {
            throw new ApplicationException("");
        }
        if (!passive.isProtect()) {
            throw new ApplicationException("");
        }
        return this.getShovelLogic().acceptFriendship(active.getUserId(), passive.getUserId(), this.isMobilePhone());
    }

    public IFriendship acceptFriendship(String activeId) throws ApplicationException {
        IUser active = this.getDirectoryService().getUser(activeId);
        IUser passive = this.getDirectoryService().getLoginUser();
        return this.acceptFriendship(active, passive);
    }

    public IFriendship acceptFriendship(long activeId) throws ApplicationException {
        IUser active = this.getDirectoryService().getUser(activeId);
        IUser passive = this.getDirectoryService().getLoginUser();
        return this.acceptFriendship(active, passive);
    }

    public IFriendship updateNotification(long passiveId, boolean notify) throws ApplicationException {
        IUser active = this.getDirectoryService().getLoginUser();
        return this.getShovelLogic().updateNotification(active.getUserId(), passiveId, notify);
    }

    public IFriendship updateNotification(String passiveId, boolean notify) throws ApplicationException {
        IUser active = this.getDirectoryService().getLoginUser();
        return this.getShovelLogic().updateNotification(active.getUserId(), passiveId, notify);
    }

    IFriendship destroyFriendship(IUser active, IUser passive) throws ApplicationException {
        if (passive == null) {
            throw new ApplicationException("");
        }
        return this.getShovelLogic().destroyFriendship(active.getUserId(), passive.getUserId(), active.isProtect(), this.isMobilePhone());
    }

    public IFriendship destroyFriendship(long passiveId) throws ApplicationException {
        IUser active = this.getDirectoryService().getLoginUser();
        IUser passive = this.getDirectoryService().getUser(passiveId);
        return this.destroyFriendship(active, passive);
    }

    public IFriendship destroyFriendship(String passiveId) throws ApplicationException {
        IUser active = this.getDirectoryService().getLoginUser();
        IUser passive = this.getDirectoryService().getUser(passiveId);
        return this.destroyFriendship(active, passive);
    }

    IFriendship denyFriendship(IUser active, IUser passive) throws ApplicationException {
        if (active == null) {
            throw new ApplicationException("");
        }
        return this.getShovelLogic().denyFriendship(active.getUserId(), passive.getUserId(), this.isMobilePhone());
    }

    public IFriendship denyFriendship(long activeId) throws ApplicationException {
        IUser active = this.getDirectoryService().getUser(activeId);
        IUser passive = this.getDirectoryService().getLoginUser();
        return this.denyFriendship(active, passive);
    }

    public IFriendship denyFriendship(String activeId) throws ApplicationException {
        IUser passive = this.getDirectoryService().getUser(activeId);
        IUser active = this.getDirectoryService().getLoginUser();
        return this.denyFriendship(active, passive);
    }

    public IFriendship[] prepareForView(IFriendship[] friendships, int limit, boolean truncate) {
        if (truncate) {
            friendships = this.truncate(friendships, limit);
        }
        if (friendships == null || friendships.length <= 0) {
            return null;
        }
        HashSet<Long> userIdSet = new HashSet<Long>();
        for (IFriendship friendship : friendships) {
            userIdSet.add(friendship.getActiveId());
            userIdSet.add(friendship.getPassiveId());
        }
        long[] userIds = ArrayUtils.toPrimitive((Long[])userIdSet.toArray(new Long[userIdSet.size()]));
        IUser[] users = this.getDirectoryService().getUsers(userIds);
        HashMap<Long, IUser> userMap = new HashMap<Long, IUser>();
        for (IUser iUser : users) {
            IServerFile serverFile = iUser.getProfileImage();
            if (serverFile != null) {
                serverFile.prepareForView();
            }
            userMap.put(iUser.getUserId(), iUser);
        }
        for (IUser iUser : friendships) {
            long userId = iUser.getActiveId();
            iUser.setActive((IUser)userMap.get(userId));
            userId = iUser.getPassiveId();
            iUser.setPassive((IUser)userMap.get(userId));
        }
        return friendships;
    }

    public IFavorite getFavorite(long statusId) {
        IDirectoryService directoryService = this.getDirectoryService();
        IUser user = directoryService.getLoginUser();
        return this.getShovelLogic().getFavorite(statusId, user.getUserId());
    }

    public IFavorite[] getFavorites(long[] statusIds) {
        IDirectoryService directoryService = this.getDirectoryService();
        IUser user = directoryService.getLoginUser();
        return this.getShovelLogic().getFavorites(statusIds, user.getUserId());
    }

    public IFavorite[] getFavoritesByStatus(long statusId, int limit) {
        return this.getShovelLogic().getFavoritesByStatus(statusId, limit);
    }

    public IFavorite[] getFavoritesByStatuses(long[] statusIds, int limit) {
        return this.getShovelLogic().getFavoritesByStatuses(statusIds, limit);
    }

    public IFavorite createFavorite(String foreignKey) throws ApplicationException {
        IStatus status = this.getRecent(foreignKey);
        if (status == null) {
            return null;
        }
        return this.createFavorite(status.getStatusId());
    }

    public IFavorite createFavorite(long statusId) throws ApplicationException {
        if (this.getFavorite(statusId) != null) {
            return null;
        }
        IStatus status = this.getStatus(statusId);
        if (status.isRemove()) {
            return null;
        }
        IDirectoryService directoryService = this.getDirectoryService();
        IUser user = directoryService.getLoginUser();
        if (!this.isMobilePhone()) {
            directoryService.incrementFavorites(user.getUserId());
            if (status.getSenderId() != user.getUserId()) {
                directoryService.incrementGivenFavorites(status.getSenderId());
            }
        }
        return this.getShovelLogic().createFavorite(statusId, user.getUserId(), this.isMobilePhone());
    }

    public int destroyFavorite(long statusId) throws ApplicationException {
        int result;
        if (this.getFavorite(statusId) == null) {
            return 0;
        }
        IStatus status = this.getStatus(statusId);
        if (status.isRemove()) {
            return 0;
        }
        IDirectoryService directoryService = this.getDirectoryService();
        IUser user = directoryService.getLoginUser();
        if (!this.isMobilePhone()) {
            directoryService.decrementFavorites(user.getUserId());
            if (status.getSenderId() != user.getUserId()) {
                directoryService.decrementGivenFavorites(status.getSenderId());
            }
        }
        if ((result = this.getShovelLogic().destroyFavorite(statusId, user.getUserId(), this.isMobilePhone())) <= 0) {
            throw new ApplicationException("");
        }
        return result;
    }

    public IDevice createDevice(String deviceType, String address) {
        IUser user = this.getDirectoryService().getLoginUser();
        IDevice device = user.getDevice();
        device.setAddress(address);
        device.setAvailabilityType(AvailabilityType.INACTIVATION);
        device.setType(deviceType);
        device.setUserId(user.getUserId());
        if (device.getDeviceId() > 0L) {
            this.getShovelLogic().updateDevice(device);
        } else {
            this.getShovelLogic().createDevice(device);
        }
        return device;
    }

    public int activateDevice() {
        IUser user = this.getDirectoryService().getLoginUser();
        IDevice device = user.getDevice();
        device.setAvailabilityType(AvailabilityType.ON);
        return this.getShovelLogic().updateDevice(device);
    }

    public int updateDevice(AvailabilityType availabilityType) {
        IUser user = this.getDirectoryService().getLoginUser();
        IDevice device = user.getDevice();
        device.setAvailabilityType(availabilityType);
        return this.getShovelLogic().updateDevice(device);
    }

    public int resetDevice() {
        IUser user = this.getDirectoryService().getLoginUser();
        IDevice device = user.getDevice();
        device.setAddress("");
        device.setAvailabilityType(AvailabilityType.INACTIVATION);
        device.setDeviceType(DeviceType.UNKNOWN);
        return this.getShovelLogic().updateDevice(device);
    }

    public IDedicatedClient createClient(String key, String url, String version) {
        return this.getShovelLogic().createClient(key, url, version);
    }

    public int updateClient(IDedicatedClient client) {
        return this.getShovelLogic().updateClient(client);
    }

    public IDedicatedClient getClient(String key) {
        return this.getShovelLogic().getClient(key);
    }

    public IDedicatedClient[] getClients(String[] keys) {
        return this.getShovelLogic().getClients(keys);
    }

    public int removeClient(String key) {
        return this.getShovelLogic().removeClient(key);
    }

    public IUser[] prepareForView(IUser[] users, int limit) {
        if ((users = this.truncate(users, limit)) == null || users.length <= 0) {
            return new IUser[0];
        }
        for (IUser user : users) {
            IServerFile backgroundImage;
            IServerFile profileImage = user.getProfileImage();
            if (profileImage != null) {
                profileImage.prepareForView();
            }
            if ((backgroundImage = user.getBackgroundImage()) == null) continue;
            backgroundImage.prepareForView();
        }
        return users;
    }

    public IUser prepareForView(IUser user) throws ApplicationException {
        IServerFile backgroundImage;
        if (user == null) {
            return null;
        }
        String foreignKey = user.getForeignKey();
        user.setFollowers(this.countFollows(foreignKey));
        user.setFollowing(this.countFriends(foreignKey));
        user.setRequests(this.countRequests(foreignKey));
        user.setRecentlyStatus(this.getRecent(user.getUserId()));
        IServerFile profileImage = user.getProfileImage();
        if (profileImage != null) {
            profileImage.prepareForView();
        }
        if ((backgroundImage = user.getBackgroundImage()) != null) {
            backgroundImage.prepareForView();
        }
        return user;
    }

    public IMobilePhone getMobilePhone() throws ApplicationException {
        if (this.mobilePhone_ == null) {
            this.mobilePhone_ = this.getMobilePhoneLogic().createMobilePhone(null);
        }
        return this.mobilePhone_;
    }

    public boolean isMobilePhone() throws ApplicationException {
        return this.getMobilePhone() != null;
    }

    public void setDirectoryService(IDirectoryService directoryService) {
        this.directoryService_ = directoryService;
    }

    public IDirectoryService getDirectoryService() {
        return this.directoryService_;
    }

    public void setServerFileService(IServerFileService serverFileService) {
        this.serverFileService_ = serverFileService;
    }

    public IServerFileService getServerFileService() {
        return this.serverFileService_;
    }

    public HttpServletRequest getRequest() {
        if (this.request_ == null) {
            this.request_ = (HttpServletRequest)this.getContainer().getComponent((Object)"request");
        }
        return this.request_;
    }

    public HttpServletResponse getResponse() {
        if (this.response_ == null) {
            this.response_ = (HttpServletResponse)this.getContainer().getComponent((Object)"response");
        }
        return this.response_;
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    S2Container getContainer() {
        return this.container_;
    }

    public void setShovelLogic(IShovelLogic shovelLogic) {
        this.shovelLogic_ = shovelLogic;
    }

    IShovelLogic getShovelLogic() {
        return this.shovelLogic_;
    }

    public void setMobilePhoneLogic(IMobilePhoneLogic mobilePhoneLogic) {
        this.mobilePhoneLogic_ = mobilePhoneLogic;
    }

    public IMobilePhoneLogic getMobilePhoneLogic() {
        return this.mobilePhoneLogic_;
    }
}

