/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.service.impl;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import jp.sourceforge.shovel.SizeType;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IServerFileLogic;
import jp.sourceforge.shovel.service.IServerFileService;
import jp.sourceforge.shovel.xa.XAServerFile;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class ServerFileServiceImpl
implements IServerFileService {
    XAServerFile xa_;
    IServerFileLogic serverFileLogic_;
    TransactionManager transactionManager_;

    public void createServerFile(IServerFile serverFile, boolean thumbnail, boolean detectEncoding) throws ApplicationException {
        if (serverFile.isExists()) {
            this.getServerFileLogic().createServerFile(serverFile, thumbnail, detectEncoding);
            this.getXAResource().addToCopy(serverFile);
        }
    }

    public void removeServerFile(IServerFile serverFile) throws ApplicationException {
        this.getXAResource().addToRemove(serverFile);
        this.getServerFileLogic().removeServerFile(serverFile.getServerFileId());
    }

    public boolean createThumbnail(IServerFile serverFile, SizeType sizeType) throws ApplicationException {
        if (!serverFile.isExists(sizeType) && !sizeType.isOriginal()) {
            this.getServerFileLogic().createThumbnail(serverFile, sizeType);
            this.getXAResource().addToWork(serverFile, sizeType);
            return true;
        }
        return false;
    }

    TransactionManager getTransactionManager() {
        return (TransactionManager)this.getContainer().getComponent(TransactionManager.class);
    }

    XAServerFile getXAResource() throws ApplicationException {
        if (this.xa_ == null) {
            try {
                Transaction tx = this.getTransactionManager().getTransaction();
                this.xa_ = (XAServerFile)this.getContainer().getComponent(XAServerFile.class);
                tx.enlistResource((XAResource)this.xa_);
            }
            catch (Exception cause) {
                ApplicationException e = new ApplicationException("");
                e.initCause((Throwable)cause);
                throw e;
            }
        }
        return this.xa_;
    }

    S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }

    public void setServerFileLogic(IServerFileLogic serverFileLogic) {
        this.serverFileLogic_ = serverFileLogic;
    }

    IServerFileLogic getServerFileLogic() {
        return this.serverFileLogic_;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager_ = transactionManager;
    }
}

