/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.mobilephone.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.mobilephone.IEZweb;
import jp.sourceforge.shovel.mobilephone.impl.AbstractMobilePhoneImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EZwebImpl
extends AbstractMobilePhoneImpl
implements IEZweb {
    String serverName_;
    String comment_;
    boolean xhtmlCompliant_;
    int width_;
    int height_;
    int depth_;
    boolean color_;
    static final Map<String, String> images_ = new HashMap();

    public boolean isEZweb() {
        return true;
    }

    public boolean isTUKa() {
        String tuka = this.getRawModel().substring(2, 1);
        if (this.isWAP2()) {
            return tuka.compareTo("U") == 0;
        }
        return tuka.compareTo("T") == 0;
    }

    public String getDeviceID() {
        return this.rawModel_;
    }

    public String getServer() {
        return this.serverName_;
    }

    public String getComment() {
        return this.comment_;
    }

    public boolean isXHTMLCompliant() {
        return this.xhtmlCompliant_;
    }

    public String getCarrierShortName() {
        return "E";
    }

    public String getCarrierLongName() {
        return "EZweb";
    }

    public boolean isWIN() {
        return this.rawModel_.substring(2, 1).compareTo("3") == 0;
    }

    public String getUID() {
        return this.getRequest().getHeader("X-UP-SUBNO");
    }

    public Map<String, String> getNumberImages() {
        return images_;
    }

    public int getWidth() {
        return this.width_;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getDepth() {
        return this.depth_;
    }

    public boolean isColor() {
        return this.color_;
    }

    void parse() throws ApplicationException {
        String userAgent = this.getUserAgent();
        Pattern pattern = Pattern.compile("^KDDI-(.*)");
        Matcher matcher = pattern.matcher(userAgent);
        if (matcher.find()) {
            this.xhtmlCompliant_ = true;
            String[] tokens = matcher.group(1).split(" ", 4);
            this.rawModel_ = tokens[0];
            this.serverName_ = tokens[3];
            StringBuilder builder = new StringBuilder(tokens[2]);
            if ((tokens = tokens[1].split("/")) == null || tokens.length < 2) {
                throw new ApplicationException("");
            }
            this.name_ = tokens[0];
            builder.insert(0, " ");
            builder.insert(0, tokens[1]);
            this.version_ = builder.toString();
        } else {
            String[] tokens = userAgent.split(" ", 3);
            if (tokens == null || tokens.length < 2) {
                throw new ApplicationException("");
            }
            this.serverName_ = tokens[1];
            if (tokens.length == 3 && tokens[2] != null && (matcher = (pattern = Pattern.compile("^\\((.*)\\)$")).matcher(tokens[2])).find()) {
                this.comment_ = matcher.group(1);
            }
            if ((tokens = tokens[0].split("/")) == null || tokens.length < 2) {
                throw new ApplicationException("");
            }
            this.name_ = tokens[0];
            if ((tokens = tokens[1].split("-")) == null || tokens.length < 2) {
                throw new ApplicationException("");
            }
            this.version_ = tokens[0];
            this.rawModel_ = tokens[1];
        }
        this.makeScreenInfo();
    }

    void makeScreenInfo() {
        String[] tokens;
        String header = this.getRequest().getHeader("X-UP-DEVCAP-SCREENPIXELS");
        if (header != null && header.length() > 0) {
            tokens = header.split(",");
            this.width_ = Integer.parseInt(tokens[0]);
            this.height_ = Integer.parseInt(tokens[1]);
        }
        if ((header = this.getRequest().getHeader("X-UP-DEVCAP-SCREENDEPTH")) != null && header.length() > 0) {
            tokens = header.split(",");
            this.depth_ = (int)Math.pow(2.0, Integer.valueOf(tokens[0]).doubleValue());
        }
        if ((header = this.getRequest().getHeader("X-UP-DEVCAP-ISCOLOR")) != null && header.length() > 0) {
            this.color_ = header.compareTo("1") == 0;
        }
    }

    static {
        images_.put("1", "&#xF6FB;");
        images_.put("2", "&#xF6FC;");
        images_.put("3", "&#xF740;");
        images_.put("4", "&#xF741;");
        images_.put("5", "&#xF742;");
        images_.put("6", "&#xF743;");
        images_.put("7", "&#xF744;");
        images_.put("8", "&#xF745;");
        images_.put("9", "&#xF746;");
        images_.put("0", "&#xF7C9;");
        images_.put("#", "&#xF489;");
    }
}

