/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.logic.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.shovel.DelayExecutionType;
import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.StatusType;
import jp.sourceforge.shovel.dao.IDedicatedClientDao;
import jp.sourceforge.shovel.dao.IDeviceDao;
import jp.sourceforge.shovel.dao.IDirectMessageDao;
import jp.sourceforge.shovel.dao.IFavoriteDao;
import jp.sourceforge.shovel.dao.IFriendshipCustomDao;
import jp.sourceforge.shovel.dao.IFriendshipDao;
import jp.sourceforge.shovel.dao.IStatusDao;
import jp.sourceforge.shovel.device.IDelayExecutorContext;
import jp.sourceforge.shovel.entity.IDedicatedClient;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IDirectMessage;
import jp.sourceforge.shovel.entity.IFavorite;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IStatusWrapper;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IShovelLogic;
import jp.sourceforge.shovel.logic.impl.ShovelLogicImpl;
import jp.sourceforge.shovel.thread.DelayExecutorQueue;
import jp.sourceforge.shovel.util.ShovelUtil;
import org.seasar.framework.container.S2Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ShovelLogicImpl
implements IShovelLogic {
    Map<String, IDedicatedClient> clientMap_ = new HashMap();
    S2Container container_;

    SortedMap<Long, StatusToken> parseStatus(String data, StatusTokenType type, String pattern, SortedMap<Long, StatusToken> tokenMap) {
        if (tokenMap == null) {
            tokenMap = new TreeMap<Long, StatusToken>();
        }
        Matcher matcher = Pattern.compile(pattern).matcher(data);
        while (matcher.find()) {
            StatusToken token = new StatusToken(this);
            token.setType(type);
            token.setStart(matcher.start());
            token.setEnd(matcher.end());
            int groupCount = matcher.groupCount();
            ArrayList<String> regs = new ArrayList<String>();
            for (int i = 0; i <= groupCount; ++i) {
                regs.add(matcher.group(i));
            }
            token.setRegs(regs);
            tokenMap.put(Long.valueOf(matcher.start()), token);
        }
        return tokenMap;
    }

    public IStatusWrapper parseStatus(String status) {
        if (status != null && status.length() > 0) {
            TreeMap tokenMap = new TreeMap();
            for (StatusTokenType statusTokenType : StatusTokenType.values()) {
                String pattern = statusTokenType.getPattern();
                this.parseStatus(status, statusTokenType, pattern, tokenMap);
            }
            IStatusWrapper statusWrapper = (IStatusWrapper)this.getContainer().getComponent(IStatusWrapper.class);
            statusWrapper.setStatusType(StatusType.STATUS);
            statusWrapper.setText(status);
            StatusToken[] tokens = tokenMap.values().toArray(new StatusToken[tokenMap.size()]);
            if (tokens != null && tokens.length > 0) {
                block13: for (StatusToken token : tokens) {
                    switch (1.$SwitchMap$jp$sourceforge$shovel$logic$impl$ShovelLogicImpl$StatusTokenType[token.getType().ordinal()]) {
                        case 1: {
                            statusWrapper.setOpen(true);
                        }
                        case 2: {
                            statusWrapper.setForeignKey(tokens[0].getRegs()[1]);
                            continue block13;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            statusWrapper.setForeignKey(tokens[0].getRegs()[1]);
                            statusWrapper.setText(tokens[0].getRegs()[3]);
                            statusWrapper.setStatusType(StatusType.DIRECT_MESSAGE);
                            continue block13;
                        }
                        case 6: {
                            statusWrapper.setForeignKey(tokens[0].getRegs()[1]);
                            statusWrapper.setStatusType(StatusType.FAVORITE);
                            continue block13;
                        }
                        case 7: 
                        case 8: {
                            statusWrapper.setForeignKey(tokens[0].getRegs()[1]);
                            statusWrapper.setStatusType(StatusType.FOLLOW);
                            continue block13;
                        }
                        case 9: 
                        case 10: {
                            statusWrapper.setForeignKey(tokens[0].getRegs()[1]);
                            statusWrapper.setStatusType(StatusType.LEAVE);
                            continue block13;
                        }
                        case 11: {
                            statusWrapper.setForeignKey(tokens[0].getRegs()[1]);
                            statusWrapper.setStatusType(StatusType.NOTIFY_ON);
                            continue block13;
                        }
                        case 12: {
                            statusWrapper.setForeignKey(tokens[0].getRegs()[1]);
                            statusWrapper.setStatusType(StatusType.NOTIFY_OFF);
                            continue block13;
                        }
                        case 13: 
                        case 14: 
                        case 15: {
                            statusWrapper.setStatusType(StatusType.SLEEP);
                            continue block13;
                        }
                        case 16: 
                        case 17: {
                            statusWrapper.setStatusType(StatusType.WAKE);
                            continue block13;
                        }
                    }
                }
            }
            return statusWrapper;
        }
        return null;
    }

    public IStatus getStatus(long statusId) {
        return this.getStatusDao().find(statusId);
    }

    public IStatus getRecent(long userId) {
        return this.getStatusDao().findRecent(userId);
    }

    public IStatus[] getRecents(long[] userIds) {
        IStatus[] statuses = this.getStatusDao().findAllRecent(userIds, 0, userIds.length);
        if (statuses == null || statuses.length <= 0) {
            return statuses;
        }
        long[] statusIds = new long[statuses.length];
        int i = 0;
        for (IStatus status : statuses) {
            statusIds[i++] = status.getStatusId();
        }
        return this.getStatusDao().findAll(statusIds, SortType.STATUS_ID, SortOrderType.DESC, 0, statusIds.length);
    }

    public IStatus[] getFavorites(long userId, int page, int limit) {
        return this.getStatusDao().findAllFavorite(userId, page, limit);
    }

    public IStatus[] getStatuses(int offset, int limit) {
        return this.getStatusDao().findAll(null, SortType.STATUS_ID, SortOrderType.DESC, offset, limit);
    }

    public IStatus[] getStatuses(long sinceId, int limit) {
        return this.getStatusDao().findAllBySinceId(sinceId, limit);
    }

    public IStatus[] getStatuses(String since, boolean useRemoved, int limit) throws ApplicationException {
        long sinceTime = ShovelUtil.parseRFC2822DateTime((String)since);
        return this.getStatusDao().findAllBySinceTime(sinceTime, useRemoved, limit);
    }

    public IStatus[] getStatuses(SortType sortType, SortOrderType sortOrderType, int limit) {
        return this.getStatusDao().findAll(null, sortType, sortOrderType, 0, limit);
    }

    public IStatus[] getStatuses(long userId, boolean withFriends, RepliesType repliesType, int offset, int limit) {
        if (withFriends) {
            return this.getStatusDao().findAllWithFriends(userId, repliesType, offset, limit);
        }
        return this.getStatusDao().findAllSingle(userId, offset, limit);
    }

    public IStatus[] getStatuses(long userId, boolean withFriends, RepliesType repliesType, String since, int limit) throws ApplicationException {
        long sentTime = ShovelUtil.parseRFC2822DateTime((String)since);
        if (withFriends) {
            return this.getStatusDao().findAllWithFriendsSinceTime(userId, repliesType, sentTime, limit);
        }
        return this.getStatusDao().findAllSingleSinceTime(userId, sentTime, limit);
    }

    public IStatus[] getReplies(long userId, int offset, int limit) {
        return this.getStatusDao().findAllReply(userId, offset, limit);
    }

    public IStatus updateStatus(String body, String location, String source, long referenceSenderId, boolean open, long senderId, boolean delayCommit) throws ApplicationException {
        IStatus reference;
        if (senderId <= 0L) {
            throw new ApplicationException("");
        }
        if (body == null || body.length() <= 0) {
            throw new ApplicationException("");
        }
        if (source == null || source.length() <= 0) {
            source = "web";
        }
        long referenceId = 0L;
        if (referenceSenderId > 0L && (reference = this.getStatusDao().findRecent(referenceSenderId)) != null) {
            referenceId = reference.getStatusId();
        }
        body = body.replaceAll("\\r?\\n", "");
        long sentTime = Calendar.getInstance().getTimeInMillis();
        IStatus status = (IStatus)this.getContainer().getComponent(IStatus.class);
        status.setBody(body);
        status.setLocation(location);
        status.setSource(source);
        status.setReferenceId(referenceId);
        status.setReferenceSenderId(referenceSenderId);
        status.setSenderId(senderId);
        status.setSentTime(sentTime);
        status.setOpen(open);
        IDelayExecutorContext context = (IDelayExecutorContext)this.getContainer().getComponent(IDelayExecutorContext.class);
        context.setDelayExecutionType(DelayExecutionType.UPDATE_STATUS);
        context.setStatus(status);
        if (delayCommit) {
            context.initServerName();
            context.setCommit(delayCommit);
        } else {
            this.getStatusDao().insert(status);
        }
        DelayExecutorQueue queue = (DelayExecutorQueue)this.getContainer().getComponent(DelayExecutorQueue.class);
        queue.pushContext(context);
        return status;
    }

    public void receiveStatus(String body, String location, String source, long referenceSenderId, boolean open, long senderId) throws ApplicationException {
        this.updateStatus(body, location, source, referenceSenderId, open, senderId, false);
    }

    int incrementGivenFavorites(long statusId) {
        return this.getStatusDao().updateIncrementGivenFavorites(statusId);
    }

    public int decrementGivenFavorites(long statusId) {
        return this.getStatusDao().updateDecrementGivenFavorites(statusId);
    }

    public int destroyStatus(long statusId, boolean delayCommit) throws ApplicationException {
        long removedTime = Calendar.getInstance().getTimeInMillis();
        int result = 1;
        IStatus status = this.getStatusDao().find(statusId);
        if (status != null) {
            IDelayExecutorContext context = (IDelayExecutorContext)this.getContainer().getComponent(IDelayExecutorContext.class);
            context.setDelayExecutionType(DelayExecutionType.DESTROY_STATUS);
            context.setStatus(status);
            if (delayCommit) {
                context.initServerName();
                context.setCommit(delayCommit);
            } else {
                result = this.getStatusDao().updateRemovedTime(statusId, removedTime);
            }
            DelayExecutorQueue queue = (DelayExecutorQueue)this.getContainer().getComponent(DelayExecutorQueue.class);
            queue.pushContext(context);
        }
        return result;
    }

    public int clearStatusReference(long referenceId) {
        return this.getStatusDao().updateReference(referenceId);
    }

    public IDirectMessage getDirectMessage(long directMessageId) {
        return this.getDirectMessageDao().find(directMessageId);
    }

    public IDirectMessage[] getDirectMessages(long userId, boolean sent, int offset, int limit) {
        return this.getDirectMessageDao().findAll(userId, sent, offset, limit);
    }

    public IDirectMessage[] getDirectMessages(long userId, boolean sent, long sinceId, int limit) {
        return this.getDirectMessageDao().findAllSinceId(userId, sent, sinceId, limit);
    }

    public IDirectMessage[] getDirectMessages(long userId, boolean sent, String since, int limit) throws ApplicationException {
        long sentTime = ShovelUtil.parseRFC2822DateTime((String)since);
        return this.getDirectMessageDao().findAllSinceTime(userId, sent, sentTime, limit);
    }

    public IDirectMessage createDirectMessage(String text, String source, long senderId, long recipientId, boolean delayCommit) throws ApplicationException {
        if (senderId <= 0L || recipientId <= 0L) {
            throw new ApplicationException("");
        }
        if (text == null || text.length() <= 0) {
            throw new ApplicationException("");
        }
        if (source == null || source.length() <= 0) {
            source = "web";
        }
        long sentTime = Calendar.getInstance().getTimeInMillis();
        IDirectMessage directMessage = (IDirectMessage)this.getContainer().getComponent(IDirectMessage.class);
        directMessage.setText(text);
        directMessage.setRecipientId(recipientId);
        directMessage.setSenderId(senderId);
        directMessage.setSentTime(sentTime);
        directMessage.setSource(source);
        IDelayExecutorContext context = (IDelayExecutorContext)this.getContainer().getComponent(IDelayExecutorContext.class);
        context.setDelayExecutionType(DelayExecutionType.SEND_DIRECT_MESSAGE);
        context.setDirectMessage(directMessage);
        if (delayCommit) {
            context.initServerName();
            context.setCommit(delayCommit);
        } else {
            this.getDirectMessageDao().insert(directMessage);
        }
        DelayExecutorQueue queue = (DelayExecutorQueue)this.getContainer().getComponent(DelayExecutorQueue.class);
        queue.pushContext(context);
        return directMessage;
    }

    public int destroyDirectMessage(long directMessageId, boolean sent, boolean delayCommit) throws ApplicationException {
        long removedTime = Calendar.getInstance().getTimeInMillis();
        int result = 1;
        IDirectMessage directMessage = this.getDirectMessageDao().find(directMessageId);
        if (directMessage != null) {
            IDelayExecutorContext context = (IDelayExecutorContext)this.getContainer().getComponent(IDelayExecutorContext.class);
            context.setDelayExecutionType(sent ? DelayExecutionType.DESTROY_SENT : DelayExecutionType.DESTROY_INBOX);
            context.setDirectMessage(directMessage);
            if (delayCommit) {
                context.initServerName();
                context.setCommit(delayCommit);
            } else {
                result = this.getDirectMessageDao().updateRemovedTime(directMessageId, sent, removedTime);
            }
            DelayExecutorQueue queue = (DelayExecutorQueue)this.getContainer().getComponent(DelayExecutorQueue.class);
            queue.pushContext(context);
        }
        return result;
    }

    public IFriendship getFriendship(long activeId, long passiveId) {
        return this.getFriendshipDao().find(activeId, passiveId);
    }

    public IFriendship getFriendship(long activeId, String passiveId) {
        return this.getFriendshipDao().findByPassiveForeignKey(activeId, passiveId);
    }

    public IFriendship getFriendship(String activeId, long passiveId) {
        return this.getFriendshipDao().findByActiveForeignKey(activeId, passiveId);
    }

    public IFriendship[] getFriends(long activeId, int offset, int limit) {
        return this.getFriendshipDao().findAllFriends(activeId, offset, limit);
    }

    public IFriendship[] getFriends(long activeId, long[] passiveIds) {
        if (passiveIds == null || passiveIds.length <= 0) {
            return new IFriendship[0];
        }
        return this.getFriendshipDao().findAllFriendsBy(activeId, passiveIds, 0, passiveIds.length);
    }

    public IFriendship[] getFollowers(long passiveId, boolean growl, int offset, int limit) {
        if (growl) {
            return this.getFriendshipDao().findAllFollowersByGrowl(passiveId, offset, limit);
        }
        return this.getFriendshipDao().findAllFollowers(passiveId, offset, limit);
    }

    public IFriendship[] getFollowers(long passiveId, String deviceType, int offset, int limit) {
        return this.getFriendshipDao().findAllFollowersByDevice(passiveId, deviceType, offset, limit);
    }

    public IFriendship[] getFollowers(long passiveId, long[] activeIds) {
        return this.getFriendshipDao().findAllFollowersBy(passiveId, activeIds, 0, activeIds.length);
    }

    public IFriendship[] searchFollowing(long activeId, String[] keywords, int offset, int limit) {
        return this.getFriendshipCustomDao().searchFollowing(activeId, keywords, offset, limit);
    }

    public IFriendship[] searchReciprocalFollow(long userId, String[] keywords, int offset, int limit) {
        return this.getFriendshipCustomDao().searchReciprocalFollow(userId, keywords, offset, limit);
    }

    public IFriendship[] searchFollowingOnly(long activeId, String[] keywords, int offset, int limit) {
        return this.getFriendshipCustomDao().searchFollowingOnly(activeId, keywords, offset, limit);
    }

    public IFriendship[] searchFollowersOnly(long passiveId, String[] keywords, int offset, int limit) {
        return this.getFriendshipCustomDao().searchFollowersOnly(passiveId, keywords, offset, limit);
    }

    public IFriendship[] getRequests(long activeId, long passiveId) {
        return this.getFriendshipDao().find2WayRequests(activeId, passiveId);
    }

    public IFriendship[] getRequests(String activeId, long passiveId) {
        return this.getFriendshipDao().find2WayRequestsByForeignKey(activeId, passiveId);
    }

    public IFriendship[] getRequests(long passiveId, int offset, int limit) {
        return this.getFriendshipDao().findAllRequests(passiveId, offset, limit);
    }

    public int countPublicFriends(long activeId) {
        return this.getFriendshipDao().countPublicFriends(activeId);
    }

    public int countProtectFriends(long activeId) {
        return this.getFriendshipDao().countProtectFriends(activeId);
    }

    public int countAllFollowers(long passiveId) {
        return this.getFriendshipDao().countAllFollowers(passiveId);
    }

    public int countAcceptFollowers(long passiveId) {
        return this.getFriendshipDao().countAcceptFollowers(passiveId);
    }

    public int countRequestFollowers(long activeId) {
        return this.getFriendshipDao().countRequestFollowers(activeId);
    }

    public IFriendship createFriendship(long activeId, long passiveId, boolean protect, boolean delayCommit) throws ApplicationException {
        if (activeId == passiveId) {
            throw new ApplicationException("");
        }
        IFriendship[] friendships = this.getRequests(activeId, passiveId);
        IFriendship friend = null;
        IFriendship follower = null;
        for (IFriendship tmp : friendships) {
            if (tmp.getPassiveId() == passiveId) {
                friend = tmp;
                continue;
            }
            follower = tmp;
        }
        long time = Calendar.getInstance().getTimeInMillis();
        boolean accept = false;
        if (follower != null && follower.getRemovedTime() == 0L) {
            accept = true;
            if (protect && follower == null && (follower = this.createFriendship(activeId, passiveId, accept, time, delayCommit)) == null) {
                throw new ApplicationException("");
            }
        }
        if (friend == null) {
            friend = this.createFriendship(activeId, passiveId, accept, time, delayCommit);
            if (friend == null) {
                throw new ApplicationException("");
            }
        } else {
            long[] friendshipIds = follower != null && follower.getRemovedTime() == 0L ? new long[]{friend.getFriendshipId(), follower.getFriendshipId()} : new long[]{friend.getFriendshipId()};
            int result = this.updateFriendships(friendshipIds, accept, time, true, 0L, delayCommit);
            if (result != friendshipIds.length) {
                throw new ApplicationException("");
            }
            friend.setAccept(accept);
            friend.setCreatedTime(time);
            friend.setNotify(true);
            friend.setRemovedTime(0L);
        }
        IDelayExecutorContext context = (IDelayExecutorContext)this.getContainer().getComponent(IDelayExecutorContext.class);
        context.setDelayExecutionType(DelayExecutionType.FOLLOW_FRIEND);
        context.setFriend(friend);
        if (delayCommit) {
            context.initServerName();
            context.setCommit(delayCommit);
        }
        DelayExecutorQueue queue = (DelayExecutorQueue)this.getContainer().getComponent(DelayExecutorQueue.class);
        queue.pushContext(context);
        return friend;
    }

    IFriendship createFriendship(long activeId, long passiveId, boolean accept, long createdTime, boolean delayCommit) throws ApplicationException {
        if (activeId == passiveId) {
            throw new ApplicationException("");
        }
        IFriendship friendship = (IFriendship)this.getContainer().getComponent(IFriendship.class);
        friendship.setAccept(accept);
        friendship.setActiveId(activeId);
        friendship.setCreatedTime(createdTime);
        friendship.setNotify(true);
        friendship.setPassiveId(passiveId);
        if (!delayCommit) {
            this.getFriendshipDao().insert(friendship);
        }
        return friendship;
    }

    public IFriendship destroyFriendship(long activeId, long passiveId, boolean protect, boolean delayCommit) throws ApplicationException {
        IFriendship[] friendships = this.getRequests(passiveId, activeId);
        if (friendships == null || friendships.length > 2) {
            throw new ApplicationException("");
        }
        IFriendship friend = null;
        IFriendship follower = null;
        for (IFriendship tmp : friendships) {
            if (tmp.getPassiveId() == passiveId) {
                friend = tmp;
                continue;
            }
            follower = tmp;
        }
        if (friend == null) {
            throw new ApplicationException("");
        }
        long time = Calendar.getInstance().getTimeInMillis();
        int result = friendships.length;
        if (follower != null && protect) {
            long[] friendshipIds = new long[]{friend.getFriendshipId(), follower.getFriendshipId()};
            result = this.updateFriendships(friendshipIds, false, 0L, false, time, delayCommit);
        } else {
            friend.setAccept(false);
            friend.setCreatedTime(0L);
            friend.setNotify(false);
            friend.setRemovedTime(time);
            if (!delayCommit) {
                result = this.getFriendshipDao().update(friend);
                if (follower != null) {
                    follower.setAccept(false);
                    result += this.getFriendshipDao().update(follower);
                }
            }
        }
        if (result != friendships.length) {
            throw new ApplicationException("");
        }
        IDelayExecutorContext context = (IDelayExecutorContext)this.getContainer().getComponent(IDelayExecutorContext.class);
        context.setDelayExecutionType(DelayExecutionType.LEAVE_FRIEND);
        context.setFriend(friend);
        if (delayCommit) {
            context.initServerName();
            context.setCommit(delayCommit);
        }
        DelayExecutorQueue queue = (DelayExecutorQueue)this.getContainer().getComponent(DelayExecutorQueue.class);
        queue.pushContext(context);
        return friend;
    }

    int updateFriendships(long[] friendshipIds, boolean accept, long createdTime, boolean notify, long removedTime, boolean delayCommit) {
        if (!delayCommit) {
            return this.getFriendshipDao().updateAll(friendshipIds, accept, createdTime, notify, removedTime);
        }
        return friendshipIds.length;
    }

    public int updateFriendshipNotify(long activeId, long passiveId, boolean notify) {
        return this.getFriendshipDao().updateNotifyByUserId(activeId, passiveId, notify);
    }

    public int updateFriendshipNotify(long activeId, String passiveId, boolean notify) {
        return this.getFriendshipDao().updateNotifyByForeignKey(activeId, passiveId, notify);
    }

    public IFriendship updateNotification(long activeId, long passiveId, boolean notify) throws ApplicationException {
        IFriendship friendship = this.getFriendship(activeId, passiveId);
        if (friendship == null) {
            throw new ApplicationException("");
        }
        int result = this.updateFriendshipNotify(activeId, passiveId, notify);
        if (result != 1) {
            throw new ApplicationException("");
        }
        return friendship;
    }

    public IFriendship updateNotification(long activeId, String passiveId, boolean notify) throws ApplicationException {
        IFriendship friendship = this.getFriendship(activeId, passiveId);
        if (friendship == null) {
            throw new ApplicationException("");
        }
        int result = this.updateFriendshipNotify(activeId, passiveId, notify);
        if (result != 1) {
            throw new ApplicationException("");
        }
        return friendship;
    }

    public IFriendship acceptFriendship(long activeId, long passiveId, boolean delayCommit) throws ApplicationException {
        IFriendship[] friendships = this.getRequests(activeId, passiveId);
        if (friendships == null) {
            throw new ApplicationException("");
        }
        IFriendship friend = null;
        IFriendship follower = null;
        for (IFriendship tmp : friendships) {
            if (tmp.getActiveId() == activeId) {
                follower = tmp;
                continue;
            }
            friend = tmp;
        }
        if (follower == null) {
            throw new ApplicationException("");
        }
        long time = Calendar.getInstance().getTimeInMillis();
        long[] friendshipIds = new long[]{follower.getFriendshipId()};
        if (friend == null && (friend = this.createFriendship(passiveId, activeId, true, time, delayCommit)) == null) {
            throw new ApplicationException("");
        }
        int result = this.updateFriendships(friendshipIds, true, time, true, 0L, delayCommit);
        if (result != friendshipIds.length) {
            throw new ApplicationException("");
        }
        return follower;
    }

    public IFriendship denyFriendship(long activeId, long passiveId, boolean denyCommit) throws ApplicationException {
        long time;
        IFriendship[] friendships = this.getRequests(passiveId, activeId);
        if (friendships == null || friendships.length > 2) {
            throw new ApplicationException("");
        }
        IFriendship friend = null;
        IFriendship follower = null;
        for (IFriendship tmp : friendships) {
            if (tmp.getActiveId() == passiveId) {
                follower = tmp;
                continue;
            }
            friend = tmp;
        }
        if (follower == null) {
            throw new ApplicationException("");
        }
        long[] friendshipIds = friend == null ? new long[]{follower.getFriendshipId()} : new long[]{follower.getFriendshipId(), friend.getFriendshipId()};
        int result = this.updateFriendships(friendshipIds, false, 0L, false, time = Calendar.getInstance().getTimeInMillis(), denyCommit);
        if (result != friendshipIds.length) {
            throw new ApplicationException("");
        }
        return follower;
    }

    public IFavorite getFavorite(long statusId, long userId) {
        return this.getFavoriteDao().findFavorite(statusId, userId);
    }

    public IFavorite[] getFavorites(long[] statusIds, long userId) {
        return this.getFavoriteDao().findAllFavorite(statusIds, userId, statusIds.length);
    }

    public IFavorite[] getFavoritesByStatus(long statusId, int limit) {
        return this.getFavoriteDao().findAllFavoriteByStatus(statusId, limit);
    }

    public IFavorite[] getFavoritesByStatuses(long[] statusIds, int limit) {
        return this.getFavoriteDao().findAllFavoriteByStatuses(statusIds, limit);
    }

    public IFavorite createFavorite(long statusId, long userId, boolean delayCommit) throws ApplicationException {
        long createdTime = Calendar.getInstance().getTimeInMillis();
        IFavorite favorite = (IFavorite)this.getContainer().getComponent(IFavorite.class);
        favorite.setCreatedTime(createdTime);
        favorite.setStatusId(statusId);
        favorite.setUserId(userId);
        IDelayExecutorContext context = (IDelayExecutorContext)this.getContainer().getComponent(IDelayExecutorContext.class);
        context.setDelayExecutionType(DelayExecutionType.CREATE_FAVORITE);
        context.setFavorite(favorite);
        if (delayCommit) {
            context.initServerName();
            context.setCommit(delayCommit);
        } else {
            this.incrementGivenFavorites(statusId);
            this.getFavoriteDao().insert(favorite);
        }
        DelayExecutorQueue queue = (DelayExecutorQueue)this.getContainer().getComponent(DelayExecutorQueue.class);
        queue.pushContext(context);
        return favorite;
    }

    public int destroyFavorite(long statusId, long userId, boolean delayCommit) throws ApplicationException {
        int result = 1;
        IFavorite favorite = this.getFavoriteDao().findFavorite(statusId, userId);
        if (favorite != null) {
            IDelayExecutorContext context = (IDelayExecutorContext)this.getContainer().getComponent(IDelayExecutorContext.class);
            context.setDelayExecutionType(DelayExecutionType.DESTROY_FAVORITE);
            context.setFavorite(favorite);
            if (delayCommit) {
                context.initServerName();
                context.setCommit(delayCommit);
            } else {
                this.decrementGivenFavorites(statusId);
                result = this.getFavoriteDao().delete(statusId, userId);
            }
            DelayExecutorQueue queue = (DelayExecutorQueue)this.getContainer().getComponent(DelayExecutorQueue.class);
            queue.pushContext(context);
        }
        return result;
    }

    public IDevice createDevice(IDevice device) {
        this.getDeviceDao().insert(device);
        return device;
    }

    public int updateDevice(IDevice device) {
        return this.getDeviceDao().update(device);
    }

    public IDedicatedClient createClient(String key, String url, String version) {
        IDedicatedClient client = (IDedicatedClient)this.getContainer().getComponent(IDedicatedClient.class);
        client.setText(key);
        client.setUrl(url);
        client.setVersion(version);
        this.getDedicatedClientDao().insert(client);
        this.clientMap_.put(key, client);
        return client;
    }

    public int updateClient(IDedicatedClient client) {
        this.clientMap_.put(client.getText(), client);
        return this.getDedicatedClientDao().update(client);
    }

    public IDedicatedClient getClient(String key) {
        IDedicatedClient client = (IDedicatedClient)this.clientMap_.get(key);
        if (client != null) {
            return client;
        }
        return this.getDedicatedClientDao().findByKey(key);
    }

    public IDedicatedClient[] getClients(String[] texts) {
        ArrayList<IDedicatedClient> clientList = new ArrayList<IDedicatedClient>();
        ArrayList<String> textList = new ArrayList<String>();
        for (String text : texts) {
            IDedicatedClient client = (IDedicatedClient)this.clientMap_.get(text);
            if (client == null) {
                textList.add(text);
                continue;
            }
            clientList.add(client);
        }
        if (textList.size() > 0) {
            IDedicatedClient[] clients;
            texts = textList.toArray(new String[textList.size()]);
            for (IDedicatedClient client : clients = this.getDedicatedClientDao().findAllByText(texts, 0, texts.length)) {
                this.clientMap_.put(client.getText(), client);
                clientList.add(client);
            }
        }
        return clientList.toArray(new IDedicatedClient[clientList.size()]);
    }

    public int removeClient(String text) {
        this.clientMap_.remove(text);
        return this.getDedicatedClientDao().deleteByText(text);
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    S2Container getContainer() {
        return this.container_;
    }

    public IStatusDao getStatusDao() {
        return (IStatusDao)this.getContainer().getComponent(IStatusDao.class);
    }

    public IDirectMessageDao getDirectMessageDao() {
        return (IDirectMessageDao)this.getContainer().getComponent(IDirectMessageDao.class);
    }

    public IFavoriteDao getFavoriteDao() {
        return (IFavoriteDao)this.getContainer().getComponent(IFavoriteDao.class);
    }

    public IFriendshipDao getFriendshipDao() {
        return (IFriendshipDao)this.getContainer().getComponent(IFriendshipDao.class);
    }

    public IDeviceDao getDeviceDao() {
        return (IDeviceDao)this.getContainer().getComponent(IDeviceDao.class);
    }

    public IDedicatedClientDao getDedicatedClientDao() {
        return (IDedicatedClientDao)this.getContainer().getComponent(IDedicatedClientDao.class);
    }

    IFriendshipCustomDao getFriendshipCustomDao() {
        return (IFriendshipCustomDao)this.getContainer().getComponent(IFriendshipCustomDao.class);
    }
}

