/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.logic.impl;

import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IMobilePhoneLogic;
import jp.sourceforge.shovel.mobilephone.IDoCoMo;
import jp.sourceforge.shovel.mobilephone.IEZweb;
import jp.sourceforge.shovel.mobilephone.IMobilePhone;
import jp.sourceforge.shovel.mobilephone.ISoftBank;
import jp.sourceforge.shovel.mobilephone.IWillcom;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class MobilePhoneLogicImpl
implements IMobilePhoneLogic {
    public IMobilePhone createMobilePhone(String userAgent) throws ApplicationException {
        if ((userAgent = this.getUserAgent(userAgent)) == null || userAgent.length() <= 0) {
            return null;
        }
        Class<IDoCoMo> klass = null;
        if (this.isDoCoMo(userAgent)) {
            klass = IDoCoMo.class;
        } else if (this.isEZweb(userAgent)) {
            klass = IEZweb.class;
        } else if (this.isSoftBank(userAgent)) {
            klass = ISoftBank.class;
        } else if (this.isWillcom(userAgent)) {
            klass = IWillcom.class;
        } else {
            return null;
        }
        IMobilePhone mobilePhone = (IMobilePhone)this.getContainer().getComponent(klass);
        if (mobilePhone != null) {
            mobilePhone.parse(userAgent);
        }
        return mobilePhone;
    }

    public boolean isDoCoMo(String userAgent) {
        if ((userAgent = this.getUserAgent(userAgent)) == null || userAgent.length() <= 0) {
            return false;
        }
        return userAgent.startsWith("DoCoMo");
    }

    public boolean isEZweb(String userAgent) {
        if ((userAgent = this.getUserAgent(userAgent)) == null || userAgent.length() <= 0) {
            return false;
        }
        if (userAgent.startsWith("KDDI-")) {
            return true;
        }
        return userAgent.startsWith("UP.Browser");
    }

    public boolean isSoftBank(String userAgent) {
        if ((userAgent = this.getUserAgent(userAgent)) == null || userAgent.length() <= 0) {
            return false;
        }
        if (userAgent.startsWith("SoftBank")) {
            return true;
        }
        if (userAgent.startsWith("Semulator")) {
            return true;
        }
        if (userAgent.startsWith("Vodafone")) {
            return true;
        }
        if (userAgent.startsWith("Vemulator")) {
            return true;
        }
        if (userAgent.startsWith("MOT-")) {
            return true;
        }
        if (userAgent.startsWith("MOTEMULATOR")) {
            return true;
        }
        if (userAgent.startsWith("J-PHONE")) {
            return true;
        }
        return userAgent.startsWith("J-EMULATOR");
    }

    public boolean isWillcom(String userAgent) {
        if (userAgent == null || userAgent.length() <= 0) {
            return false;
        }
        return userAgent.matches("^Mozilla/3\\.0\\((?:DDIPOCKET|WILLCOM);.+");
    }

    String getUserAgent(String userAgent) {
        if (userAgent == null || userAgent.length() <= 0) {
            userAgent = this.getRequest().getHeader("USER-AGENT");
        }
        return userAgent;
    }

    HttpServletRequest getRequest() {
        return (HttpServletRequest)this.getContainer().getComponent((Object)"request");
    }

    S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }
}

