/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class InputStreamReaderExt
extends InputStreamReader {
    String prepend = "<#escape x as x?html>";
    String append = "</#escape>";
    int cursor_ = 0;
    int end_ = 0;

    public InputStreamReaderExt(InputStream in) {
        super(in);
    }

    public InputStreamReaderExt(InputStream in, String charsetName) throws UnsupportedEncodingException {
        super(in, charsetName);
    }

    public InputStreamReaderExt(InputStream in, Charset cs) {
        super(in, cs);
    }

    public InputStreamReaderExt(InputStream in, CharsetDecoder dec) {
        super(in, dec);
    }

    public int read() throws IOException {
        if (this.cursor_ < this.prepend.length()) {
            return this.prepend.codePointAt(this.cursor_++);
        }
        int code = super.read();
        if (code >= 0) {
            return code;
        }
        int offset = this.cursor_ - this.prepend.length();
        if (offset <= 0) {
            return -1;
        }
        ++this.cursor_;
        return this.append.codePointAt(offset);
    }

    public int read(char[] cbuf, int offset, int length) throws IOException {
        int start;
        length -= offset;
        StringBuilder builder = new StringBuilder();
        int end = this.prepend.length();
        int read = 0;
        if (end > this.cursor_) {
            if (end > length) {
                end = length;
            }
            builder.append(this.prepend.substring(0, end));
            if ((read += end) == length) {
                builder.getChars(offset, read, cbuf, 0);
                return read;
            }
            this.cursor_ += end;
        } else {
            end = 0;
        }
        end = super.read(cbuf, 0, length - read);
        if (end != -1) {
            builder.append(cbuf, 0, end);
            this.cursor_ += end;
            if ((read += end) == length) {
                builder.getChars(offset, read, cbuf, 0);
                return read;
            }
            this.end_ = this.cursor_;
        }
        if ((start = this.cursor_ - this.end_) >= (end = this.append.length())) {
            return -1;
        }
        builder.append(this.append.substring(start, end));
        if ((read += end - start) > length) {
            end -= read - length;
            read = length;
        }
        builder.getChars(offset, read, cbuf, 0);
        this.cursor_ += end;
        return read;
    }
}

