/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.device.impl;

import jp.sourceforge.shovel.AvailabilityType;
import jp.sourceforge.shovel.device.IMsnpWrapper;
import jp.sourceforge.shovel.device.impl.AbstractDelayExecutorImpl;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import net.sf.jml.Email;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnGroup;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.event.MsnContactListListener;
import net.sf.jml.event.MsnMessageListener;
import net.sf.jml.event.MsnMessengerListener;
import net.sf.jml.impl.MsnMessengerFactory;
import net.sf.jml.message.MsnControlMessage;
import net.sf.jml.message.MsnDatacastMessage;
import net.sf.jml.message.MsnInstantMessage;
import net.sf.jml.message.MsnSystemMessage;
import net.sf.jml.message.MsnUnknownMessage;
import net.sf.jml.message.p2p.MsnP2PMessage;

public class MsnpWrapperImpl
extends AbstractDelayExecutorImpl
implements IMsnpWrapper {
    MsnMessenger messenger_;
    boolean login_;

    public String getEmail() {
        return this.properties_.getProperty("userId");
    }

    public String getPassword() {
        return this.properties_.getProperty("password");
    }

    public String getExecutorId() {
        return "msnp";
    }

    public String getAddress() {
        return this.getEmail();
    }

    public void login() throws ApplicationException {
        this.messenger_ = MsnMessengerFactory.createMsnMessenger((String)this.getEmail(), (String)this.getPassword());
        this.messenger_.setLogIncoming(true);
        this.messenger_.setLogOutgoing(true);
        this.messenger_.addContactListListener((MsnContactListListener)this);
        this.messenger_.addMessengerListener((MsnMessengerListener)this);
        this.messenger_.addMessageListener((MsnMessageListener)this);
        this.messenger_.login();
    }

    public void logout() {
        this.messenger_.logout();
    }

    public void sendMessage(IUser receiver, String body) {
        IDevice device = receiver.getDevice();
        if (this.getExecutorId().compareToIgnoreCase(device.getType()) == 0 && device.getAvailabilityType() == AvailabilityType.ON) {
            String address = receiver.getAddress();
            if (address == null || address.length() <= 0) {
                return;
            }
            Email email = Email.parseStr((String)address);
            this.messenger_.sendText(email, body);
        }
    }

    public boolean isConnected() {
        return this.messenger_ != null && this.login_;
    }

    public void contactAddedMe(MsnMessenger messenger, MsnContact contact) {
    }

    public void contactListSyncCompleted(MsnMessenger messenger) {
    }

    public void contactListInitCompleted(MsnMessenger messenger) {
    }

    public void contactStatusChanged(MsnMessenger messenger, MsnContact contact) {
    }

    public void ownerStatusChanged(MsnMessenger messenger) {
    }

    public void contactRemovedMe(MsnMessenger messenger, MsnContact contact) {
    }

    public void contactAddCompleted(MsnMessenger messenger, MsnContact contact) {
    }

    public void contactRemoveCompleted(MsnMessenger messenger, MsnContact contact) {
    }

    public void groupAddCompleted(MsnMessenger messenger, MsnGroup group) {
    }

    public void groupRemoveCompleted(MsnMessenger messenger, MsnGroup group) {
    }

    public void loginCompleted(MsnMessenger messenger) {
        this.login_ = true;
    }

    public void logout(MsnMessenger messenger) {
        this.login_ = false;
        this.messenger_ = null;
    }

    public void exceptionCaught(MsnMessenger messenger, Throwable throwable) {
    }

    public void instantMessageReceived(MsnSwitchboard switchboard, MsnInstantMessage message, MsnContact contact) {
        try {
            String address = contact.getEmail().getEmailAddress();
            String body = message.getContent();
            this.receiveMessage(address, body);
        }
        catch (ApplicationException e) {
            // empty catch block
        }
    }

    public void controlMessageReceived(MsnSwitchboard switchboard, MsnControlMessage message, MsnContact contact) {
    }

    public void systemMessageReceived(MsnMessenger messenger, MsnSystemMessage message) {
    }

    public void datacastMessageReceived(MsnSwitchboard switchboard, MsnDatacastMessage message, MsnContact contact) {
    }

    public void unknownMessageReceived(MsnSwitchboard switchboard, MsnUnknownMessage message, MsnContact contact) {
    }

    public void p2pMessageReceived(MsnSwitchboard switchboard, MsnP2PMessage message, MsnContact contact) {
    }
}

