/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.device.impl;

import jp.sourceforge.shovel.AvailabilityType;
import jp.sourceforge.shovel.device.IDelayExecutorContext;
import jp.sourceforge.shovel.device.IMobilePhoneWrapper;
import jp.sourceforge.shovel.device.impl.MobilePhoneWrapperImpl;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IDirectMessage;
import jp.sourceforge.shovel.entity.IFavorite;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IStatusWrapper;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IDirectoryLogic;
import jp.sourceforge.shovel.logic.IShovelLogic;
import org.seasar.framework.container.S2Container;

public class MobilePhoneWrapperImpl
implements IMobilePhoneWrapper {
    final String source_ = "mobile web";
    S2Container container_;

    public String getDisplayName() {
        return null;
    }

    public void setDisplayName(String displayName) {
    }

    public String getAddress() {
        return null;
    }

    public String getExecutorId() {
        return "mobilePhone";
    }

    public boolean isConnected() {
        return true;
    }

    public void setProperty(String key, String value) {
    }

    public void connect() throws ApplicationException {
    }

    public void disconnect() {
    }

    public void execute(IDelayExecutorContext context) throws ApplicationException {
        if (!context.isCommit()) {
            return;
        }
        IDirectoryLogic directoryLogic = this.getDirectoryLogic();
        IShovelLogic shovelLogic = this.getShovelLogic();
        switch (1.$SwitchMap$jp$sourceforge$shovel$DelayExecutionType[context.getDelayExecutionType().ordinal()]) {
            case 1: {
                IStatus status = context.getStatus();
                this.updateStatus(status);
                break;
            }
            case 2: {
                IStatus status = context.getStatus();
                directoryLogic.decrementStatuses(status.getSenderId());
                directoryLogic.decrementFavoritesAll(status.getSenderId());
                shovelLogic.clearStatusReference(status.getStatusId());
                shovelLogic.destroyStatus(status.getStatusId(), false);
                break;
            }
            case 3: {
                IFavorite favorite = context.getFavorite();
                IStatus status = shovelLogic.getStatus(favorite.getStatusId());
                directoryLogic.incrementFavorites(favorite.getUserId());
                if (status.getSenderId() != favorite.getUserId()) {
                    directoryLogic.incrementGivenFavorites(status.getSenderId());
                }
                shovelLogic.createFavorite(favorite.getStatusId(), favorite.getUserId(), false);
                break;
            }
            case 4: {
                IFavorite favorite = context.getFavorite();
                IStatus status = shovelLogic.getStatus(favorite.getStatusId());
                directoryLogic.decrementFavoritesAll(favorite.getUserId());
                if (status.getSenderId() != favorite.getUserId()) {
                    directoryLogic.decrementGivenFavorites(status.getSenderId());
                }
                shovelLogic.destroyFavorite(favorite.getStatusId(), favorite.getUserId(), false);
                break;
            }
            case 5: {
                IDirectMessage directMessage = context.getDirectMessage();
                directoryLogic.incrementDirectMessages(directMessage.getRecipientId());
                shovelLogic.createDirectMessage(directMessage.getText(), "mobile web", directMessage.getSenderId(), directMessage.getRecipientId(), false);
                break;
            }
            case 6: {
                IDirectMessage directMessage = context.getDirectMessage();
                shovelLogic.destroyDirectMessage(directMessage.getDirectMessageId(), true, false);
                break;
            }
            case 7: {
                IDirectMessage directMessage = context.getDirectMessage();
                directoryLogic.decrementDirectMessages(directMessage.getRecipientId());
                shovelLogic.destroyDirectMessage(directMessage.getDirectMessageId(), false, false);
                break;
            }
            case 8: {
                IFriendship friend = context.getFriend();
                IUser active = directoryLogic.getUser(friend.getActiveId());
                shovelLogic.createFriendship(friend.getActiveId(), friend.getPassiveId(), active.isProtect(), false);
                break;
            }
            case 9: {
                IFriendship friend = context.getFriend();
                IUser active = directoryLogic.getUser(friend.getActiveId());
                shovelLogic.destroyFriendship(friend.getActiveId(), friend.getPassiveId(), active.isProtect(), false);
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
    }

    void updateStatus(IStatus status) throws ApplicationException {
        IDirectoryLogic directoryLogic = this.getDirectoryLogic();
        IShovelLogic shovelLogic = this.getShovelLogic();
        IStatusWrapper statusWrapper = shovelLogic.parseStatus(status.getBody());
        IUser sender = directoryLogic.getUser(status.getSenderId());
        String foreignKey = statusWrapper.getForeignKey();
        IUser user = null;
        if (foreignKey != null) {
            user = directoryLogic.getUserByForeignKey(foreignKey);
        }
        switch (1.$SwitchMap$jp$sourceforge$shovel$StatusType[statusWrapper.getStatusType().ordinal()]) {
            case 1: {
                directoryLogic.incrementStatuses(sender.getUserId());
                long referenceSenderId = 0L;
                if (user != null) {
                    referenceSenderId = user.getUserId();
                }
                shovelLogic.updateStatus(statusWrapper.getText(), sender.getLocation(), "mobile web", referenceSenderId, statusWrapper.isOpen(), sender.getUserId(), false);
                break;
            }
            case 2: {
                directoryLogic.incrementDirectMessages(user.getUserId());
                shovelLogic.createDirectMessage(statusWrapper.getText(), "mobile web", sender.getUserId(), user.getUserId(), false);
                break;
            }
            case 3: {
                IFavorite favorite;
                status = shovelLogic.getRecent(user.getUserId());
                if (status == null || (favorite = shovelLogic.getFavorite(status.getStatusId(), sender.getUserId())) != null) break;
                directoryLogic.incrementFavorites(sender.getUserId());
                if (user.getUserId() != sender.getUserId()) {
                    directoryLogic.incrementGivenFavorites(user.getUserId());
                }
                shovelLogic.createFavorite(status.getStatusId(), sender.getUserId(), false);
                break;
            }
            case 4: {
                shovelLogic.createFriendship(sender.getUserId(), user.getUserId(), sender.isProtect(), false);
                break;
            }
            case 5: {
                shovelLogic.destroyFriendship(sender.getUserId(), user.getUserId(), sender.isProtect(), false);
                break;
            }
            case 6: {
                shovelLogic.updateNotification(sender.getUserId(), user.getUserId(), true);
                break;
            }
            case 7: {
                shovelLogic.updateNotification(sender.getUserId(), user.getUserId(), false);
                break;
            }
            case 8: {
                IDevice device = sender.getDevice();
                device.setAvailabilityType(AvailabilityType.OFF);
                shovelLogic.updateDevice(device);
                break;
            }
            case 9: {
                IDevice device = sender.getDevice();
                device.setAvailabilityType(AvailabilityType.ON);
                shovelLogic.updateDevice(device);
                break;
            }
        }
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    S2Container getContainer() {
        return this.container_;
    }

    IDirectoryLogic getDirectoryLogic() {
        return (IDirectoryLogic)this.getContainer().getComponent(IDirectoryLogic.class);
    }

    IShovelLogic getShovelLogic() {
        return (IShovelLogic)this.getContainer().getComponent(IShovelLogic.class);
    }
}

