/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.device.impl;

import com.sun.net.ssl.internal.ssl.Provider;
import java.security.Security;
import java.util.Calendar;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jp.sourceforge.shovel.device.IDelayExecutorContext;
import jp.sourceforge.shovel.device.IMailWrapper;
import jp.sourceforge.shovel.device.impl.MailWrapperImpl;
import jp.sourceforge.shovel.entity.IDirectMessage;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IDirectoryLogic;
import jp.sourceforge.shovel.logic.IShovelLogic;
import jp.sourceforge.shovel.util.ShovelUtil;
import org.apache.struts.util.MessageResources;
import org.seasar.framework.container.S2Container;

public class MailWrapperImpl
implements IMailWrapper {
    Properties properties_;
    S2Container container_;

    public String getDisplayName() {
        return null;
    }

    public void setDisplayName(String displayName) {
    }

    public String getAddress() {
        return null;
    }

    public String getExecutorId() {
        return "mail";
    }

    public boolean isConnected() {
        return true;
    }

    public void setProperty(String key, String value) {
        if (this.properties_ == null) {
            this.properties_ = new Properties();
        }
        this.properties_.setProperty("mail." + key, value);
    }

    public void connect() throws ApplicationException {
    }

    public void disconnect() {
    }

    void sendDirectMessage() {
    }

    public void execute(IDelayExecutorContext context) throws ApplicationException {
        if (context.isCommit()) {
            return;
        }
        MessageResources resources = MessageResources.getMessageResources((String)"jp.sourceforge.shovel.application");
        String address = null;
        String subject = null;
        String text = null;
        switch (2.$SwitchMap$jp$sourceforge$shovel$DelayExecutionType[context.getDelayExecutionType().ordinal()]) {
            case 1: {
                IDirectMessage directMessage = context.getDirectMessage();
                IUser recipient = this.getDirectoryLogic().getUser(directMessage.getRecipientId());
                if (!recipient.isRecipientDirectMessage()) {
                    return;
                }
                address = recipient.getEmail();
                if (address == null || address.length() <= 0) {
                    return;
                }
                IUser sender = this.getDirectoryLogic().getUser(directMessage.getSenderId());
                subject = resources.getMessage("mail.directMessage.subject", (Object)sender.getForeignKey());
                text = resources.getMessage("mail.directMessage.text", (Object)directMessage.getText(), (Object)sender.getForeignKey());
                break;
            }
            case 2: {
                IStatus status = context.getStatus();
                IUser recipient = this.getDirectoryLogic().getUser(status.getReferenceSenderId());
                if (recipient == null) {
                    return;
                }
                if (!recipient.isReply()) {
                    return;
                }
                address = recipient.getEmail();
                if (address == null || address.length() <= 0) {
                    return;
                }
                IUser sender = this.getDirectoryLogic().getUser(status.getSenderId());
                IFriendship friend = this.getShovelLogic().getFriendship(recipient.getUserId(), sender.getUserId());
                if (friend == null) {
                    return;
                }
                subject = resources.getMessage("mail.reply.subject", (Object)sender.getForeignKey());
                text = resources.getMessage("mail.reply.text", (Object)status.getBody(), (Object)sender.getForeignKey());
                break;
            }
            case 3: {
                IFriendship friendship = context.getFriend();
                IUser recipient = this.getDirectoryLogic().getUser(friendship.getPassiveId());
                if (!recipient.isNewFriends()) {
                    return;
                }
                address = recipient.getEmail();
                if (address == null || address.length() <= 0) {
                    return;
                }
                IUser sender = this.getDirectoryLogic().getUser(friendship.getActiveId());
                subject = resources.getMessage("mail.followers.subject", (Object)sender.getForeignKey());
                text = resources.getMessage("mail.followers.text", (Object)recipient.getForeignKey(), (Object)sender.getDisplayName(), (Object)sender.getForeignKey(), (Object)context.getServerName());
                break;
            }
            case 4: {
                IUser user = context.getUser();
                address = user.getEmail();
                if (address == null || address.length() <= 0) {
                    return;
                }
                subject = resources.getMessage("mail.resendPassword.subject");
                String token = ShovelUtil.generateToken((String)(address + ":" + user.getPassword()));
                text = resources.getMessage("mail.resendPassword.text", (Object)context.getServerName(), (Object)address, (Object)token);
                break;
            }
            default: {
                return;
            }
        }
        Security.addProvider((java.security.Provider)new Provider());
        Session session = Session.getDefaultInstance((Properties)this.properties_, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
        text = text + resources.getMessage("mail.signature");
        try {
            InternetAddress[] to = new InternetAddress[]{new InternetAddress(address)};
            MimeMessage message = new MimeMessage(session);
            message.setRecipients(Message.RecipientType.TO, (Address[])to);
            message.setSubject(subject, "iso-2022-jp");
            message.setText(text, "iso-2022-jp");
            message.setHeader("Content-Type", "text/plain");
            message.setSentDate(Calendar.getInstance().getTime());
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            throw new ApplicationException("");
        }
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    S2Container getContainer() {
        return this.container_;
    }

    IDirectoryLogic getDirectoryLogic() {
        return (IDirectoryLogic)this.getContainer().getComponent(IDirectoryLogic.class);
    }

    IShovelLogic getShovelLogic() {
        return (IShovelLogic)this.getContainer().getComponent(IShovelLogic.class);
    }
}

