/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.device.impl;

import jp.sourceforge.shovel.GrowlPriorityType;
import jp.sourceforge.shovel.GrowlType;
import jp.sourceforge.shovel.device.IGrowlWrapper;
import jp.sourceforge.shovel.device.impl.AbstractDelayExecutorImpl;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IGrowlPacket;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IGrowlLogic;
import org.seasar.framework.log.Logger;

public class GrowlWrapperImpl
extends AbstractDelayExecutorImpl
implements IGrowlWrapper {
    static Logger logger = Logger.getLogger(GrowlWrapperImpl.class);

    public String getExecutorId() {
        return "growl";
    }

    public String getDeviceTypeWrapper() {
        return null;
    }

    public String getAddress() {
        return null;
    }

    public void setProperty(String key, String value) {
    }

    public void login() throws ApplicationException {
    }

    public void logout() {
    }

    public boolean isConnected() {
        return true;
    }

    boolean isRepeat() {
        return false;
    }

    IFriendship[] getFollowers(long senderId, int offset, int limit) {
        return this.getShovelLogic().getFollowers(senderId, true, offset, limit);
    }

    void sendMessage(IUser receiver, String body) throws ApplicationException {
        if (receiver.isGrowl()) {
            try {
                IGrowlLogic logic = (IGrowlLogic)this.getContainer().getComponent(IGrowlLogic.class);
                IGrowlPacket packet = logic.createPacket("Shovel", GrowlType.NOTIFICATION, "Updated Status", "Updated Status", body, GrowlPriorityType.NORMAL, false, receiver.getGrowlPassword());
                logic.sendPacket(receiver.getGrowlHost(), packet);
            }
            catch (ApplicationException applicationException) {
                // empty catch block
            }
        }
    }

    void replyMessage(IUser sender, IUser receiver, String body) throws ApplicationException {
        IFriendship follower = this.getShovelLogic().getFriendship(receiver.getUserId(), sender.getUserId());
        if (follower == null || sender.isProtect() && !follower.isAccept()) {
            return;
        }
        this.sendMessage(receiver, body);
    }
}

