/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.action.IStatisticsAction;
import jp.sourceforge.shovel.action.impl.StatisticsActionImpl;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatisticsForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class StatisticsActionImpl
implements IStatisticsAction {
    IStatisticsForm actionForm_;
    HttpServletRequest request_;

    String compileUserStatistics(FormatType formatType, SortType sortType, int limit) throws ApplicationException {
        String forward;
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser[] users = directoryService.getUsers(sortType, SortOrderType.DESC, limit);
        shovelService.prepareForView(users, users.length);
        this.request_.setAttribute("users", (Object)users);
        long[] userIds = new long[users.length];
        int i = 0;
        for (IUser user : users) {
            userIds[i++] = user.getUserId();
        }
        IStatus[] statuses = shovelService.getRecents(userIds);
        HashMap<String, IStatus> statusMap = new HashMap<String, IStatus>();
        for (IStatus status : statuses) {
            long statusId = status.getSenderId();
            statusMap.put(String.valueOf(statusId), status);
        }
        this.request_.setAttribute("statuses", statusMap);
        switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
            case 1: {
                forward = "user_xml";
                break;
            }
            case 2: {
                forward = "user_json";
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        return forward;
    }

    String compileStatusStatistics(FormatType formatType, SortType sortType, int limit) throws ApplicationException {
        String forward;
        IShovelService shovelService = this.getShovelService();
        IStatus[] statuses = shovelService.getStatuses(sortType, SortOrderType.DESC, limit);
        shovelService.prepareForView(statuses, limit, false);
        this.request_.setAttribute("statuses", (Object)statuses);
        switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
            case 1: {
                forward = "status_xml";
                break;
            }
            case 2: {
                forward = "status_json";
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        return forward;
    }

    @Perform(CSRF=false)
    public String perform() throws Exception {
        String forward;
        FormatType formatType = this.actionForm_.getFormatType();
        int limit = this.actionForm_.getCount();
        switch (1.$SwitchMap$jp$sourceforge$shovel$StatisticsType[this.actionForm_.getStatisticsType().ordinal()]) {
            case 1: {
                forward = this.compileUserStatistics(formatType, SortType.STATUSES, limit);
                break;
            }
            case 2: {
                forward = this.compileUserStatistics(formatType, SortType.GIVEN_FAVORITES, limit);
                break;
            }
            case 3: {
                forward = this.compileStatusStatistics(formatType, SortType.GIVEN_FAVORITES, limit);
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        return forward;
    }

    public void setStatisticsForm(IStatisticsForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }
}

