/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.MethodType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.action.IFriendsAction;
import jp.sourceforge.shovel.action.impl.FriendsActionImpl;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IFriendsForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import org.seasar.framework.container.S2Container;

public class FriendsActionImpl
implements IFriendsAction {
    IFriendsForm actionForm_;
    HttpServletRequest request_;
    S2Container container_;

    @Perform(CSRF=false, login=true)
    public String perform() throws Exception {
        IFriendship[] tmp;
        FormatType formatType = this.actionForm_.getFormatType();
        int page = this.actionForm_.getPage();
        int limit = this.actionForm_.getCount();
        String foreignKey = this.actionForm_.getForeignKey();
        long userId = this.actionForm_.getUserId();
        if (formatType.isHtml()) {
            IListRefine listRefine = (IListRefine)this.getSession().getAttribute("listRefine");
            if (listRefine == null || !listRefine.getViewType().isFriends()) {
                listRefine = (IListRefine)this.container_.getComponent(IListRefine.class);
                this.getSession().setAttribute("listRefine", (Object)listRefine);
            } else if (this.actionForm_.getMethodType() == MethodType.PAGE) {
                listRefine.setPage(this.actionForm_.getPage());
            }
            listRefine.setViewType(this.actionForm_.isFollowers() ? ViewType.FOLLOWERS : ViewType.FRIENDS);
            page = listRefine.getPage();
            limit = 0;
        }
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser user = null;
        if (foreignKey == null || foreignKey.length() <= 0) {
            user = directoryService.getLoginUser();
            foreignKey = user.getForeignKey();
        } else {
            user = foreignKey.matches("^[0-9]+$") ? directoryService.getUser(userId) : directoryService.getUser(foreignKey);
        }
        if (shovelService.isMobilePhone()) {
            tmp = shovelService.searchFriends(user.getUserId(), this.actionForm_.getKeyword(), this.actionForm_.getSearchFriendsType(), page, limit);
        } else if (this.actionForm_.isFollowers()) {
            tmp = shovelService.getFollowers(foreignKey, true, page, limit);
        } else {
            boolean withFollower = formatType.isHtml() && (foreignKey == null || foreignKey.length() <= 0);
            tmp = shovelService.getFriends(foreignKey, withFollower, page, limit);
        }
        IFriendship[] friends = shovelService.prepareForView(tmp, limit, true);
        this.request_.setAttribute("friendships", (Object)friends);
        String forward = null;
        switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
            case 1: {
                if (friends != null && friends.length > 0) {
                    this.request_.setAttribute("nextPage", (Object)(tmp.length > friends.length ? 1 : 0));
                }
                shovelService.prepareForView(user);
                this.request_.setAttribute("user", (Object)user);
                if (shovelService.isMobilePhone()) {
                    this.request_.setAttribute("keyword", (Object)this.actionForm_.getKeyword());
                    this.request_.setAttribute("type", (Object)this.actionForm_.getSearchFriendsType());
                    this.request_.setAttribute("page", (Object)page);
                    forward = "mobile";
                    break;
                }
                forward = this.actionForm_.isPartial() ? "partial" : "full";
                break;
            }
            case 2: 
            case 3: {
                IStatus[] statuses;
                if (friends != null && friends.length > 0) {
                    long[] userIds = new long[friends.length];
                    int i = 0;
                    for (IFriendship friend : friends) {
                        userIds[i++] = friend.getPassiveId();
                    }
                    statuses = shovelService.getRecents(userIds);
                    shovelService.prepareForView(statuses, 0, true);
                } else {
                    statuses = new IStatus[]{};
                }
                HashMap<String, IStatus> statusMap = new HashMap<String, IStatus>();
                for (IStatus status : statuses) {
                    long senderId = status.getSenderId();
                    statusMap.put(String.valueOf(senderId), status);
                }
                this.request_.setAttribute("statuses", statusMap);
                forward = formatType.getId();
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        return forward;
    }

    public void setFriendshipForm(IFriendsForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    HttpSession getSession() {
        return this.request_.getSession(true);
    }
}

