/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.sourceforge.shovel.action.IDownloadFileAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IDownloadFileForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IServerFileService;
import jp.sourceforge.shovel.service.IShovelService;
import org.apache.commons.httpclient.util.DateUtil;

public class DownloadFileActionImpl
implements IDownloadFileAction {
    IDownloadFileForm actionForm_;
    HttpServletRequest request_;
    HttpServletResponse response_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        IDirectoryService directoryService = this.getShovelService().getDirectoryService();
        String foreignKey = this.actionForm_.getForeignKey();
        long userId = this.actionForm_.getUserId();
        IUser user = null;
        if (foreignKey != null) {
            user = directoryService.getUser(foreignKey);
        } else if (userId > 0L) {
            user = directoryService.getUser(userId);
        }
        if (user == null) {
            throw new ApplicationException("");
        }
        IServerFile serverFile = null;
        serverFile = this.actionForm_.isBackground() ? user.getBackgroundImage() : user.getProfileImage();
        if (serverFile == null) {
            throw new ApplicationException("");
        }
        if (!serverFile.isExists()) {
            return null;
        }
        IServerFileService serverFileService = this.getShovelService().getServerFileService();
        if (serverFileService.createThumbnail(serverFile, this.actionForm_.getSizeType())) {
            this.response_.setHeader("Location", (String)this.request_.getAttribute("request-url"));
            this.response_.setStatus(302);
            return null;
        }
        String time = this.request_.getHeader("If-Modified-Since");
        if (time != null && time.length() > 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(DateUtil.parseDate((String)time));
            if (calendar.getTimeInMillis() >= serverFile.getCreatedTime() / 1000L * 1000L) {
                this.response_.setStatus(304);
                return null;
            }
        }
        ServletOutputStream outputStream = null;
        ApplicationException e = null;
        try {
            try {
                outputStream = this.response_.getOutputStream();
                serverFile.download((OutputStream)outputStream, this.actionForm_.getSizeType());
            }
            catch (IOException cause) {
                e = new ApplicationException("");
                e.initCause((Throwable)cause);
                throw e;
            }
            Object var13_10 = null;
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            try {
                if (outputStream == null) throw throwable;
                outputStream.close();
                throw throwable;
            }
            catch (IOException cause) {
                if (e != null) throw throwable;
                e = new ApplicationException("");
                e.initCause((Throwable)cause);
                throw e;
            }
        }
        try {}
        catch (IOException cause) {
            if (e != null) return null;
            e = new ApplicationException("");
            e.initCause((Throwable)cause);
            throw e;
        }
        if (outputStream == null) return null;
        outputStream.close();
        return null;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response_ = response;
    }

    public void setDownloadFileForm(IDownloadFileForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IDirectoryService getDirectoryService() {
        return this.getShovelService().getDirectoryService();
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }
}

