/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.sourceforge.shovel.action.IDeviceAction;
import jp.sourceforge.shovel.action.impl.DeviceActionImpl;
import jp.sourceforge.shovel.device.IDelayExecutor;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.IDeviceForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import jp.sourceforge.shovel.thread.DelayExecutorQueue;
import net.arnx.jsonic.JSON;

public class DeviceActionImpl
implements IDeviceAction {
    IDeviceForm actionForm_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    DelayExecutorQueue queue_;

    public String perform() throws Exception {
        IUser user = this.getDirectoryService().getLoginUser();
        IDelayExecutor executor = null;
        switch (this.actionForm_.getPhase()) {
            default: {
                String deviceType = this.actionForm_.getDeviceType();
                String address = this.actionForm_.getAddress();
                this.getShovelService().createDevice(deviceType, address);
                executor = this.queue_.getDelayExecutor(deviceType);
                break;
            }
            case 1: {
                this.getShovelService().resetDevice();
                break;
            }
            case 2: {
                this.getShovelService().updateDevice(this.actionForm_.getAvailabilityType());
            }
        }
        String json = JSON.encode((Object)new JSONBean(this, user, executor));
        this.response_.getOutputStream().write(json.getBytes("UTF-8"));
        return null;
    }

    public void setDeviceForm(IDeviceForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IDirectoryService getDirectoryService() {
        return this.getShovelService().getDirectoryService();
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response_ = response;
    }

    public void setDelayExecutorQueue(DelayExecutorQueue queue) {
        this.queue_ = queue;
    }
}

