/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.IDestroyFriendshipAction;
import jp.sourceforge.shovel.action.impl.DestroyFriendshipActionImpl;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IFriendsForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class DestroyFriendshipActionImpl
implements IDestroyFriendshipAction {
    IFriendsForm actionForm_;
    HttpServletRequest request_;

    public String perform() throws Exception {
        IFriendship friend;
        FormatType formatType = this.actionForm_.getFormatType();
        long userId = this.actionForm_.getUserId();
        String foreignKey = this.actionForm_.getForeignKey();
        IShovelService shovelService = this.getShovelService();
        if (foreignKey == null || foreignKey.length() <= 0) {
            IDirectoryService directoryService = shovelService.getDirectoryService();
            IUser user = directoryService.getLoginUser();
            userId = user.getUserId();
            friend = shovelService.destroyFriendship(userId);
        } else if (foreignKey.matches("^[0-9]+$")) {
            foreignKey = null;
            friend = shovelService.destroyFriendship(userId);
        } else {
            userId = 0L;
            friend = shovelService.destroyFriendship(foreignKey);
        }
        String forward = null;
        switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
            case 1: {
                if (!shovelService.isMobilePhone()) break;
                this.request_.setAttribute("post", (Object)"leaveFriend");
                forward = "mobile";
                break;
            }
            case 2: 
            case 3: {
                shovelService.prepareForView(new IFriendship[]{friend}, 1, false);
                this.request_.setAttribute("friendship", (Object)friend);
                this.request_.setAttribute("friends", (Object)true);
                IStatus status = null;
                status = userId > 0L ? shovelService.getRecent(userId) : shovelService.getRecent(foreignKey);
                if (status != null) {
                    shovelService.prepareForView(status);
                    HashMap<String, IStatus> statusMap = new HashMap<String, IStatus>();
                    statusMap.put(String.valueOf(friend.getPassiveId()), status);
                    this.request_.setAttribute("statuses", statusMap);
                }
                forward = formatType.getId();
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        return forward;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setFriendshipForm(IFriendsForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }
}

