/*
 * Decompiled with CFR 0.152.
 */
package shohaku.ginkgo.tags.core.collections;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import shohaku.core.lang.ObjectCreationException;
import shohaku.core.lang.feature.FeatureFactory;
import shohaku.ginkgo.GinkgoException;
import shohaku.ginkgo.tags.AbstractValueTag;

public class MapTag
extends AbstractValueTag {
    private Class type = LinkedHashMap.class;
    private final List elements = new LinkedList();

    protected Object generateValue() {
        Map m;
        try {
            m = (Map)FeatureFactory.getLoader().getInstance(this.type);
        }
        catch (ClassCastException e) {
            throw new GinkgoException("class name which is not a Map class is specified. " + this.type, e);
        }
        catch (ObjectCreationException e) {
            throw new GinkgoException("illegal class name is specified. " + this.type, e);
        }
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            m.putAll((Map)i.next());
        }
        return Collections.unmodifiableMap(m);
    }

    public void setType(Class type) {
        this.type = type;
    }

    public Class getType() {
        return this.type;
    }

    public void addElementTransferValue(Map element) {
        this.elements.add(element);
    }
}

